/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.toolbox.SWTUtils;
import fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartActionEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class JLChartMemoryUsage
extends JPanel {
    private static final boolean verbose = false;
    private static final boolean debug = false;
    private static final long serialVersionUID = 1L;
    private static final double SCALE = 9.5367431640625E-7;
    public static final int DEFAULT_INTERVAL = 1000;
    public static final int DEFAULT_AGE = 60000;
    public static final boolean DEFAULT_SHOW_MAX = true;
    public static final boolean DEFAULT_SHOW_LEGEND = true;
    private IJLChartActionListener chartActionListener;
    private boolean showMax = true;
    private boolean showLegend = true;
    private JLChart chart = null;
    private JLDataView total;
    private JLDataView used;
    private JLDataView max;
    private Timer timer = null;
    private int interval = 1000;
    private int maxAge = 60000;
    private String header = null;

    public JLChartMemoryUsage() {
        this(60000);
    }

    public JLChartMemoryUsage(int maxAge) {
        super(new BorderLayout());
        this.maxAge = maxAge;
        this.chart = new JLChart();
        this.chart.setHeader(this.getName());
        this.chart.setHeaderFont(new Font("Dialog", 1, 18));
        this.chart.setDisplayDuration((double)maxAge);
        this.chart.getXAxis().setName("Time");
        this.chart.getXAxis().setAutoScale(true);
        this.chart.getXAxis().setGridVisible(true);
        this.chart.getXAxis().setSubGridVisible(true);
        this.chart.getXAxis().setAnnotation(1);
        this.chart.getXAxis().setAxisDuration((double)maxAge);
        this.chart.getXAxis().setFitXAxisToDisplayDuration(true);
        this.chart.getY1Axis().setName("Memory, MB");
        this.chart.getY1Axis().setAutoScale(true);
        this.chart.getY1Axis().setGridVisible(true);
        this.chart.getY1Axis().setSubGridVisible(true);
        this.total = new JLDataView();
        this.total.setColor(new Color(0, 0, 255));
        this.total.setName("Total Memory");
        this.used = new JLDataView();
        this.used.setColor(new Color(0, 0, 0));
        this.used.setName("Used Memory");
        this.max = new JLDataView();
        this.max.setColor(new Color(255, 0, 0));
        this.max.setName("Max Memory");
        this.chart.getY1Axis().addDataView(this.total);
        this.chart.getY1Axis().addDataView(this.used);
        this.chart.getY1Axis().addDataView(this.max);
        this.extendPopupMenu();
        this.add((Component)this.chart, "Center");
    }

    public String getConfiguration() {
        String ls = System.getProperty("line.separator");
        String info = "";
        info = String.valueOf(info) + "Chart Configuration" + ls;
        info = String.valueOf(info) + this.chart.getConfiguration() + ls;
        JLAxis axis = this.chart.getXAxis();
        info = String.valueOf(info) + "X Axis: " + axis.getAxeName() + ls;
        info = String.valueOf(info) + axis.getConfiguration("  ") + ls;
        info = String.valueOf(info) + "  JLDataViews:" + ls;
        Vector views = axis.getViews();
        int i = 0;
        for (JLDataView dv : views) {
            info = String.valueOf(info) + "    DataView " + i + " " + dv.getName() + ls;
            info = String.valueOf(info) + dv.getConfiguration("      ") + ls;
        }
        axis = this.chart.getY1Axis();
        info = String.valueOf(info) + "Y1 Axis: " + axis.getAxeName() + ls;
        info = String.valueOf(info) + axis.getConfiguration("  ") + ls;
        info = String.valueOf(info) + "  JLDataViews:" + ls;
        views = axis.getViews();
        i = 0;
        for (JLDataView dv : views) {
            info = String.valueOf(info) + "    DataView " + i + " " + dv.getName() + ls;
            info = String.valueOf(info) + dv.getConfiguration("      ") + ls;
        }
        return info;
    }

    private void extendPopupMenu() {
        if (this.chart == null) {
            return;
        }
        this.chart.removeMenuItem(2);
        this.chart.removeMenuItem(5);
        this.chart.removeMenuItem(3);
        this.chart.addUserAction("Toggle Max Memory");
        this.chart.addUserAction("Toggle Legend");
        this.chart.addUserAction("Set Max Age...");
        this.chartActionListener = new IJLChartActionListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(JLChartActionEvent evt) {
                if (evt.getName().equals("Toggle Max Memory")) {
                    JLChartMemoryUsage.this.toggleMax();
                } else if (evt.getName().equals("Toggle Legend")) {
                    JLChartMemoryUsage.this.chart.setLabelVisible(!JLChartMemoryUsage.this.chart.isLabelVisible());
                } else if (evt.getName().equals("Set Max Age...")) {
                    JLChartMemoryUsage.this.queryResetMaxAge();
                }
            }

            public boolean getActionState(JLChartActionEvent evt) {
                return false;
            }
        };
        this.chart.addJLChartActionListener(this.chartActionListener);
    }

    public void update() {
        double totalMem = 9.5367431640625E-7 * (double)Runtime.getRuntime().totalMemory();
        double freeMem = 9.5367431640625E-7 * (double)Runtime.getRuntime().freeMemory();
        double maxMem = 9.5367431640625E-7 * (double)Runtime.getRuntime().maxMemory();
        long time = System.currentTimeMillis();
        this.chart.addData(this.total, (double)time, totalMem);
        this.chart.addData(this.used, (double)time, totalMem - freeMem);
        this.chart.addData(this.max, (double)time, maxMem);
    }

    public void queryResetInterval() {
        String result = JOptionPane.showInputDialog("Enter update interval in ms", (Object)Integer.toString(this.interval));
        if (result != null) {
            int newVal = 0;
            try {
                newVal = Integer.valueOf(result);
            }
            catch (NumberFormatException numberFormatException) {
                SWTUtils.errMsgAsync("MemoryUsage: Invalid interval");
                return;
            }
            this.setInterval(newVal);
        }
    }

    public void queryResetMaxAge() {
        String result = JOptionPane.showInputDialog("Enter maximum age in ms", (Object)Integer.toString(this.maxAge));
        if (result != null) {
            int newVal = 0;
            try {
                newVal = Integer.valueOf(result);
            }
            catch (NumberFormatException numberFormatException) {
                SWTUtils.errMsgAsync("MemoryUsage: Invalid age");
                return;
            }
            this.setMaxAge(newVal);
        }
    }

    public void toggleMax() {
        if (this.max == null) {
            return;
        }
        if (this.showMax) {
            this.showMax = false;
            this.chart.getY1Axis().removeDataView(this.max);
        } else {
            this.showMax = true;
            this.chart.getY1Axis().addDataView(this.max);
        }
    }

    public void start() {
        this.stop();
        this.timer = new Timer(this.interval, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JLChartMemoryUsage.this.update();
            }
        });
        this.timer.start();
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public void finish() {
        if (this.chart != null && this.chartActionListener != null) {
            this.chart.removeJLChartActionListener(this.chartActionListener);
        }
        this.chart = null;
        this.chartActionListener = null;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        if (interval == this.interval) {
            return;
        }
        this.interval = interval;
        if (this.timer != null && this.timer.isRunning()) {
            this.start();
        }
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        if (maxAge == this.maxAge) {
            return;
        }
        this.maxAge = maxAge;
        this.chart.setDisplayDuration((double)maxAge);
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        if (header == this.header) {
            return;
        }
        this.header = header;
        if (this.chart != null) {
            this.chart.setHeader(header);
        }
    }

    public JLChart getChart() {
        return this.chart;
    }

    public boolean getShowMax() {
        return this.showMax;
    }

    public void setShowMax(boolean showMax) {
        this.showMax = showMax;
    }

    public static void main(String[] args) {
        try {
            JFrame.setDefaultLookAndFeelDecorated(true);
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JLChartMemoryUsage panel = new JLChartMemoryUsage(600000);
                    panel.setInterval(1000);
                    panel.setHeader("JVM Memory Usage");
                    panel.start();
                    JFrame frame = new JFrame("JLChart Memory Usage");
                    frame.getContentPane().add((Component)panel, "Center");
                    frame.setBounds(200, 120, 600, 280);
                    frame.setDefaultCloseOperation(3);
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

