/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.imageprint;

import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;

public class PrintSettings {
    private static final String DEFAULT_UNITS_FORMAT = "%.3f";
    private String unitsFormat = "%.3f";
    private Units units = Units.INCH;
    private double left = 1.0;
    private double right = 1.0;
    private double top = 1.0;
    private double bottom = 1.0;
    private int verticalAlign = 128;
    private int horizontalAlign = 0x1000000;
    private Orientation orientation = Orientation.PORTRAIT;
    private PrinterData printerData = Printer.getDefaultPrinterData();

    public PrintSettings clone() {
        PrintSettings newSettings = new PrintSettings();
        newSettings.setUnits(this.units);
        newSettings.setLeft(this.left);
        newSettings.setRight(this.right);
        newSettings.setTop(this.top);
        newSettings.setBottom(this.bottom);
        newSettings.setVerticalAlign(this.verticalAlign);
        newSettings.setHorizontalAlign(this.horizontalAlign);
        newSettings.setOrientation(this.orientation);
        newSettings.setPrinterData(this.printerData);
        return newSettings;
    }

    public ValueWithUnits scaleToInches(ValueWithUnits vwu) {
        Units convertUnit = this.units;
        Units[] unitsArray = Units.values();
        int n = unitsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Units unit = unitsArray[n2];
            if (unit.getName().equals(vwu.getUnitsName())) {
                convertUnit = unit;
                break;
            }
            ++n2;
        }
        return new ValueWithUnits(convertUnit.scaleToInches(vwu.getVal()), convertUnit.getName());
    }

    public ValueWithUnits scaleFromInches(ValueWithUnits vwu) {
        Units convertUnit = this.units;
        Units[] unitsArray = Units.values();
        int n = unitsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Units unit = unitsArray[n2];
            if (unit.getName().equals(vwu.getUnitsName())) {
                convertUnit = unit;
                break;
            }
            ++n2;
        }
        return new ValueWithUnits(convertUnit.scaleFromInches(vwu.getVal()), Units.INCH.getName());
    }

    public ValueWithUnits parseUnitsString(String string) {
        String[] tokens = string.trim().split("\\s+");
        if (tokens.length == 0) {
            return null;
        }
        double val = 0.0;
        String name = this.units.getName();
        try {
            val = Double.parseDouble(tokens[0]);
        }
        catch (NumberFormatException numberFormatException) {
            val = 0.0;
        }
        if (tokens.length >= 2) {
            Units[] unitsArray = Units.values();
            int n = unitsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Units unit = unitsArray[n2];
                if (tokens[1].toLowerCase().equals(unit.getName())) {
                    name = unit.getName();
                    break;
                }
                ++n2;
            }
        }
        return new ValueWithUnits(val, name);
    }

    public String getUnitsName() {
        return this.units.getName();
    }

    public Units getUnits() {
        return this.units;
    }

    public void setUnits(Units units) {
        this.units = units;
    }

    public void setUnits(String name) {
        Units[] unitsArray = Units.values();
        int n = unitsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Units units = unitsArray[n2];
            if (units.getName().equals(name)) {
                this.units = units;
                return;
            }
            ++n2;
        }
        this.units = Units.INCH;
    }

    public double getLeft() {
        return this.left;
    }

    public void setLeft(double left) {
        this.left = left;
    }

    public String getLeftString() {
        return new ValueWithUnits(this.units.scaleFromInches(this.left), this.units.getName()).getString();
    }

    public void setLeftString(String string) {
        this.left = this.scaleToInches(this.parseUnitsString(string)).getVal();
    }

    public double getRight() {
        return this.right;
    }

    public void setRight(double right) {
        this.right = right;
    }

    public String getRightString() {
        return new ValueWithUnits(this.units.scaleFromInches(this.right), this.units.getName()).getString();
    }

    public void setRightString(String string) {
        this.right = this.scaleToInches(this.parseUnitsString(string)).getVal();
    }

    public double getTop() {
        return this.top;
    }

    public void setTop(double top) {
        this.top = top;
    }

    public String getTopString() {
        return new ValueWithUnits(this.units.scaleFromInches(this.top), this.units.getName()).getString();
    }

    public void setTopString(String string) {
        this.top = this.scaleToInches(this.parseUnitsString(string)).getVal();
    }

    public double getBottom() {
        return this.bottom;
    }

    public void setBottom(double bottom) {
        this.bottom = bottom;
    }

    public String getBottomString() {
        return new ValueWithUnits(this.units.scaleFromInches(this.bottom), this.units.getName()).getString();
    }

    public void setBottomString(String string) {
        this.bottom = this.scaleToInches(this.parseUnitsString(string)).getVal();
    }

    public int getVerticalAlign() {
        return this.verticalAlign;
    }

    public void setVerticalAlign(int verticalAlign) {
        this.verticalAlign = verticalAlign;
    }

    public int getHorizontalAlign() {
        return this.horizontalAlign;
    }

    public void setHorizontalAlign(int horizontalAlign) {
        this.horizontalAlign = horizontalAlign;
    }

    public String getUnitsFormat() {
        return this.unitsFormat;
    }

    public void setUnitsFormat(String unitsFormat) {
        this.unitsFormat = unitsFormat;
    }

    public void resetUnitsFormat() {
        this.unitsFormat = DEFAULT_UNITS_FORMAT;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public void setOrientation(String name) {
        Orientation[] orientationArray = Orientation.values();
        int n = orientationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Orientation orientation = orientationArray[n2];
            if (orientation.getName().equals(name)) {
                this.orientation = orientation;
                return;
            }
            ++n2;
        }
        this.orientation = Orientation.DEFAULT;
    }

    public PrinterData getPrinterData() {
        return this.printerData;
    }

    public void setPrinterData(PrinterData printerData) {
        this.printerData = printerData;
    }

    public static enum Orientation {
        DEFAULT("Default"),
        PORTRAIT("Portrait"),
        LANDSCAPE("Landscape");

        private final String name;

        private Orientation(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Units {
        INCH("in", 1.0),
        CENTIMETER("cm", 0.39370078740157477),
        MILLIMETER("mm", 0.003937007874015748);

        private final String name;
        private final double scale;

        private Units(String name, double scale) {
            this.name = name;
            this.scale = scale;
        }

        public String getName() {
            return this.name;
        }

        public double getScale() {
            return this.scale;
        }

        public double scaleToInches(double val) {
            return val * this.scale;
        }

        public double scaleFromInches(double val) {
            return val / this.scale;
        }
    }

    public class ValueWithUnits {
        private double val;
        private String unitsName;

        ValueWithUnits(double val, String unitsName) {
            this.val = val;
            this.unitsName = unitsName;
        }

        public String getString() {
            return String.format(String.valueOf(PrintSettings.this.unitsFormat) + " %s", this.val, this.unitsName);
        }

        public double getVal() {
            return this.val;
        }

        public String getUnitsName() {
            return this.unitsName;
        }
    }
}

