/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.imageprint;

import fable.framework.imageprint.FableImagePrinter;
import fable.framework.imageprint.ImagePrintPreviewDialog;
import fable.framework.imageprint.ImagePrintSetupDialog;
import fable.framework.imageprint.ImagePrintUtils;
import fable.framework.imageprint.PrintSettings;
import fable.framework.toolbox.ImageSelection;
import fable.framework.toolbox.SWTUtils;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.image.BufferedImage;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class JLChartActions {
    JLChart chart;
    Display display;
    public Action printSetupAction;
    public Action printPreviewAction;
    public Action printAction;
    public Action copyAction;

    public JLChartActions(Display display, JLChart chart) {
        this.chart = chart;
        this.display = display;
        this.printSetupAction = new Action("Print Setup"){

            public void run() {
                Image image = JLChartActions.this.getSWTChartImage();
                if (image == null) {
                    return;
                }
                ImagePrintSetupDialog dialog = new ImagePrintSetupDialog(JLChartActions.this.display.getActiveShell(), image, FableImagePrinter.settings);
                PrintSettings settings = dialog.open();
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
                if (settings != null) {
                    FableImagePrinter.settings = settings;
                }
            }
        };
        this.printPreviewAction = new Action("Print Preview"){

            public void run() {
                Image image = JLChartActions.this.getSWTChartImage();
                if (image == null) {
                    return;
                }
                ImagePrintPreviewDialog dialog = new ImagePrintPreviewDialog(JLChartActions.this.display.getActiveShell(), image, FableImagePrinter.settings);
                PrintSettings settings = dialog.open();
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
                if (settings != null) {
                    FableImagePrinter.settings = settings;
                }
            }
        };
        this.printAction = new Action("Print"){

            public void run() {
                Image image = JLChartActions.this.getSWTChartImage();
                if (image == null) {
                    return;
                }
                ImagePrintUtils.dialogPrintImage(JLChartActions.this.display.getActiveShell(), image, JLChartActions.this.display.getDPI(), FableImagePrinter.settings);
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        };
        this.copyAction = new Action("Copy"){

            public void run() {
                BufferedImage image = JLChartActions.this.getAWTChartImage();
                if (image == null) {
                    return;
                }
                Clipboard awtClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                awtClipboard.setContents(new ImageSelection(image), null);
            }
        };
    }

    public BufferedImage getAWTChartImage() {
        if (this.display == null || this.display.isDisposed() || this.chart == null) {
            return null;
        }
        int w = this.chart.getSize().width;
        int h = this.chart.getSize().height;
        BufferedImage img = new BufferedImage(w, h, 1);
        if (img == null) {
            return null;
        }
        Color oldBackground = this.chart.getBackground();
        this.chart.setBackground(Color.WHITE);
        this.chart.paint(img.getGraphics());
        this.chart.setBackground(oldBackground);
        return img;
    }

    public Image getSWTChartImage() {
        if (this.display == null || this.display.isDisposed() || this.chart == null) {
            return null;
        }
        BufferedImage img = this.getAWTChartImage();
        if (img == null) {
            return null;
        }
        ImageData data = SWTUtils.convertToSWT(img);
        if (data == null) {
            return null;
        }
        return new Image((Device)this.display, data);
    }

    public JLChart getChart() {
        return this.chart;
    }

    public void setChart(JLChart chart) {
        this.chart = chart;
    }
}

