/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.views;

import fable.framework.imageprint.JLChartActions;
import fable.framework.ui.object.ColumnFileController;
import fable.framework.ui.rcp.Activator;
import fable.python.ColumnFile;
import fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartActionEvent;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import jep.JepException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ColFileXYPlot
implements IJLChartListener {
    private static final long serialVersionUID = 1L;
    private Vector<ColumnFile> columnFileVector = new Vector();
    private Vector<JLDataView> dataViewVector = new Vector();
    private Frame chartFrame;
    private JApplet chartContainer;
    private JLChart chart;
    private JLChartActions actions;
    Composite parent;
    SashForm sashForm;
    private Composite plotSwtAwtComposite;
    private ScrolledComposite optionsComposite;
    private boolean optionsShowing = true;
    private IJLChartActionListener chartActionListener;
    private PaintListener paintListener;
    private String chartName;
    private String syAxisLabel;
    private String sxAxisLabel;
    static int iDataColor = 0;
    Combo colFileCombo;
    Combo xKeysCombo;
    Combo yKeysCombo;
    public Button updateButton;
    private Button removeButton;
    private Button resetButton;
    private Button switchXYButton;
    private Group editGroup;
    private int currentXIndex = 0;
    private int currentYIndex = 1;
    double[] currentXData;
    double[] currentYData;
    private JLDataView currentDataView = null;
    ColumnFile currentColumnFile = null;
    private Text txtY1Min;
    private Text txtY1Max;
    private Text txtXMax;
    private Text txtXMin;
    private Button removeDataButton;
    private Button keepDataButton;
    ImageDescriptor widget_close = Activator.imageDescriptorFromPlugin((String)"fable.framework.ui", (String)"images/widget_close.gif");
    ImageDescriptor widget_open = Activator.imageDescriptorFromPlugin((String)"fable.framework.ui", (String)"images/widget_open.gif");
    private ImageDescriptor imgdescChartOpt = Activator.imageDescriptorFromPlugin((String)"fable.framework.ui", (String)"images/graphView.gif");
    private ImageDescriptor imgdescRefreshplot = Activator.imageDescriptorFromPlugin((String)"fable.framework.ui", (String)"images/refresh.gif");
    private ImageDescriptor imgdescdelete = Activator.imageDescriptorFromPlugin((String)"fable.framework.ui", (String)"images/delete.gif");
    private ImageDescriptor imgdescswitch = Activator.imageDescriptorFromPlugin((String)"fable.framework.ui", (String)"images/switch.gif");
    private ImageDescriptor imgdescSub = Activator.imageDescriptorFromPlugin((String)"fable.framework.ui", (String)"images/subtract.gif");
    private Color[] dataColors = new Color[]{new Color(51, 51, 255), new Color(255, 51, 0), new Color(51, 255, 255), new Color(255, 204, 51), new Color(153, 0, 153), new Color(0, 255, 60)};
    private ImageDescriptor keep_descriptor = Activator.imageDescriptorFromPlugin((String)"fable.framework.ui", (String)"images/check.gif");
    private ImageDescriptor remove_descriptor = Activator.imageDescriptorFromPlugin((String)"fable.framework.ui", (String)"images/delete.gif");
    private Image img_delete;
    private Image img_keep;
    private ColumnFileController colController;
    private JLDataView markedDataView;
    private int[] selectedRowsId;

    public ColFileXYPlot(Composite parent, String name, String xLabel, String yLabel) {
        this.parent = parent;
        this.chartName = name;
        this.syAxisLabel = yLabel;
        this.sxAxisLabel = xLabel;
        this.img_keep = this.keep_descriptor.createImage();
        int width = this.img_keep.getBounds().width;
        int height = this.img_keep.getBounds().height;
        Image tmp = this.remove_descriptor.createImage();
        this.img_delete = new Image((Device)Display.getDefault(), tmp.getImageData().scaledTo(width, height));
        tmp.dispose();
        parent.setLayout((Layout)new GridLayout(1, true));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        parent.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent arg0) {
                ColFileXYPlot.this.repaint();
            }
        });
        this.sashForm = new SashForm(parent, 256);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sashForm);
        this.createChartFrame((Composite)this.sashForm);
        this.createChart();
        this.createOptionsGroup((Composite)this.sashForm);
        this.sashForm.setWeights(new int[]{2, 1});
        this.colController = ColumnFileController.getColumnFileController();
        this.colController.setcolumnFileVector(this.columnFileVector);
    }

    public void setSyAxisLabel(String syAxisLabel) {
        if (syAxisLabel != null) {
            this.syAxisLabel = syAxisLabel;
            this.selectLabelinYCombo(syAxisLabel);
        }
    }

    public void setSxAxisLabel(String sxAxisLabel) {
        if (sxAxisLabel != null) {
            this.sxAxisLabel = sxAxisLabel;
            this.selectLabelinXCombo(sxAxisLabel);
        }
    }

    public void populateListsKeys(final ColumnFile col) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String[] colandValues = col.getTitles();
                ColFileXYPlot.this.xKeysCombo.removeAll();
                ColFileXYPlot.this.yKeysCombo.removeAll();
                int i = 0;
                while (colandValues != null && i < colandValues.length) {
                    String key = colandValues[i];
                    ColFileXYPlot.this.yKeysCombo.setData("help" + key, (Object)key);
                    ColFileXYPlot.this.xKeysCombo.setData("help" + key, (Object)key);
                    ColFileXYPlot.this.xKeysCombo.add(key);
                    ColFileXYPlot.this.yKeysCombo.add(key);
                    ++i;
                }
                ColFileXYPlot.this.yKeysCombo.setEnabled(ColFileXYPlot.this.yKeysCombo.getItemCount() > 0);
                ColFileXYPlot.this.xKeysCombo.setEnabled(ColFileXYPlot.this.yKeysCombo.getItemCount() > 0);
                if (ColFileXYPlot.this.currentXIndex > ColFileXYPlot.this.xKeysCombo.getItemCount()) {
                    ColFileXYPlot.this.resetPreferredCurrentXIndex();
                }
                if (ColFileXYPlot.this.currentYIndex > ColFileXYPlot.this.yKeysCombo.getItemCount()) {
                    ColFileXYPlot.this.resetPreferredCurrentY1Index();
                }
                ColFileXYPlot.this.xKeysCombo.select(ColFileXYPlot.this.currentXIndex);
                ColFileXYPlot.this.yKeysCombo.select(ColFileXYPlot.this.currentYIndex);
            }
        });
    }

    private void createListsKeys_X(Composite parent) {
        new Label(parent, 0).setText("X");
        this.xKeysCombo = new Combo(parent, 2560);
        GridData gdlist = new GridData(16384, 2, true, false);
        this.xKeysCombo.setLayoutData((Object)gdlist);
        this.xKeysCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColFileXYPlot.this.plotSelectedXAxis();
            }
        });
    }

    private void plotSelectedXAxis() {
        String[] sel = this.xKeysCombo.getItems();
        this.currentXIndex = this.xKeysCombo.getSelectionIndex();
        if (this.currentXIndex < 0) {
            this.resetPreferredCurrentXIndex();
        }
        this.sxAxisLabel = sel[this.currentXIndex];
        this.chart.getXAxis().setName(this.sxAxisLabel);
        this.updateChart();
    }

    private void createListsKeys_Y(Composite parent) {
        new Label(parent, 0).setText("Y");
        this.yKeysCombo = new Combo(parent, 2560);
        GridData gdlist = new GridData(16384, 2, true, false);
        this.yKeysCombo.setLayoutData((Object)gdlist);
        this.yKeysCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColFileXYPlot.this.plotSelectedY1Axis();
            }
        });
    }

    private void plotSelectedY1Axis() {
        String[] sel = this.yKeysCombo.getItems();
        this.currentYIndex = this.yKeysCombo.getSelectionIndex();
        if (this.currentYIndex < 0) {
            this.resetPreferredCurrentY1Index();
        }
        this.syAxisLabel = sel[this.currentYIndex];
        this.chart.getY1Axis().setName(this.syAxisLabel);
        this.updateChart();
    }

    private void createOptionsGroup(Composite parent) {
        this.optionsComposite = new ScrolledComposite(parent, 768);
        this.optionsComposite.setLayout((Layout)new GridLayout(1, false));
        Composite mainComposite = new Composite((Composite)this.optionsComposite, 0);
        mainComposite.setLayout((Layout)new GridLayout(1, false));
        mainComposite.setLayoutData((Object)new GridData());
        mainComposite.pack();
        this.optionsComposite.setContent((Control)mainComposite);
        Group groupChartOptions = new Group(mainComposite, 0);
        groupChartOptions.setLayout((Layout)new GridLayout());
        ((GridLayout)groupChartOptions.getLayout()).numColumns = 2;
        GridData gridChartOpt = new GridData(0x1000004, 4, true, false);
        gridChartOpt.verticalSpan = 1;
        gridChartOpt.horizontalSpan = 1;
        groupChartOptions.setLayoutData((Object)gridChartOpt);
        groupChartOptions.setText("Plot Options");
        this.createListsKeys_X((Composite)groupChartOptions);
        this.createListsKeys_Y((Composite)groupChartOptions);
        new Label((Composite)groupChartOptions, 0).setText("Data");
        this.colFileCombo = new Combo((Composite)groupChartOptions, 8);
        this.colFileCombo.setEnabled(this.dataViewVector.size() > 0);
        this.colFileCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)this.colFileCombo.getLayoutData()).horizontalSpan = 1;
        this.colFileCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Combo cbo = (Combo)e.widget;
                int index = cbo.getSelectionIndex();
                if (index >= 0) {
                    ColFileXYPlot.this.currentColumnFile = (ColumnFile)ColFileXYPlot.this.columnFileVector.get(index);
                    ColFileXYPlot.this.colController.setCurrentColumnFile(ColFileXYPlot.this.currentColumnFile);
                    ColFileXYPlot.this.populateListsKeys(ColFileXYPlot.this.currentColumnFile);
                    if (ColFileXYPlot.this.currentDataView != null) {
                        ColFileXYPlot.this.chart.removeDataView(ColFileXYPlot.this.currentDataView);
                    }
                    ColFileXYPlot.this.currentDataView = (JLDataView)ColFileXYPlot.this.dataViewVector.get(index);
                    ColFileXYPlot.this.chart.getY1Axis().addDataView(ColFileXYPlot.this.currentDataView);
                }
                ColFileXYPlot.this.updateChart();
                ColFileXYPlot.this.repaint();
            }
        });
        this.createOptionsButtons(groupChartOptions);
        this.createEditPlotOptions(mainComposite);
        this.optionsComposite.setMinHeight(Display.getDefault().getPrimaryMonitor().getBounds().height);
        this.optionsComposite.setMinWidth(Display.getDefault().getPrimaryMonitor().getBounds().width);
        this.optionsComposite.setExpandVertical(true);
        this.optionsComposite.setExpandHorizontal(true);
        this.optionsComposite.setMinSize(mainComposite.computeSize(-1, -1));
    }

    private void createOptionsButtons(Group groupChartOptions) {
        this.createRemoveButton(groupChartOptions);
        this.createShowDataOptionsButton(groupChartOptions);
        this.createSwitchXYButton(groupChartOptions);
        this.createUpdateButton(groupChartOptions);
        this.createClearAllButton(groupChartOptions);
    }

    private void createSwitchXYButton(Group groupChartOptions) {
        this.switchXYButton = new Button((Composite)groupChartOptions, 8);
        this.switchXYButton.setText("Switch X Y");
        final Image removeimage = this.imgdescswitch.createImage();
        this.switchXYButton.setImage(removeimage);
        this.switchXYButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (removeimage != null && !removeimage.isDisposed()) {
                    removeimage.dispose();
                }
            }
        });
        this.switchXYButton.setToolTipText("Switch the x and y axes");
        this.switchXYButton.setLayoutData((Object)new GridData(272));
        this.switchXYButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColFileXYPlot.this.currentXIndex < 0 || ColFileXYPlot.this.currentYIndex < 0) {
                    return;
                }
                int temp = ColFileXYPlot.this.currentYIndex;
                ColFileXYPlot.this.currentYIndex = ColFileXYPlot.this.currentXIndex;
                ColFileXYPlot.this.currentXIndex = temp;
                String tempString = ColFileXYPlot.this.syAxisLabel;
                ColFileXYPlot.this.syAxisLabel = ColFileXYPlot.this.sxAxisLabel;
                ColFileXYPlot.this.sxAxisLabel = tempString;
                ColFileXYPlot.this.xKeysCombo.select(ColFileXYPlot.this.currentXIndex);
                ColFileXYPlot.this.yKeysCombo.select(ColFileXYPlot.this.currentYIndex);
                ColFileXYPlot.this.chart.getXAxis().setName(ColFileXYPlot.this.sxAxisLabel);
                ColFileXYPlot.this.chart.getY1Axis().setName(ColFileXYPlot.this.syAxisLabel);
                ColFileXYPlot.this.updateChart();
            }
        });
    }

    private void createClearAllButton(Group groupChartOptions) {
        this.resetButton = new Button((Composite)groupChartOptions, 8);
        this.resetButton.setText("Clear");
        final Image removeimage = this.imgdescdelete.createImage();
        this.resetButton.setImage(removeimage);
        this.resetButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (removeimage != null && !removeimage.isDisposed()) {
                    removeimage.dispose();
                }
            }
        });
        this.resetButton.setToolTipText("Clear plot and remove all column files");
        this.resetButton.setLayoutData((Object)new GridData(272));
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColFileXYPlot.this.clearAllPlots();
            }
        });
    }

    private void createUpdateButton(Group groupChartOptions) {
        this.updateButton = new Button((Composite)groupChartOptions, 8);
        this.updateButton.setText("Update");
        final Image imageRefresh = this.imgdescRefreshplot.createImage();
        this.updateButton.setImage(imageRefresh);
        this.updateButton.setToolTipText("Update chart frame and plot");
        this.updateButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (imageRefresh != null && !imageRefresh.isDisposed()) {
                    imageRefresh.dispose();
                }
            }
        });
        this.updateButton.setLayoutData((Object)new GridData(272));
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                double[] listY;
                int len;
                double[] listX = (double[])ColFileXYPlot.this.currentColumnFile.getColumnstoPlot().get(ColFileXYPlot.this.sxAxisLabel);
                int n = len = listX != null ? listX.length : 0;
                if (len > 0) {
                    ColFileXYPlot.this.currentXData = new double[len];
                    ColFileXYPlot.this.currentXData = (double[])ColFileXYPlot.this.currentColumnFile.getColumnstoPlot().get(ColFileXYPlot.this.sxAxisLabel);
                }
                int n2 = len = (listY = (double[])ColFileXYPlot.this.currentColumnFile.getColumnstoPlot().get(ColFileXYPlot.this.syAxisLabel)) != null ? listY.length : 0;
                if (len > 0) {
                    ColFileXYPlot.this.currentYData = new double[len];
                    ColFileXYPlot.this.currentYData = (double[])ColFileXYPlot.this.currentColumnFile.getColumnstoPlot().get(ColFileXYPlot.this.syAxisLabel);
                }
                ColFileXYPlot.this.updateChart(ColFileXYPlot.this.currentXData, ColFileXYPlot.this.currentYData);
            }
        });
    }

    private void createShowDataOptionsButton(Group groupChartOptions) {
        Button button = new Button((Composite)groupChartOptions, 8);
        button.setText("Data");
        button.setLayoutData((Object)new GridData(272));
        final Image image_chartOptions = this.imgdescChartOpt.createImage();
        button.setImage(image_chartOptions);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColFileXYPlot.this.currentDataView != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ColFileXYPlot.this.chart.showDataOptionDialog(ColFileXYPlot.this.currentDataView);
                        }
                    });
                } else {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Column file plot", (String)"No current dataview is available to display options.");
                }
            }
        });
        button.setToolTipText("Display current data options box.");
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (image_chartOptions != null && !image_chartOptions.isDisposed()) {
                    image_chartOptions.dispose();
                }
            }
        });
    }

    private void createRemoveButton(Group groupChartOptions) {
        this.removeButton = new Button((Composite)groupChartOptions, 8);
        final Image subtractimage = this.imgdescSub.createImage();
        this.removeButton.setImage(subtractimage);
        this.removeButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (subtractimage != null && !subtractimage.isDisposed()) {
                    subtractimage.dispose();
                }
            }
        });
        this.removeButton.setLayoutData((Object)new GridData(272));
        this.removeButton.setText("Remove Data");
        this.removeButton.setToolTipText("Remove selected ColumnFile of the list from the plot");
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ColFileXYPlot.this.colFileCombo.getSelectionIndex();
                ColFileXYPlot.this.columnFileVector.remove(index);
                JLDataView dataview = (JLDataView)ColFileXYPlot.this.dataViewVector.elementAt(index);
                ColFileXYPlot.this.chart.removeDataView(dataview);
                ColFileXYPlot.this.xKeysCombo.removeAll();
                ColFileXYPlot.this.yKeysCombo.removeAll();
                ColFileXYPlot.this.dataViewVector.remove(index);
                ColFileXYPlot.this.colFileCombo.remove(index);
                if (index > ColFileXYPlot.this.colFileCombo.getItemCount() - 1) {
                    index = ColFileXYPlot.this.colFileCombo.getItemCount() - 1;
                }
                ColFileXYPlot.this.colFileCombo.select(index);
                ColFileXYPlot.this.colFileCombo.notifyListeners(13, new Event());
            }
        });
    }

    private void createEditPlotOptions(Composite mainComposite) {
        this.editGroup = new Group(mainComposite, 0);
        this.editGroup.setText("Plot Editor");
        this.editGroup.setLayout((Layout)new GridLayout());
        ((GridLayout)this.editGroup.getLayout()).numColumns = 2;
        GridData gdColumnDots = new GridData(0x1000004, 4, true, false);
        gdColumnDots.verticalSpan = 1;
        gdColumnDots.horizontalSpan = 1;
        this.editGroup.setLayoutData((Object)gdColumnDots);
        new Label((Composite)this.editGroup, 0).setText("X Min");
        this.txtXMin = new Text((Composite)this.editGroup, 2048);
        this.txtXMin.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)this.editGroup, 0).setText("X Max");
        this.txtXMax = new Text((Composite)this.editGroup, 2048);
        this.txtXMax.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)this.editGroup, 0).setText("Y Min");
        this.txtY1Min = new Text((Composite)this.editGroup, 2048);
        this.txtY1Min.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)this.editGroup, 0).setText("Y Max");
        this.txtY1Max = new Text((Composite)this.editGroup, 2048);
        this.txtY1Max.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.keepDataButton = new Button((Composite)this.editGroup, 8);
        this.keepDataButton.setText("Keep");
        this.keepDataButton.setToolTipText("Keep all dots between min X, Y and max X, Y and remove others");
        this.keepDataButton.setImage(this.img_keep);
        this.keepDataButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ColFileXYPlot.this.img_keep != null && !ColFileXYPlot.this.img_keep.isDisposed()) {
                    ColFileXYPlot.this.img_keep.dispose();
                }
            }
        });
        this.keepDataButton.setEnabled(this.columnFileVector.size() > 0);
        this.keepDataButton.setLayoutData((Object)new GridData(256, 2, true, false, 1, 1));
        this.keepDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                double minX = 0.0;
                double minY = 0.0;
                double maxX = 0.0;
                double maxY = 0.0;
                if (!ColFileXYPlot.this.txtXMin.getText().trim().equals("")) {
                    minX = Double.valueOf(ColFileXYPlot.this.txtXMin.getText());
                }
                if (!ColFileXYPlot.this.txtXMin.getText().trim().equals("")) {
                    minY = Double.valueOf(ColFileXYPlot.this.txtY1Min.getText());
                }
                if (!ColFileXYPlot.this.txtXMin.getText().trim().equals("")) {
                    maxX = Double.valueOf(ColFileXYPlot.this.txtXMax.getText());
                }
                if (!ColFileXYPlot.this.txtXMin.getText().trim().equals("")) {
                    maxY = Double.valueOf(ColFileXYPlot.this.txtY1Max.getText());
                }
                ColFileXYPlot.this.keepDots(minX, maxX, minY, maxY);
                ColFileXYPlot.this.updateChart();
                ColFileXYPlot.this.repaint();
            }
        });
        this.removeDataButton = new Button((Composite)this.editGroup, 8);
        this.removeDataButton.setText("Remove");
        this.removeDataButton.setToolTipText("Remove all dots between min X, Y and max X, Y and keep others");
        this.removeDataButton.setImage(this.img_delete);
        this.removeDataButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ColFileXYPlot.this.img_delete != null && !ColFileXYPlot.this.img_delete.isDisposed()) {
                    ColFileXYPlot.this.img_delete.dispose();
                }
            }
        });
        this.removeDataButton.setEnabled(this.columnFileVector.size() > 0);
        this.removeDataButton.setLayoutData((Object)new GridData(256, 2, true, false, 1, 1));
        this.removeDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                double minX = 0.0;
                double minY = 0.0;
                double maxX = 0.0;
                double maxY = 0.0;
                if (!ColFileXYPlot.this.txtXMin.getText().trim().equals("")) {
                    minX = Double.valueOf(ColFileXYPlot.this.txtXMin.getText());
                }
                if (!ColFileXYPlot.this.txtXMin.getText().trim().equals("")) {
                    minY = Double.valueOf(ColFileXYPlot.this.txtY1Min.getText());
                }
                if (!ColFileXYPlot.this.txtXMin.getText().trim().equals("")) {
                    maxX = Double.valueOf(ColFileXYPlot.this.txtXMax.getText());
                }
                if (!ColFileXYPlot.this.txtXMin.getText().trim().equals("")) {
                    maxY = Double.valueOf(ColFileXYPlot.this.txtY1Max.getText());
                }
                ColFileXYPlot.this.removeDots(minX, maxX, minY, maxY);
                ColFileXYPlot.this.updateChart();
                ColFileXYPlot.this.repaint();
            }
        });
    }

    private void removeDots(double xmin, double xmax, double ymin, double ymax) {
        try {
            this.currentColumnFile.removeDots(this.sxAxisLabel, xmin, xmax, this.syAxisLabel, ymin, ymax);
        }
        catch (JepException e) {
            System.out.println(e.getMessage());
        }
    }

    private void keepDots(double xmin, double xmax, double ymin, double ymax) {
        try {
            this.currentColumnFile.keepDots(this.sxAxisLabel, xmin, xmax, this.syAxisLabel, ymin, ymax);
        }
        catch (JepException e) {
            System.out.println(e.getMessage());
        }
    }

    private void createChartFrame(Composite parent) {
        this.plotSwtAwtComposite = new Composite(parent, 0x1040000);
        GridData gdlist = new GridData(4, 4, true, true);
        gdlist.verticalSpan = 2;
        gdlist.horizontalSpan = 2;
        this.plotSwtAwtComposite.setLayout((Layout)new GridLayout());
        this.plotSwtAwtComposite.setLayoutData((Object)gdlist);
        this.chartFrame = SWT_AWT.new_Frame((Composite)this.plotSwtAwtComposite);
        this.chartContainer = new JApplet();
        this.chartFrame.add(this.chartContainer);
    }

    public void clearAllPlots() {
        Iterator<JLDataView> it = this.dataViewVector.iterator();
        while (it.hasNext()) {
            this.chart.removeDataView(it.next());
        }
        this.columnFileVector.removeAllElements();
        this.dataViewVector.removeAllElements();
        this.colFileCombo.removeAll();
        this.xKeysCombo.removeAll();
        this.yKeysCombo.removeAll();
        this.repaint();
        iDataColor = 0;
    }

    public void createChart() {
        this.chart = new JLChart();
        this.chart.setToolTipText("Zoom: Ctrl + select zone with mouse ");
        this.chart.setHeader(this.chartName);
        this.chart.setHeaderFont(new Font("Dialog", 1, 18));
        this.chart.getY1Axis().setName(this.syAxisLabel);
        this.chart.getY1Axis().setAutoScale(true);
        this.chart.getY1Axis().setGridVisible(true);
        this.chart.getY1Axis().setSubGridVisible(true);
        this.chart.getXAxis().setName(this.sxAxisLabel);
        this.chart.getXAxis().setGridVisible(true);
        this.chart.getXAxis().setSubGridVisible(true);
        this.chart.getXAxis().setAnnotation(2);
        this.chart.getXAxis().setAutoScale(true);
        this.chartContainer.add((Component)this.chart);
        Dimension chartSize = this.chartContainer.getSize();
        if (chartSize.height < chartSize.width) {
            this.chart.setSize(chartSize.height, chartSize.height);
        } else {
            this.chart.setSize(chartSize.width, chartSize.width);
        }
        this.actions = new JLChartActions(this.parent.getDisplay(), this.chart);
        this.chart.removeMenuItem(4);
        this.chart.addUserAction("Print Setup");
        this.chart.addUserAction("Print Preview");
        this.chart.addUserAction("Print");
        this.chart.addUserAction("Copy");
        this.chart.addUserAction("Toggle Plot Options");
        this.chartActionListener = new IJLChartActionListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(final JLChartActionEvent evt) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (evt.getName().equals("Print Setup")) {
                            ((ColFileXYPlot)(this).ColFileXYPlot.this).actions.printSetupAction.run();
                        } else if (evt.getName().equals("Print Preview")) {
                            ((ColFileXYPlot)(this).ColFileXYPlot.this).actions.printPreviewAction.run();
                        } else if (evt.getName().equals("Print")) {
                            ((ColFileXYPlot)(this).ColFileXYPlot.this).actions.printAction.run();
                        } else if (evt.getName().equals("Copy")) {
                            ((ColFileXYPlot)(this).ColFileXYPlot.this).actions.copyAction.run();
                        } else if (evt.getName().equals("Toggle Plot Options")) {
                            ColFileXYPlot.this.setOptionsShowing(!ColFileXYPlot.this.optionsShowing);
                        }
                    }
                });
            }

            public boolean getActionState(JLChartActionEvent evt) {
                return false;
            }
        };
        this.chart.addJLChartActionListener(this.chartActionListener);
        this.chart.setJLChartListener((IJLChartListener)this);
        this.chart.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        double minX = ColFileXYPlot.this.chart.getXAxis().getMin();
                        double minY = ColFileXYPlot.this.chart.getY1Axis().getMin();
                        double maxX = ColFileXYPlot.this.chart.getXAxis().getMax();
                        double maxY = ColFileXYPlot.this.chart.getY1Axis().getMax();
                        if (ColFileXYPlot.this.chart.getY1Axis().getScale() == 1) {
                            minY = Math.pow(10.0, minY);
                            maxY = Math.pow(10.0, maxY);
                        }
                        if (ColFileXYPlot.this.chart.getXAxis().getScale() == 1) {
                            minX = Math.pow(10.0, minX);
                            maxX = Math.pow(10.0, maxX);
                        }
                        ColFileXYPlot.this.txtY1Min.setText(String.valueOf(minY));
                        ColFileXYPlot.this.txtY1Max.setText(String.valueOf(maxY));
                        ColFileXYPlot.this.txtXMax.setText(String.valueOf(maxX));
                        ColFileXYPlot.this.txtXMin.setText(String.valueOf(minX));
                    }
                });
            }
        });
    }

    public String[] clickOnChart(JLChartEvent e) {
        String[] ret = new String[]{String.valueOf(this.sxAxisLabel) + "=" + e.getXValue(), String.valueOf(this.syAxisLabel) + "=" + e.getYValue()};
        return ret;
    }

    public int[] markSelectedRows(double[] id, String name) {
        this.selectedRowsId = new int[id.length];
        if (this.markedDataView == null) {
            this.markedDataView = new JLDataView();
            this.setDataViewOptions(this.markedDataView, 8, null, 7, 0);
        } else {
            this.markedDataView.reset();
        }
        double[] allid = (double[])this.currentColumnFile.getColumnstoPlot().get(name);
        int j = 0;
        while (j < id.length) {
            int i = 0;
            while (i < allid.length) {
                if (allid[i] == id[j]) {
                    this.selectedRowsId[j] = i;
                    if (this.currentDataView == null) break;
                    double x = this.currentDataView.getXValueByIndex(i);
                    double y = this.currentDataView.getYValueByIndex(i);
                    this.markedDataView.add(x, y);
                    break;
                }
                ++i;
            }
            ++j;
        }
        if (this.markedDataView.getDataLength() > 0) {
            this.markedDataView.setLabelVisible(true);
            this.markedDataView.setName("# " + id.length + " selected dots in table : ");
            this.setDataViewOptions(this.markedDataView, this.markedDataView.getMarker(), this.markedDataView.getMarkerColor(), this.markedDataView.getMarkerSize(), this.markedDataView.getLineWidth());
            this.chart.getY1Axis().addDataView(this.markedDataView);
            this.repaint();
        }
        return this.selectedRowsId;
    }

    public void updateChart() {
        if (this.currentDataView != null) {
            this.currentDataView.reset();
        }
        this.currentYData = null;
        this.currentXData = null;
        if (this.xKeysCombo.getItemCount() > this.currentXIndex && this.currentXIndex > -1) {
            this.sxAxisLabel = this.xKeysCombo.getItem(this.currentXIndex);
            this.chart.getXAxis().setName(this.sxAxisLabel);
        }
        int len = 0;
        if (this.sxAxisLabel != null && this.currentColumnFile != null) {
            double[] listX = (double[])this.currentColumnFile.getColumnstoPlot().get(this.sxAxisLabel);
            int n = len = listX != null ? listX.length : 0;
        }
        if (len > 0) {
            this.currentXData = new double[len];
            this.currentXData = (double[])this.currentColumnFile.getColumnstoPlot().get(this.sxAxisLabel);
        }
        if (this.yKeysCombo.getItemCount() > this.currentYIndex && this.currentYIndex > -1) {
            this.syAxisLabel = this.yKeysCombo.getItem(this.currentYIndex);
            this.chart.getY1Axis().setName(this.syAxisLabel);
        }
        if (this.syAxisLabel != null && this.currentColumnFile != null) {
            double[] listY = (double[])this.currentColumnFile.getColumnstoPlot().get(this.syAxisLabel);
            int n = len = listY != null ? listY.length : 0;
        }
        if (len > 0) {
            this.currentYData = new double[len];
            this.currentYData = (double[])this.currentColumnFile.getColumnstoPlot().get(this.syAxisLabel);
        }
        if (this.currentXData != null && this.currentYData != null) {
            if (!this.syAxisLabel.equals("") && !this.sxAxisLabel.equals("")) {
                if (this.currentDataView == null) {
                    this.currentDataView = new JLDataView();
                }
                this.currentDataView.setXDataSorted(false);
                this.currentDataView.setData(this.currentXData, this.currentYData);
            }
            this.chart.setHeader(this.currentColumnFile.getFileName());
        } else {
            this.chart.setNoValueString("No value to display");
        }
        this.updateRowsMarked();
        this.repaint();
    }

    private void updateRowsMarked() {
        if (this.selectedRowsId != null && this.selectedRowsId.length > 0) {
            this.markedDataView.reset();
            double[] allid = (double[])this.currentColumnFile.getColumnstoPlot().get(this.currentColumnFile.getColumnfileId());
            int j = 0;
            while (j < this.selectedRowsId.length) {
                int i = 0;
                while (i < allid.length) {
                    if (allid[i] == (double)this.selectedRowsId[j]) {
                        if (this.currentDataView == null) break;
                        double x = this.currentDataView.getXValueByIndex(i);
                        double y = this.currentDataView.getYValueByIndex(i);
                        this.markedDataView.add(x, y);
                        break;
                    }
                    ++i;
                }
                ++j;
            }
            if (this.markedDataView != null) {
                this.chart.getY1Axis().addDataView(this.markedDataView);
            }
        }
    }

    public JLDataView updateChart(double[] x, double[] y) {
        if (!Display.getCurrent().isDisposed()) {
            if (x != null && y != null) {
                if (!this.syAxisLabel.equals("") && !this.sxAxisLabel.equals("")) {
                    if (this.currentDataView == null) {
                        this.currentDataView = new JLDataView();
                    }
                    this.currentDataView.setXDataSorted(false);
                    this.currentDataView.setData(x, y);
                }
            } else {
                this.chart.setNoValueString("No value to display");
            }
        }
        this.repaint();
        this.currentDataView = null;
        return null;
    }

    public void updateColumnFile(ColumnFile col) {
        this.populateListsKeys(col);
    }

    public void addColumnFile(ColumnFile col) {
        this.currentColumnFile = col;
        this.colController.setCurrentColumnFile(this.currentColumnFile);
        if (this.columnFileVector.lastIndexOf(col) < 0) {
            this.columnFileVector.add(col);
            JLDataView data = null;
            data = new JLDataView();
            data.setXDataSorted(false);
            data.setName(col.getFullFileName());
            this.addDataView(data);
            this.populateListsKeys(col);
            if (this.xKeysCombo.getItemCount() > 0) {
                this.setSxAxisLabel(this.xKeysCombo.getItems()[this.currentXIndex]);
            }
            if (this.yKeysCombo.getItemCount() > 0) {
                this.setSyAxisLabel(this.yKeysCombo.getItems()[this.currentYIndex]);
            }
            this.updateChart();
        } else {
            this.populateListsKeys(col);
            this.repaint();
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ColFileXYPlot.this.removeDataButton.setEnabled(ColFileXYPlot.this.columnFileVector.size() > 0);
                ColFileXYPlot.this.keepDataButton.setEnabled(ColFileXYPlot.this.columnFileVector.size() > 0);
            }
        });
    }

    public void addDataView(JLDataView dtV) {
        if (!Display.getCurrent().isDisposed()) {
            if (dtV != null) {
                this.chart.getY1Axis().setName(this.syAxisLabel);
                this.chart.getXAxis().setName(this.sxAxisLabel);
                if (this.dataViewVector.indexOf(dtV) < 0) {
                    this.dataViewVector.add(dtV);
                    this.colFileCombo.add(dtV.getName());
                    this.colFileCombo.setData(dtV.getName(), (Object)this.columnFileVector.lastElement());
                }
                if (this.currentDataView != null) {
                    this.chart.removeDataView(this.currentDataView);
                }
                this.currentDataView = dtV;
                this.currentColumnFile = this.columnFileVector.lastElement();
                this.colController.setCurrentColumnFile(this.currentColumnFile);
                this.colFileCombo.select(this.colFileCombo.getItemCount() - 1);
                this.colFileCombo.setEnabled(this.dataViewVector.size() > 0);
                this.setDataViewOptions(dtV, 1, null, 7, 0);
                this.chart.getY1Axis().addDataView(dtV);
            } else {
                this.chart.setNoValueString("No value to display");
            }
            this.repaint();
        }
    }

    private void setDataViewOptions(JLDataView dtV, int marker, Color color, int markerSize, int lineWidth) {
        dtV.setMarker(marker);
        dtV.setMarkerSize(markerSize);
        dtV.setLineWidth(lineWidth);
        if (color == null) {
            dtV.setMarkerColor(this.dataColors[iDataColor]);
            iDataColor = iDataColor < this.dataColors.length - 1 ? ++iDataColor : 0;
        }
    }

    public void removeDataView(JLDataView dv) {
        this.chart.removeDataView(dv);
        this.dataViewVector.remove(dv);
        if (this.colFileCombo.getItemCount() > 0) {
            this.colFileCombo.remove(dv.getName());
            this.colFileCombo.select(this.colFileCombo.getItemCount() - 1);
        } else {
            this.colFileCombo.setEnabled(false);
        }
        this.repaint();
    }

    public void repaint() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColFileXYPlot.this.chartContainer.repaint();
            }
        });
    }

    private void selectLabelinXCombo(String label) {
        boolean found = false;
        int i = 0;
        i = 0;
        while (this.xKeysCombo != null && !found && i < this.xKeysCombo.getItemCount()) {
            if (this.xKeysCombo.getItems()[i].equals(label)) {
                found = true;
                this.xKeysCombo.select(i);
                this.currentXIndex = i;
            }
            ++i;
        }
    }

    private void selectLabelinYCombo(String label) {
        boolean found = false;
        int i = 0;
        i = 0;
        while (this.yKeysCombo != null && !found && i < this.yKeysCombo.getItemCount()) {
            if (this.yKeysCombo.getItems()[i].equals(label)) {
                found = true;
                this.yKeysCombo.select(i);
                this.currentYIndex = i;
            }
            ++i;
        }
    }

    public JLChart getChart() {
        return this.chart;
    }

    public JApplet getChartContainer() {
        return this.chartContainer;
    }

    public Vector<JLDataView> getVectordataview() {
        return this.dataViewVector;
    }

    public JLDataView getCurrentDataView() {
        return this.currentDataView;
    }

    public void plotData(String[] xyLabel) {
        boolean bfound = false;
        String xlabel = "";
        String ylabel = "";
        if (xyLabel.length == 2) {
            xlabel = xyLabel[0];
            ylabel = xyLabel[1];
        }
        int i = 0;
        while (!bfound && i < this.xKeysCombo.getItemCount()) {
            if (this.xKeysCombo.getItem(i).equals(xlabel)) {
                bfound = true;
                this.xKeysCombo.select(i);
            }
            ++i;
        }
        bfound = false;
        i = 0;
        while (!bfound && i < this.yKeysCombo.getItemCount()) {
            if (this.yKeysCombo.getItem(i).equals(ylabel)) {
                bfound = true;
                this.yKeysCombo.select(i);
            }
            ++i;
        }
        this.plotSelectedXAxis();
        this.plotSelectedY1Axis();
    }

    public void dispose() {
        if (this.chart != null && this.chartActionListener != null) {
            this.chart.removeJLChartActionListener(this.chartActionListener);
            this.chartActionListener = null;
        }
        if (this.parent != null && !this.parent.isDisposed() && this.paintListener != null) {
            this.parent.removePaintListener(this.paintListener);
            this.paintListener = null;
        }
        this.chart = null;
    }

    public boolean getOptionsShowing() {
        return this.optionsShowing;
    }

    public void setOptionsShowing(boolean optionsShowing) {
        this.optionsShowing = optionsShowing;
        if (this.sashForm == null) {
            return;
        }
        if (optionsShowing) {
            this.sashForm.setMaximizedControl(null);
        } else {
            this.sashForm.setMaximizedControl((Control)this.plotSwtAwtComposite);
        }
    }

    private void resetPreferredCurrentXIndex() {
        this.currentXIndex = 0;
    }

    private void resetPreferredCurrentY1Index() {
        this.currentYIndex = 1;
    }

    class comboDataView_ContentProvider
    implements IContentProvider {
        comboDataView_ContentProvider() {
        }

        public Object[] getElements(Vector<JLDataView> inputElement) {
            return inputElement.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class comboDataView_LabelProvider
    implements IBaseLabelProvider {
        comboDataView_LabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return ((JLDataView)element).getName();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

