/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.dialog;

import fable.framework.internal.ICrystalSymmetryVarKeys;
import fable.framework.ui.rcp.Activator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class CrystalSymmetryDialog
extends Dialog {
    private Combo spaceGroupSymbolCombo;
    private Shell shell;
    private Spinner spaceGroupSpinner;
    private static final int COMBO_BOX_WIDTH = 50;
    private Text spaceSystemText;
    private int spaceGroup = 1;
    private int spaceGroupSystem = 0;

    public CrystalSymmetryDialog(Shell parentShell, int spgr) {
        this(parentShell, 67680, spgr);
    }

    public CrystalSymmetryDialog(Shell parentShell, int style, int spgr) {
        super(parentShell, style);
        this.setText("Space Group");
        this.spaceGroup = spgr;
    }

    public int open() {
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.setText(this.getText());
        this.shell.setLayout((Layout)new GridLayout(2, true));
        this.createContents((Composite)this.shell);
        this.shell.pack();
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.spaceGroup;
    }

    protected Control createContents(Composite container) {
        Composite composite = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)composite);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        new Label(composite, 0).setText("Symbol");
        this.spaceGroupSymbolCombo = new Combo(composite, 28);
        this.spaceGroupSymbolCombo.setLayoutData((Object)new GridData(4, 16, true, false));
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).hint(50, -1).applyTo((Control)this.spaceGroupSymbolCombo);
        this.spaceGroupSymbolCombo.setToolTipText("spacegroup:\n\nThe space group ID number is needed to transform a \ndetermined orientation into the fundamental region \n(the unique part of the orientation space). This is \ndone so that the same solution will always have the same \nU matrix, not one of the other possible symmetric \norientations allowed by symmetry. Either the space group\n symbol or the number may equivalently be given, but the \nnumber is used in the program");
        int i = 0;
        while (i < 230) {
            this.spaceGroupSymbolCombo.add(ICrystalSymmetryVarKeys.SPACE_GROUP_SYMBOLS[i]);
            ++i;
        }
        this.spaceGroupSymbolCombo.select(0);
        this.spaceGroupSymbolCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CrystalSymmetryDialog.this.spaceGroup = CrystalSymmetryDialog.this.spaceGroupSymbolCombo.getSelectionIndex() + 1;
                CrystalSymmetryDialog.this.setSpaceGroup(CrystalSymmetryDialog.this.spaceGroup);
            }
        });
        composite = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)composite);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        new Label(composite, 0).setText("Number");
        this.spaceGroupSpinner = new Spinner(composite, 2068);
        this.spaceGroupSpinner.setToolTipText("spacegroup:\n\nThe space group ID number is needed to transform a \ndetermined orientation into the fundamental region \n(the unique part of the orientation space). This is \ndone so that the same solution will always have the same \nU matrix, not one of the other possible symmetric \norientations allowed by symmetry. Either the space group\n symbol or the number may equivalently be given, but the \nnumber is used in the program");
        this.spaceGroupSpinner.setLayoutData((Object)new GridData(16384, 16, true, false));
        this.spaceGroupSpinner.setMinimum(1);
        this.spaceGroupSpinner.setMaximum(230);
        this.spaceGroupSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CrystalSymmetryDialog.this.spaceGroup = CrystalSymmetryDialog.this.spaceGroupSpinner.getSelection();
                CrystalSymmetryDialog.this.setSpaceGroup(CrystalSymmetryDialog.this.spaceGroup);
            }
        });
        composite = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(2, 1).applyTo((Control)composite);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        new Label(composite, 0).setText("Crystal System:");
        this.spaceSystemText = new Text(composite, 0);
        this.spaceSystemText.setEditable(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.spaceSystemText);
        this.spaceSystemText.setText(ICrystalSymmetryVarKeys.SPACE_GROUP_TYPES[this.spaceGroupSystem]);
        this.spaceSystemText.setToolTipText("The crystal system is determined by the space group.");
        this.createButtons();
        this.setSpaceGroup(this.spaceGroup);
        return container;
    }

    private void createButtons() {
        Image image;
        Image image2;
        Composite composite = new Composite((Composite)this.shell, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Button ok = new Button(composite, 24);
        ok.setText("Ok");
        ImageDescriptor descriptor = Activator.getImageDescriptor("images/add.gif");
        if (descriptor != null && (image2 = descriptor.createImage()) != null) {
            ok.setImage(image2);
        }
        ok.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CrystalSymmetryDialog.this.shell.close();
            }
        });
        Button cancel = new Button(composite, 24);
        cancel.setText("Cancel");
        descriptor = Activator.getImageDescriptor("images/delete.gif");
        if (descriptor != null && (image = descriptor.createImage()) != null) {
            cancel.setImage(image);
        }
        cancel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CrystalSymmetryDialog.this.spaceGroup = 0;
                CrystalSymmetryDialog.this.shell.close();
            }
        });
        this.shell.setDefaultButton(ok);
    }

    public void setSpaceGroup(int spaceGroup) {
        this.spaceGroup = spaceGroup;
        if (this.spaceGroupSymbolCombo.getSelectionIndex() != spaceGroup - 1) {
            this.spaceGroupSymbolCombo.select(spaceGroup - 1);
        }
        if (this.spaceGroupSpinner.getSelection() != spaceGroup) {
            this.spaceGroupSpinner.setSelection(spaceGroup);
        }
        int newspaceGroupSystem = 0;
        int i = 0;
        while (i < ICrystalSymmetryVarKeys.SPACE_GROUP_MAXIMUM.length) {
            if (spaceGroup <= ICrystalSymmetryVarKeys.SPACE_GROUP_MAXIMUM[i]) {
                newspaceGroupSystem = i;
                break;
            }
            ++i;
        }
        this.spaceGroupSystem = newspaceGroupSystem;
        this.spaceSystemText.setText(ICrystalSymmetryVarKeys.SPACE_GROUP_TYPES[this.spaceGroupSystem]);
    }
}

