/*
 * Decompiled with CFR 0.152.
 */
package fable.fitallb.wizard;

import fable.fitallb.Activator;
import fable.fitallb.editors.FitAllB;
import fable.fitallb.wizard.IInputPage;
import fable.fitallb.wizard.InputWizard;
import fable.framework.toolbox.FloatText;
import fable.framework.toolbox.FloatTextAppender;
import fable.framework.toolbox.TypedText;
import java.io.BufferedWriter;
import java.io.IOException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class OutlierRejectionPageNearField
extends WizardPage
implements IInputPage {
    private FloatText near_min_refl;
    private FloatText near_overlap;
    private Button rejMultiYes;
    private Button rejMultiNo;
    private FloatText near_rej_ia;
    private FloatText near_rej_vol;
    private FloatText near_rej_median;
    private FloatText near_rej_resmean;
    private FitAllB fitAllB;

    protected OutlierRejectionPageNearField(String pageName, FitAllB fit) {
        super(pageName);
        this.setTitle("Outlier Rejection - Near-field detector");
        this.setDescription("Set second detector option for outlier rejection here.");
        this.fitAllB = fit;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        GridData gd = new GridData(768);
        container.setLayoutData((Object)gd);
        Label label = new Label(container, 0);
        label.setText("Minimum Number of Reflections [1, inf]:");
        this.near_min_refl = new FloatText(container, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.near_min_refl.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText("Overlap:");
        this.near_overlap = new FloatText(container, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.near_overlap.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText("Reject peaks assigned to multiple grains:");
        this.rejMultiYes = new Button(container, 16);
        this.rejMultiYes.setText("Yes");
        this.rejMultiNo = new Button(container, 16);
        this.rejMultiNo.setText("No");
        label = new Label(container, 0);
        label.setText("Outlier Rejection Limits In Term Of :");
        gd = new GridData(770);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText("Gvector Misorientations ]0,inf] [deg]:");
        this.near_rej_ia = new FloatText(container, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.near_rej_ia.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText("Volume/Intensity Based Rejection [3,inf]:");
        this.near_rej_vol = new FloatText(container, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.near_rej_vol.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText("Robust Residual Based Rejection [1,inf]:");
        this.near_rej_median = new FloatText(container, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.near_rej_median.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText("Average Residual [3,inf]:");
        this.near_rej_resmean = new FloatText(container, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.near_rej_resmean.setLayoutData((Object)gd);
        this.setControl((Control)container);
        this.setData();
        this.setTooltipText();
        this.initialize();
        this.dialogChanged();
    }

    private void setTooltipText() {
        this.near_overlap.setToolTipText("near_overlap: fraction of identical peaks assigned to grains before merging is considered, \nvalue in ]0;1], default: 1 (no merging)");
        this.near_min_refl.setToolTipText("near_min_refl: minimum number of reflections to considered near_field refinement meaningful,\nvalue in [1,inf], default: 3");
        this.rejMultiYes.setToolTipText("near_rej_multi: reject peaks assigned to multiple grains (0=no/1=yes), \ndefault: 1");
        this.rejMultiNo.setToolTipText("near_rej_multi: reject peaks assigned to multiple grains (0=no/1=yes), \ndefault: 1");
        this.near_rej_ia.setToolTipText("near_rej_ia:  near-field outlier rejection limits same meaning and defaults as far-field conterparts");
        this.near_rej_vol.setToolTipText("near_rej_vol: outlier limit for volume/intensity based rejection, \nvalue in [3;inf], default: 5");
        this.near_rej_median.setToolTipText("near_rej_resmedian: outlier limit for robust residual based rejection, \nvalue in [1;inf], default: 5");
        this.near_rej_resmean.setToolTipText("near_rej_resmean: outlier rejection limit in terms of average residual, \nvalue in [3;inf], default: 10");
    }

    private void initialize() {
        this.fitAllB = ((InputWizard)this.getWizard()).getFitAllB();
        this.initialize((Composite)this.getControl());
    }

    private void dialogChanged() {
        this.updateStatus(null);
    }

    private void initialize(Composite container) {
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        Control[] children = container.getChildren();
        int i = 0;
        while (i < children.length) {
            Float preferredValue;
            Text text;
            String key;
            if (children[i] instanceof Composite && !(children[i] instanceof TypedText)) {
                this.initialize((Composite)children[i]);
            } else if (children[i] instanceof Button) {
                Button child = (Button)children[i];
                if ((child.getStyle() & 0x10) != 0 && (key = (String)child.getData()) != null) {
                    int preferredValue2 = preferences.getInt(key);
                    String value = (String)child.getData(key);
                    if (value != null) {
                        child.setSelection(value.equals(String.valueOf(preferredValue2)));
                    }
                }
            } else if (children[i] instanceof Text) {
                String preferredValue3;
                text = (Text)children[i];
                key = (String)text.getData();
                if (key != null && (preferredValue3 = preferences.getString(key)) != null) {
                    text.setText(preferredValue3);
                }
            } else if (children[i] instanceof Group) {
                this.initialize((Composite)((Group)children[i]));
            } else if (children[i] instanceof FloatTextAppender) {
                String preferredValue4;
                text = (FloatTextAppender)children[i];
                key = (String)text.getTextField().getData();
                if (key != null && (preferredValue4 = preferences.getString(key)) != null && !preferredValue4.trim().equals("")) {
                    text.setText(preferredValue4);
                }
            } else if (children[i] instanceof FloatText && (key = (String)(text = (FloatText)children[i]).getTextField().getData()) != null && (preferredValue = Float.valueOf(preferences.getFloat(key))) != null) {
                text.setText(preferredValue.toString());
            }
            ++i;
        }
    }

    private void setData() {
        this.near_overlap.getTextField().setData((Object)"near_overlap");
        this.near_min_refl.getTextField().setData((Object)"near_min_refl");
        this.rejMultiYes.setData((Object)"near_rej_multi");
        this.rejMultiYes.setData("near_rej_multi", (Object)"1");
        this.rejMultiNo.setData((Object)"near_rej_multi");
        this.rejMultiNo.setData("near_rej_multi", (Object)"0");
        this.near_rej_ia.getTextField().setData((Object)"near_rej_ia");
        this.near_rej_vol.getTextField().setData((Object)"near_rej_vol");
        this.near_rej_median.getTextField().setData((Object)"near_rej_resmedian");
        this.near_rej_resmean.getTextField().setData((Object)"near_rej_resmean");
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getMin_refl() {
        return this.near_min_refl.getText();
    }

    public String getOverlap() {
        return this.near_overlap.getText();
    }

    public boolean getRejMultiYes() {
        return this.rejMultiYes.getSelection();
    }

    public String getRej_ia() {
        return this.near_rej_ia.getText();
    }

    public String getRej_vol() {
        return this.near_rej_vol.getText();
    }

    public String getRej_median() {
        return this.near_rej_median.getText();
    }

    public String getRej_resmean() {
        return this.near_rej_resmean.getText();
    }

    @Override
    public void writePage(BufferedWriter writer) throws IOException {
        if (this.fitAllB.getNumberOfDetectors() == 2) {
            writer.write("#Outlier rejection - Second Detector (near-field)");
            writer.newLine();
            if (this.getMin_refl() != null && this.getMin_refl().trim().length() > 0) {
                writer.write("near_min_refl " + this.getMin_refl());
                writer.newLine();
            }
            if (this.getOverlap() != null && this.getOverlap().trim().length() > 0) {
                writer.write("near_overlap " + this.getOverlap());
                writer.newLine();
            }
            writer.write("near_rej_multi " + (this.getRejMultiYes() ? "1" : "0"));
            writer.newLine();
            if (this.getRej_ia() != null && this.getRej_ia().trim().length() > 0) {
                writer.write("near_rej_ia " + this.getRej_ia());
                writer.newLine();
            }
            if (this.getRej_vol() != null && this.getRej_vol().trim().length() > 0) {
                writer.write("near_rej_vol " + this.getRej_vol());
                writer.newLine();
            }
            if (this.getRej_median() != null && this.getRej_median().trim().length() > 0) {
                writer.write("near_rej_resmedian " + this.getRej_median());
                writer.newLine();
            }
            if (this.getRej_resmean() != null && this.getRej_resmean().trim().length() > 0) {
                writer.write("near_rej_resmean " + this.getRej_resmean());
                writer.newLine();
            }
        }
    }
}

