/*
 * Decompiled with CFR 0.152.
 */
package fable.fitallb.wizard;

import fable.fitallb.editors.FitAllB;
import fable.fitallb.internal.FitAllBException;
import fable.fitallb.internal.IVarKeys;
import fable.fitallb.properties.InputForFitallbDocument;
import fable.fitallb.wizard.CommonRequiredKeysPage2;
import fable.fitallb.wizard.FitPage;
import fable.fitallb.wizard.FitallbInputWizardPage1;
import fable.fitallb.wizard.IInputPage;
import fable.fitallb.wizard.OutlierRejectionPageFarField;
import fable.fitallb.wizard.OutlierRejectionPageNearField;
import fable.framework.toolbox.FableUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class InputWizard
extends Wizard
implements INewWizard {
    private static final String ID = "fable.fitallb.wizard";
    private FitallbInputWizardPage1 page1;
    private CommonRequiredKeysPage2 page2;
    private OutlierRejectionPageFarField page3;
    private ISelection selection;
    private FitPage fitPage;
    private OutlierRejectionPageNearField page4;
    private FitAllB fitallb;
    private IInputPage[] inputPages;

    public InputWizard() {
        this.setWindowTitle("Input File Wizard for FitAllb or FitGloball/FitGlobalGrain");
        try {
            this.fitallb = new FitAllB();
        }
        catch (FitAllBException e) {
            FableUtils.errMsg((Object)e.getClassname(), (String)e.getMessage());
        }
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void setPage2(CommonRequiredKeysPage2 page) {
        this.page2 = page;
    }

    public CommonRequiredKeysPage2 getPage2() {
        return this.page2;
    }

    public void addPages() {
        this.inputPages = new IInputPage[5];
        this.page1 = new FitallbInputWizardPage1("Input file", this.selection);
        this.addPage((IWizardPage)this.page1);
        this.inputPages[0] = this.page1;
        this.setPage2(new CommonRequiredKeysPage2("Experiment, Setup & Files For One Detector", 2, this.selection, this.fitallb));
        this.addPage((IWizardPage)this.getPage2());
        this.inputPages[1] = this.getPage2();
        this.page3 = new OutlierRejectionPageFarField("Outlier Rejection for far-field detector", this.fitallb);
        this.addPage((IWizardPage)this.page3);
        this.inputPages[2] = this.page3;
        this.page4 = new OutlierRejectionPageNearField("Outlier Rejection for near-field detector", this.fitallb);
        this.addPage((IWizardPage)this.page4);
        this.inputPages[3] = this.page4;
        this.fitPage = new FitPage("Fitting Parameters", this.fitallb);
        this.addPage((IWizardPage)this.fitPage);
        this.inputPages[4] = this.fitPage;
    }

    public boolean performFinish_() {
        final String containerName = this.page1.getContainerName();
        final String fileName = this.page1.getFileName();
        final ArrayList<InputForFitallbDocument> properties = new ArrayList<InputForFitallbDocument>();
        properties.add(new InputForFitallbDocument());
        ((InputForFitallbDocument)properties.get(0)).setProperty("LABEL", "#");
        ((InputForFitallbDocument)properties.get(0)).setProperty("title", this.page1.getInputFileTitle());
        properties.add(new InputForFitallbDocument());
        this.fillFilesAndExperimentalSetupProperties((InputForFitallbDocument)properties.get(1));
        properties.add(new InputForFitallbDocument());
        this.fillOutlierRejectionProperties((InputForFitallbDocument)properties.get(2));
        properties.add(new InputForFitallbDocument());
        if (this.fitallb.getNumberOfDetectors() == 2) {
            this.fillOutlierRejectionForNearfieldProperties((InputForFitallbDocument)properties.get(3));
        }
        properties.add(new InputForFitallbDocument());
        this.fillFitProperties((InputForFitallbDocument)properties.get(4));
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        InputWizard.this.doFinish_(containerName, fileName, properties, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void fillFilesAndExperimentalSetupProperties(InputForFitallbDocument properties) {
        properties.setProperty("LABEL", "#Experiment, Set up and files");
        properties.setProperty("log_file", this.getPage2().getLogFile());
        properties.setProperty("flt_file ", this.getPage2().getFltFile());
        properties.setProperty("par_file", this.getPage2().getParFile());
        properties.setProperty("res_file", this.getPage2().getResFile());
        properties.setProperty("sgno", this.getPage2().getSgno());
        properties.setProperty("near_flt_file ", this.getPage2().getNearFltFile());
        properties.setProperty("near_par_file", this.getPage2().getNearParFile());
        properties.setProperty("w_step", this.getPage2().getWStep());
        properties.setProperty("w_limit", this.getPage2().getWLimitRange());
        properties.setProperty("bg", this.getPage2().getBg());
        properties.setProperty("dety_size", this.getPage2().getdetYSize());
        properties.setProperty("detz_size", this.getPage2().getdetZSize());
        properties.setProperty("near_bg", this.getPage2().getNearBg());
        properties.setProperty("near_dety_size", this.getPage2().getNeardetYSize());
        properties.setProperty("near_detz_size", this.getPage2().getNeardetZSize());
        properties.setProperty("structure_file ", this.getPage2().getStructureFile());
        if (!this.getPage2().getStructureFile().equals("")) {
            properties.setProperty("beampol_factor", this.getPage2().getBeamPolFactor());
            properties.setProperty("beampol_direct", this.getPage2().getBeamPolDirect());
        }
        properties.setProperty("crystal_system", this.getPage2().getCrystalSystem());
        properties.setProperty("stress", this.getPage2().getStress() ? "1" : "0");
        if (this.getPage2().getStress()) {
            HashMap<String, String> stifnessConstants = this.page2.getStifnessConstants();
            Set<Map.Entry<String, String>> entrySet = stifnessConstants.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                System.out.println(String.valueOf(entry.getKey()) + " " + entry.getValue());
                properties.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    private void doFinish_(String containerName, String fileName, ArrayList<InputForFitallbDocument> property, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (resource == null) {
            this.throwCoreException("Project not found. Please check page 1 for the project name.");
        } else if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Project \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile iFile = container.getFile((IPath)new Path(fileName));
        File file = iFile.getLocation().toFile();
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file, false));
            for (InputForFitallbDocument properties : property) {
                if (properties.getProperty("LABEL") != null) {
                    writer.write(properties.getProperty("LABEL"));
                    writer.newLine();
                    properties.remove("LABEL");
                }
                Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
                for (Map.Entry<Object, Object> entry : entrySet) {
                    if (entry.getValue().toString().length() <= 0) continue;
                    writer.write(entry.getKey() + " " + entry.getValue());
                    writer.newLine();
                }
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.throwCoreException("Error writing to file " + file.toString());
        }
        container.refreshLocal(2, monitor);
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)iFile, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (resource == null) {
            this.throwCoreException("Project not found. Please check page 1 for the project name.");
        } else if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Project \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile iFile = container.getFile((IPath)new Path(fileName));
        final File file = iFile.getLocation().toFile();
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    BufferedWriter writer = new BufferedWriter(new FileWriter(file, false));
                    IInputPage[] iInputPageArray = InputWizard.this.inputPages;
                    int n = iInputPageArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IInputPage page = iInputPageArray[n2];
                        page.writePage(writer);
                        ++n2;
                    }
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {
                    FableUtils.errMsg((Object)InputWizard.getId(), (String)("Error writing to file " + file.toString()));
                }
            }
        });
        container.refreshLocal(2, monitor);
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)iFile, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "Fitallb input file", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    private void fillOutlierRejectionProperties(InputForFitallbDocument properties) {
        properties.setProperty("LABEL", "#Outlier rejection - First Detector (far-field)");
        properties.setProperty("skip", this.page3.getSkip());
        properties.setProperty("min_refl", this.page3.getMin_refl());
        properties.setProperty("overlap", this.page3.getOverlap());
        properties.setProperty("rej_multi", this.page3.getRejMultiYes() ? "1" : "0");
        properties.setProperty("rej_ia", this.page3.getRej_ia());
        properties.setProperty("rej_vol", this.page3.getRej_vol());
        properties.setProperty("rej_resmedian", this.page3.getRej_median());
        properties.setProperty("rej_resmean", this.page3.getRej_resmean());
    }

    private void fillOutlierRejectionForNearfieldProperties(InputForFitallbDocument properties) {
        properties.setProperty("LABEL", "#Outlier rejection - Second Detector (near-field)");
        properties.setProperty("near_min_refl", this.page4.getMin_refl());
        properties.setProperty("near_overlap", this.page4.getOverlap());
        properties.setProperty("near_rej_multi", this.page4.getRejMultiYes() ? "1" : "0");
        properties.setProperty("near_rej_ia", this.page4.getRej_ia());
        properties.setProperty("near_rej_vol", this.page4.getRej_vol());
        properties.setProperty("near_rej_resmedian", this.page4.getRej_median());
        properties.setProperty("near_rej_resmean", this.page4.getRej_resmean());
    }

    private void fillFitProperties(InputForFitallbDocument properties) {
        properties.setProperty("LABEL", "#Fit parameters");
        if (!this.fitallb.getProgram().equals(IVarKeys.MODE_FITALLB)) {
            properties.setProperty("w", this.fitPage.getWfit() ? "1" : "0");
            properties.setProperty("tilt", this.fitPage.getTiltFit() ? "1" : "0");
            properties.setProperty("pixel", this.fitPage.getPixelFit() ? "1" : "0");
            properties.setProperty("center", this.fitPage.getCenterFit() ? "1" : "0");
            properties.setProperty("L", this.fitPage.getLFit() ? "1" : "0");
            properties.setProperty("cycle", this.fitPage.getCycle());
        }
        properties.setProperty("xyz", this.fitPage.getXyzFit() ? "1" : "0");
        properties.setProperty("rod", this.fitPage.getRodFit() ? "1" : "0");
        properties.setProperty("eps", this.fitPage.getEpsFit() ? "1" : "0");
        if (this.fitallb.getNumberOfDetectors() == 2) {
            properties.setProperty("near_xyz", this.fitPage.getNear_xyzFit() ? "1" : "0");
            properties.setProperty("near_rod", this.fitPage.getNear_rodFit() ? "1" : "0");
        }
        properties.setProperty("tol_grain", this.fitPage.getTol_grain());
        properties.setProperty("tol_rotpos", this.fitPage.getTol_rotpos());
        properties.setProperty("tol_global", this.fitPage.getTol_global());
    }

    public FitallbInputWizardPage1 getPage1() {
        return this.page1;
    }

    public IWizardPage getFitPage() {
        return this.fitPage;
    }

    public FitAllB getFitAllB() {
        return this.fitallb;
    }

    public static String getId() {
        return ID;
    }

    public boolean performFinish() {
        IRunnableWithProgress op = new IRunnableWithProgress(){
            final String containerName;
            final String fileName;
            {
                this.containerName = InputWizard.this.page1.getContainerName();
                this.fileName = InputWizard.this.page1.getFileName();
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        InputWizard.this.doFinish(this.containerName, this.fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            FableUtils.errMsg((Object)InputWizard.getId(), (String)realException.getMessage());
            return false;
        }
        return true;
    }
}

