/*
 * Decompiled with CFR 0.152.
 */
package fable.fitallb.wizard;

import fable.fitallb.Activator;
import fable.fitallb.editors.FitAllB;
import fable.fitallb.event.FitAllBEvent;
import fable.fitallb.internal.IVarKeys;
import fable.fitallb.listeners.IFitAllBEventListener;
import fable.fitallb.wizard.IInputPage;
import fable.framework.toolbox.FloatText;
import fable.framework.toolbox.FloatTextAppender;
import fable.framework.toolbox.IntegerText;
import fable.framework.toolbox.TypedText;
import fable.framework.ui.dialog.CrystalSymmetryDialog;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CommonRequiredKeysPage2
extends WizardPage
implements IInputPage {
    private Image helpImg;
    private ISelection selection;
    private Text logFile;
    private Text fltFile;
    private Text parFile;
    private Text resFile;
    private Text structureFile;
    private IntegerText sgno;
    private Text nearDetectorfltFile;
    private Text nearDetectorparFile;
    private Group secondDetectorComposite;
    private FloatText wstep;
    private Table wlimitRange;
    private Text bg;
    private Text detYSize;
    private Text detZSize;
    private Combo crystalSystem;
    private FloatText beamPolDirect;
    private FloatText beamPolFactor;
    private int nDetectors;
    private Text nearDetZSize;
    private Text nearDetYSize;
    private Text nearBg;
    private Button notconvert;
    private Button convert;
    private static String[] logFileExt = new String[]{"*.log", "*.*"};
    private static String[] logFileNames = new String[]{"*.log", "All Files (*.*)"};
    private static String[] filteredFileExt = new String[]{"*.flt", "*.*"};
    private static String[] filteredFileNames = new String[]{"*.flt", "All Files (*.*)"};
    private static String[] paramFileExt = new String[]{"*.par;*.pars;*.prm", "*.*"};
    private static String[] paramFileNames = new String[]{"*.par, *.pars, *.prm", "All Files (*.*)"};
    private Text stiffness;
    private Group groupStress;
    private FitAllB fitAllB;
    final String YES = "1";
    final String NO = "0";
    public String currentDirectory;
    private FitallbListener fitallbListener;
    private Button unitCellSpaceGroupHelpBtn;
    ImageDescriptor deleteDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.fitallb", (String)"icons/delete.gif");
    ImageDescriptor addDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.fitallb", (String)"icons/add.gif");
    protected int activeColumn;

    protected CommonRequiredKeysPage2(String pageName, int numberOfDetectors, ISelection selection2, FitAllB fit) {
        super(pageName);
        this.setTitle("Files and Experimental Set up");
        this.setDescription("Set files for and Experimental setup here.");
        this.nDetectors = numberOfDetectors;
        this.selection = selection2;
        this.fitAllB = fit;
        this.fitallbListener = new FitallbListener();
        this.fitAllB.addFitallbListener(this.fitallbListener);
    }

    public void dispose() {
        if (this.fitAllB != null) {
            this.fitAllB.removeFitallbListener(this.fitallbListener);
        }
    }

    public void createControl(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        Composite container = new Composite((Composite)sc, 20);
        sc.setContent((Control)container);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        GridData gd = new GridData(16, 16);
        container.setLayoutData((Object)gd);
        this.createcompositeFilesParam(container);
        this.createFarFieldDetectorParam(container);
        this.createSecondDetectorsParameters(container);
        Group groupExperimental = new Group(container, 0);
        groupExperimental.setText("Experimental");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        groupExperimental.setLayout((Layout)gridLayout);
        gd = new GridData(768);
        groupExperimental.setLayoutData((Object)gd);
        Label label = new Label((Composite)groupExperimental, 0);
        label.setText("Step Size In Omega [deg] :");
        this.wstep = new FloatText((Composite)groupExperimental, 0);
        this.wstep.getTextField().setData((Object)"w_step");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.wstep.setLayoutData((Object)gd);
        this.wstep.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonRequiredKeysPage2.this.dialogChanged();
            }
        });
        this.createTableOmegaLimit(groupExperimental);
        label = new Label((Composite)groupExperimental, 0);
        label.setText("Beam Polarisation Factor:");
        this.beamPolFactor = new FloatText((Composite)groupExperimental, 0);
        this.beamPolFactor.getTextField().setData((Object)"beampol_factor");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.beamPolFactor.setLayoutData((Object)gd);
        this.beamPolFactor.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonRequiredKeysPage2.this.dialogChanged();
            }
        });
        label = new Label((Composite)groupExperimental, 0);
        label.setText("Primary Beam Polarisation Direction [deg]:");
        this.beamPolDirect = new FloatText((Composite)groupExperimental, 0);
        this.beamPolDirect.getTextField().setData((Object)"beampol_direct");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.beamPolDirect.setLayoutData((Object)gd);
        this.beamPolDirect.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonRequiredKeysPage2.this.dialogChanged();
            }
        });
        label = new Label((Composite)groupExperimental, 0);
        label.setText("Crystal System:");
        this.crystalSystem = new Combo((Composite)groupExperimental, 12);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.crystalSystem.setLayoutData((Object)gd);
        this.crystalSystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonRequiredKeysPage2.this.initializeStiffness();
                CommonRequiredKeysPage2.this.dialogChanged();
            }
        });
        this.crystalSystem.setData((Object)"crystal_system");
        this.fillComboCrystalSystem();
        this.createGroupStrainToStress(container);
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        sc.setMinSize(container.computeSize(-1, -1));
        this.setControl((Control)sc);
        this.initialize();
        this.dialogChanged();
    }

    private void createTableOmegaLimit(Group omegaGroup) {
        Label label = new Label((Composite)omegaGroup, 0);
        label.setText("Limit Of Omega Intervals [deg] (]-180, 180]):");
        Composite container = new Composite((Composite)omegaGroup, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(16384, 4, true, false, 2, 1));
        this.wlimitRange = new Table(container, 68352);
        this.wlimitRange.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 2));
        this.wlimitRange.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int x = 0;
                int i = 0;
                while (i < CommonRequiredKeysPage2.this.wlimitRange.getColumnCount()) {
                    if (e.x <= (x += CommonRequiredKeysPage2.this.wlimitRange.getColumn(i).getWidth())) {
                        CommonRequiredKeysPage2.this.activeColumn = i;
                        break;
                    }
                    ++i;
                }
            }
        });
        String[] columnsProperties = new String[]{"Minimum", "Maximum"};
        this.createMinMaxColumnOmegaRange(columnsProperties);
        this.createRows(this.wlimitRange, 1);
        Button addButton = new Button(container, 8);
        addButton.setLayoutData((Object)new GridData(16384, 1024, false, true, 1, 1));
        final Image imageAdd = this.addDescriptor.createImage();
        addButton.setImage(imageAdd);
        addButton.setToolTipText("Add a new range for this option.");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new TableItem(CommonRequiredKeysPage2.this.wlimitRange, 0);
            }
        });
        addButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (imageAdd != null && !imageAdd.isDisposed()) {
                    imageAdd.dispose();
                }
            }
        });
        Button removeButton = new Button(container, 8);
        final Image imageremove = this.deleteDescriptor.createImage();
        removeButton.setImage(imageremove);
        removeButton.setLayoutData((Object)new GridData(16384, 1024, false, true, 1, 1));
        removeButton.setToolTipText("Remove a range for this option.");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = CommonRequiredKeysPage2.this.wlimitRange.getSelectionIndex();
                if (index != -1) {
                    TableItem tableItem = CommonRequiredKeysPage2.this.wlimitRange.getItem(index);
                    tableItem.dispose();
                }
            }
        });
        removeButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (imageremove != null && !imageremove.isDisposed()) {
                    imageremove.dispose();
                }
            }
        });
        this.wlimitRange.setToolTipText("");
        this.wlimitRange.setData((Object)"w_limit");
        this.triggerTableSelectionOmegaRange();
    }

    private void createMinMaxColumnOmegaRange(String[] columnsProperties) {
        TableColumn columnMin = new TableColumn(this.wlimitRange, 0);
        columnMin.setText(columnsProperties[0]);
        columnMin.setWidth(100);
        columnMin.setData("index", (Object)0);
        TableColumn columnMax = new TableColumn(this.wlimitRange, 0);
        columnMax.setText(columnsProperties[1]);
        columnMax.setWidth(100);
        columnMax.setData("index", (Object)1);
        this.wlimitRange.setHeaderVisible(true);
        columnMin.pack();
        columnMax.pack();
        this.wlimitRange.pack();
    }

    private void createRows(Table table, int maxrows) {
        int i = 0;
        while (i < maxrows) {
            new TableItem(table, 0);
            ++i;
        }
    }

    private void triggerTableSelectionOmegaRange() {
        final TableEditor omegaRangeEditor = new TableEditor(this.wlimitRange);
        omegaRangeEditor.horizontalAlignment = 16384;
        omegaRangeEditor.grabHorizontal = true;
        omegaRangeEditor.minimumWidth = 50;
        this.wlimitRange.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = CommonRequiredKeysPage2.this.wlimitRange.getClientArea();
                Point pt = new Point(event.x, event.y);
                int index = CommonRequiredKeysPage2.this.wlimitRange.getTopIndex();
                while (index < CommonRequiredKeysPage2.this.wlimitRange.getItemCount()) {
                    boolean visible = false;
                    final TableItem item = CommonRequiredKeysPage2.this.wlimitRange.getItem(index);
                    int i = 0;
                    while (i < CommonRequiredKeysPage2.this.wlimitRange.getColumnCount()) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt)) {
                            final int column = i;
                            final Text text = new Text((Composite)CommonRequiredKeysPage2.this.wlimitRange, 0);
                            Listener textListener = new Listener(){

                                public void handleEvent(Event e) {
                                    switch (e.type) {
                                        case 16: {
                                            item.setText(column, text.getText());
                                            CommonRequiredKeysPage2.this.dialogChanged();
                                            text.dispose();
                                            break;
                                        }
                                        case 31: {
                                            switch (e.detail) {
                                                case 4: {
                                                    item.setText(column, text.getText());
                                                }
                                                case 2: {
                                                    text.dispose();
                                                    e.doit = false;
                                                }
                                            }
                                            CommonRequiredKeysPage2.this.dialogChanged();
                                        }
                                    }
                                }
                            };
                            text.addListener(16, textListener);
                            text.addListener(31, textListener);
                            omegaRangeEditor.setEditor((Control)text, item, i);
                            text.setText(item.getText(i));
                            text.setFocus();
                            CommonRequiredKeysPage2.this.dialogChanged();
                            return;
                        }
                        if (!visible && rect.intersects(clientArea)) {
                            CommonRequiredKeysPage2.this.dialogChanged();
                            visible = true;
                        }
                        ++i;
                    }
                    if (!visible) {
                        CommonRequiredKeysPage2.this.dialogChanged();
                        return;
                    }
                    ++index;
                }
                CommonRequiredKeysPage2.this.dialogChanged();
            }
        });
    }

    private void initializeEnableFields() {
        boolean enable = this.structureFile.getText().length() == 0 && this.resFile.getText().length() != 0;
        this.sgno.getTextField().setEnabled(enable);
        this.unitCellSpaceGroupHelpBtn.setEnabled(enable);
        this.enableGroupBeamPolFactor(this.structureFile.getText().length() > 0);
    }

    private void createFarFieldDetectorParam(Composite container) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        GridData gd = new GridData(768);
        Group group = new Group(container, 0);
        group.setLayout((Layout)new GridLayout(3, true));
        group.setLayoutData((Object)new GridData(768));
        group.setText("Farfield Detector");
        Label label = new Label((Composite)group, 0);
        label.setText("Filtered Peaks File (.flt):");
        this.fltFile = new Text((Composite)group, 2052);
        this.fltFile.setData((Object)"flt_file ");
        gd = new GridData(768);
        this.fltFile.setLayoutData((Object)gd);
        this.fltFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonRequiredKeysPage2.this.dialogChanged();
            }
        });
        Button buttonflt = new Button((Composite)group, 8);
        buttonflt.setText("Browse...");
        buttonflt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonRequiredKeysPage2.this.handleBrowse(CommonRequiredKeysPage2.this.fltFile, filteredFileNames, filteredFileExt);
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Parameter File:");
        this.parFile = new Text((Composite)group, 2052);
        this.parFile.setData((Object)"par_file");
        gd = new GridData(768);
        this.parFile.setLayoutData((Object)gd);
        this.parFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonRequiredKeysPage2.this.dialogChanged();
            }
        });
        Button buttonpar = new Button((Composite)group, 8);
        buttonpar.setText("Browse...");
        buttonpar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonRequiredKeysPage2.this.handleBrowse(CommonRequiredKeysPage2.this.parFile, paramFileNames, paramFileExt);
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Background [counts]:");
        this.bg = new Text((Composite)group, 2052);
        this.bg.setData((Object)"bg");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.bg.setLayoutData((Object)gd);
        this.bg.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonRequiredKeysPage2.this.dialogChanged();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Detector in y [pixels]:");
        this.detYSize = new Text((Composite)group, 2052);
        this.detYSize.setData((Object)"dety_size");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.detYSize.setLayoutData((Object)gd);
        this.detYSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonRequiredKeysPage2.this.dialogChanged();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Detector in z [pixels]:");
        this.detZSize = new Text((Composite)group, 2052);
        this.detZSize.setData((Object)"detz_size");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.detZSize.setLayoutData((Object)gd);
        this.detZSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonRequiredKeysPage2.this.dialogChanged();
            }
        });
    }

    private void createGroupStrainToStress(Composite container) {
        this.groupStress = new Group(container, 0);
        this.groupStress.setLayout((Layout)new GridLayout(3, true));
        this.groupStress.setLayoutData((Object)new GridData(4, 4, true, true));
        this.groupStress.setText("Strain to stress");
        Label label = new Label((Composite)this.groupStress, 0);
        label.setText("stress:");
        this.convert = new Button((Composite)this.groupStress, 16);
        this.convert.setData((Object)"stress");
        this.convert.setData("stress", (Object)"1");
        this.convert.setText("convert");
        this.notconvert = new Button((Composite)this.groupStress, 16);
        this.notconvert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CommonRequiredKeysPage2.this.convert.getSelection()) {
                    CommonRequiredKeysPage2.this.stiffness.setEnabled(true);
                    CommonRequiredKeysPage2.this.initializeStiffness();
                } else {
                    CommonRequiredKeysPage2.this.stiffness.setText("");
                    CommonRequiredKeysPage2.this.stiffness.setEnabled(false);
                }
            }
        });
        this.notconvert.setData((Object)"stress");
        this.notconvert.setData("stress", (Object)"0");
        this.notconvert.setText("do not convert");
        this.convert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CommonRequiredKeysPage2.this.convert.getSelection()) {
                    CommonRequiredKeysPage2.this.stiffness.setEnabled(true);
                    CommonRequiredKeysPage2.this.initializeStiffness();
                } else {
                    CommonRequiredKeysPage2.this.stiffness.setText("");
                    CommonRequiredKeysPage2.this.stiffness.setEnabled(false);
                }
            }
        });
        label = new Label((Composite)this.groupStress, 0);
        label.setText("Stiffness constants (Gpa):");
        this.stiffness = new Text((Composite)this.groupStress, 2882);
        GridData gridData = new GridData(272);
        gridData.horizontalSpan = 3;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        this.stiffness.setLayoutData((Object)gridData);
        this.stiffness.setData((Object)"StiffnessPreferences");
    }

    private void initializeStiffness() {
        String cSystem = this.crystalSystem.getText();
        this.stiffness.setText("");
        if (cSystem.length() > 0 && this.convert.getSelection()) {
            String[] constants = IVarKeys.getStiffness(cSystem);
            int i = 0;
            while (i < constants.length) {
                this.stiffness.append(constants[i]);
                this.stiffness.append("\r\n");
                ++i;
            }
        }
    }

    private void createcompositeFilesParam(Composite container) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        Composite filesComposite = new Composite(container, 16);
        filesComposite.setLayout((Layout)gridLayout);
        GridData gd = new GridData(768);
        filesComposite.setLayoutData((Object)gd);
        Label label = new Label(filesComposite, 0);
        label.setText("Grainspotter Log File (.log):");
        this.logFile = new Text(filesComposite, 2052);
        this.logFile.setData((Object)"log_file");
        this.logFile.setLayoutData((Object)gd);
        this.logFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonRequiredKeysPage2.this.dialogChanged();
            }
        });
        Button button = new Button(filesComposite, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonRequiredKeysPage2.this.handleBrowse(CommonRequiredKeysPage2.this.logFile, logFileNames, logFileExt);
            }
        });
        label = new Label(filesComposite, 0);
        label.setText("Result File (.gff file):");
        this.resFile = new Text(filesComposite, 2052);
        this.resFile.setData((Object)"res_file");
        gd = new GridData(768);
        this.resFile.setLayoutData((Object)gd);
        this.resFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean enabled = CommonRequiredKeysPage2.this.structureFile.getText().length() == 0 && CommonRequiredKeysPage2.this.resFile.getText().length() != 0;
                CommonRequiredKeysPage2.this.sgno.getTextField().setEnabled(enabled);
                CommonRequiredKeysPage2.this.unitCellSpaceGroupHelpBtn.setEnabled(enabled);
                CommonRequiredKeysPage2.this.dialogChanged();
            }
        });
        Button buttonRes = new Button(filesComposite, 8);
        buttonRes.setText("Browse...");
        buttonRes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonRequiredKeysPage2.this.handleBrowse(CommonRequiredKeysPage2.this.resFile, new String[]{"*.gff", "All Files (*.*)"}, new String[]{"*.gff", "*.*"});
            }
        });
        label = new Label(filesComposite, 0);
        label.setText("Structure File:");
        this.structureFile = new Text(filesComposite, 2052);
        this.structureFile.setData((Object)"structure_file ");
        gd = new GridData(768);
        this.structureFile.setLayoutData((Object)gd);
        this.structureFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonRequiredKeysPage2.this.enableGroupBeamPolFactor(CommonRequiredKeysPage2.this.structureFile.getText().length() > 0);
                boolean enabled = CommonRequiredKeysPage2.this.structureFile.getText().length() == 0 && CommonRequiredKeysPage2.this.resFile.getText().length() != 0;
                CommonRequiredKeysPage2.this.sgno.getTextField().setEnabled(enabled);
                CommonRequiredKeysPage2.this.unitCellSpaceGroupHelpBtn.setEnabled(enabled);
                CommonRequiredKeysPage2.this.dialogChanged();
            }
        });
        Button btnstructureFile = new Button(filesComposite, 8);
        btnstructureFile.setText("Browse...");
        btnstructureFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonRequiredKeysPage2.this.handleBrowse(CommonRequiredKeysPage2.this.structureFile, new String[]{"*.cif", "*.pdf", "All Files (*.*)"}, new String[]{"*.cif", "*.pdf", "*.*"});
            }
        });
        new Label(filesComposite, 0).setText("Space group number:");
        this.sgno = new IntegerText(filesComposite, 0, "", 1, 230);
        gd = new GridData(768);
        this.sgno.setLayoutData((Object)gd);
        this.sgno.setData((Object)"sgno");
        this.sgno.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonRequiredKeysPage2.this.dialogChanged();
            }
        });
        this.helpImg = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_LINKTO_HELP");
        this.unitCellSpaceGroupHelpBtn = new Button(filesComposite, 0x840000);
        this.unitCellSpaceGroupHelpBtn.setImage(this.helpImg);
        this.unitCellSpaceGroupHelpBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CrystalSymmetryDialog dialog;
                int value;
                int oldValue = 0;
                String strOldValue = CommonRequiredKeysPage2.this.sgno.getText();
                try {
                    oldValue = Integer.valueOf(strOldValue);
                }
                catch (Exception exception) {
                    oldValue = 1;
                }
                if (oldValue < 1) {
                    oldValue = 1;
                }
                if (oldValue > 230) {
                    oldValue = 230;
                }
                if ((value = (dialog = new CrystalSymmetryDialog(CommonRequiredKeysPage2.this.getShell(), oldValue)).open()) != 0) {
                    CommonRequiredKeysPage2.this.sgno.set_Text(String.valueOf(value));
                }
            }
        });
        this.unitCellSpaceGroupHelpBtn.setToolTipText("Need some help based on the Space Group Symbol?");
    }

    private void createSecondDetectorsParameters(Composite container) {
        this.secondDetectorComposite = new Group(container, 0);
        this.secondDetectorComposite.setLayout((Layout)new GridLayout(3, true));
        this.secondDetectorComposite.setLayoutData((Object)new GridData(768));
        this.secondDetectorComposite.setText("Nearfield Detector");
        Label label = new Label((Composite)this.secondDetectorComposite, 0);
        label.setText("Nearfield Filtered Peaks File (.flt):");
        this.nearDetectorfltFile = new Text((Composite)this.secondDetectorComposite, 2052);
        this.nearDetectorfltFile.setData((Object)"near_flt_file ");
        GridData gd = new GridData(768);
        this.nearDetectorfltFile.setLayoutData((Object)gd);
        this.nearDetectorfltFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonRequiredKeysPage2.this.dialogChanged();
            }
        });
        Button buttonnearflt = new Button((Composite)this.secondDetectorComposite, 8);
        buttonnearflt.setText("Browse...");
        buttonnearflt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonRequiredKeysPage2.this.handleBrowse(CommonRequiredKeysPage2.this.nearDetectorfltFile, filteredFileNames, filteredFileExt);
            }
        });
        label = new Label((Composite)this.secondDetectorComposite, 0);
        label.setText("Nearfield Detector Parameter File:");
        this.nearDetectorparFile = new Text((Composite)this.secondDetectorComposite, 2052);
        this.nearDetectorparFile.setData((Object)"near_par_file");
        gd = new GridData(768);
        this.nearDetectorparFile.setLayoutData((Object)gd);
        this.nearDetectorparFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonRequiredKeysPage2.this.dialogChanged();
            }
        });
        Button buttonNearpar = new Button((Composite)this.secondDetectorComposite, 8);
        buttonNearpar.setText("Browse...");
        buttonNearpar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonRequiredKeysPage2.this.handleBrowse(CommonRequiredKeysPage2.this.nearDetectorparFile, paramFileNames, paramFileExt);
            }
        });
        label = new Label((Composite)this.secondDetectorComposite, 0);
        label.setText("Background [counts]:");
        this.nearBg = new Text((Composite)this.secondDetectorComposite, 2052);
        this.nearBg.setData((Object)"near_bg");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.nearBg.setLayoutData((Object)gd);
        this.nearBg.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonRequiredKeysPage2.this.dialogChanged();
            }
        });
        label = new Label((Composite)this.secondDetectorComposite, 0);
        label.setText("Detector in y [pixels]:");
        this.nearDetYSize = new Text((Composite)this.secondDetectorComposite, 2052);
        this.nearDetYSize.setData((Object)"near_dety_size");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.nearDetYSize.setLayoutData((Object)gd);
        this.nearDetYSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonRequiredKeysPage2.this.dialogChanged();
            }
        });
        label = new Label((Composite)this.secondDetectorComposite, 0);
        label.setText("Detector in z [pixels]:");
        this.nearDetZSize = new Text((Composite)this.secondDetectorComposite, 2052);
        this.nearDetZSize.setData((Object)"near_detz_size");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.nearDetZSize.setLayoutData((Object)gd);
        this.nearDetZSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonRequiredKeysPage2.this.dialogChanged();
            }
        });
    }

    private void fillComboCrystalSystem() {
        int i = 0;
        while (i < IVarKeys.CRYSTAL_SYSTEM.length) {
            this.crystalSystem.add(IVarKeys.CRYSTAL_SYSTEM[i]);
            ++i;
        }
    }

    private void initialize(Composite container) {
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        Control[] children = container.getChildren();
        int i = 0;
        while (i < children.length) {
            String preferredValues;
            Combo combo;
            Text text;
            String key;
            if (children[i] instanceof Composite && !(children[i] instanceof TypedText) && !(children[i] instanceof Table) && !(children[i] instanceof Combo)) {
                this.initialize((Composite)children[i]);
            } else if (children[i] instanceof Button) {
                Button child = (Button)children[i];
                if ((child.getStyle() & 0x10) != 0 && (key = (String)child.getData()) != null) {
                    int preferredValue = preferences.getInt(key);
                    String value = (String)child.getData(key);
                    if (value != null) {
                        child.setSelection(value.equals(String.valueOf(preferredValue)));
                    }
                }
            } else if (children[i] instanceof Text) {
                String preferredValue;
                text = (Text)children[i];
                key = (String)text.getData();
                if (key != null && (preferredValue = preferences.getString(key)) != null) {
                    text.setText(preferredValue);
                }
            } else if (children[i] instanceof Group) {
                this.initialize((Composite)((Group)children[i]));
            } else if (children[i] instanceof FloatTextAppender) {
                String preferredValue;
                text = (FloatTextAppender)children[i];
                key = (String)text.getTextField().getData();
                if (key != null && (preferredValue = preferences.getString(key)) != null && !preferredValue.trim().equals("")) {
                    text.setText(preferredValue);
                }
            } else if (children[i] instanceof FloatText) {
                Float preferredValue;
                text = (FloatText)children[i];
                key = (String)text.getTextField().getData();
                if (key != null && (preferredValue = Float.valueOf(preferences.getFloat(key))) != null) {
                    text.setText(preferredValue.toString());
                }
            } else if (children[i] instanceof Table) {
                String preferredValues2;
                Table table = (Table)children[i];
                key = (String)table.getData();
                if (key != null && (preferredValues2 = preferences.getString(key)) != null && preferredValues2.trim().length() > 0) {
                    String[] pairs = preferredValues2.split("\\p{Space}");
                    int items = pairs.length;
                    int row = 0;
                    while (row < items) {
                        if (table.getItemCount() <= row / 2) {
                            new TableItem(table, 0);
                        }
                        TableItem item = table.getItem(row / 2);
                        item.setText(0, pairs[row]);
                        if (++row < pairs.length) {
                            item.setText(1, pairs[row]);
                        }
                        ++row;
                    }
                }
            } else if (children[i] instanceof Combo && (key = (String)(combo = (Combo)children[i]).getData()) != null && (preferredValues = preferences.getString(key)) != null && preferredValues.trim().length() > 0) {
                int index = combo.indexOf(preferredValues);
                combo.select(index);
            }
            ++i;
        }
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                IPath path = container.getLocation();
                System.out.println("Path: " + path.toOSString());
                this.currentDirectory = path.toOSString();
            }
        }
        this.setTooltipText();
        this.initializeEnableFields();
        this.initialize((Composite)this.getControl());
        this.stiffness.setEnabled(this.convert.getSelection());
    }

    private void setTooltipText() {
        this.logFile.setToolTipText("log_file: name of grainspotter.log from GrainSpotter containing indexing information");
        this.fltFile.setToolTipText("flt_file : name of peaksearch.flt from peaksearch containing filtered peaks information");
        this.parFile.setToolTipText("par_file: name of detector.par from ImageD11 containing information about experimental setup");
        this.resFile.setToolTipText("res_file: name of .gff file from which to read starting grain parameters");
        this.structureFile.setToolTipText("structure_file : name of file containing crystallographic information, possible formats: .cif or .pdf");
        this.nearDetectorfltFile.setToolTipText("near_flt_file : name of peaksearch.flt filtered peaks file from peaksearch containing near-field data");
        this.nearDetectorparFile.setToolTipText("near_par_file: name of detector.par file from ImageD11 containing near-field global parameters");
        this.wstep.setToolTipText("w_step: step size in omega [deg], value in ]0;inf[");
        this.wlimitRange.setToolTipText("w_limit: limits of omega intervals [deg], order irrelevant but there must be an even number of limits, values in ]-180;180]");
        this.bg.setToolTipText("bg: average background level [counts] on detector, value in ]0;2e16], default: 1000");
        this.detYSize.setToolTipText("dety_size: detector dimension in y [pixels], default: 2048 (ESRF ID11 Frelon4M)");
        this.detZSize.setToolTipText("detz_size: detector dimension in z [pixels], default: 2048");
        this.crystalSystem.setToolTipText("crystal_system");
        this.beamPolDirect.setToolTipText("beampol_direct: direction of the normal to the plane of the primary beam polarisation with respect to the sample rotation axis [deg]");
        this.beamPolFactor.setToolTipText("beampol_factor: beam polarisation factor: 1 = fully plane polarised (default), 0 = unpolarised");
        this.nearDetZSize.setToolTipText("near_detz_size: near-field detector dimension in z [pixels], default: 1024");
        this.nearDetYSize.setToolTipText("near_dety_size: near-field detector dimension in y [pixels], default: 1536 (ESRF ID11 quantix)");
        this.nearBg.setToolTipText("near_bg: average background level [counts] on near-field detector, value in ]0;2e16], default: 100");
        this.notconvert.setToolTipText("stress: convert strain to stress (0=no/1=yes), default: 0");
        this.convert.setToolTipText("stress: convert strain to stress (0=no/1=yes), default: 0");
        this.stiffness.setToolTipText("stiffness constants, symmetry given by crystal_system \nwill ensure setup of entire tensor from minimal set, which must be given for stress 1, defaults: None");
        this.sgno.setToolTipText("sgno: space group number. Onle needed a structure file is not given, \nand if the grain info is given as a res_file in stead of a log_file");
    }

    private void enableGroupBeamPolFactor(boolean b) {
        this.beamPolDirect.setEnabled(b);
        this.beamPolFactor.setEnabled(b);
    }

    private void handleBrowse(Text file, String[] filterNames, String[] filterExtension) {
        FileDialog dlg = new FileDialog(this.getShell());
        dlg.setFilterNames(filterNames);
        dlg.setFilterExtensions(filterExtension);
        dlg.setFilterPath(this.currentDirectory);
        String textFile = dlg.open();
        if (textFile != null) {
            file.setText(textFile);
        }
    }

    private void dialogChanged() {
        if (this.logFile.getText().length() == 0 && this.resFile.getText().length() == 0) {
            this.updateStatus("Either Log file or Result file is required.");
            return;
        }
        if (this.fltFile.getText().length() == 0) {
            this.updateStatus("Filtered file for farfield detector is required.");
            return;
        }
        if (this.parFile.getText().length() == 0) {
            this.updateStatus("Parameter file for farfield detector is required.");
            return;
        }
        if (this.wstep.getText().length() == 0) {
            this.updateStatus("Omega step is required.");
            return;
        }
        if (this.wlimitRange.getItemCount() == 0 || this.wlimitRange.getItemCount() > 0 && this.wlimitRange.getItem(0).getText(0).length() == 0 || this.wlimitRange.getItemCount() > 0 && this.wlimitRange.getItem(0).getText(1).length() == 0) {
            this.updateStatus("Omega limit is required.");
            return;
        }
        if (this.crystalSystem.getText().length() == 0) {
            this.updateStatus("Crystal system is required.");
            return;
        }
        if (!(this.structureFile.getText().length() != 0 || this.resFile.getText().length() == 0 || this.sgno.getText().length() != 0 && this.sgno.is_bValide())) {
            this.updateStatus("Space group number is required.");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getLogFile() {
        return this.logFile.getText();
    }

    public String getFltFile() {
        return this.fltFile.getText();
    }

    public String getParFile() {
        return this.parFile.getText();
    }

    public String getWStep() {
        return this.wstep.getText();
    }

    public String getWLimitRange() {
        String listOfOmega = "";
        int i = 0;
        while (i < this.wlimitRange.getItemCount()) {
            listOfOmega = String.valueOf(listOfOmega) + this.wlimitRange.getItem(i).getText(0);
            listOfOmega = String.valueOf(listOfOmega) + " " + this.wlimitRange.getItem(i).getText(1) + " ";
            ++i;
        }
        return listOfOmega;
    }

    public String getBg() {
        return this.bg.getText();
    }

    public String getdetYSize() {
        return this.detYSize.getText();
    }

    public String getdetZSize() {
        return this.detZSize.getText();
    }

    public String getBeamPolDirect() {
        return this.beamPolDirect.getText();
    }

    public String getCrystalSystem() {
        return this.crystalSystem.getText();
    }

    public String getBeamPolFactor() {
        return this.beamPolFactor.getText();
    }

    public String getNearDetectorfltFile() {
        return this.nearDetectorfltFile.getText();
    }

    public void setNearDetectorfltFile(String string) {
        this.nearDetectorfltFile.setText(string);
    }

    public String getNearDetectorparFile() {
        return this.nearDetectorparFile.getText();
    }

    public void setNearDetectorparFile(String string) {
        this.nearDetectorparFile.setText(string);
    }

    public String getResFile() {
        return this.resFile.getText();
    }

    public void setNumberOfDetectors(int numberOfDetectors) {
        this.nDetectors = numberOfDetectors;
        this.showSecondDetectorParameters(this.nDetectors == 2);
    }

    public void showSecondDetectorParameters(boolean show) {
        this.secondDetectorComposite.setVisible(show);
        GridData data = (GridData)this.secondDetectorComposite.getLayoutData();
        data.exclude = !show;
        Composite parent = this.secondDetectorComposite.getParent();
        if (parent != null) {
            parent.layout(false);
        }
    }

    public String getNearFltFile() {
        return this.nearDetectorfltFile.getText();
    }

    public String getNearParFile() {
        return this.nearDetectorparFile.getText();
    }

    public String getNearBg() {
        return this.nearBg.getText();
    }

    public String getNeardetYSize() {
        return this.nearDetYSize.getText();
    }

    public String getNeardetZSize() {
        return this.nearDetZSize.getText();
    }

    public String getStructureFile() {
        return this.structureFile.getText();
    }

    public boolean getStress() {
        return this.convert.getSelection();
    }

    public HashMap<String, String> getStifnessConstants() {
        String longText = this.stiffness.getText();
        String[] split = longText.split("\r\n");
        HashMap<String, String> stifnessconstants = new HashMap<String, String>();
        int i = 0;
        while (i < split.length) {
            String[] keySplit = split[i].trim().split("\\p{Space}+");
            if (keySplit.length > 0) {
                String key = keySplit[0];
                int keyIndex = split[i].indexOf(keySplit[0]);
                String value = "";
                if ((keyIndex += keySplit[0].length()) > 0 && keyIndex < split[i].length()) {
                    value = split[i].substring(keyIndex);
                }
                stifnessconstants.put(key, value);
            }
            ++i;
        }
        return stifnessconstants;
    }

    public String getSgno() {
        return this.sgno.getText();
    }

    @Override
    public void writePage(BufferedWriter writer) throws IOException {
        writer.write("#Experiment, Set up and files");
        writer.newLine();
        writer.write("log_file " + this.getLogFile());
        writer.newLine();
        writer.write("flt_file  " + this.getFltFile());
        writer.newLine();
        writer.write("par_file " + this.getParFile());
        writer.newLine();
        if (this.getResFile() != null && this.getResFile().trim().length() > 0) {
            writer.write("res_file " + this.getResFile());
            writer.newLine();
        }
        if (this.getSgno() != null && this.getSgno().trim().length() > 0) {
            writer.write("sgno " + this.getSgno());
            writer.newLine();
        }
        if (this.fitAllB.getNumberOfDetectors() == 2) {
            if (this.getNearFltFile() != null && this.getNearFltFile().trim().length() > 0) {
                writer.write("near_flt_file  " + this.getNearFltFile());
                writer.newLine();
            }
            if (this.getNearParFile() != null && this.getNearParFile().trim().length() > 0) {
                writer.write("near_par_file " + this.getNearParFile());
                writer.newLine();
            }
        }
        writer.write("w_step " + this.getWStep());
        writer.newLine();
        writer.write("w_limit " + this.getWLimitRange());
        writer.newLine();
        if (this.getBg() != null && this.getBg().trim().length() > 0) {
            writer.write("bg " + this.getBg());
            writer.newLine();
        }
        if (this.getdetYSize() != null && this.getdetYSize().trim().length() > 0) {
            writer.write("dety_size " + this.getdetYSize());
            writer.newLine();
        }
        if (this.getdetZSize() != null && this.getdetZSize().trim().length() > 0) {
            writer.write("detz_size " + this.getdetZSize());
            writer.newLine();
        }
        if (this.fitAllB.getNumberOfDetectors() == 2) {
            if (this.getNearBg() != null && this.getNearBg().trim().length() > 0) {
                writer.write("near_bg " + this.getNearBg());
                writer.newLine();
            }
            if (this.getNeardetYSize() != null && this.getNeardetYSize().trim().length() > 0) {
                writer.write("near_dety_size " + this.getNeardetYSize());
                writer.newLine();
            }
            if (this.getNeardetZSize() != null && this.getNeardetZSize().trim().length() > 0) {
                writer.write("near_detz_size " + this.getNeardetZSize());
                writer.newLine();
            }
        }
        if (this.getStructureFile() != null && this.getStructureFile().trim().length() > 0) {
            writer.write("structure_file  " + this.getStructureFile());
            writer.newLine();
        }
        if (!this.getStructureFile().equals("")) {
            writer.write("beampol_factor " + this.getBeamPolFactor());
            writer.newLine();
            writer.write("beampol_direct " + this.getBeamPolDirect());
            writer.newLine();
        }
        writer.write("crystal_system " + this.getCrystalSystem());
        writer.newLine();
        writer.write("stress " + (this.getStress() ? "1" : "0"));
        writer.newLine();
        if (this.getStress()) {
            HashMap<String, String> stifnessConstants = this.getStifnessConstants();
            Set<Map.Entry<String, String>> entrySet = stifnessConstants.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                writer.write(String.valueOf(entry.getKey()) + " " + entry.getValue());
                writer.newLine();
            }
        }
    }

    class FitallbListener
    implements IFitAllBEventListener {
        FitallbListener() {
        }

        @Override
        public void updateInputFileEvent(FitAllBEvent event) {
        }

        @Override
        public void updateNumberOfDetectors(FitAllBEvent event) {
        }

        @Override
        public void updateCurrentDirectory(FitAllBEvent event) {
            if (CommonRequiredKeysPage2.this.fitAllB != null) {
                CommonRequiredKeysPage2.this.currentDirectory = CommonRequiredKeysPage2.this.fitAllB.getCurrentDirectory();
            }
        }
    }
}

