/*
 * Decompiled with CFR 0.152.
 */
package fable.fitallb.preferences;

import fable.fitallb.Activator;
import fable.fitallb.internal.IVarKeys;
import java.util.regex.Pattern;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ExperimentPreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Combo crystalSystem;
    private Text stiffness;
    private Button stressConvert;
    private Button stressDoNotConvert;
    private IPreferenceStore preferencesStore = Activator.getDefault().getPreferenceStore();

    public ExperimentPreferences() {
        super(1);
        this.setPreferenceStore(this.preferencesStore);
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new IntegerFieldEditor("sgno", "Space group : ", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("w_step", "Omega Step : ", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("w_limit", "Omega Limit Range : ", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("bg", "Average Background Level : ", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("dety_size", "Detector Dimension in y [pixels] : ", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("detz_size", "Detector Dimension in z [pixels] : ", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("beampol_factor", "Beam Polarisation factor : ", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("beampol_direct", "Beam Polarisation direct [deg] : ", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("near_bg", "Near-field Detector - Average Background Level : ", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("near_dety_size", "Near-field Detector - Detector Dimension in y [pixels] : ", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("near_detz_size", "Near-field Detector - Detector Dimension in z [pixels] : ", this.getFieldEditorParent()));
        Composite composite = new Composite(this.getFieldEditorParent(), 0);
        composite.setLayout((Layout)new GridLayout(3, true));
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 64);
        label.setText("Crystal System : ");
        this.crystalSystem = new Combo(composite, 8);
        this.crystalSystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExperimentPreferences.this.stressConvert.getSelection()) {
                    ExperimentPreferences.this.initializeStiffness();
                } else {
                    ExperimentPreferences.this.stiffness.setText("");
                }
            }
        });
        gd = new GridData(4, 0x1000000, true, true);
        gd.horizontalSpan = 2;
        this.crystalSystem.setLayoutData((Object)gd);
        String[] stringArray = IVarKeys.CRYSTAL_SYSTEM;
        int n = IVarKeys.CRYSTAL_SYSTEM.length;
        int n2 = 0;
        while (n2 < n) {
            String crystal = stringArray[n2];
            this.crystalSystem.add(crystal);
            ++n2;
        }
        label = new Label(composite, 64);
        label.setText("Stress : ");
        this.stressConvert = new Button(composite, 16);
        this.stressDoNotConvert = new Button(composite, 16);
        this.stressConvert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExperimentPreferences.this.activateStifnessConstant();
                ExperimentPreferences.this.initializeStiffness();
            }
        });
        this.stressConvert.setText("Convert");
        this.stressDoNotConvert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExperimentPreferences.this.activateStifnessConstant();
                ExperimentPreferences.this.stiffness.setText("");
            }
        });
        this.stressDoNotConvert.setText("Do not Convert");
        label = new Label(composite, 64);
        label.setText("Stiffness constants : ");
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).applyTo((Control)label);
        this.stiffness = new Text(composite, 2818);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 3).applyTo((Control)this.stiffness);
        this.initPreferencesForNonEditorFields();
        if (this.stiffness.getText().equals("") && this.stressConvert.getSelection()) {
            this.initializeStiffness();
        }
        this.activateStifnessConstant();
    }

    private void initPreferencesForNonEditorFields() {
        this.stressConvert.setSelection(this.preferencesStore.getInt("stress") == 1);
        this.stressDoNotConvert.setSelection(this.preferencesStore.getInt("stress") == 0);
        String crystal = this.preferencesStore.getString("crystal_system");
        this.crystalSystem.select(this.crystalSystem.indexOf(crystal));
        this.stressConvert.setSelection(this.preferencesStore.getInt("stress") == 1);
        this.stressDoNotConvert.setSelection(this.preferencesStore.getInt("stress") == 0);
        this.stiffness.setText(this.preferencesStore.getString("StiffnessPreferences"));
    }

    protected void activateStifnessConstant() {
        this.stiffness.setEnabled(this.stressConvert.getSelection());
        if (!this.stressConvert.getSelection()) {
            this.stiffness.setText("");
        }
    }

    private void initializeStiffness() {
        String cSystem = this.crystalSystem.getText();
        this.stiffness.setText("");
        if (cSystem.length() > 0) {
            String[] constants = IVarKeys.getStiffness(cSystem);
            int i = 0;
            while (i < constants.length) {
                this.stiffness.append(constants[i]);
                this.stiffness.append("\r\n");
                ++i;
            }
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        String defaultCrystalSystem = this.preferencesStore.getDefaultString("crystal_system");
        if (defaultCrystalSystem == null) {
            this.crystalSystem.select(-1);
        } else {
            int index = this.crystalSystem.indexOf(defaultCrystalSystem);
            this.crystalSystem.select(index);
        }
        this.stressConvert.setSelection(this.preferencesStore.getDefaultInt("stress") == 1);
        this.stressDoNotConvert.setSelection(this.preferencesStore.getDefaultInt("stress") == 0);
        this.activateStifnessConstant();
        super.performDefaults();
    }

    public boolean performOk() {
        this.preferencesStore.setValue("crystal_system", this.crystalSystem.getText());
        this.preferencesStore.setValue("stress", this.stressConvert.getSelection() ? 1 : 0);
        this.preferencesStore.setValue("StiffnessPreferences", this.stiffness.getText());
        return super.performOk();
    }

    class FloatFieldEditor
    extends StringFieldEditor {
        Float _minValue;
        Float _maxValue;
        boolean _maxValueIsIncluded;
        boolean _minValueIsIncluded;

        public FloatFieldEditor(Float value, Float value2) {
            this._minValue = null;
            this._maxValue = null;
            this._maxValueIsIncluded = true;
            this._minValueIsIncluded = true;
            this._minValue = value;
            this._maxValue = value2;
            this._maxValueIsIncluded = true;
            this._minValueIsIncluded = true;
        }

        public FloatFieldEditor() {
            this._minValue = null;
            this._maxValue = null;
            this._maxValueIsIncluded = true;
            this._minValueIsIncluded = true;
        }

        public FloatFieldEditor(String name, String labelText, Composite parent, Float value, Float value2) {
            super(name, labelText, parent);
            this._minValue = null;
            this._maxValue = null;
            this._maxValueIsIncluded = true;
            this._minValueIsIncluded = true;
            this._minValue = value;
            this._maxValue = value2;
            this._maxValueIsIncluded = true;
            this._minValueIsIncluded = true;
        }

        public FloatFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this._minValue = null;
            this._maxValue = null;
            this._maxValueIsIncluded = true;
            this._minValueIsIncluded = true;
        }

        public void setMinValue(float minValue, boolean bInclude) {
            this._minValue = new Float(minValue);
            this._minValueIsIncluded = bInclude;
        }

        public void setMaxValue(float maxValue, boolean bInclude) {
            this._maxValue = new Float(maxValue);
            this._maxValueIsIncluded = bInclude;
        }

        protected boolean checkState() {
            boolean bok = true;
            if (this.getStringValue().compareTo("") == 0 && !this.isEmptyStringAllowed()) {
                bok = false;
                this.setErrorMessage("Field should contain a float value");
                this.showErrorMessage();
            } else {
                Pattern pattern = Pattern.compile("[ \\D &&[^\\.]&&[^-]]");
                if (pattern.matcher(this.getStringValue()).find()) {
                    this.setErrorMessage("Field should contain a float value");
                    this.showErrorMessage();
                    bok = false;
                } else {
                    this.clearErrorMessage();
                    try {
                        float myValue = Float.parseFloat(this.getStringValue());
                        if (this._minValue != null && this._maxValue != null) {
                            if (this._minValueIsIncluded && this._maxValueIsIncluded) {
                                bok = Float.compare(myValue, this._minValue.floatValue()) >= 0 && Float.compare(myValue, this._maxValue.floatValue()) <= 0;
                                this.setErrorMessage("Field should contain a float value between " + this._minValue + " and " + this._maxValue);
                            } else if (!this._minValueIsIncluded && !this._maxValueIsIncluded) {
                                bok = Float.compare(myValue, this._minValue.floatValue()) > 0 && Float.compare(myValue, this._maxValue.floatValue()) < 0;
                                this.setErrorMessage("Field should contain a float value greater than " + this._minValue + "  and less than " + this._maxValue);
                            } else if (!this._minValueIsIncluded && this._maxValueIsIncluded) {
                                bok = Float.compare(myValue, this._minValue.floatValue()) > 0 && Float.compare(myValue, this._maxValue.floatValue()) <= 0;
                                this.setErrorMessage("Field should contain a float value greater than " + this._minValue + "  and less or equal than " + this._maxValue);
                            } else if (this._minValueIsIncluded && !this._maxValueIsIncluded) {
                                bok = Float.compare(myValue, this._minValue.floatValue()) >= 0 && Float.compare(myValue, this._maxValue.floatValue()) < 0;
                                this.setErrorMessage("Field should contain a float value greater or equel than " + this._minValue + "  and less than " + this._maxValue);
                            }
                        } else if (this._minValue == null && this._maxValue != null) {
                            if (this._maxValueIsIncluded) {
                                bok = Float.compare(myValue, this._maxValue.floatValue()) <= 0;
                                this.setErrorMessage("Field should contain a float value less or equal than " + this._maxValue);
                            } else {
                                bok = Float.compare(myValue, this._maxValue.floatValue()) < 0;
                                this.setErrorMessage("Field should contain a float value less than " + this._maxValue);
                            }
                        } else if (this._minValue != null && this._maxValue == null) {
                            if (this._minValueIsIncluded) {
                                bok = Float.compare(myValue, this._minValue.floatValue()) >= 0;
                                this.setErrorMessage("Field should contain a float value greater or equal than " + this._minValue);
                            } else {
                                bok = Float.compare(myValue, this._minValue.floatValue()) > 0;
                                this.setErrorMessage("Field should contain a float value greater than " + this._minValue);
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
                if (bok) {
                    this.clearErrorMessage();
                } else {
                    this.showErrorMessage();
                }
            }
            return bok;
        }
    }
}

