/*
 * Decompiled with CFR 0.152.
 */
package fable.fitallb.internal;

import java.util.HashMap;

public class IVarKeys {
    private static HashMap<String, String[]> stiffness;
    public static String[] FILTER_EXTS_INI;
    String ITEMS = "items_fitallb";
    public static final String[] FILTER_NAMES_INI;
    public static final String[] CRYSTAL_SYSTEM;
    public static final String INPUTFILE_EXTENSION = "fit";
    public static final String MODE_FITGLOBAL = "gofitgloball";
    public static String MODE_FITGLOBALGRAIN;
    public static String MODE_FITALLB;

    static {
        FILTER_EXTS_INI = new String[]{"*.fit", "*.*"};
        FILTER_NAMES_INI = new String[]{"input files (*.fit)", "All Files (*.*)"};
        CRYSTAL_SYSTEM = new String[]{"isotropic", "cubic", "hexagonal", "trigonal_high", "trigonal_low", "tetragonal_high", "tetragonal_low", "orthorhombic", "monoclinic", "triclinic"};
        MODE_FITGLOBALGRAIN = "gofitglobalgrain";
        MODE_FITALLB = "gofitallb";
    }

    public static String[] getStiffness(String crystalSystem) {
        if (stiffness == null) {
            IVarKeys.initStiffness();
        }
        return stiffness.get(crystalSystem);
    }

    private static void initStiffness() {
        stiffness = new HashMap();
        stiffness.put("isotropic", new String[]{"c11", "c12"});
        stiffness.put("cubic", new String[]{"c11", "c12", "c44"});
        stiffness.put("hexagonal", new String[]{"c11", "c12", "c13", "c33", "c44"});
        stiffness.put("trigonal_high", new String[]{"c11", "c12", "c13", "c14", "c33", "c44"});
        stiffness.put("trigonal_low", new String[]{"c11", "c12", "c13", "c14", "c25", "c33", "c44"});
        stiffness.put("tetragonal_high", new String[]{"c11", "c12", "c13", "c33", "c44", "c66"});
        stiffness.put("tetragonal_low", new String[]{"c11", "c12", "c13", "c16", "c33", "c44", "c66"});
        stiffness.put("orthorhombic", new String[]{"c11", "c12", "c13", "c22", "c23", "c33", "c44", "c55", "c66"});
        stiffness.put("monoclinic", new String[]{"c11", "c12", "c13", "c15", "c22", "c23", "c25", "c33", "c35", "c44", "c46", "c55", "c66"});
        stiffness.put("triclinic", new String[]{"c11", "c12", "c13", "c14", "c15", "c16", "c22", "c23", "c24", "c25", "c26", "c33", "c34", "c35", "c36", "c44", "c45", "c46", "c55", "c56", "c66"});
    }

    public static String getProgramScriptName(String programName) {
        if (programName.equals(MODE_FITALLB)) {
            return "fitallb";
        }
        if (programName.equals(MODE_FITGLOBAL)) {
            return "fitgloball";
        }
        if (programName.equals(MODE_FITGLOBALGRAIN)) {
            return "fitglobalgrain";
        }
        return "";
    }
}

