/*
 * Decompiled with CFR 0.152.
 */
package fable.fitallb.editors;

import fable.fitallb.event.FitAllBEvent;
import fable.fitallb.internal.FitAllBException;
import fable.fitallb.internal.IVarKeys;
import fable.fitallb.listeners.IFitAllBEventListener;
import fable.framework.toolbox.FableUtils;
import fable.python.jep.FableJep;
import fable.python.jep.StdoutRead;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import jep.JepException;

public class FitAllB {
    private FableJep jep;
    private String inputFile;
    private StdoutRead stdoutThread;
    private String currentDirectory;
    private String program;
    private ArrayList<IFitAllBEventListener> listeners = new ArrayList();
    private int nDetectors = 1;
    private String killFile;
    private boolean endOfProgram = false;
    private static HashMap<String, Object> optionalItems;

    public FitAllB() throws FitAllBException {
        try {
            this.jep = new FableJep();
            this.nDetectors = 1;
            this.program = IVarKeys.MODE_FITALLB;
        }
        catch (JepException e) {
            new FitAllBException(FitAllB.class.getName(), "Constructor", e.getMessage());
        }
    }

    public static void checkImport(FableJep myjep) throws JepException {
        myjep.eval("from FitAllB import check_input");
    }

    public String[] getRequiredKeys() {
        String[] requireKeys = null;
        try {
            FitAllB.checkImport(this.jep);
            this.jep.eval("checkObject = check_input.parse_input()");
            this.jep.eval("required_items = checkObject.needed_items");
            if (this.jep.eval("required_items is not None")) {
                int len = this.jep.getIntegerValue("len(required_items)");
                requireKeys = new String[len];
                int i = 0;
                while (i < len) {
                    this.jep.set("i", i);
                    requireKeys[i] = this.jep.getStringValue("required_items.keys()[i]");
                    ++i;
                }
            }
        }
        catch (JepException e) {
            FableUtils.excMsg(FitAllB.class, (String)"An error occured with jep", (Throwable)e);
        }
        return requireKeys;
    }

    public String[] getOptionalKeys() {
        String[] optionalKeys = null;
        try {
            FitAllB.checkImport(this.jep);
            this.jep.eval("checkObject = check_input.parse_input()");
            this.jep.eval("optional_items = checkObject.optional_items");
            if (this.jep.eval("optional_items is not None")) {
                int len = this.jep.getIntegerValue("len(optional_items)");
                optionalKeys = new String[len];
                int i = 0;
                while (i < len) {
                    this.jep.set("i", i);
                    optionalKeys[i] = this.jep.getStringValue("optional_items.keys()[i]");
                    ++i;
                }
            }
        }
        catch (JepException e) {
            FableUtils.excMsg(FitAllB.class, (String)"An error occured with jep", (Throwable)e);
        }
        return optionalKeys;
    }

    public void dispose() {
        this.jep.close();
        this.listeners.removeAll(this.listeners);
    }

    private void fireNewProgramEvent() {
        FitAllBEvent event = new FitAllBEvent(this);
        for (IFitAllBEventListener listener : this.listeners) {
            listener.updateInputFileEvent(event);
        }
    }

    private void fireUpdateNumberOfDetector() {
        FitAllBEvent event = new FitAllBEvent(this);
        for (IFitAllBEventListener listener : this.listeners) {
            listener.updateNumberOfDetectors(event);
        }
    }

    private void fireUpdateCurrentDirectory() {
        FitAllBEvent event = new FitAllBEvent(this);
        for (IFitAllBEventListener listener : this.listeners) {
            listener.updateCurrentDirectory(event);
        }
    }

    public static String[] getAllKeyWords() {
        String[] allKeys = null;
        try {
            FableJep jep = new FableJep();
            FitAllB.checkImport(jep);
            jep.eval("checkObject = check_input.parse_input()");
            jep.eval("required_items = checkObject.needed_items");
            jep.eval("optional_items = checkObject.optional_items");
            if (jep.eval("optional_items is not None") && jep.eval("required_items is not None")) {
                int len_optional_items = jep.getIntegerValue("len(optional_items)");
                int len_required_items = jep.getIntegerValue("len(required_items)");
                int len = len_required_items + len_optional_items;
                allKeys = new String[len];
                int i = 0;
                i = 0;
                while (i < len_optional_items) {
                    jep.set("i", i);
                    allKeys[i] = jep.getStringValue("optional_items.keys()[i]");
                    ++i;
                }
                int j = 0;
                while (j < len_required_items) {
                    jep.set("j", j);
                    allKeys[i] = jep.getStringValue("required_items.keys()[j]");
                    ++i;
                    ++j;
                }
            }
            jep.close();
        }
        catch (JepException e) {
            FableUtils.excMsg(FitAllB.class, (String)"An error occured with jep", (Throwable)e);
        }
        return allKeys;
    }

    public void launchFitallb(String inputFile) throws FitAllBException {
        this.endOfProgram = false;
        try {
            FableJep jep = new FableJep();
            this.chdir(this.getCurrentDirectory(), jep);
            File tempFile = File.createTempFile(String.valueOf(IVarKeys.getProgramScriptName(this.program)) + "_" + inputFile, ".stdout");
            File tempErrFile = File.createTempFile(String.valueOf(IVarKeys.getProgramScriptName(this.program)) + "_" + inputFile, ".stderr");
            this.stdoutThread = new StdoutRead(tempFile.getAbsolutePath());
            StdoutRead stderr = new StdoutRead(tempErrFile.getAbsolutePath());
            tempFile.deleteOnExit();
            tempErrFile.deleteOnExit();
            jep.redirectStdout(tempFile.getAbsolutePath());
            jep.redirectStderr(tempErrFile.getAbsolutePath());
            this.stdoutThread.start();
            stderr.start();
            stderr.setOutputToFableConsole(true);
            jep.eval("from FitAllB import " + this.program);
            jep.eval("from optparse import OptionParser");
            jep.eval("parser = OptionParser()");
            jep.eval("options  = " + this.program + ".get_options(parser)");
            jep.eval("options.filename = \"" + inputFile + "\"");
            if (this.killFile != null) {
                jep.eval("options.killfile = \"" + this.killFile + "\"");
            }
            jep.eval(String.valueOf(this.program) + ".run(options)");
            jep.flushStdout();
            this.endOfProgram = true;
            jep.close();
            if (this.stdoutThread != null) {
                this.stdoutThread.stopped = true;
                try {
                    this.stdoutThread.join();
                }
                catch (InterruptedException e) {
                    FableUtils.excMsg((Object)this, (String)e.getMessage(), (Throwable)e);
                }
            }
            if (stderr != null) {
                stderr.stopped = true;
                try {
                    stderr.join();
                }
                catch (InterruptedException e) {
                    FableUtils.excMsg((Object)this, (String)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            this.endOfProgram = true;
            throw new FitAllBException(this.getClass().getName(), "launchFitallb()", "A IOException occurs while trying to create temp file for getting output message for this program : " + e.getMessage());
        }
        catch (JepException e) {
            this.endOfProgram = true;
            throw new FitAllBException(this.getClass().getName(), "launchFitallb()", "A JepException occurs : " + e.getMessage());
        }
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(String path) {
        this.currentDirectory = path.replaceAll("\\\\", "/");
        this.fireUpdateCurrentDirectory();
    }

    private void chdir(String currentDirectory, FableJep jep) throws JepException {
        jep.eval("import os");
        currentDirectory = currentDirectory.replaceAll("\\\\", "/");
        jep.eval("os.chdir('" + currentDirectory + "')");
    }

    public void setInputFile(String inputFile) {
        this.inputFile = inputFile;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    private String getDefaultValueFromPython(String key) {
        String value = null;
        try {
            FitAllB.checkImport(this.jep);
            this.jep.eval("checkObject = check_input.parse_input()");
            this.jep.eval("optional_items = checkObject.optional_items");
            if (this.jep.eval("optional_items is not None")) {
                this.jep.set("key", key);
                Object obj = this.jep.getValue("optional_items[key]");
                if (obj != null) {
                    value = obj.toString();
                }
            }
        }
        catch (JepException e) {
            FableUtils.excMsg(FitAllB.class, (String)"An error occured with jep", (Throwable)e);
        }
        return value;
    }

    public static Object getDefaultValue(String key) {
        return FitAllB.getOptionalItems().get(key);
    }

    public static HashMap<String, Object> getOptionalItems() {
        if (optionalItems == null) {
            optionalItems = new HashMap();
            try {
                FableJep jep = new FableJep();
                FitAllB.checkImport(jep);
                jep.eval("checkObject = check_input.parse_input()");
                jep.eval("optional_items = checkObject.optional_items");
                if (jep.eval("optional_items is not None")) {
                    int len = jep.getIntegerValue("len(optional_items)");
                    int i = 0;
                    while (i < len) {
                        jep.set("i", i);
                        String key = jep.getStringValue("optional_items.keys()[i]");
                        if (key != null) {
                            jep.set("key_java", key);
                            Object value = jep.getValue("optional_items[key_java]");
                            optionalItems.put(key, value);
                        }
                        ++i;
                    }
                }
                jep.close();
            }
            catch (JepException e) {
                FableUtils.excMsg(FitAllB.class, (String)"An error occured with jep", (Throwable)e);
            }
        }
        return optionalItems;
    }

    public void setProgram(String mode) {
        this.program = mode;
        this.fireNewProgramEvent();
    }

    public String getProgram() {
        return this.program;
    }

    public void addFitallbListener(IFitAllBEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeFitallbListener(IFitAllBEventListener listener) {
        this.listeners.remove(listener);
    }

    public int getNumberOfDetectors() {
        return this.nDetectors;
    }

    public void setNumberOfDetectors(int n) {
        this.nDetectors = n;
        this.fireUpdateNumberOfDetector();
    }

    public String getKillFile() {
        return this.killFile;
    }

    public void setKillFile(String killFile2) {
        this.killFile = killFile2;
    }

    public boolean hasFinished() {
        return this.endOfProgram;
    }

    public void setEndOfProgram(boolean b) {
        this.endOfProgram = b;
    }
}

