/*
 * Decompiled with CFR 0.152.
 */
package fable.fitallb.actions;

import fable.fitallb.editors.FitAllBeditor;
import fable.fitallb.internal.IVarKeys;
import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.SWTUtils;
import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class OpenInputFile
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private static String ID = "fable.fitallb.actionOpenInputFile";
    private IEditorInput input;
    private String selectionContainer;
    private ISelection selection;

    public OpenInputFile() {
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"));
        this.setId(ID);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow windowArg) {
        this.window = windowArg;
    }

    public void run(IAction action) {
        if (this.window != null) {
            FileDialog fileDlg = new FileDialog(Display.getDefault().getActiveShell());
            IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWindow != null) {
                try {
                    activeWindow.getWorkbench().showPerspective("fable.fitallb.perspective", activeWindow);
                }
                catch (WorkbenchException workbenchException) {
                    FableUtils.errMsg((Object)((Object)this), (String)"Error opening FitAllB perspective.");
                }
            }
            fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_INI);
            fileDlg.setFilterNames(IVarKeys.FILTER_NAMES_INI);
            fileDlg.setText("Select an input file.");
            String file = fileDlg.open();
            if (file != null) {
                File theInputFile = new File(file);
                if (theInputFile.exists()) {
                    this.input = SWTUtils.createEditorInput((File)theInputFile);
                    String editorId = FitAllBeditor.getID();
                    try {
                        this.window.getActivePage().openEditor(this.input, editorId);
                    }
                    catch (PartInitException e) {
                        MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening input file: " + e.getMessage()));
                    }
                } else {
                    FableUtils.errMsg((Object)((Object)this), (String)("Error opening ini file: " + theInputFile.getName()));
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.selectionContainer = container.getFullPath().toString();
            }
        }
    }
}

