/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.JTableRow;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChartActionEvent;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLChartOption;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.JLDataViewOption;
import fr.esrf.tangoatk.widget.util.chart.JLTable;
import fr.esrf.tangoatk.widget.util.chart.LabelRect;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import fr.esrf.tangoatk.widget.util.chart.SearchInfo;
import fr.esrf.tangoatk.widget.util.chart.TabbedLine;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;

public class JLChart
extends JComponent
implements MouseListener,
MouseMotionListener,
ActionListener {
    public static final int LABEL_DOWN = 0;
    public static final int LABEL_UP = 1;
    public static final int LABEL_RIGHT = 2;
    public static final int LABEL_LEFT = 3;
    public static final int MENU_CHARTPROP = 0;
    public static final int MENU_DVPROP = 1;
    public static final int MENU_TABLE = 2;
    public static final int MENU_DATASAVE = 3;
    public static final int MENU_PRINT = 4;
    public static final int MENU_STAT = 5;
    public static final String US_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String FR_DATE_FORMAT = "dd-MM-yyyy HH:mm:ss.SSS";
    private String header = null;
    private boolean headerVisible = false;
    private Font headerFont;
    private Color headerColor;
    private boolean labelVisible = true;
    private int labelMode = 0;
    private Font labelFont;
    protected Vector<LabelRect> labelRect;
    private boolean ipanelVisible = false;
    private boolean paintAxisFirst = true;
    private Color chartBackground;
    private double displayDuration;
    protected double maxDisplayDuration;
    protected JPopupMenu chartMenu;
    private JMenuItem optionMenuItem;
    private JMenuItem saveFileMenuItem;
    private JMenuItem zoomBackMenuItem;
    private JMenuItem printMenuItem;
    private JSeparator sepMenuItem;
    private JMenu tableMenu;
    private JMenuItem tableAllMenuItem;
    private JMenuItem[] tableSingleY1MenuItem = new JMenuItem[0];
    private JMenuItem[] tableSingleY2MenuItem = new JMenuItem[0];
    private JMenu dvMenu;
    private JMenuItem[] dvY1MenuItem = new JMenuItem[0];
    private JMenuItem[] dvY2MenuItem = new JMenuItem[0];
    private JMenu statMenu;
    private JMenuItem statAllMenuItem;
    private JMenuItem[] statSingleY1MenuItem = new JMenuItem[0];
    private JMenuItem[] statSingleY2MenuItem = new JMenuItem[0];
    private JMenuItem[] userActionMenuItem;
    private String[] userAction;
    private boolean zoomDrag;
    private boolean zoomDragAllowed;
    private int zoomX;
    private int zoomY;
    private JButton zoomButton;
    private int lastX;
    private int lastY;
    private SearchInfo lastSearch;
    private Rectangle headerR;
    private Rectangle labelR;
    private Rectangle viewR;
    private Dimension margin;
    private int labelSHeight;
    private int labelWidth;
    private int labelHeight;
    private int headerWidth;
    private int axisHeight;
    private int axisWidth;
    private int y1AxisThickness;
    private int y2AxisThickness;
    private int xAxisThickness;
    private int xAxisUpMargin;
    private JLAxis xAxis;
    private JLAxis y1Axis;
    private JLAxis y2Axis;
    private IJLChartListener listener;
    private JLTable theTable = null;
    private int timePrecision = 0;
    private JMenuItem precisionMenuItem;
    private JMenuItem saveSnapshotMenuItem;
    protected boolean preferDialog = false;
    protected boolean modalDialog = false;
    protected JDialog tableDialog = null;
    protected Window dialogParent;
    protected String lastSnapshotLocation = ".";
    protected String lastDataFileLocation = ".";
    protected FileFilter lastFileFilter = null;
    protected String noValueString = "*";

    public JLChart() {
        Color defColor = Color.WHITE;
        this.setBackground(defColor);
        this.setChartBackground(defColor);
        this.setForeground(Color.black);
        this.setOpaque(true);
        this.setFont(new Font("Dialog", 0, 12));
        this.headerFont = this.getFont();
        this.headerColor = this.getForeground();
        this.labelFont = this.getFont();
        this.margin = new Dimension(5, 5);
        this.headerR = new Rectangle(0, 0, 0, 0);
        this.viewR = new Rectangle(0, 0, 0, 0);
        this.labelR = new Rectangle(0, 0, 0, 0);
        this.xAxis = new JLAxis(this, 1);
        this.xAxis.setAnnotation(1);
        this.xAxis.setAutoScale(true);
        this.xAxis.setAxeName("(X)");
        this.y1Axis = new JLAxis(this, 6);
        this.y1Axis.setAxeName("(Y1)");
        this.y2Axis = new JLAxis(this, 5);
        this.y2Axis.setAxeName("(Y2)");
        this.displayDuration = Double.POSITIVE_INFINITY;
        this.maxDisplayDuration = Double.POSITIVE_INFINITY;
        this.labelRect = new Vector();
        this.zoomDrag = false;
        this.zoomDragAllowed = false;
        this.chartMenu = new JPopupMenu();
        this.optionMenuItem = new JMenuItem("Chart properties");
        this.optionMenuItem.addActionListener(this);
        this.saveFileMenuItem = new JMenuItem("Save data File");
        this.saveFileMenuItem.addActionListener(this);
        this.tableMenu = new JMenu("Show table");
        this.tableAllMenuItem = new JMenuItem("All");
        this.tableAllMenuItem.addActionListener(this);
        this.zoomBackMenuItem = new JMenuItem("Zoom back");
        this.zoomBackMenuItem.addActionListener(this);
        this.printMenuItem = new JMenuItem("Print Chart");
        this.printMenuItem.addActionListener(this);
        this.precisionMenuItem = new JMenuItem("Abscisse error margin");
        this.precisionMenuItem.addActionListener(this);
        this.saveSnapshotMenuItem = new JMenuItem("Save a snapshot of this chart");
        this.saveSnapshotMenuItem.addActionListener(this);
        this.dvMenu = new JMenu("Data View properties");
        this.statMenu = new JMenu("Show statistics");
        this.statAllMenuItem = new JMenuItem("All");
        this.statAllMenuItem.addActionListener(this);
        this.chartMenu.add(this.zoomBackMenuItem);
        this.chartMenu.add(new JSeparator());
        this.chartMenu.add(this.optionMenuItem);
        this.chartMenu.add(this.dvMenu);
        this.chartMenu.add(this.tableMenu);
        this.chartMenu.add(this.statMenu);
        this.chartMenu.add(new JSeparator());
        this.chartMenu.add(this.saveFileMenuItem);
        this.chartMenu.add(this.printMenuItem);
        this.chartMenu.add(this.saveSnapshotMenuItem);
        this.chartMenu.add(this.precisionMenuItem);
        this.sepMenuItem = new JSeparator();
        this.chartMenu.add(this.sepMenuItem);
        this.userActionMenuItem = new JMenuItem[0];
        this.userAction = new String[0];
        this.sepMenuItem.setVisible(false);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.listener = null;
        this.listenerList = new EventListenerList();
        this.zoomButton = new JButton("Zoom back");
        this.zoomButton.setFont(this.labelFont);
        this.zoomButton.setMargin(new Insets(2, 2, 1, 1));
        this.zoomButton.setVisible(false);
        this.zoomButton.addActionListener(this);
        this.add(this.zoomButton);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveSnapshot() {
        this.chartMenu.setVisible(false);
        int ok = 0;
        FileFilter jpgFilter = new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = JLChart.this.getExtension(f);
                return extension != null && extension.equals("jpg");
            }

            public String getDescription() {
                return "jpg - JPEG pictures";
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)obj).getDescription());
                }
                return false;
            }
        };
        FileFilter pngFilter = new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = JLChart.this.getExtension(f);
                return extension != null && extension.equals("png");
            }

            public String getDescription() {
                return "png - PNG pictures";
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)obj).getDescription());
                }
                return false;
            }
        };
        FileFilter[] filters = new FileFilter[]{jpgFilter, pngFilter};
        JFileChooser chooser = new JFileChooser(this.lastSnapshotLocation);
        int i = 0;
        while (i < filters.length) {
            if (!filters[i].equals(this.lastFileFilter)) {
                chooser.addChoosableFileFilter(filters[i]);
            }
            ++i;
        }
        if (this.lastFileFilter != null) {
            chooser.addChoosableFileFilter(this.lastFileFilter);
        }
        chooser.setDialogTitle("Save snapshot");
        int returnVal = chooser.showSaveDialog(this);
        String extension = "";
        File f = null;
        if (returnVal != 0) return;
        f = chooser.getSelectedFile();
        if (f != null) {
            this.lastSnapshotLocation = f.getParentFile().getAbsolutePath();
            FileFilter filter = chooser.getFileFilter();
            if (filter == jpgFilter) {
                if (this.getExtension(f) == null || !this.getExtension(f).equalsIgnoreCase("jpg")) {
                    f = new File(String.valueOf(f.getAbsolutePath()) + ".jpg");
                }
                this.lastFileFilter = filter;
            } else if (filter == pngFilter) {
                if (this.getExtension(f) == null || !this.getExtension(f).equalsIgnoreCase("png")) {
                    f = new File(String.valueOf(f.getAbsolutePath()) + ".png");
                }
                this.lastFileFilter = filter;
            }
            if (f.exists()) {
                ok = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + f.getName() + " ?", "Confirm overwrite", 0);
            }
            if (ok != 0) return;
            this.repaint();
            if (this.getExtension(f) == null) {
                JOptionPane.showMessageDialog(this, "Unknown file type", "Error", 0);
            } else {
                extension = this.getExtension(f).equalsIgnoreCase("jpg") ? "jpg" : (this.getExtension(f).equalsIgnoreCase("png") ? "png" : "");
            }
        }
        if (!"".equals(extension.trim())) {
            this.revalidate();
            this.repaint();
            BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            this.paint(img.getGraphics());
            try {
                ImageIO.write((RenderedImage)img, extension, f);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
            }
            img.flush();
        } else {
            JOptionPane.showMessageDialog(this, "Unknown file type", "Error", 0);
        }
        jpgFilter = null;
        pngFilter = null;
        int i2 = 0;
        while (i2 < filters.length) {
            filters[i2] = null;
            ++i2;
        }
        filters = null;
    }

    public JLAxis getXAxis() {
        return this.xAxis;
    }

    public JLAxis getY1Axis() {
        return this.y1Axis;
    }

    public JLAxis getY2Axis() {
        return this.y2Axis;
    }

    public void setXAxisOnBottom(boolean b) {
        if (b) {
            this.getXAxis().setPosition(1);
        } else {
            this.getXAxis().setPosition(3);
        }
    }

    public boolean isXAxisOnBottom() {
        return this.getXAxis().getPosition() == 1;
    }

    public void setHeaderFont(Font f) {
        this.headerFont = f;
    }

    public Font getHeaderFont() {
        return this.headerFont;
    }

    public void setMargin(Dimension d) {
        this.margin = d;
    }

    public Dimension getMargin() {
        return this.margin;
    }

    public void setBackground(Color c) {
        super.setBackground(c);
    }

    public void setChartBackground(Color c) {
        this.chartBackground = c;
    }

    public Color getChartBackground() {
        return this.chartBackground;
    }

    public void setPaintAxisFirst(boolean b) {
        this.paintAxisFirst = b;
    }

    public boolean isPaintAxisFirst() {
        return this.paintAxisFirst;
    }

    public void setHeaderVisible(boolean b) {
        this.headerVisible = b;
    }

    public void setHeader(String s) {
        this.header = s;
        if (s != null && s.length() == 0) {
            this.header = null;
        }
        this.setHeaderVisible(this.header != null);
    }

    public String getHeader() {
        return this.header;
    }

    public void setDisplayDuration(double v) {
        if (v <= this.maxDisplayDuration) {
            this.displayDuration = v;
            this.getXAxis().setAxisDuration(v);
        } else {
            StringBuffer result = new StringBuffer("Duration refused : can not be greater than ");
            if (1 == this.getXAxis().getAnnotation() || 2 == this.getXAxis().getLabelFormat()) {
                String millisecondString;
                int dayTime = 86400000;
                int hourTime = 3600000;
                int minuteTime = 60000;
                int secondTime = 1000;
                double totalTime = this.maxDisplayDuration;
                double days = totalTime / (double)dayTime;
                double hours = (totalTime -= days * (double)dayTime) / (double)hourTime;
                double minutes = (totalTime -= hours * (double)hourTime) / (double)minuteTime;
                double seconds = (totalTime -= minutes * (double)minuteTime) / (double)secondTime;
                double milliseconds = totalTime -= seconds * (double)secondTime;
                if (days > 0.0) {
                    String dayString = Double.toString(days);
                    if (dayString.endsWith(".0")) {
                        dayString = dayString.substring(0, dayString.indexOf("."));
                    }
                    result.append(dayString).append("day(s) ");
                    dayString = null;
                }
                if (hours > 0.0) {
                    String hourString = Double.toString(hours);
                    if (hourString.endsWith(".0")) {
                        hourString = hourString.substring(0, hourString.indexOf("."));
                    }
                    result.append(hours).append("hr ");
                    hourString = null;
                }
                if (minutes > 0.0) {
                    String minuteString = Double.toString(minutes);
                    if (minuteString.endsWith(".0")) {
                        minuteString = minuteString.substring(0, minuteString.indexOf("."));
                    }
                    result.append(minuteString).append("mn ");
                    minuteString = null;
                }
                if (seconds > 0.0) {
                    String secondString = Double.toString(seconds);
                    if (secondString.endsWith(".0")) {
                        secondString = secondString.substring(0, secondString.indexOf("."));
                    }
                    result.append(secondString).append("s ");
                    secondString = null;
                }
                if (milliseconds > 0.0) {
                    millisecondString = Double.toString(milliseconds);
                    if (millisecondString.endsWith(".0")) {
                        millisecondString = millisecondString.substring(0, millisecondString.indexOf("."));
                    }
                    result.append(millisecondString).append("ms ");
                    millisecondString = null;
                } else if (days == 0.0 && hours == 0.0 && minutes == 0.0 && seconds == 0.0 && milliseconds == 0.0) {
                    millisecondString = Double.toString(milliseconds);
                    if (millisecondString.endsWith(".0")) {
                        millisecondString = millisecondString.substring(0, millisecondString.indexOf("."));
                    }
                    result.append(millisecondString).append("ms ");
                    millisecondString = null;
                }
            } else {
                String maxString = Double.toString(this.maxDisplayDuration);
                if (maxString.endsWith(".0")) {
                    maxString = maxString.substring(0, maxString.indexOf("."));
                }
                result.append(maxString);
                maxString = null;
            }
            JOptionPane.showMessageDialog(this, result.toString(), "Warning !", 2);
            Object var3_2 = null;
        }
    }

    public double getDisplayDuration() {
        return this.displayDuration;
    }

    public double getMaxDisplayDuration() {
        return this.maxDisplayDuration;
    }

    public void setMaxDisplayDuration(double maxDisplayDuration) {
        this.maxDisplayDuration = maxDisplayDuration;
    }

    public void setHeaderColor(Color c) {
        this.headerColor = c;
        this.setHeaderVisible(true);
    }

    public void setLabelVisible(boolean b) {
        this.labelVisible = b;
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelPlacement(int p) {
        this.labelMode = p;
    }

    public int getLabelPlacement() {
        return this.labelMode;
    }

    public void setLabelFont(Font f) {
        this.labelFont = f;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void showOptionDialog() {
        Container dlgParent = null;
        if (this.getRootPane() != null) {
            dlgParent = this.getRootPane().getParent();
        }
        JLChartOption optionDlg = dlgParent instanceof JDialog ? new JLChartOption((JDialog)dlgParent, this) : (dlgParent instanceof JFrame ? new JLChartOption((JFrame)dlgParent, this) : new JLChartOption(null, this));
        ATKGraphicsUtils.centerDialog(optionDlg);
        optionDlg.setVisible(true);
    }

    public void showDataOptionDialog(JLDataView v) {
        Container dlgParent = null;
        if (this.getRootPane() != null) {
            dlgParent = this.getRootPane().getParent();
        }
        JLDataViewOption optionDlg = dlgParent instanceof JDialog ? new JLDataViewOption((JDialog)dlgParent, this, v) : (dlgParent instanceof JFrame ? new JLDataViewOption((JFrame)dlgParent, this, v) : new JLDataViewOption(null, this, v));
        ATKGraphicsUtils.centerDialog(optionDlg);
        optionDlg.setVisible(true);
    }

    public boolean isZoomed() {
        return this.xAxis.isZoomed() || this.y1Axis.isZoomed() || this.y2Axis.isZoomed();
    }

    public void enterZoom() {
        if (!this.zoomDragAllowed) {
            this.zoomDragAllowed = true;
            this.setCursor(new Cursor(1));
        }
    }

    public void setJLChartListener(IJLChartListener l) {
        this.listener = l;
    }

    public void addUserAction(String name) {
        String[] action = new String[this.userAction.length + 1];
        int i = 0;
        while (i < this.userAction.length) {
            action[i] = this.userAction[i];
            ++i;
        }
        action[i] = name;
        i = 0;
        while (i < this.userActionMenuItem.length) {
            this.chartMenu.remove(this.userActionMenuItem[i]);
            this.userActionMenuItem[i].removeActionListener(this);
            this.userActionMenuItem[i] = null;
            ++i;
        }
        JMenuItem[] actionMenu = new JMenuItem[action.length];
        i = 0;
        while (i < action.length) {
            actionMenu[i] = action[i].startsWith("chk") ? new JCheckBoxMenuItem(action[i].substring(3)) : new JMenuItem(action[i]);
            actionMenu[i].addActionListener(this);
            this.chartMenu.add(actionMenu[i]);
            ++i;
        }
        this.userActionMenuItem = actionMenu;
        this.userAction = action;
        this.sepMenuItem.setVisible(true);
    }

    public void removeUserAction(String name) {
        int correspondingIndex = -1;
        int i = 0;
        while (i < this.userAction.length) {
            if (this.userAction[i].equals(name)) {
                correspondingIndex = i;
                break;
            }
            ++i;
        }
        if (correspondingIndex != -1) {
            String[] action = new String[this.userAction.length - 1];
            i = 0;
            while (i < correspondingIndex) {
                action[i] = this.userAction[i];
                ++i;
            }
            i = correspondingIndex + 1;
            while (i < this.userAction.length) {
                action[i - 1] = this.userAction[i];
                ++i;
            }
            i = 0;
            while (i < this.userActionMenuItem.length) {
                this.chartMenu.remove(this.userActionMenuItem[i]);
                this.userActionMenuItem[i].removeActionListener(this);
                this.userActionMenuItem[i] = null;
                ++i;
            }
            JMenuItem[] actionMenu = new JMenuItem[action.length];
            i = 0;
            while (i < action.length) {
                actionMenu[i] = action[i].startsWith("chk") ? new JCheckBoxMenuItem(action[i].substring(3)) : new JMenuItem(action[i]);
                actionMenu[i].addActionListener(this);
                this.chartMenu.add(actionMenu[i]);
                ++i;
            }
            this.userActionMenuItem = actionMenu;
            this.userAction = action;
            this.sepMenuItem.setVisible(true);
        }
    }

    public void addJLChartActionListener(IJLChartActionListener l) {
        this.listenerList.add(IJLChartActionListener.class, l);
    }

    public void exitZoom() {
        this.xAxis.unzoom();
        this.y1Axis.unzoom();
        this.y2Axis.unzoom();
        this.zoomDragAllowed = false;
        this.setCursor(Cursor.getDefaultCursor());
        this.repaint();
    }

    public void removeMenuItem(int menu) {
        switch (menu) {
            case 0: {
                this.chartMenu.remove(this.optionMenuItem);
                break;
            }
            case 1: {
                this.chartMenu.remove(this.dvMenu);
                break;
            }
            case 2: {
                this.chartMenu.remove(this.tableMenu);
                break;
            }
            case 3: {
                this.chartMenu.remove(this.saveFileMenuItem);
                break;
            }
            case 4: {
                this.chartMenu.remove(this.printMenuItem);
                break;
            }
            case 5: {
                this.chartMenu.remove(this.statMenu);
            }
        }
    }

    public void addMenuItem(JMenuItem menu) {
        this.chartMenu.add(menu);
    }

    public void addSeparator() {
        this.chartMenu.addSeparator();
    }

    public void removeJLChartActionListener(IJLChartActionListener l) {
        this.listenerList.remove(IJLChartActionListener.class, l);
    }

    public void applyConfiguration(CfFileReader f) {
        Vector p = f.getParam("graph_title");
        if (p != null) {
            this.setHeader(OFormat.getName(p.get(0).toString()));
        }
        if ((p = f.getParam("label_visible")) != null) {
            this.setLabelVisible(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam("label_placement")) != null) {
            this.setLabelPlacement(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam("label_font")) != null) {
            this.setLabelFont(OFormat.getFont(p));
        }
        if ((p = f.getParam("graph_background")) != null) {
            this.setBackground(OFormat.getColor(p));
        }
        if ((p = f.getParam("chart_background")) != null) {
            this.setChartBackground(OFormat.getColor(p));
        }
        if ((p = f.getParam("title_font")) != null) {
            this.setHeaderFont(OFormat.getFont(p));
        }
        if ((p = f.getParam("display_duration")) != null) {
            this.setDisplayDuration(OFormat.getDouble(p.get(0).toString()));
        }
        if ((p = f.getParam("precision")) != null) {
            this.setTimePrecision(OFormat.getInt(p.get(0).toString()));
        }
    }

    public String getConfiguration() {
        String to_write = "";
        to_write = String.valueOf(to_write) + "graph_title:'" + this.getHeader() + "'\n";
        to_write = String.valueOf(to_write) + "label_visible:" + this.isLabelVisible() + "\n";
        to_write = String.valueOf(to_write) + "label_placement:" + this.getLabelPlacement() + "\n";
        to_write = String.valueOf(to_write) + "label_font:" + OFormat.font(this.getLabelFont()) + "\n";
        to_write = String.valueOf(to_write) + "graph_background:" + OFormat.color(this.getBackground()) + "\n";
        to_write = String.valueOf(to_write) + "chart_background:" + OFormat.color(this.getChartBackground()) + "\n";
        to_write = String.valueOf(to_write) + "title_font:" + OFormat.font(this.getHeaderFont()) + "\n";
        to_write = String.valueOf(to_write) + "display_duration:" + this.getDisplayDuration() + "\n";
        to_write = String.valueOf(to_write) + "precision:" + this.getTimePrecision() + "\n";
        return to_write;
    }

    public String getHelpString() {
        return "-- Global chart settings --\n\ngraph_title:'title'   Chart title ('null' to disable)\nlabel_visible:true or false  Show legend\nlabel_placement:value   (0 Down,1 Up,2 Right, 3 Left)\nlabel_font:name,style(0 Plain,1 Bold,2 italic),size \ngraph_background:r,g,b   Component background \nchart_background:r,g,b   Graph area background \ntitle_font:name,style(0 Plain,1 Bold,2 italic),size\ndisplay_duration:milliSec   X axis duration (time monitoring)\n\n" + JLAxis.getHelpString() + "\n" + JLDataView.getHelpString();
    }

    public void unselectAll() {
        this.getY1Axis().clearDataView();
        this.getY2Axis().clearDataView();
        this.getXAxis().clearDataView();
    }

    public void printGraph() {
        ATKGraphicsUtils.printComponent(this, "Print Graph", true, 0);
    }

    private void fireActionPerfromed(String name, boolean state) {
        IJLChartActionListener[] list = (IJLChartActionListener[])this.listenerList.getListeners(IJLChartActionListener.class);
        JLChartActionEvent w = new JLChartActionEvent(this, name, state);
        int i = 0;
        while (i < list.length) {
            list[i].actionPerformed(w);
            ++i;
        }
    }

    private boolean fireGetActionState(String name) {
        IJLChartActionListener[] list = (IJLChartActionListener[])this.listenerList.getListeners(IJLChartActionListener.class);
        JLChartActionEvent w = new JLChartActionEvent(this, name);
        boolean ret = true;
        int i = 0;
        while (i < list.length) {
            ret = list[i].getActionState(w) && ret;
            ++i;
        }
        return ret;
    }

    private void saveDataFile(String fileName) {
        try {
            FileWriter fw = new FileWriter(fileName);
            Vector<JLDataView> views = new Vector<JLDataView>();
            if (this.xAxis.isXY()) {
                views.addAll(this.xAxis.getViews());
            }
            views.addAll(this.y1Axis.getViews());
            views.addAll(this.y2Axis.getViews());
            TabbedLine tl = new TabbedLine(views.size());
            tl.setPrecision(this.timePrecision);
            tl.setNoValueString(this.noValueString);
            int v = 0;
            while (v < views.size()) {
                tl.add(v, (JLDataView)views.get(v));
                ++v;
            }
            String s = tl.getFirstLine(this.xAxis.getAnnotation());
            while (s != null) {
                fw.write(s);
                s = tl.getNextLine();
            }
            fw.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error during saving file.\n" + e.getMessage());
        }
    }

    public void loadDataFile(String fileName) {
        try {
            File dataFile = new File(fileName);
            BufferedReader reader = new BufferedReader(new FileReader(dataFile));
            String line = "";
            line = reader.readLine();
            if ("".equals(line.trim())) {
                throw new Exception();
            }
            String[] parsedLine = line.split("\t");
            int annotationType = -1;
            if ("Time (s)".equals(parsedLine[0].trim())) {
                annotationType = 1;
            } else if ("Index".equals(parsedLine[0].trim())) {
                annotationType = 2;
            } else {
                reader.close();
                reader = null;
                dataFile = null;
                line = null;
                parsedLine = null;
                throw new Exception("Failed to read X Axis annotation type");
            }
            Vector<JLDataView> existingViews = new Vector<JLDataView>();
            if (this.xAxis.isXY()) {
                existingViews.addAll(this.xAxis.getViews());
            }
            existingViews.addAll(this.y1Axis.getViews());
            existingViews.addAll(this.y2Axis.getViews());
            if (existingViews.size() != 0 && annotationType != this.getXAxis().getAnnotation()) {
                existingViews.clear();
                existingViews = null;
                String warning = "Loading this file will change X Axis annotation type.\nYour component may not work any more.\nAre you sure to load this file ?";
                int choice = JOptionPane.showConfirmDialog(this, warning, "Risk of breaking component", 2);
                if (choice != 0) {
                    reader.close();
                    reader = null;
                    dataFile = null;
                    line = null;
                    parsedLine = null;
                    return;
                }
            }
            this.lastDataFileLocation = dataFile.getParentFile().getAbsolutePath();
            int viewCount = parsedLine.length - 1;
            if (viewCount < 0) {
                throw new Exception();
            }
            JLDataView[] views = new JLDataView[viewCount];
            Color[] defaultColor = new Color[]{Color.red, Color.blue, Color.cyan, Color.green, Color.magenta, Color.orange, Color.pink, Color.yellow, Color.black};
            int i = 0;
            while (i < views.length) {
                views[i] = new JLDataView();
                views[i].setName(parsedLine[i + 1].trim());
                views[i].setLineWidth(1);
                views[i].setColor(defaultColor[i % defaultColor.length]);
                views[i].setStyle(0);
                views[i].setViewType(0);
                views[i].setMarkerSize(5);
                views[i].setMarker(2);
                views[i].setMarkerColor(views[i].getColor());
                ++i;
            }
            double time = 0.0;
            SimpleDateFormat genFormatFR = new SimpleDateFormat(FR_DATE_FORMAT);
            SimpleDateFormat genFormatUS = new SimpleDateFormat(US_DATE_FORMAT);
            while ((line = reader.readLine()) != null) {
                block26: {
                    parsedLine = line.split("\t");
                    if (parsedLine.length - 1 != viewCount) {
                        throw new Exception();
                    }
                    if (annotationType == 1) {
                        try {
                            time = Double.parseDouble(parsedLine[0]) * 1000.0;
                        }
                        catch (NumberFormatException e) {
                            if (parsedLine[0].indexOf(".") == -1) {
                                parsedLine[0] = String.valueOf(parsedLine[0]) + ".000";
                            }
                            if (parsedLine[0].indexOf("-") != 4) {
                                genFormatFR.parse(parsedLine[0]);
                                time = genFormatFR.getCalendar().getTimeInMillis();
                                break block26;
                            }
                            genFormatUS.parse(parsedLine[0]);
                            time = genFormatUS.getCalendar().getTimeInMillis();
                        }
                    } else {
                        try {
                            time = Double.parseDouble(parsedLine[0]);
                        }
                        catch (NumberFormatException nfe) {
                            continue;
                        }
                    }
                }
                int i2 = 0;
                while (i2 < views.length) {
                    block27: {
                        try {
                            views[i2].add(time, Double.parseDouble(parsedLine[i2 + 1]));
                        }
                        catch (NumberFormatException nfe) {
                            if (!"null".equalsIgnoreCase(parsedLine[i2 + 1].trim())) break block27;
                            views[i2].add(time, JLDataView.NAN_FOR_NULL);
                        }
                    }
                    ++i2;
                }
            }
            reader.close();
            reader = null;
            dataFile = null;
            line = null;
            parsedLine = null;
            genFormatFR = null;
            genFormatUS = null;
            int i3 = 0;
            while (i3 < views.length) {
                this.getY1Axis().addDataView(views[i3]);
                ++i3;
            }
            this.getXAxis().setAnnotation(annotationType);
            this.repaint();
            defaultColor = null;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Failed to load file: " + fileName, "Error", 0);
        }
    }

    public void refreshTableSingle(JLDataView v) {
        if (this.preferDialog) {
            if (this.tableDialog == null) {
                return;
            }
            if (!this.tableDialog.isVisible()) {
                return;
            }
        } else {
            if (this.theTable == null) {
                return;
            }
            if (!this.theTable.isVisible()) {
                return;
            }
        }
        this.updateTableDataSingle(v);
    }

    private void updateTableDataSingle(JLDataView v) {
        TabbedLine tl = new TabbedLine(1);
        tl.add(0, v);
        Vector<String[]> data = new Vector<String[]>();
        String[] cols = tl.getFirstFields(this.xAxis.getAnnotation(), !this.xAxis.isXY());
        String[] s = tl.getNextFields();
        while (s != null) {
            data.add(s);
            s = tl.getNextFields();
        }
        int y = data.size();
        int x = cols.length;
        Object[][] dv = new Object[y][x];
        int j = 0;
        while (j < y) {
            Object[] ln = (Object[])data.get(j);
            int i = 0;
            while (i < x) {
                dv[j][i] = ln[i];
                ++i;
            }
            ++j;
        }
        if (this.preferDialog && this.tableDialog != null) {
            JTableRow row = null;
            try {
                row = (JTableRow)this.tableDialog.getContentPane();
            }
            catch (ClassCastException cce) {
                if (this.theTable != null) {
                    row = (JTableRow)this.theTable.getContentPane();
                }
                return;
            }
            row.setData(dv, cols);
            row = null;
        } else {
            this.theTable.setData(dv, cols);
        }
    }

    private void showTableSingle(JLDataView v) {
        if (this.theTable == null) {
            this.theTable = new JLTable();
        }
        if (this.tableDialog == null) {
            this.tableDialog = this.dialogParent != null ? (this.dialogParent instanceof Frame ? new JDialog((Frame)this.dialogParent, this.theTable.getTitle(), this.modalDialog) : (this.dialogParent instanceof Dialog ? new JDialog((Dialog)this.dialogParent, this.theTable.getTitle(), this.modalDialog) : new JDialog(null, this.theTable.getTitle(), this.modalDialog))) : new JDialog(null, this.theTable.getTitle(), this.modalDialog);
        }
        this.updateTableDataSingle(v);
        if (this.tableDialog != null && this.tableDialog.getContentPane() instanceof JTableRow) {
            this.theTable.setContentPane(this.tableDialog.getContentPane());
        }
        if (!this.theTable.isVisible()) {
            this.theTable.centerWindow();
        }
        if (this.preferDialog) {
            this.tableDialog.setContentPane(this.theTable.getContentPane());
            this.tableDialog.setBounds(this.theTable.getBounds());
            this.tableDialog.setResizable(this.theTable.isResizable());
            this.theTable.setVisible(false);
            this.theTable = null;
            this.tableDialog.setVisible(true);
        } else {
            this.tableDialog.setVisible(false);
            this.tableDialog = null;
            this.theTable.setVisible(true);
        }
        if (this.preferDialog) {
            this.tableDialog.repaint();
        } else {
            this.theTable.repaint();
        }
    }

    private void displayPrecisionDialog() {
        final JDialog precisionDialog = new JDialog(null, "Set error margin", true);
        JLabel precisionLabel = new JLabel("Set error margin in x units.");
        JLabel detailLabel = new JLabel("If x represents time, unit is ms.");
        final char[] allowed = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\b', '\u007f', '%', '\'', '\u00e2', '\u00e3', '\n', '\t', '\u0010'};
        JTextField textField = new JTextField();
        textField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent arg0) {
                if (!this.validateChar(arg0.getKeyChar())) {
                    arg0.consume();
                }
            }

            public void keyReleased(KeyEvent arg0) {
                if (!this.validateChar(arg0.getKeyChar())) {
                    arg0.consume();
                }
            }

            public void keyTyped(KeyEvent arg0) {
                if (!this.validateChar(arg0.getKeyChar())) {
                    arg0.consume();
                }
            }

            private boolean validateChar(char c) {
                int j = 0;
                while (j < allowed.length) {
                    if (c == allowed[j]) {
                        return true;
                    }
                    ++j;
                }
                return false;
            }
        });
        textField.setColumns(5);
        textField.setText("" + this.timePrecision);
        JButton ok = new JButton("ok");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                precisionDialog.setVisible(false);
            }
        });
        JPanel panel = new JPanel();
        Box box = new Box(1);
        box.add(precisionLabel);
        box.add(textField);
        box.add(detailLabel);
        box.add(ok);
        panel.add(box);
        precisionDialog.setContentPane(panel);
        precisionDialog.setSize(230, 120);
        precisionDialog.setResizable(false);
        precisionDialog.setVisible(true);
        int prec = this.timePrecision;
        try {
            this.timePrecision = Integer.parseInt(textField.getText());
        }
        catch (Exception e) {
            this.timePrecision = prec;
        }
    }

    protected void showTableAll() {
        Vector<JLDataView> views = new Vector<JLDataView>();
        if (this.xAxis.isXY()) {
            views.addAll(this.xAxis.getViews());
        }
        views.addAll(this.y1Axis.getViews());
        views.addAll(this.y2Axis.getViews());
        TabbedLine tl = new TabbedLine(views.size());
        tl.setPrecision(this.timePrecision);
        int v = 0;
        while (v < views.size()) {
            tl.add(v, (JLDataView)views.get(v));
            ++v;
        }
        if (this.theTable == null) {
            this.theTable = new JLTable();
        }
        if (this.tableDialog == null) {
            this.tableDialog = this.dialogParent != null ? (this.dialogParent instanceof Frame ? new JDialog((Frame)this.dialogParent, this.theTable.getTitle(), this.modalDialog) : (this.dialogParent instanceof Dialog ? new JDialog((Dialog)this.dialogParent, this.theTable.getTitle(), this.modalDialog) : new JDialog(null, this.theTable.getTitle(), this.modalDialog))) : new JDialog(null, this.theTable.getTitle(), this.modalDialog);
        }
        Vector<String[]> data = new Vector<String[]>();
        String[] cols = tl.getFirstFields(this.xAxis.getAnnotation(), !this.xAxis.isXY());
        String[] s = tl.getNextFields();
        while (s != null) {
            data.add(s);
            s = tl.getNextFields();
        }
        int y = data.size();
        int x = cols.length;
        Object[][] dv = new Object[y][x];
        int j = 0;
        while (j < y) {
            Object[] ln = (Object[])data.get(j);
            int i = 0;
            while (i < x) {
                dv[j][i] = ln[i];
                ++i;
            }
            ++j;
        }
        if (x == 1 && y == 0) {
            dv = null;
            cols = null;
        }
        this.theTable.setData(dv, cols);
        if (!this.theTable.isVisible()) {
            this.theTable.centerWindow();
        }
        if (this.preferDialog) {
            this.tableDialog.setContentPane(this.theTable.getContentPane());
            this.tableDialog.setBounds(this.theTable.getBounds());
            this.tableDialog.setResizable(this.theTable.isResizable());
            this.theTable.setVisible(false);
            this.theTable = null;
            this.tableDialog.setVisible(true);
        } else {
            this.tableDialog.setVisible(false);
            this.tableDialog = null;
            this.theTable.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showStatAll() {
        double[][] values;
        Vector<JLDataView> views = new Vector<JLDataView>();
        if (this.xAxis.isXY()) {
            views.addAll(this.xAxis.getViews());
        }
        views.addAll(this.y1Axis.getViews());
        views.addAll(this.y2Axis.getViews());
        int dataCount = 0;
        Vector<JLDataView> vector = views;
        synchronized (vector) {
            int i = 0;
            while (i < views.size()) {
                dataCount += ((JLDataView)views.get(i)).getDataLength();
                ++i;
            }
            values = new double[dataCount][2];
            int index = 0;
            int i2 = 0;
            while (i2 < views.size()) {
                DataList data = ((JLDataView)views.get(i2)).getData();
                while (data != null) {
                    long l;
                    double y = data.y;
                    double x = data.x;
                    if (Double.isNaN(y)) {
                        l = Double.doubleToRawLongBits(data.y);
                        if (l == Double.doubleToRawLongBits(JLDataView.NAN_FOR_NEGATIVE_INFINITY)) {
                            y = Double.POSITIVE_INFINITY;
                        } else if (l == Double.doubleToRawLongBits(JLDataView.NAN_FOR_POSITIVE_INFINITY)) {
                            y = Double.NEGATIVE_INFINITY;
                        }
                    }
                    if (Double.isNaN(y)) {
                        l = Double.doubleToRawLongBits(data.y);
                        if (l == Double.doubleToRawLongBits(JLDataView.NAN_FOR_NEGATIVE_INFINITY)) {
                            y = Double.POSITIVE_INFINITY;
                        } else if (l == Double.doubleToRawLongBits(JLDataView.NAN_FOR_POSITIVE_INFINITY)) {
                            y = Double.NEGATIVE_INFINITY;
                        }
                    }
                    if (Double.isNaN(x)) {
                        l = Double.doubleToRawLongBits(data.x);
                        if (l == Double.doubleToRawLongBits(JLDataView.NAN_FOR_NEGATIVE_INFINITY)) {
                            x = Double.POSITIVE_INFINITY;
                        } else if (l == Double.doubleToRawLongBits(JLDataView.NAN_FOR_POSITIVE_INFINITY)) {
                            x = Double.NEGATIVE_INFINITY;
                        }
                    }
                    values[index][0] = y;
                    values[index++][1] = x;
                    data = data.next;
                }
                ++i2;
            }
        }
        this.showStatistics(values, "all");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showStatSingle(JLDataView v) {
        double[][] values;
        JLDataView jLDataView = v;
        synchronized (jLDataView) {
            int dataCount = v.getDataLength();
            DataList data = v.getData();
            values = new double[dataCount][2];
            int i = 0;
            while (i < values.length) {
                long l;
                double y = data.y;
                double x = data.x;
                if (Double.isNaN(y)) {
                    l = Double.doubleToRawLongBits(data.y);
                    if (l == Double.doubleToRawLongBits(JLDataView.NAN_FOR_NEGATIVE_INFINITY)) {
                        y = Double.POSITIVE_INFINITY;
                    } else if (l == Double.doubleToRawLongBits(JLDataView.NAN_FOR_POSITIVE_INFINITY)) {
                        y = Double.NEGATIVE_INFINITY;
                    }
                }
                if (Double.isNaN(x)) {
                    l = Double.doubleToRawLongBits(data.x);
                    if (l == Double.doubleToRawLongBits(JLDataView.NAN_FOR_NEGATIVE_INFINITY)) {
                        x = Double.POSITIVE_INFINITY;
                    } else if (l == Double.doubleToRawLongBits(JLDataView.NAN_FOR_POSITIVE_INFINITY)) {
                        x = Double.NEGATIVE_INFINITY;
                    }
                }
                values[i][0] = y;
                values[i][1] = x;
                data = data.next;
                ++i;
            }
        }
        this.showStatistics(values, v.getName());
    }

    private void showStatistics(double[][] values, String name) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double minX = Double.NaN;
        double maxX = Double.NaN;
        double average = 0.0;
        double standardDeviation = 0.0;
        double sampleStandardDeviation = 0.0;
        double squareSum = 0.0;
        try {
            String xStringValue;
            int i = 0;
            while (i < values.length) {
                if (values[i][0] < min) {
                    min = values[i][0];
                    minX = values[i][1];
                }
                if (values[i][0] > max) {
                    max = values[i][0];
                    maxX = values[i][1];
                }
                average += values[i][0];
                double square = Double.isInfinite(values[i][0]) ? Double.POSITIVE_INFINITY : (Double.isNaN(values[i][0]) ? Double.NaN : values[i][0] * values[i][0]);
                squareSum += square;
                ++i;
            }
            if (Double.isInfinite(min) && min > 0.0) {
                min = Double.NaN;
            }
            if (Double.isInfinite(max) && max < 0.0) {
                max = Double.NaN;
            }
            if (values.length > 0) {
                standardDeviation = Math.sqrt((squareSum /= (double)values.length) - (average /= (double)values.length) * average);
                sampleStandardDeviation = values.length > 1 ? Math.sqrt((double)values.length / (double)(values.length - 1) * (squareSum - average * average)) : Double.NaN;
            } else {
                average = Double.NaN;
                standardDeviation = Double.NaN;
                sampleStandardDeviation = Double.NaN;
                min = Double.NaN;
                max = Double.NaN;
            }
            StringBuffer titleBuffer = new StringBuffer("Statistics: ");
            titleBuffer.append(name);
            StringBuffer messageBuffer = new StringBuffer("Minimum: ");
            messageBuffer.append(min);
            if (!Double.isNaN(minX)) {
                xStringValue = "";
                xStringValue = this.xAxis.getAnnotation() == 1 ? JLAxis.formatTimeValue(minX) : this.xAxis.formatValue(minX, 0.0);
                messageBuffer.append(", obtained at X = ");
                messageBuffer.append(xStringValue);
            }
            messageBuffer.append("\nMaximum: ").append(max);
            if (!Double.isNaN(maxX)) {
                xStringValue = "";
                xStringValue = this.xAxis.getAnnotation() == 1 ? JLAxis.formatTimeValue(maxX) : this.xAxis.formatValue(maxX, 0.0);
                messageBuffer.append(", obtained at X = ");
                messageBuffer.append(xStringValue);
            }
            messageBuffer.append("\nAverage: ").append(average);
            messageBuffer.append("\nStandard Deviation: ");
            messageBuffer.append(standardDeviation);
            messageBuffer.append("\nSample Standard Deviation: ");
            messageBuffer.append(sampleStandardDeviation);
            JOptionPane.showMessageDialog(this, messageBuffer.toString(), titleBuffer.toString(), -1, null);
            titleBuffer = null;
            messageBuffer = null;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Failed to obtain statistics on " + name, "Error", 0);
            e.printStackTrace();
        }
    }

    protected String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.optionMenuItem) {
            this.showOptionDialog();
        } else if (src == this.zoomBackMenuItem || src == this.zoomButton) {
            this.exitZoom();
        } else if (src == this.printMenuItem) {
            this.printGraph();
        } else if (src == this.saveSnapshotMenuItem) {
            this.saveSnapshot();
        } else if (src == this.precisionMenuItem) {
            this.displayPrecisionDialog();
        } else if (src == this.tableAllMenuItem) {
            this.showTableAll();
        } else if (src == this.statAllMenuItem) {
            this.showStatAll();
        } else if (src == this.saveFileMenuItem) {
            File f;
            int ok = 0;
            JFileChooser chooser = new JFileChooser(this.lastDataFileLocation);
            chooser.addChoosableFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String extension = JLChart.this.getExtension(f);
                    return extension != null && extension.equals("txt");
                }

                public String getDescription() {
                    return "text files ";
                }
            });
            chooser.setDialogTitle("Save Graph Data (Text file with TAB separated fields)");
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0 && (f = chooser.getSelectedFile()) != null) {
                if (this.getExtension(f) == null) {
                    f = new File(String.valueOf(f.getAbsolutePath()) + ".txt");
                }
                if (f.exists()) {
                    ok = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + f.getName() + " ?", "Confirm overwrite", 0);
                }
                if (ok == 0) {
                    this.lastDataFileLocation = f.getParentFile().getAbsolutePath();
                    this.saveDataFile(f.getAbsolutePath());
                }
            }
        } else {
            boolean found = false;
            int i = 0;
            while (i < this.userActionMenuItem.length && !found) {
                boolean bl = found = this.userActionMenuItem[i] == evt.getSource();
                if (found) continue;
                ++i;
            }
            if (found) {
                if (this.userActionMenuItem[i] instanceof JCheckBoxMenuItem) {
                    JCheckBoxMenuItem c = (JCheckBoxMenuItem)this.userActionMenuItem[i];
                    this.fireActionPerfromed(c.getText(), c.getState());
                } else {
                    this.fireActionPerfromed(this.userActionMenuItem[i].getText(), false);
                }
                return;
            }
            i = 0;
            while (i < this.dvY1MenuItem.length && !found) {
                boolean bl = found = this.dvY1MenuItem[i] == evt.getSource();
                if (found) continue;
                ++i;
            }
            if (found) {
                this.showDataOptionDialog(this.y1Axis.getDataView(i));
                return;
            }
            i = 0;
            while (i < this.dvY2MenuItem.length && !found) {
                boolean bl = found = this.dvY2MenuItem[i] == evt.getSource();
                if (found) continue;
                ++i;
            }
            if (found) {
                this.showDataOptionDialog(this.y2Axis.getDataView(i));
                return;
            }
            i = 0;
            while (i < this.tableSingleY1MenuItem.length && !found) {
                boolean bl = found = this.tableSingleY1MenuItem[i] == evt.getSource();
                if (found) continue;
                ++i;
            }
            if (found) {
                this.showTableSingle(this.y1Axis.getDataView(i));
                return;
            }
            i = 0;
            while (i < this.tableSingleY2MenuItem.length && !found) {
                boolean bl = found = this.tableSingleY2MenuItem[i] == evt.getSource();
                if (found) continue;
                ++i;
            }
            if (found) {
                this.showTableSingle(this.y2Axis.getDataView(i));
                return;
            }
            i = 0;
            while (i < this.statSingleY1MenuItem.length && !found) {
                boolean bl = found = this.statSingleY1MenuItem[i] == evt.getSource();
                if (found) continue;
                ++i;
            }
            if (found) {
                this.showStatSingle(this.y1Axis.getDataView(i));
                return;
            }
            i = 0;
            while (i < this.statSingleY2MenuItem.length && !found) {
                boolean bl = found = this.statSingleY2MenuItem[i] == evt.getSource();
                if (found) continue;
                ++i;
            }
            if (found) {
                this.showStatSingle(this.y2Axis.getDataView(i));
                return;
            }
        }
    }

    private void paintLabelAndHeader(Graphics2D g) {
        int xpos;
        int nbv1 = this.y1Axis.getViews().size();
        int nbv2 = this.y2Axis.getViews().size();
        if (this.headerR.width > 0) {
            g.setFont(this.headerFont);
            xpos = (this.headerR.width - this.headerWidth) / 2;
            g.setColor(this.headerColor);
            g.drawString(this.header, xpos, this.headerR.y + g.getFontMetrics(this.headerFont).getAscent() - 1);
        }
        this.labelRect.clear();
        if (this.labelR.width > 0) {
            int y;
            JLDataView v;
            g.setFont(this.labelFont);
            int a = g.getFontMetrics(this.labelFont).getAscent();
            int k = 0;
            xpos = this.labelR.x + (this.labelR.width - this.labelWidth) / 2 + 2;
            int ypos = this.labelR.y + (this.labelR.height - this.labelHeight) / 2 + 2;
            int i = 0;
            while (i < nbv1) {
                v = this.y1Axis.getViews().get(i);
                if (v.isLabelVisible()) {
                    g.setColor(v.getColor());
                    y = ypos + this.labelSHeight * k + this.labelSHeight / 2;
                    JLAxis.drawSampleLine(g, xpos, y - 2, v);
                    g.setColor(v.getLabelColor());
                    g.drawString(String.valueOf(v.getExtendedName()) + " " + this.y1Axis.getAxeName(), xpos + 44, y + this.labelSHeight - a);
                    this.labelRect.add(new LabelRect(xpos, y - a, this.labelWidth + 44, this.labelSHeight, v));
                    ++k;
                }
                ++i;
            }
            i = 0;
            while (i < nbv2) {
                v = this.y2Axis.getViews().get(i);
                if (v.isLabelVisible()) {
                    g.setColor(v.getColor());
                    y = ypos + this.labelSHeight * k + this.labelSHeight / 2;
                    JLAxis.drawSampleLine(g, xpos, y - 2, v);
                    g.setColor(Color.BLACK);
                    g.drawString(String.valueOf(v.getExtendedName()) + " " + this.y2Axis.getAxeName(), xpos + 44, y + this.labelSHeight - a);
                    this.labelRect.add(new LabelRect(xpos, y - a, this.labelWidth + 44, this.labelSHeight, v));
                    ++k;
                }
                ++i;
            }
        }
    }

    private void measureGraphItems(Graphics2D g, FontRenderContext frc, int w, int h, Vector views) {
        Rectangle2D bounds = null;
        int MX = this.margin.width;
        int MY = this.margin.height;
        this.headerR.setBounds(0, 0, 0, 10);
        this.viewR.setBounds(0, 0, 0, 0);
        this.labelR.setBounds(0, 0, 0, 0);
        this.labelWidth = 0;
        this.labelHeight = 0;
        this.headerWidth = 0;
        this.axisWidth = 0;
        this.axisHeight = 0;
        this.y1AxisThickness = 0;
        this.y2AxisThickness = 0;
        if (this.headerVisible && this.header != null && this.headerFont != null) {
            bounds = this.headerFont.getStringBounds(this.header, frc);
            this.headerWidth = (int)bounds.getWidth();
            this.headerR.setBounds(MX, MY, w - 2 * MX, (int)bounds.getHeight() + 5);
        }
        int nbLab = 0;
        int i = 0;
        while (i < this.y1Axis.getViews().size()) {
            if (this.y1Axis.getViews().get(i).isLabelVisible()) {
                ++nbLab;
            }
            ++i;
        }
        i = 0;
        while (i < this.y2Axis.getViews().size()) {
            if (this.y2Axis.getViews().get(i).isLabelVisible()) {
                ++nbLab;
            }
            ++i;
        }
        if (this.labelVisible && nbLab > 0 && this.labelFont != null) {
            JLDataView v;
            i = 0;
            double maxLength = 0.0;
            i = 0;
            while (i < this.y1Axis.getViews().size()) {
                v = this.y1Axis.getViews().get(i);
                if (v.isLabelVisible() && (bounds = this.labelFont.getStringBounds(String.valueOf(v.getExtendedName()) + " " + this.y1Axis.getAxeName(), frc)).getWidth() > maxLength) {
                    maxLength = bounds.getWidth();
                }
                ++i;
            }
            i = 0;
            while (i < this.y2Axis.getViews().size()) {
                v = this.y2Axis.getViews().get(i);
                if (v.isLabelVisible() && (bounds = this.labelFont.getStringBounds(String.valueOf(v.getExtendedName()) + " " + this.y2Axis.getAxeName(), frc)).getWidth() > maxLength) {
                    maxLength = bounds.getWidth();
                }
                ++i;
            }
            this.labelSHeight = (int)bounds.getHeight() + 2;
            this.labelHeight = this.labelSHeight * nbLab;
            this.labelWidth = (int)(maxLength + 45.0);
            switch (this.labelMode) {
                case 1: {
                    this.labelR.setBounds(MX, MY + this.headerR.height, w - 2 * MX, this.labelHeight);
                    break;
                }
                case 0: {
                    this.labelR.setBounds(MX, h - MY - this.labelHeight, w - 2 * MX, this.labelHeight);
                    break;
                }
                case 2: {
                    this.labelR.setBounds(w - MX - this.labelWidth, MY + this.headerR.height, this.labelWidth, h - 2 * MY - this.headerR.height);
                    break;
                }
                case 3: {
                    this.labelR.setBounds(MX, MY + this.headerR.height, this.labelWidth, h - 2 * MY - this.headerR.height);
                }
            }
        }
        switch (this.labelMode) {
            case 1: {
                this.viewR.setBounds(MX, MY + this.headerR.height + this.labelR.height, w - 2 * MX, h - 2 * MY - this.headerR.height - this.labelR.height);
                break;
            }
            case 0: {
                this.viewR.setBounds(MX, MY + this.headerR.height, w - 2 * MX, h - 2 * MY - this.headerR.height - this.labelR.height);
                break;
            }
            case 2: {
                this.viewR.setBounds(MX, MY + this.headerR.height, w - 2 * MX - this.labelR.width, h - 2 * MY - this.headerR.height);
                break;
            }
            case 3: {
                this.viewR.setBounds(MX + this.labelR.width, MY + this.headerR.height, w - 2 * MX - this.labelR.width, h - 2 * MY - this.headerR.height);
            }
        }
        this.xAxisThickness = this.xAxis.getLabelFontDimension(frc);
        this.xAxisUpMargin = this.xAxis.getOrientation() == 2 ? this.xAxisThickness / 2 : 0;
        this.axisHeight = this.viewR.height - this.xAxisThickness;
        this.xAxis.computeXScale(views);
        this.y1Axis.measureAxis(frc, 0, this.axisHeight);
        this.y2Axis.measureAxis(frc, 0, this.axisHeight);
        this.y1AxisThickness = this.y1Axis.getThickness();
        if (this.y1AxisThickness == 0) {
            this.y1AxisThickness = 5;
        }
        this.y2AxisThickness = this.y2Axis.getThickness();
        if (this.y2AxisThickness == 0) {
            this.y2AxisThickness = 5;
        }
        this.axisWidth = this.viewR.width - (this.y1AxisThickness + this.y2AxisThickness);
        this.xAxis.measureAxis(frc, this.axisWidth, 0);
    }

    private void paintZoomButton(int x, int y) {
        if (this.isZoomed()) {
            int w = this.zoomButton.getPreferredSize().width;
            int h = this.zoomButton.getPreferredSize().height;
            this.zoomButton.setBounds(x + 7, y + 5, w, h);
            this.zoomButton.setVisible(w < this.axisWidth - 7 && h < this.axisHeight - 5);
        } else {
            this.zoomButton.setVisible(false);
        }
    }

    private void paintZoomSelection(Graphics g) {
        if (this.zoomDrag) {
            g.setColor(Color.black);
            Rectangle r = this.buildRect(this.zoomX, this.zoomY, this.lastX, this.lastY);
            g.drawRect(r.x, r.y, r.width, r.height);
        }
    }

    public void paint(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        Vector<JLDataView> views = new Vector<JLDataView>(this.y1Axis.getViews());
        views.addAll(this.y2Axis.getViews());
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontRenderContext frc = g2.getFontRenderContext();
        g.setPaintMode();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, w, h);
        }
        this.measureGraphItems(g2, frc, w, h, views);
        this.paintLabelAndHeader(g2);
        int xOrg = this.viewR.x + this.y1AxisThickness;
        int yOrg = this.viewR.y + this.axisHeight + this.xAxisUpMargin;
        int xOrgY1 = this.viewR.x;
        int xOrgY2 = this.viewR.x + this.y1AxisThickness + this.axisWidth;
        int yOrgY = this.viewR.y + this.xAxisUpMargin;
        if (!this.chartBackground.equals(this.getBackground()) && this.axisWidth > 0 && this.axisHeight > 0) {
            g.setColor(this.chartBackground);
            g.fillRect(xOrg, yOrg - this.axisHeight, this.axisWidth, this.axisHeight);
        }
        this.paintZoomSelection(g);
        this.paintZoomButton(xOrg, yOrgY);
        if (this.paintAxisFirst) {
            this.y1Axis.paintAxis(g, frc, xOrgY1, yOrgY, this.xAxis, xOrg, yOrg, this.getBackground(), !this.y2Axis.isVisible() || this.y2Axis.getViewNumber() == 0);
            this.y2Axis.paintAxis(g, frc, xOrgY2, yOrgY, this.xAxis, xOrg, yOrg, this.getBackground(), !this.y1Axis.isVisible() || this.y1Axis.getViewNumber() == 0);
            if (this.xAxis.getPosition() == 4) {
                this.xAxis.paintAxis(g, frc, xOrg, yOrg, this.y2Axis, 0, 0, this.getBackground(), true);
            } else {
                this.xAxis.paintAxis(g, frc, xOrg, yOrg, this.y1Axis, 0, 0, this.getBackground(), true);
            }
            Rectangle clipRect = g.getClipBounds();
            this.y1Axis.paintDataViews(g, this.xAxis, xOrg, yOrg);
            this.y2Axis.paintDataViews(g, this.xAxis, xOrg, yOrg);
            if (clipRect != null) {
                g.setClip(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
            } else {
                g.setClip(null);
            }
        } else {
            Rectangle clipRect = g.getClipBounds();
            this.y1Axis.paintDataViews(g, this.xAxis, xOrg, yOrg);
            this.y2Axis.paintDataViews(g, this.xAxis, xOrg, yOrg);
            if (clipRect != null) {
                g.setClip(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
            } else {
                g.setClip(null);
            }
            this.y1Axis.paintAxis(g, frc, xOrgY1, yOrgY, this.xAxis, xOrg, yOrg, this.getBackground(), !this.y2Axis.isVisible() || this.y2Axis.getViewNumber() == 0);
            this.y2Axis.paintAxis(g, frc, xOrgY2, yOrgY, this.xAxis, xOrg, yOrg, this.getBackground(), !this.y1Axis.isVisible() || this.y1Axis.getViewNumber() == 0);
            if (this.xAxis.getPosition() == 4) {
                this.xAxis.paintAxis(g, frc, xOrg, yOrg, this.y2Axis, 0, 0, this.getBackground(), true);
            } else {
                this.xAxis.paintAxis(g, frc, xOrg, yOrg, this.y1Axis, 0, 0, this.getBackground(), true);
            }
        }
        this.redrawPanel(g);
        this.paintComponents(g);
        this.paintBorder(g);
    }

    private Rectangle buildRect(int x1, int y1, int x2, int y2) {
        Rectangle r = new Rectangle();
        if (x1 < x2) {
            if (y1 < y2) {
                r.setRect(x1, y1, x2 - x1, y2 - y1);
            } else {
                r.setRect(x1, y2, x2 - x1, y1 - y2);
            }
        } else if (y1 < y2) {
            r.setRect(x2, y1, x1 - x2, y2 - y1);
        } else {
            r.setRect(x2, y2, x1 - x2, y1 - y2);
        }
        return r;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.zoomDrag) {
            Rectangle r = this.buildRect(this.zoomX, this.zoomY, this.lastX, this.lastY);
            ++r.width;
            ++r.height;
            this.repaint(r);
            this.lastX = e.getX();
            this.lastY = e.getY();
            r = this.buildRect(this.zoomX, this.zoomY, this.lastX, this.lastY);
            ++r.width;
            ++r.height;
            this.repaint(r);
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (this.zoomDrag) {
            Rectangle r = this.buildRect(this.zoomX, this.zoomY, e.getX(), e.getY());
            this.zoomDrag = false;
            this.xAxis.zoom(r.x, r.x + r.width);
            this.y1Axis.zoom(r.y, r.y + r.height);
            this.y2Axis.zoom(r.y, r.y + r.height);
        }
        this.ipanelVisible = false;
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            if (e.isControlDown() || this.zoomDragAllowed) {
                this.zoomDrag = true;
                this.zoomX = e.getX();
                this.zoomY = e.getY();
                this.lastX = e.getX();
                this.lastY = e.getY();
                return;
            }
            SearchInfo msi = null;
            msi = this.y1Axis.searchNearest(e.getX(), e.getY(), this.xAxis);
            SearchInfo si = this.y2Axis.searchNearest(e.getX(), e.getY(), this.xAxis);
            if (si.found && si.dist < msi.dist) {
                msi = si;
            }
            if (msi.found) {
                Graphics g = this.getGraphics();
                this.showPanel(g, msi);
                g.dispose();
                return;
            }
            int i = 0;
            boolean found = false;
            while (i < this.labelRect.size() && !found) {
                LabelRect r = this.labelRect.get(i);
                found = r.rect.contains(e.getX(), e.getY());
                if (found) {
                    this.showDataOptionDialog(r.view);
                }
                ++i;
            }
        }
        if (e.getButton() == 3) {
            this.zoomBackMenuItem.setEnabled(this.isZoomed());
            int i = 0;
            while (i < this.userActionMenuItem.length) {
                if (this.userActionMenuItem[i] instanceof JCheckBoxMenuItem) {
                    JCheckBoxMenuItem b = (JCheckBoxMenuItem)this.userActionMenuItem[i];
                    b.setSelected(this.fireGetActionState(b.getText()));
                }
                ++i;
            }
            this.tableMenu.removeAll();
            this.tableMenu.add(this.tableAllMenuItem);
            if (this.y1Axis.getViewNumber() > 0) {
                this.tableMenu.add(new JSeparator());
            }
            i = 0;
            while (i < this.tableSingleY1MenuItem.length) {
                this.tableSingleY1MenuItem[i].removeActionListener(this);
                ++i;
            }
            this.tableSingleY1MenuItem = new JMenuItem[this.y1Axis.getViewNumber()];
            i = 0;
            while (i < this.y1Axis.getViewNumber()) {
                this.tableSingleY1MenuItem[i] = new JMenuItem(this.y1Axis.getDataView(i).getName());
                this.tableSingleY1MenuItem[i].addActionListener(this);
                this.tableMenu.add(this.tableSingleY1MenuItem[i]);
                ++i;
            }
            if (this.y1Axis.getViewNumber() > 0 && this.y2Axis.getViewNumber() > 0) {
                this.tableMenu.add(new JSeparator());
            }
            i = 0;
            while (i < this.tableSingleY2MenuItem.length) {
                this.tableSingleY2MenuItem[i].removeActionListener(this);
                ++i;
            }
            this.tableSingleY2MenuItem = new JMenuItem[this.y2Axis.getViewNumber()];
            i = 0;
            while (i < this.y2Axis.getViewNumber()) {
                this.tableSingleY2MenuItem[i] = new JMenuItem(this.y2Axis.getDataView(i).getName());
                this.tableSingleY2MenuItem[i].addActionListener(this);
                this.tableMenu.add(this.tableSingleY2MenuItem[i]);
                ++i;
            }
            this.dvMenu.removeAll();
            i = 0;
            while (i < this.dvY1MenuItem.length) {
                this.dvY1MenuItem[i].removeActionListener(this);
                ++i;
            }
            i = 0;
            while (i < this.dvY2MenuItem.length) {
                this.dvY2MenuItem[i].removeActionListener(this);
                ++i;
            }
            this.dvY1MenuItem = new JMenuItem[this.y1Axis.getViewNumber()];
            this.dvY2MenuItem = new JMenuItem[this.y2Axis.getViewNumber()];
            int unamedDv = 1;
            i = 0;
            while (i < this.y1Axis.getViewNumber()) {
                String dvName = this.y1Axis.getDataView(i).getName();
                if (dvName.length() == 0) {
                    dvName = "Dataview #" + unamedDv;
                    ++unamedDv;
                }
                this.dvY1MenuItem[i] = new JMenuItem(dvName);
                this.dvY1MenuItem[i].addActionListener(this);
                this.dvMenu.add(this.dvY1MenuItem[i]);
                ++i;
            }
            i = 0;
            while (i < this.y2Axis.getViewNumber()) {
                String dvName = this.y2Axis.getDataView(i).getName();
                if (dvName.length() == 0) {
                    dvName = "Dataview #" + unamedDv;
                    ++unamedDv;
                }
                this.dvY2MenuItem[i] = new JMenuItem(dvName);
                this.dvY2MenuItem[i].addActionListener(this);
                this.dvMenu.add(this.dvY2MenuItem[i]);
                ++i;
            }
            this.statMenu.removeAll();
            this.statMenu.add(this.statAllMenuItem);
            if (this.y1Axis.getViewNumber() > 0) {
                this.statMenu.add(new JSeparator());
            }
            i = 0;
            while (i < this.statSingleY1MenuItem.length) {
                this.statSingleY1MenuItem[i].removeActionListener(this);
                ++i;
            }
            this.statSingleY1MenuItem = new JMenuItem[this.y1Axis.getViewNumber()];
            i = 0;
            while (i < this.y1Axis.getViewNumber()) {
                this.statSingleY1MenuItem[i] = new JMenuItem(this.y1Axis.getDataView(i).getName());
                this.statSingleY1MenuItem[i].addActionListener(this);
                this.statMenu.add(this.statSingleY1MenuItem[i]);
                ++i;
            }
            if (this.y1Axis.getViewNumber() > 0 && this.y2Axis.getViewNumber() > 0) {
                this.statMenu.add(new JSeparator());
            }
            i = 0;
            while (i < this.statSingleY2MenuItem.length) {
                this.statSingleY2MenuItem[i].removeActionListener(this);
                ++i;
            }
            this.statSingleY2MenuItem = new JMenuItem[this.y2Axis.getViewNumber()];
            i = 0;
            while (i < this.y2Axis.getViewNumber()) {
                this.statSingleY2MenuItem[i] = new JMenuItem(this.y2Axis.getDataView(i).getName());
                this.statSingleY2MenuItem[i].addActionListener(this);
                this.statMenu.add(this.statSingleY2MenuItem[i]);
                ++i;
            }
            this.chartMenu.show(this, e.getX(), e.getY());
        }
    }

    private void redrawPanel(Graphics g) {
        if (!this.ipanelVisible) {
            return;
        }
        JLDataView vy = this.lastSearch.dataView;
        JLDataView vx = this.lastSearch.xdataView;
        DataList dy = this.lastSearch.value;
        DataList dx = this.lastSearch.xvalue;
        JLAxis yaxis = this.lastSearch.axis;
        Point p = this.xAxis.isXY() ? yaxis.transform(vx.getTransformedValue(dx.y), vy.getTransformedValue(dy.y), this.xAxis) : yaxis.transform(dy.x, vy.getTransformedValue(dy.y), this.xAxis);
        this.lastSearch.x = p.x;
        this.lastSearch.y = p.y;
        this.showPanel(g, this.lastSearch);
    }

    protected String[] buildPanelString(SearchInfo si) {
        String[] str = null;
        String xValue = this.xAxis.getAnnotation() == 1 ? "Time= " + JLAxis.formatTimeValue(si.value.x) : "Index= " + si.value.x;
        str = this.xAxis.isXY() ? new String[]{String.valueOf(si.dataView.getExtendedName()) + " " + si.axis.getAxeName(), xValue, "X= " + si.xdataView.formatValue(si.xdataView.getTransformedValue(si.xvalue.y)), "Y= " + si.dataView.formatValue(si.dataView.getTransformedValue(si.value.y)) + " " + si.dataView.getUnit()} : new String[]{String.valueOf(si.dataView.getExtendedName()) + " " + si.axis.getAxeName(), xValue, "Y= " + si.dataView.formatValue(si.dataView.getTransformedValue(si.value.y)) + " " + si.dataView.getUnit()};
        return str;
    }

    public void showPanel(Graphics g, SearchInfo si) {
        Graphics2D g2 = (Graphics2D)g;
        int maxh = 0;
        int h = 0;
        int maxw = 0;
        int x0 = 0;
        int y0 = 0;
        String[] str = null;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontRenderContext frc = g2.getFontRenderContext();
        g.setPaintMode();
        g.setFont(this.labelFont);
        if (this.listener != null) {
            JLChartEvent w = new JLChartEvent(this, si);
            str = this.listener.clickOnChart(w);
        }
        if (str == null) {
            str = this.buildPanelString(si);
        }
        if (str.length <= 0) {
            return;
        }
        Rectangle2D bounds = g.getFont().getStringBounds(str[0], frc);
        maxw = (int)bounds.getWidth();
        h = maxh = (int)bounds.getHeight();
        int i = 1;
        while (i < str.length) {
            bounds = g.getFont().getStringBounds(str[i], frc);
            if ((int)bounds.getWidth() > maxw) {
                maxw = (int)bounds.getWidth();
            }
            maxh = (int)((double)maxh + bounds.getHeight());
            ++i;
        }
        maxw += 10;
        maxh += 10;
        g.setColor(Color.black);
        switch (si.placement) {
            case 3: {
                x0 = si.x + 10;
                y0 = si.y + 10;
                g.drawLine(si.x, si.y, si.x + 10, si.y + 10);
                break;
            }
            case 2: {
                x0 = si.x - 10 - maxw;
                y0 = si.y + 10;
                g.drawLine(si.x, si.y, si.x - 10, si.y + 10);
                break;
            }
            case 1: {
                x0 = si.x + 10;
                y0 = si.y - 10 - maxh;
                g.drawLine(si.x, si.y, si.x + 10, si.y - 10);
                break;
            }
            case 0: {
                x0 = si.x - 10 - maxw;
                y0 = si.y - 10 - maxh;
                g.drawLine(si.x, si.y, si.x - 10, si.y - 10);
            }
        }
        g.setColor(Color.white);
        g.fillRect(x0, y0, maxw, maxh);
        g.setColor(Color.black);
        g.drawRect(x0, y0, maxw, maxh);
        g.setColor(Color.black);
        i = 0;
        while (i < str.length) {
            g.drawString(str[i], x0 + 3, y0 + 3 + (i + 1) * h);
            ++i;
        }
        this.lastSearch = si;
        this.ipanelVisible = true;
    }

    public int garbageData(JLDataView v) {
        int nb = 0;
        if (this.displayDuration != Double.POSITIVE_INFINITY) {
            nb = v.garbagePointTime(this.displayDuration);
        }
        return nb;
    }

    public void addData(JLDataView v, double x, double y) {
        DataList lv = null;
        boolean need_repaint = false;
        if (v.getDataLength() > 0) {
            lv = v.getLastValue();
        }
        v.add(x, y);
        int nb = this.garbageData(v);
        if (nb > 0 && v.getAxis() != null) {
            need_repaint = true;
        }
        if (this.zoomDrag) {
            return;
        }
        if (this.xAxis.isXY()) {
            this.repaint();
            return;
        }
        JLAxis yaxis = v.getAxis();
        if (yaxis != null) {
            Point lp = null;
            Point p = yaxis.transform(x, v.getTransformedValue(y), this.xAxis);
            if (lv != null) {
                lp = yaxis.transform(lv.x, v.getTransformedValue(lv.y), this.xAxis);
            }
            if (yaxis.getBoundRect().contains(p) && !need_repaint) {
                yaxis.drawFast(this.getGraphics(), lp, p, v);
            } else {
                this.repaint();
            }
        }
    }

    public void setTimePrecision(int milliseconds) {
        this.timePrecision = milliseconds;
    }

    public int getTimePrecision() {
        return this.timePrecision;
    }

    public String getNoValueString() {
        return this.noValueString;
    }

    public void setNoValueString(String noValueString) {
        this.noValueString = noValueString;
    }

    public void setPreferDialogForTable(boolean preferDialog, boolean modal) {
        this.preferDialog = preferDialog;
        this.modalDialog = modal;
    }

    public void setParentForTableDialog(Frame parent) {
        this.dialogParent = parent;
    }

    public void setParentForTableDialog(Dialog parent) {
        this.dialogParent = parent;
    }

    public void removeDataView(JLDataView view) {
        JLAxis axis;
        if (view != null && (axis = view.getAxis()) != null) {
            axis.removeDataView(view);
        }
    }

    public void reset() {
        this.reset(true);
    }

    protected void reset(boolean showConfirmDialog) {
        String warning;
        int choice;
        Vector<JLDataView> existingViews = new Vector<JLDataView>();
        if (this.xAxis.isXY()) {
            existingViews.addAll(this.xAxis.getViews());
        }
        existingViews.addAll(this.y1Axis.getViews());
        existingViews.addAll(this.y2Axis.getViews());
        if (existingViews.size() != 0 && showConfirmDialog && (choice = JOptionPane.showConfirmDialog(this, warning = "Reseting chart will remove all the existing dataviews.\nYour component may not work any more.\nAre you sure to reset chart ?", "Risk of breaking component", 2)) != 0) {
            existingViews.clear();
            existingViews = null;
            return;
        }
        this.maxDisplayDuration = Double.POSITIVE_INFINITY;
        this.displayDuration = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < existingViews.size()) {
            this.removeDataView((JLDataView)existingViews.get(i));
            ++i;
        }
        this.getY1Axis().setLabels(null, null);
        this.getY1Axis().setScale(0);
        this.getY1Axis().setAutoScale(true);
        this.getY2Axis().setLabels(null, null);
        this.getY2Axis().setScale(0);
        this.getY2Axis().setAutoScale(true);
        this.getXAxis().setLabels(null, null);
        this.getXAxis().setScale(0);
        this.getXAxis().setAutoScale(true);
        existingViews.clear();
        existingViews = null;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        JLChart chart = new JLChart();
        JLDataView v1 = new JLDataView();
        JLDataView v2 = new JLDataView();
        chart.setHeaderFont(new Font("Times", 1, 18));
        chart.setLabelFont(new Font("Times", 1, 12));
        chart.setHeader("Test DataView");
        chart.getY1Axis().setName("mAp");
        chart.getY1Axis().setAutoScale(false);
        chart.getY1Axis().setMinimum(-100.0);
        chart.getY1Axis().setMaximum(100.0);
        chart.getY2Axis().setName("unit");
        chart.getXAxis().setAutoScale(true);
        chart.getXAxis().setName("Value");
        chart.getXAxis().setGridVisible(true);
        chart.getXAxis().setSubGridVisible(true);
        chart.getXAxis().setAnnotation(2);
        chart.getY1Axis().setGridVisible(true);
        chart.getY1Axis().setSubGridVisible(true);
        chart.getY2Axis().setVisible(true);
        chart.getY2Axis().setName("mAp");
        if (args.length > 0) {
            chart.reset(false);
            chart.loadDataFile(args[0]);
        }
        v1.add(-6.0, -10.0);
        v1.add(-5.0, -15.0);
        v1.add(-4.0, 17.0);
        v1.add(-3.0, 21.0);
        v1.add(-2.0, 22.0);
        v1.add(-1.0, 24.0);
        v1.add(0.0, 98.0);
        v1.add(1.0, Double.NaN);
        v1.add(2.0, 21.0);
        v1.add(3.0, 99.0);
        v1.add(4.0, 50.0);
        v1.add(5.0, 40.0);
        v1.add(6.0, 30.0);
        v1.add(7.0, 20.0);
        v1.setMarker(9);
        v1.setStyle(2);
        v1.setName("Le signal 1");
        v1.setUnit("std");
        v1.setClickable(true);
        v1.setUserFormat("%5.2f");
        chart.getY1Axis().addDataView(v1);
        v2.add(-6.0, -10.0);
        v2.add(-5.0, -5.0);
        v2.add(-4.0, 7.0);
        v2.add(-3.0, 11.0);
        v2.add(-2.0, 12.0);
        v2.add(-1.0, 14.0);
        v2.add(0.0, 78.0);
        v2.add(1.0, Double.NaN);
        v2.add(2.0, 22.0);
        v2.add(3.0, 55.0);
        v2.add(4.0, 42.0);
        v2.add(5.0, 11.0);
        v2.add(6.0, 47.0);
        v2.add(7.0, 12.0);
        v2.setName("Le signal 2");
        v2.setUnit("std");
        v2.setColor(Color.blue);
        v2.setLineWidth(3);
        v2.setFillColor(Color.orange);
        v2.setFillStyle(1);
        v2.setViewType(1);
        chart.getY2Axis().addDataView(v2);
        JPanel bot = new JPanel();
        bot.setLayout(new FlowLayout());
        JButton b = new JButton("Exit");
        b.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                System.exit(0);
            }
        });
        bot.add(b);
        JButton c = new JButton("Options");
        c.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                JLChart.this.showOptionDialog();
            }
        });
        bot.add(c);
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add((Component)chart, "Center");
        f.getContentPane().add((Component)bot, "South");
        f.setSize(400, 300);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

