/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import com.braju.format.Format;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.GraphicsUtils;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.LabelInfo;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import fr.esrf.tangoatk.widget.util.chart.SearchInfo;
import fr.esrf.tangoatk.widget.util.chart.XYData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JLAxis
implements Serializable {
    public static final int HORIZONTAL_DOWN = 1;
    public static final int HORIZONTAL_UP = 2;
    public static final int HORIZONTAL_ORG1 = 3;
    public static final int HORIZONTAL_ORG2 = 4;
    public static final int VERTICAL_RIGHT = 5;
    public static final int VERTICAL_LEFT = 6;
    public static final int VERTICAL_ORG = 7;
    public static final int TIME_ANNO = 1;
    public static final int VALUE_ANNO = 2;
    public static final int LINEAR_SCALE = 0;
    public static final int LOG_SCALE = 1;
    public static final int AUTO_FORMAT = 0;
    public static final int SCIENTIFIC_FORMAT = 1;
    public static final int TIME_FORMAT = 2;
    public static final int DECINT_FORMAT = 3;
    public static final int HEXINT_FORMAT = 4;
    public static final int BININT_FORMAT = 5;
    public static final int SCIENTIFICINT_FORMAT = 6;
    public static final int DATE_FORMAT = 7;
    public static final String US_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String FR_DATE_FORMAT = "dd-MM-yyyy HH:mm:ss.SSS";
    static final double YEAR = 3.1536E10;
    static final double MONTH = 2.592E9;
    static final double DAY = 8.64E7;
    static final double HOUR = 3600000.0;
    static final double MINU = 60000.0;
    static final double SECO = 1000.0;
    private boolean visible;
    private double min = 0.0;
    private double max = 100.0;
    private double minimum = 0.0;
    private double maximum = 100.0;
    private boolean autoScale = false;
    private int scale = 0;
    private Color labelColor;
    private Font labelFont;
    private int labelFormat;
    private Vector<LabelInfo> labels;
    private int orientation;
    private int dOrientation;
    private boolean subtickVisible;
    private Dimension csize = null;
    private String name = null;
    private int annotation = 2;
    private Vector<JLDataView> dataViews;
    private double ln10;
    private boolean gridVisible;
    private boolean subGridVisible;
    private int gridStyle;
    private Rectangle boundRect;
    private boolean lastAutoScate;
    private boolean isZoomed;
    private double percentScrollback;
    private double axisDuration = Double.POSITIVE_INFINITY;
    private String axeName;
    private SimpleDateFormat useFormat;
    private double desiredPrec;
    private boolean drawOpposite;
    private int tickLength;
    private int subtickLength;
    private int fontOverWidth;
    private boolean inverted = false;
    private double tickStep;
    private double minTickStep;
    private int subTickStep;
    private boolean fitXAxisToDisplayDuration;
    private boolean zeroAlwaysVisible = false;
    private boolean autoLabeling = true;
    private String[] userLabel = null;
    private double[] userLabelPos = null;
    private String dateFormat = "yyyy-MM-dd HH:mm:ss.SSS";
    static final GregorianCalendar calendar = new GregorianCalendar();
    static final SimpleDateFormat genFormat = new SimpleDateFormat("dd/MM/yy HH:mm:ss.SSS");
    static final SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
    static final SimpleDateFormat monthFormat = new SimpleDateFormat("MMMMM yy");
    static final SimpleDateFormat weekFormat = new SimpleDateFormat("dd/MM/yy");
    static final SimpleDateFormat dayFormat = new SimpleDateFormat("EEE dd");
    static final SimpleDateFormat hour12Format = new SimpleDateFormat("EEE HH:mm");
    static final SimpleDateFormat hourFormat = new SimpleDateFormat("HH:mm");
    static final SimpleDateFormat secFormat = new SimpleDateFormat("HH:mm:ss");
    static final double[] timePrecs = new double[]{1000.0, 5000.0, 10000.0, 30000.0, 60000.0, 300000.0, 600000.0, 1800000.0, 3600000.0, 1.08E7, 2.16E7, 4.32E7, 8.64E7, 6.048E8, 2.592E9, 3.1536E10, 1.5768E11, 3.1536E11};
    static final SimpleDateFormat[] timeFormats = new SimpleDateFormat[]{secFormat, secFormat, secFormat, secFormat, secFormat, secFormat, secFormat, hourFormat, hourFormat, hourFormat, hourFormat, hour12Format, dayFormat, weekFormat, monthFormat, yearFormat, yearFormat, yearFormat};
    static final String[] labelFomats = new String[]{"%g", "", "%02d:%02d:%02d", "%d", "%X", "%b"};
    static final int[] triangleX;
    static final int[] triangleY;
    static final Polygon triangleShape;
    static final int[] diamondX;
    static final int[] diamondY;
    static final Polygon diamondShape;
    static double[] logStep;

    static {
        int[] nArray = new int[3];
        nArray[1] = 4;
        nArray[2] = -4;
        triangleX = nArray;
        triangleY = new int[]{-3, 3, 3};
        triangleShape = new Polygon(triangleX, triangleY, 3);
        int[] nArray2 = new int[4];
        nArray2[1] = 4;
        nArray2[3] = -4;
        diamondX = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 4;
        nArray3[2] = -4;
        diamondY = nArray3;
        diamondShape = new Polygon(diamondX, diamondY, 4);
        logStep = new double[]{0.301, 0.477, 0.602, 0.699, 0.778, 0.845, 0.903, 0.954};
    }

    public static String getHelpString() {
        return "-- Axis settings --\n  Parameter name is preceded by the axis name.\n\nvisible:true or false   Displays the axis\ngrid:true or false   Displays the grid\nsubgrid:true or false   Displays the sub grid\ngrid_style:style   (0 Solid,1 Dot, 2 Dash, 3 Long Dash)\nmin:value Axis minimum\nmax:value Axis maximum\nautoscale:true or false Axis autoscale\nscale:s   Axis scale (0 Linear ,1 Log)\nformat:format   Axis format (0 Auto,1 Sci,2 Time,3 Dec,4 Hex,5 Bin))\ntitle:'title'   Axis title ('null' to disable)\ncolor:r,g,b   Axis color\nlabel_font:name,style(0 Plain,1 Bold,2 italic),size\n";
    }

    public JLAxis(JComponent parent, int orientation) {
        this.labels = new Vector();
        this.labelFont = new Font("Dialog", 0, 11);
        this.labelColor = Color.black;
        this.orientation = orientation;
        this.dOrientation = orientation;
        this.inverted = !this.isHorizontal();
        this.dataViews = new Vector();
        this.ln10 = Math.log(10.0);
        this.gridVisible = false;
        this.subGridVisible = false;
        this.gridStyle = 1;
        this.labelFormat = 0;
        this.subtickVisible = true;
        this.boundRect = new Rectangle(0, 0, 0, 0);
        this.isZoomed = false;
        this.percentScrollback = 0.0;
        this.axeName = "";
        this.visible = true;
        this.drawOpposite = true;
        this.tickLength = 4;
        this.subtickLength = this.tickLength / 2;
        this.fontOverWidth = 0;
        this.minTickStep = 50.0;
        this.fitXAxisToDisplayDuration = true;
    }

    public void setPercentScrollback(double d) {
        this.percentScrollback = d / 100.0;
    }

    public double getPercentScrollback() {
        return this.percentScrollback;
    }

    public void setAxisColor(Color c) {
        this.labelColor = c;
    }

    public Color getAxisColor() {
        return this.labelColor;
    }

    public void setLabelFormat(int l) {
        this.labelFormat = l;
    }

    public int getLabelFormat() {
        return this.labelFormat;
    }

    public void setGridVisible(boolean b) {
        this.gridVisible = b;
    }

    public void setFitXAxisToDisplayDuration(boolean b) {
        this.fitXAxisToDisplayDuration = b;
    }

    public boolean isFitXAxisToDisplayDuration() {
        return this.fitXAxisToDisplayDuration;
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setDrawOpposite(boolean b) {
        this.drawOpposite = b;
    }

    public boolean isDrawOpposite() {
        return this.drawOpposite;
    }

    public void setSubGridVisible(boolean b) {
        this.subGridVisible = b;
    }

    public boolean isSubGridVisible() {
        return this.subGridVisible;
    }

    public void setGridStyle(int s) {
        this.gridStyle = s;
    }

    public int getGridStyle() {
        return this.gridStyle;
    }

    public void setFont(Font f) {
        this.labelFont = f;
    }

    public Font getFont() {
        return this.labelFont;
    }

    public void setAnnotation(int a) {
        this.annotation = a;
    }

    public int getAnnotation() {
        return this.annotation;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isZoomed() {
        return this.isZoomed;
    }

    public boolean isXY() {
        return this.dataViews.size() > 0;
    }

    public void setMinimum(double d) {
        this.minimum = d;
        if (!this.autoScale) {
            if (this.scale == 1) {
                if (d <= 0.0) {
                    d = 1.0;
                }
                this.min = Math.log(d) / this.ln10;
            } else {
                this.min = d;
            }
        }
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setMaximum(double d) {
        this.maximum = d;
        if (!this.autoScale) {
            if (this.scale == 1) {
                if (this.max <= 0.0) {
                    this.max = this.min * 10.0;
                }
                this.max = Math.log(d) / this.ln10;
            } else {
                this.max = d;
            }
        }
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean b) {
        this.autoScale = b;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int s) {
        this.scale = s;
        if (this.scale == 1 && (this.minimum <= 0.0 || this.maximum <= 0.0)) {
            this.minimum = 1.0;
            this.maximum = 10.0;
        }
        if (this.scale == 1) {
            this.min = Math.log(this.minimum) / this.ln10;
            this.max = Math.log(this.maximum) / this.ln10;
        } else {
            this.min = this.minimum;
            this.max = this.maximum;
        }
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.dOrientation = orientation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void zoom(int x1, int x2) {
        if (!this.isZoomed) {
            this.lastAutoScate = this.autoScale;
        }
        if (this.isHorizontal()) {
            if (x1 < this.boundRect.x) {
                x1 = this.boundRect.x;
            }
            if (x2 > this.boundRect.x + this.boundRect.width) {
                x2 = this.boundRect.x + this.boundRect.width;
            }
            if (x2 - x1 < 10) {
                return;
            }
            double xr2 = (double)(x2 - this.boundRect.x) / (double)this.boundRect.width;
            double nmax = this.min + (this.max - this.min) * xr2;
            double xr1 = (double)(x1 - this.boundRect.x) / (double)this.boundRect.width;
            double nmin = this.min + (this.max - this.min) * xr1;
            double difference = nmax - nmin;
            if (difference < 1.0E-13) {
                return;
            }
            this.min = nmin;
            this.max = nmax;
        } else {
            if (x1 < this.boundRect.y) {
                x1 = this.boundRect.y;
            }
            if (x2 > this.boundRect.y + this.boundRect.height) {
                x2 = this.boundRect.y + this.boundRect.height;
            }
            if (x2 - x1 < 10) {
                return;
            }
            double yr2 = (double)(this.boundRect.y + this.boundRect.height - x1) / (double)this.boundRect.height;
            double nmax = this.min + (this.max - this.min) * yr2;
            double yr1 = (double)(this.boundRect.y + this.boundRect.height - x2) / (double)this.boundRect.height;
            double nmin = this.min + (this.max - this.min) * yr1;
            double difference = nmax - nmin;
            if (difference < 1.0E-13) {
                return;
            }
            this.min = nmin;
            this.max = nmax;
        }
        this.autoScale = false;
        this.isZoomed = true;
    }

    public void unzoom() {
        this.autoScale = this.lastAutoScate;
        if (!this.lastAutoScate) {
            this.setMinimum(this.getMinimum());
            this.setMaximum(this.getMaximum());
        }
        this.isZoomed = false;
    }

    public int getTick() {
        return (int)this.minTickStep;
    }

    public double getTickSpacing() {
        return this.minTickStep;
    }

    public void setTickSpacing(double spacing) {
        this.minTickStep = spacing;
    }

    public void setTick(int s) {
        this.minTickStep = s;
    }

    public void setTickLength(int lgth) {
        this.tickLength = lgth;
        this.subtickLength = this.tickLength / 2;
    }

    public int getTickLength() {
        return this.tickLength;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        int z = 0;
        if (s != null) {
            z = s.length();
        }
        this.name = z > 0 ? s : null;
    }

    public void setPosition(int o) {
        if (this.isHorizontal()) {
            if (o >= 1 && o <= 4) {
                this.orientation = o;
            }
        } else if (o >= 5 && o <= 7) {
            this.orientation = o;
        }
    }

    int getPosition() {
        return this.orientation;
    }

    public String getAxeName() {
        return this.axeName;
    }

    public void setAxeName(String s) {
        this.axeName = s;
    }

    public void addDataView(JLDataView v) {
        if (this.dataViews.contains(v)) {
            return;
        }
        if (!this.isHorizontal()) {
            this.dataViews.add(v);
            v.setAxis(this);
        } else {
            this.dataViews.clear();
            this.dataViews.add(v);
            v.setAxis(this);
            this.setAnnotation(2);
        }
    }

    public void addDataViewAt(int index, JLDataView v) {
        if (this.dataViews.contains(v)) {
            return;
        }
        if (!this.isHorizontal()) {
            this.dataViews.add(index, v);
            v.setAxis(this);
        } else {
            this.addDataView(v);
        }
    }

    public JLDataView getDataView(int index) {
        if (index < 0 || index >= this.dataViews.size()) {
            return null;
        }
        return this.dataViews.get(index);
    }

    public void removeDataView(JLDataView v) {
        this.dataViews.remove(v);
        v.setAxis(null);
        if (this.isHorizontal()) {
            this.setAnnotation(1);
            if (this.scale != 0) {
                this.setScale(0);
            }
        }
    }

    public boolean checkRemoveDataView(JLDataView v) {
        boolean contained = this.dataViews.remove(v);
        if (contained) {
            v.setAxis(null);
            if (this.isHorizontal()) {
                this.setAnnotation(1);
                if (this.scale != 0) {
                    this.setScale(0);
                }
            }
        }
        return contained;
    }

    public void clearDataView() {
        int sz = this.dataViews.size();
        int i = 0;
        while (i < sz) {
            JLDataView v = this.dataViews.get(i);
            v.setAxis(null);
            ++i;
        }
        this.dataViews.clear();
    }

    public Vector<JLDataView> getViews() {
        return this.dataViews;
    }

    public int getViewNumber() {
        return this.dataViews.size();
    }

    public void setInverted(boolean i) {
        this.inverted = i;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public Rectangle getBoundRect() {
        return this.boundRect;
    }

    /*
     * Unable to fully structure code
     */
    public String toScientific(double d) {
        block4: {
            a = Math.abs(d);
            e = 0;
            f = "%.2fe%d";
            if (a == 0.0) break block4;
            if (!(a < 1.0)) ** GOTO lbl13
            while (a < 1.0) {
                a *= 10.0;
                --e;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                a /= 10.0;
                ++e;
lbl13:
                // 2 sources

                ** while (a >= 10.0)
            }
        }
        if (a >= 9.999999999) {
            a /= 10.0;
            ++e;
        }
        if (d < 0.0) {
            a = -a;
        }
        o = new Object[]{new Double(a), new Integer(e)};
        return Format.sprintf((String)f, (Object[])o);
    }

    /*
     * Unable to fully structure code
     */
    public String toScientificInt(double d) {
        block4: {
            a = Math.abs(d);
            e = 0;
            f = "%de%d";
            if (a == 0.0) break block4;
            if (!(a < 1.0)) ** GOTO lbl13
            while (a < 1.0) {
                a *= 10.0;
                --e;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                a /= 10.0;
                ++e;
lbl13:
                // 2 sources

                ** while (a >= 10.0)
            }
        }
        if (a >= 9.999999999) {
            a /= 10.0;
            ++e;
        }
        if (d < 0.0) {
            a = -a;
        }
        o = new Object[]{new Integer((int)Math.rint(a)), new Integer(e)};
        return Format.sprintf((String)f, (Object[])o);
    }

    public static String formatTimeValue(double vt) {
        calendar.setTimeInMillis((long)vt);
        Date date = calendar.getTime();
        return genFormat.format(date);
    }

    private void computeDateformat(int maxLab) {
        boolean found = false;
        int i = 0;
        while (i < timePrecs.length && !found) {
            int n = (int)((this.max - this.min) / timePrecs[i]);
            boolean bl = found = n <= maxLab;
            if (found) continue;
            ++i;
        }
        if (!found) {
            --i;
            this.desiredPrec = 3.1536E11;
            this.useFormat = yearFormat;
        } else {
            this.desiredPrec = timePrecs[i];
            this.useFormat = timeFormats[i];
        }
    }

    public void setLabels(String[] labels, double[] labelPos) {
        if (labels == null || labelPos == null) {
            this.userLabel = null;
            this.userLabelPos = null;
            this.autoLabeling = true;
            return;
        }
        if (labels.length != labelPos.length) {
            System.out.println("JLAxis.setLabels() : labels and labelPos must have the same size");
            return;
        }
        this.userLabel = labels;
        if (this.userLabel != null) {
            int i = 0;
            while (i < this.userLabel.length) {
                if (this.userLabel[i] == null) {
                    this.userLabel[i] = "" + null;
                }
                ++i;
            }
        }
        this.userLabelPos = labelPos;
        this.autoLabeling = false;
    }

    private String suppressZero(String n) {
        boolean hasDecimal;
        boolean bl = hasDecimal = n.indexOf(46) != -1;
        if (hasDecimal) {
            StringBuffer str = new StringBuffer(n);
            int i = str.length() - 1;
            while (str.charAt(i) == '0') {
                str.deleteCharAt(i);
                --i;
            }
            if (str.charAt(i) == '.') {
                str.deleteCharAt(i);
            }
            return str.toString();
        }
        return n;
    }

    public String formatValue(double vt, double prec) {
        if (Double.isNaN(vt)) {
            return "NaN";
        }
        if (prec != 0.0 && this.scale == 0) {
            boolean isNegative;
            boolean bl = isNegative = vt < 0.0;
            if (isNegative) {
                vt = -vt;
            }
            double i = Math.floor(vt / prec + 0.5);
            vt = i * prec;
            if (isNegative) {
                vt = -vt;
            }
        }
        switch (this.labelFormat) {
            case 1: {
                return this.toScientific(vt);
            }
            case 6: {
                return this.toScientificInt(vt);
            }
            case 3: 
            case 4: 
            case 5: {
                Object[] o2 = new Object[]{new Integer((int)(Math.abs(vt) + 0.5))};
                if (vt < 0.0) {
                    return "-" + Format.sprintf((String)labelFomats[this.labelFormat], (Object[])o2);
                }
                return Format.sprintf((String)labelFomats[this.labelFormat], (Object[])o2);
            }
            case 2: {
                int sec = (int)Math.abs(vt);
                Object[] o3 = new Object[]{new Integer(sec / 3600), new Integer(sec % 3600 / 60), new Integer(sec % 60)};
                if (vt < 0.0) {
                    return "-" + Format.sprintf((String)labelFomats[this.labelFormat], (Object[])o3);
                }
                return Format.sprintf((String)labelFomats[this.labelFormat], (Object[])o3);
            }
            case 7: {
                SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
                long millisec = (long)(Math.abs(vt) * 1000.0);
                return format.format(new Date(millisec));
            }
        }
        if (vt == 0.0) {
            return "0";
        }
        if (Math.abs(vt) <= 1.0E-4) {
            return this.toScientific(vt);
        }
        int nbDigit = -((int)Math.floor(Math.log10(prec)));
        if (nbDigit <= 0) {
            return this.suppressZero(Double.toString(vt));
        }
        String dFormat = "%." + nbDigit + "f";
        return this.suppressZero(Format.sprintf((String)dFormat, (Object[])new Object[]{new Double(vt)}));
    }

    private boolean isHorizontal() {
        return this.dOrientation == 1 || this.dOrientation == 2;
    }

    private double computeHighTen(double d) {
        int p = (int)Math.log10(d);
        return Math.pow(10.0, p + 1);
    }

    private double computeLowTen(double d) {
        int p = (int)Math.log10(d);
        return Math.pow(10.0, p);
    }

    private void computeAutoScale() {
        int i = 0;
        int sz = this.dataViews.size();
        double mi = 0.0;
        double ma = 0.0;
        if (this.autoScale && sz > 0) {
            this.min = Double.MAX_VALUE;
            this.max = -1.7976931348623157E308;
            i = 0;
            while (i < sz) {
                JLDataView v = this.dataViews.get(i);
                if (v.hasTransform()) {
                    double[] mm = v.computeTransformedMinMax();
                    mi = mm[0];
                    ma = mm[1];
                } else {
                    mi = v.getMinimum();
                    ma = v.getMaximum();
                }
                if (this.scale == 1) {
                    if (mi <= 0.0) {
                        mi = v.computePositiveMin();
                    }
                    if (mi != Double.MAX_VALUE) {
                        mi = Math.log(mi) / this.ln10;
                    }
                    ma = ma <= 0.0 ? -1.7976931348623157E308 : Math.log(ma) / this.ln10;
                }
                if (ma > this.max) {
                    this.max = ma;
                }
                if (mi < this.min) {
                    this.min = mi;
                }
                ++i;
            }
            if (this.min == Double.MAX_VALUE && this.max == -1.7976931348623157E308) {
                if (this.scale == 1) {
                    this.min = 0.0;
                    this.max = 1.0;
                } else {
                    this.min = 0.0;
                    this.max = 99.99;
                }
            } else if (this.zeroAlwaysVisible) {
                if (this.min < 0.0 && this.max < 0.0) {
                    this.max = 0.0;
                } else if (this.min > 0.0 && this.max > 0.0) {
                    this.min = 0.0;
                }
            }
            if (this.max - this.min < 1.0E-100) {
                this.max += 0.999;
                this.min -= 0.999;
            }
            double prec = this.computeLowTen(this.max - this.min);
            if (this.scale == 1 && prec < 1.0) {
                prec = 1.0;
            }
            this.min = this.min < 0.0 ? (double)((int)(this.min / prec) - 1) * prec : (double)((int)(this.min / prec)) * prec;
            this.max = this.max < 0.0 ? (double)((int)(this.max / prec)) * prec : (double)((int)(this.max / prec) + 1) * prec;
        }
    }

    public void setAxisDuration(double d) {
        this.axisDuration = d;
    }

    public void computeXScale(Vector views) {
        int i = 0;
        int sz = views.size();
        if (this.isHorizontal() && this.autoScale && sz > 0) {
            if (!this.isXY()) {
                this.min = Double.MAX_VALUE;
                this.max = -1.7976931348623157E308;
                i = 0;
                while (i < sz) {
                    JLDataView v = (JLDataView)views.get(i);
                    double ma = v.getMaxXValue();
                    double mi = v.getMinXValue();
                    if (this.scale == 1) {
                        if (mi <= 0.0) {
                            mi = this.annotation == 2 ? v.getPositiveMinXValue() : v.getPositiveMinTime();
                        }
                        if (mi != Double.MAX_VALUE) {
                            mi = Math.log(mi) / this.ln10;
                        }
                        ma = ma <= 0.0 ? -1.7976931348623157E308 : Math.log(ma) / this.ln10;
                    }
                    if (ma > this.max) {
                        this.max = ma;
                    }
                    if (mi < this.min) {
                        this.min = mi;
                    }
                    ++i;
                }
                if (this.min == Double.MAX_VALUE && this.max == -1.7976931348623157E308) {
                    if (this.scale == 1) {
                        this.min = 0.0;
                        this.max = 1.0;
                    } else if (this.annotation == 1) {
                        this.min = (double)System.currentTimeMillis() - 3600000.0;
                        this.max = System.currentTimeMillis();
                    } else {
                        this.min = 0.0;
                        this.max = 99.99;
                    }
                }
                if (this.annotation == 1) {
                    if (this.axisDuration != Double.POSITIVE_INFINITY && this.fitXAxisToDisplayDuration) {
                        this.min = this.max - this.axisDuration;
                    }
                    this.max += (this.max - this.min) * this.percentScrollback;
                }
                if (this.max - this.min < 1.0E-100) {
                    this.max += 0.999;
                    this.min -= 0.999;
                }
            } else {
                this.computeAutoScale();
            }
        }
    }

    public int getFontHeight(Graphics g) {
        return this.getLabelFontDimension(null);
    }

    public int getLabelFontDimension(FontRenderContext frc) {
        if (!this.visible || frc == null) {
            return 5;
        }
        int hFont = (int)((double)this.labelFont.getLineMetrics("dummyStr0", frc).getHeight() + 0.5);
        if (this.isHorizontal()) {
            if (this.name != null) {
                if (this.orientation == 1 || this.orientation == 2) {
                    return 2 * hFont + 5;
                }
                return hFont + 5;
            }
            return hFont + 5;
        }
        if (this.name != null) {
            return hFont + 5;
        }
        return 5;
    }

    public int getFontOverWidth() {
        return this.fontOverWidth;
    }

    public int getThickness() {
        if (this.csize != null && this.visible) {
            if (!this.isHorizontal()) {
                return this.csize.width;
            }
            return this.csize.height;
        }
        return 0;
    }

    public int getLength() {
        if (this.csize != null) {
            if (this.isHorizontal()) {
                return this.csize.width;
            }
            return this.csize.height;
        }
        return 0;
    }

    public void measureAxis(FontRenderContext frc, int desiredWidth, int desiredHeight) {
        int max_width = 10;
        int max_height = 0;
        this.computeAutoScale();
        if (this.autoLabeling) {
            if (!this.isHorizontal()) {
                this.computeLabels(frc, desiredHeight);
            } else {
                this.computeLabels(frc, desiredWidth);
            }
        } else if (!this.isHorizontal()) {
            this.computeUserLabels(frc, desiredHeight);
        } else {
            this.computeUserLabels(frc, desiredWidth);
        }
        int i = 0;
        while (i < this.labels.size()) {
            LabelInfo li = this.labels.get(i);
            if (li.getWidth() > max_width) {
                max_width = li.getWidth();
            }
            if (li.getHeight() > max_height) {
                max_height = li.getHeight();
            }
            ++i;
        }
        this.fontOverWidth = max_width / 2 + 1;
        this.csize = !this.isHorizontal() ? new Dimension(max_width + this.getLabelFontDimension(frc), desiredHeight) : new Dimension(desiredWidth, max_height);
    }

    public Point transform(double x, double y, JLAxis xAxis) {
        double vy;
        double vx;
        if (this.csize == null) {
            return new Point(-100, -100);
        }
        double xlength = xAxis.getMax() - xAxis.getMin();
        int xOrg = this.boundRect.x;
        int yOrg = this.boundRect.y + this.getLength();
        if (Double.isNaN(y) || Double.isNaN(x)) {
            return new Point(-100, -100);
        }
        if (xAxis.getScale() == 1) {
            if (x <= 0.0) {
                return new Point(-100, -100);
            }
            vx = Math.log(x) / this.ln10;
        } else {
            vx = x;
        }
        if (this.scale == 1) {
            if (y <= 0.0) {
                return new Point(-100, -100);
            }
            vy = Math.log(y) / this.ln10;
        } else {
            vy = y;
        }
        double xratio = (vx - xAxis.getMin()) / xlength * (double)xAxis.getLength();
        double yratio = -(vy - this.min) / (this.max - this.min) * (double)this.csize.height;
        if (xratio < -32000.0) {
            xratio = -32000.0;
        }
        if (xratio > 32000.0) {
            xratio = 32000.0;
        }
        if (yratio < -32000.0) {
            yratio = -32000.0;
        }
        if (yratio > 32000.0) {
            yratio = 32000.0;
        }
        return new Point((int)xratio + xOrg, (int)yratio + yOrg);
    }

    private int distance2(int x1, int y1, int x2, int y2) {
        return (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1);
    }

    public SearchInfo searchNearestNormal(int x, int y, JLAxis xAxis) {
        int sz = this.dataViews.size();
        int idx = 0;
        DataList minP = null;
        Point minPt = null;
        int minNorme = Integer.MAX_VALUE;
        JLDataView minDataView = null;
        int minPl = 0;
        int minIdx = -1;
        Rectangle boundRect2 = new Rectangle();
        boundRect2.setBounds(this.boundRect.x - 2, this.boundRect.y - 2, this.boundRect.width + 4, this.boundRect.height + 4);
        int i = 0;
        while (i < sz) {
            JLDataView v = this.dataViews.get(i);
            if (v.isClickable()) {
                DataList e = v.getData();
                idx = 0;
                while (e != null) {
                    int norme2;
                    Point p = this.transform(e.x, v.getTransformedValue(e.y), xAxis);
                    if (boundRect2.contains(p) && (norme2 = this.distance2(x, y, p.x, p.y)) < minNorme) {
                        minNorme = norme2;
                        minP = e;
                        minDataView = v;
                        minPt = p;
                        minIdx = idx;
                        minPl = p.x < this.boundRect.x + this.boundRect.width / 2 ? (p.y < this.boundRect.y + this.boundRect.height / 2 ? 3 : 1) : (p.y < this.boundRect.y + this.boundRect.height / 2 ? 2 : 0);
                    }
                    e = e.next;
                    ++idx;
                }
            }
            ++i;
        }
        if (minNorme == Integer.MAX_VALUE) {
            return new SearchInfo();
        }
        return new SearchInfo(minPt.x, minPt.y, minDataView, this, minP, minNorme, minPl, minIdx);
    }

    public SearchInfo searchNearestXY(int x, int y, JLAxis xAxis) {
        int sz = this.dataViews.size();
        DataList minP = null;
        DataList minXP = null;
        Point minPt = null;
        int minNorme = Integer.MAX_VALUE;
        JLDataView minDataView = null;
        int minPl = 0;
        JLDataView w = xAxis.getViews().get(0);
        Rectangle boundRect2 = new Rectangle();
        boundRect2.setBounds(this.boundRect.x - 2, this.boundRect.y - 2, this.boundRect.width + 4, this.boundRect.height + 4);
        int i = 0;
        while (i < sz) {
            JLDataView v = this.dataViews.get(i);
            if (v.isClickable()) {
                XYData e = new XYData(v.getData(), w.getData());
                if (e.isValid()) {
                    e.initFirstPoint();
                }
                while (e.isValid()) {
                    int norme2;
                    Point p = this.transform(w.getTransformedValue(e.d2.y), v.getTransformedValue(e.d1.y), xAxis);
                    if (boundRect2.contains(p) && (norme2 = this.distance2(x, y, p.x, p.y)) < minNorme) {
                        minNorme = norme2;
                        minP = e.d1;
                        minXP = e.d2;
                        minDataView = v;
                        minPt = p;
                        minPl = p.x < this.boundRect.x + this.boundRect.width / 2 ? (p.y < this.boundRect.y + this.boundRect.height / 2 ? 3 : 1) : (p.y < this.boundRect.y + this.boundRect.height / 2 ? 2 : 0);
                    }
                    e.toNextXYPoint();
                }
            }
            ++i;
        }
        if (minNorme == Integer.MAX_VALUE) {
            return new SearchInfo();
        }
        SearchInfo si = new SearchInfo(minPt.x, minPt.y, minDataView, this, minP, minNorme, minPl, -1);
        si.setXValue(minXP, w);
        return si;
    }

    public SearchInfo searchNearest(int x, int y, JLAxis xAxis) {
        if (x <= this.boundRect.x - 10 || x >= this.boundRect.x + this.boundRect.width + 10 || y <= this.boundRect.y - 10 || y >= this.boundRect.y + this.boundRect.height + 10) {
            return new SearchInfo();
        }
        if (xAxis.isXY()) {
            return this.searchNearestXY(x, y, xAxis);
        }
        return this.searchNearestNormal(x, y, xAxis);
    }

    private void computeUserLabels(FontRenderContext frc, double length) {
        double sz = this.max - this.min;
        double precDelta = sz / length;
        this.labels.clear();
        int offX = 0;
        int offY = 0;
        switch (this.dOrientation) {
            case 6: {
                offX = this.tickLength < 0 ? this.tickLength : 0;
                break;
            }
            case 5: {
                offX = this.tickLength < 0 ? -this.tickLength : 0;
                break;
            }
            default: {
                offY = this.tickLength < 0 ? -this.tickLength : 0;
            }
        }
        int i = 0;
        while (i < this.userLabel.length) {
            double upos = this.scale == 1 ? Math.log10(this.userLabelPos[i]) : this.userLabelPos[i];
            if (upos >= this.min - precDelta && upos <= this.max + precDelta) {
                int pos = this.inverted ? (int)Math.rint(length * (1.0 - (upos - this.min) / sz)) : (int)Math.rint(length * ((upos - this.min) / sz));
                Rectangle2D bounds = this.labelFont.getStringBounds(this.userLabel[i], frc);
                LabelInfo li = new LabelInfo(this.userLabel[i], (int)bounds.getWidth(), (int)bounds.getHeight(), pos);
                li.setOffset(offX, offY);
                this.labels.add(li);
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void computeLabels(FontRenderContext frc, double length) {
        if (this.max < this.min) {
            a = this.min;
            this.min = this.max;
            this.max = a;
        }
        sz = this.max - this.min;
        lgth = (int)length;
        precDelta = sz / length;
        this.labels.clear();
        switch (this.annotation) {
            case 1: {
                this.computeDateformat(10);
                round = (long)(this.min / this.desiredPrec);
                startx = (double)(round + 1L) * this.desiredPrec;
                pos = this.inverted != false ? length * (1.0 - (startx - this.min) / sz) : length * ((startx - this.min) / sz);
                JLAxis.calendar.setTimeInMillis((long)startx);
                date = JLAxis.calendar.getTime();
                s = this.useFormat.format(date);
                bounds = this.labelFont.getStringBounds(s, frc);
                w = (int)bounds.getWidth();
                h = (int)bounds.getHeight();
                this.labels.add(new LabelInfo(s, w, h, pos));
                minStep = (double)w * 1.3;
                if (minStep < this.minTickStep) {
                    minStep = this.minTickStep;
                }
                minPrec = minStep / length * sz;
                prec = this.desiredPrec;
                while (prec < minPrec) {
                    prec += this.desiredPrec;
                }
                this.tickStep = length * prec / sz;
                startx += prec;
                if (this.inverted) {
                    this.tickStep = -this.tickStep;
                }
                this.subTickStep = 0;
                while (startx <= this.max + precDelta) {
                    pos = this.inverted != false ? (double)((int)Math.rint(length * (1.0 - (startx - this.min) / sz))) : (double)((int)Math.rint(length * ((startx - this.min) / sz)));
                    JLAxis.calendar.setTimeInMillis((long)startx);
                    date = JLAxis.calendar.getTime();
                    s = this.useFormat.format(date);
                    bounds = this.labelFont.getStringBounds(s, frc);
                    if (pos > 0.0 && pos < (double)lgth) {
                        w = (int)bounds.getWidth();
                        h = (int)bounds.getHeight();
                        this.labels.add(new LabelInfo(s, w, h, pos));
                    }
                    startx += prec;
                }
                break;
            }
            case 2: {
                fontAscent = this.labelFont.getLineMetrics("0", frc).getAscent();
                prec = this.computeLowTen(this.max - this.min);
                extractLabel = false;
                if (!this.isHorizontal()) {
                    nbMaxLab = (int)(length / (2.0 * fontAscent));
                } else {
                    if (this.scale == 1) {
                        minT = Math.pow(10.0, this.min);
                        maxT = Math.pow(10.0, this.max);
                    } else {
                        minT = this.min;
                        maxT = this.max;
                    }
                    s = this.formatValue(minT, prec);
                    bounds = this.labelFont.getStringBounds(s, frc);
                    mW = bounds.getWidth();
                    s = this.formatValue(maxT, prec);
                    bounds = this.labelFont.getStringBounds(s, frc);
                    if (bounds.getWidth() > mW) {
                        mW = bounds.getWidth();
                    }
                    nbMaxLab = (int)(length / (mW *= 1.5));
                }
                step = 0;
                subStep = 0;
                userMaxLab = (int)Math.rint(length / this.minTickStep);
                if (userMaxLab < nbMaxLab) {
                    nbMaxLab = userMaxLab;
                }
                if (nbMaxLab < 1) {
                    nbMaxLab = 1;
                }
                if (this.scale != 1) ** GOTO lbl92
                prec = 1.0;
                step = -1;
                startx = Math.rint(this.min);
                n = (int)Math.rint((this.max - this.min) / prec);
                while (n > nbMaxLab) {
                    step = 2;
                    n = (int)Math.rint((this.max - this.min) / (prec *= 2.0));
                    if (n <= nbMaxLab) continue;
                    step = 10;
                    n = (int)Math.rint((this.max - this.min) / (prec *= 5.0));
                }
                subStep = step;
                ** GOTO lbl141
lbl92:
                // 1 sources

                step = 10;
                n = (int)Math.rint((this.max - this.min) / prec);
                if (n > nbMaxLab) ** GOTO lbl109
                n = (int)Math.rint((this.max - this.min) / (prec / 2.0));
                while (n <= nbMaxLab) {
                    step = 5;
                    n = (int)Math.rint((this.max - this.min) / ((prec /= 2.0) / 5.0));
                    if (n > nbMaxLab) continue;
                    step = 10;
                    n = (int)Math.rint((this.max - this.min) / ((prec /= 5.0) / 2.0));
                }
                ** GOTO lbl110
lbl-1000:
                // 1 sources

                {
                    step = 5;
                    n = (int)Math.rint((this.max - this.min) / (prec *= 5.0));
                    if (n <= nbMaxLab) continue;
                    step = 10;
                    n = (int)Math.rint((this.max - this.min) / (prec *= 2.0));
lbl109:
                    // 3 sources

                    ** while (n > nbMaxLab)
                }
lbl110:
                // 2 sources

                round = (long)Math.floor(this.min / prec);
                sx = startx = (double)round * prec;
                nbL = 0;
                while (sx <= this.max + precDelta) {
                    if (sx >= this.min - precDelta) {
                        ++nbL;
                    }
                    sx += prec;
                }
                if (nbL <= 2) {
                    if (step == 10) {
                        step = 5;
                        prec /= 2.0;
                    } else {
                        step = 10;
                        prec /= 5.0;
                    }
                    extractLabel = true;
                }
                tickSpacing = Math.abs(prec / sz * length / (double)step);
                subStep = step;
                while (tickSpacing < 10.0 && subStep > 1) {
                    switch (subStep) {
                        case 10: {
                            subStep = 5;
                            tickSpacing *= 2.0;
                            break;
                        }
                        case 5: {
                            subStep = 2;
                            tickSpacing *= 2.5;
                            break;
                        }
                        case 2: {
                            subStep = 1;
                        }
                    }
                }
lbl141:
                // 2 sources

                this.tickStep = length * prec / sz;
                if (this.inverted) {
                    this.tickStep = -this.tickStep;
                }
                this.subTickStep = subStep;
                offX = 0;
                offY = 0;
                switch (this.dOrientation) {
                    case 6: {
                        offX = this.tickLength < 0 ? this.tickLength : 0;
                        break;
                    }
                    case 5: {
                        offX = this.tickLength < 0 ? -this.tickLength : 0;
                        break;
                    }
                    default: {
                        offY = this.tickLength < 0 ? -this.tickLength : 0;
                    }
                }
                lastLabelText = "";
                lastDiff = 1.7976931348623157E308;
                lastLabel = null;
                while (startx <= this.max + precDelta) {
                    pos = this.inverted != false ? (double)((int)Math.rint(length * (1.0 - (startx - this.min) / sz))) : (double)((int)Math.rint(length * ((startx - this.min) / sz)));
                    vt = this.scale == 1 ? Math.pow(10.0, startx) : startx;
                    tempValue = this.formatValue(vt, prec);
                    diff = 0.0;
                    if (this.labelFormat != 2 && this.labelFormat != 7) {
                        diff = Math.abs(Double.parseDouble(tempValue) - vt);
                    }
                    if (lastLabelText.equals(tempValue)) {
                        if (diff < lastDiff) {
                            s = new String(tempValue);
                            if (lastLabel != null) {
                                lastLabel.value = "";
                            }
                        } else {
                            s = "";
                        }
                    } else {
                        s = new String(tempValue);
                    }
                    lastDiff = diff;
                    lastLabelText = new String(tempValue);
                    bounds = this.labelFont.getStringBounds(s, frc);
                    if (startx >= this.min - precDelta) {
                        li = new LabelInfo(s, (int)bounds.getWidth(), (int)fontAscent, pos);
                        li.setOffset(offX, offY);
                        this.labels.add(li);
                        lastLabel = li;
                    }
                    startx += prec;
                }
                if (!extractLabel || this.labels.size() <= 2) break;
                nLabels = new Vector<LabelInfo>();
                lis = this.labels.get(0);
                lie = this.labels.get(this.labels.size() - 1);
                nLabels.add(lis);
                nLabels.add(lie);
                this.tickStep = lie.pos - lis.pos;
                this.subTickStep = this.labels.size() - 1;
                this.labels = nLabels;
            }
        }
    }

    public void drawFast(Graphics g, Point lp, Point p, JLDataView v) {
        if (lp != null && this.boundRect.contains(lp)) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke old = g2.getStroke();
            BasicStroke bs = GraphicsUtils.createStrokeForLine(v.getLineWidth(), v.getStyle());
            if (bs != null) {
                g2.setStroke(bs);
            }
            g.setColor(v.getColor());
            g.drawLine(lp.x, lp.y, p.x, p.y);
            g2.setStroke(old);
        }
        Color oc = g.getColor();
        g.setColor(v.getMarkerColor());
        JLAxis.paintMarker(g, v.getMarker(), v.getMarkerSize(), p.x, p.y);
        g.setColor(oc);
    }

    public static void paintMarker(Graphics g, int mType, int mSize, int x, int y) {
        int mSize2 = mSize / 2;
        int mSize21 = mSize / 2 + 1;
        switch (mType) {
            case 1: {
                g.fillOval(x - mSize2, y - mSize2, mSize, mSize);
                break;
            }
            case 2: {
                g.fillRect(x - mSize2, y - mSize2, mSize, mSize);
                break;
            }
            case 3: {
                triangleShape.translate(x, y);
                g.fillPolygon(triangleShape);
                triangleShape.translate(-x, -y);
                break;
            }
            case 4: {
                diamondShape.translate(x, y);
                g.fillPolygon(diamondShape);
                diamondShape.translate(-x, -y);
                break;
            }
            case 5: {
                g.drawLine(x - mSize2, y + mSize2, x + mSize21, y - mSize21);
                g.drawLine(x + mSize2, y + mSize2, x - mSize21, y - mSize21);
                g.drawLine(x, y - mSize2, x, y + mSize21);
                g.drawLine(x - mSize2, y, x + mSize21, y);
                break;
            }
            case 6: {
                g.drawLine(x, y - mSize2, x, y + mSize21);
                break;
            }
            case 7: {
                g.drawLine(x - mSize2, y, x + mSize21, y);
                break;
            }
            case 8: {
                g.drawLine(x, y - mSize2, x, y + mSize21);
                g.drawLine(x - mSize2, y, x + mSize21, y);
                break;
            }
            case 9: {
                g.drawOval(x - mSize2, y - mSize2, mSize + 1, mSize + 1);
                break;
            }
            case 10: {
                g.drawRect(x - mSize2, y - mSize2, mSize, mSize);
            }
        }
    }

    private void paintBarBorder(Graphics g, int barWidth, int y0, int x, int y) {
        g.drawLine(x - barWidth / 2, y, x + barWidth / 2, y);
        g.drawLine(x + barWidth / 2, y, x + barWidth / 2, y0);
        g.drawLine(x + barWidth / 2, y0, x - barWidth / 2, y0);
        g.drawLine(x - barWidth / 2, y0, x - barWidth / 2, y);
    }

    private void paintBar(Graphics g, Paint pattern, int barWidth, Color background, int fillStyle, int y0, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        if (fillStyle != 0) {
            if (pattern != null) {
                g2.setPaint(pattern);
            } else {
                g2.setColor(background);
            }
            if (y > y0) {
                g.fillRect(x - barWidth / 2, y0, barWidth, y - y0);
            } else {
                g.fillRect(x - barWidth / 2, y, barWidth, y0 - y);
            }
        }
    }

    public static void drawSampleLine(Graphics g, int x, int y, JLDataView v) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke old = g2.getStroke();
        BasicStroke bs = GraphicsUtils.createStrokeForLine(v.getLineWidth(), v.getStyle());
        if (bs != null) {
            g2.setStroke(bs);
        }
        g.drawLine(x, y, x + 40, y);
        g2.setStroke(old);
        Color oc = g.getColor();
        g.setColor(v.getMarkerColor());
        JLAxis.paintMarker(g, v.getMarker(), v.getMarkerSize(), x + 20, y);
        g.setColor(oc);
    }

    void paintDataViews(Graphics g, JLAxis xAxis, int xOrg, int yOrg) {
        int nbView = this.dataViews.size();
        boolean isXY = xAxis.isXY();
        JLDataView vx = null;
        int xClip = xOrg + 1;
        int yClip = yOrg - this.getLength() + 1;
        int wClip = xAxis.getLength() - 1;
        int hClip = this.getLength() - 1;
        if (wClip <= 1 || hClip <= 1) {
            return;
        }
        g.clipRect(xClip, yClip, wClip, hClip);
        if (isXY) {
            vx = xAxis.getViews().get(0);
        }
        int k = 0;
        while (k < nbView) {
            JLDataView v = this.dataViews.get(k);
            if (isXY) {
                this.paintDataViewXY(g, v, vx, xAxis, xOrg, yOrg);
            } else {
                this.paintDataViewNormal(g, v, xAxis, xOrg, yOrg);
            }
            ++k;
        }
    }

    private int computeBarWidth(JLDataView v, JLAxis xAxis) {
        int defaultWidth = 20;
        double minx = xAxis.getMin();
        double maxx = xAxis.getMax();
        int bw = v.getBarWidth();
        double minI = Double.MAX_VALUE;
        if (bw > 0) {
            return bw;
        }
        if (xAxis.getScale() == 1) {
            return defaultWidth;
        }
        if (xAxis.isXY()) {
            JLDataView vx = xAxis.getViews().get(0);
            DataList d = vx.getData();
            if (d != null) {
                double x = d.y;
                d = d.next;
                while (d != null) {
                    double diff = Math.abs(d.y - x);
                    if (diff < minI) {
                        minI = diff;
                    }
                    x = d.y;
                    d = d.next;
                }
            }
        } else {
            DataList d = v.getData();
            if (d != null) {
                double x = d.x;
                d = d.next;
                while (d != null) {
                    double diff = Math.abs(d.x - x);
                    if (diff < minI) {
                        minI = diff;
                    }
                    x = d.x;
                    d = d.next;
                }
            }
        }
        if (minI == Double.MAX_VALUE) {
            return defaultWidth;
        }
        bw = (int)Math.floor(minI / (maxx - minx) * (double)xAxis.getLength()) - 2;
        bw /= 2;
        if ((bw *= 2) < 0) {
            bw = 0;
        }
        return bw;
    }

    private void paintDataViewBar(Graphics2D g2, JLDataView v, int barWidth, BasicStroke bs, Paint fPattern, int y0, int x, int y) {
        if (v.getViewType() == 1) {
            this.paintBar(g2, fPattern, barWidth, v.getFillColor(), v.getFillStyle(), y0, x, y);
            if (v.getLineWidth() > 0) {
                Stroke old = g2.getStroke();
                if (bs != null) {
                    g2.setStroke(bs);
                }
                g2.setColor(v.getColor());
                this.paintBarBorder(g2, barWidth, y0, x, y);
                g2.setStroke(old);
            }
        }
    }

    private void paintDataViewPolyline(Graphics2D g2, JLDataView v, BasicStroke bs, Paint fPattern, int nb, int yOrg, int[] pointX, int[] pointY) {
        if (nb > 1 && v.getViewType() == 0) {
            if (v.getFillStyle() != 0) {
                int[] Xs = new int[nb + 2];
                int[] Ys = new int[nb + 2];
                int i = 0;
                while (i < nb) {
                    Xs[i + 1] = pointX[i];
                    Ys[i + 1] = pointY[i];
                    ++i;
                }
                Xs[0] = Xs[1];
                Ys[0] = yOrg;
                Xs[nb + 1] = Xs[nb];
                Ys[nb + 1] = yOrg;
                if (fPattern != null) {
                    g2.setPaint(fPattern);
                }
                g2.fillPolygon(Xs, Ys, nb + 2);
            }
            if (v.getLineWidth() > 0) {
                Stroke old = g2.getStroke();
                if (bs != null) {
                    g2.setStroke(bs);
                }
                g2.setColor(v.getColor());
                g2.drawPolyline(pointX, pointY, nb);
                g2.setStroke(old);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void paintDataViewNormal(Graphics g, JLDataView v, JLAxis xAxis, int xOrg, int yOrg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void paintDataViewXY(Graphics g, JLDataView v, JLDataView w, JLAxis xAxis, int xOrg, int yOrg) {
        XYData l = new XYData(v.getData(), w.getData());
        if (l.isValid()) {
            int y0;
            int nbPoint = v.getDataLength() + w.getDataLength();
            int[] pointX = new int[nbPoint];
            int[] pointY = new int[nbPoint];
            double A0y = v.getA0();
            double A1y = v.getA1();
            double A2y = v.getA2();
            double A0x = w.getA0();
            double A1x = w.getA1();
            double A2x = w.getA2();
            double minx = xAxis.getMin();
            double maxx = xAxis.getMax();
            double lx = xAxis.getLength();
            int sx = xAxis.getScale();
            double miny = this.min;
            double maxy = this.max;
            double ly = this.getLength();
            int j = 0;
            boolean valid = true;
            switch (v.getFillMethod()) {
                case 0: {
                    y0 = yOrg - (int)ly;
                    break;
                }
                case 1: {
                    if (this.scale == 1) {
                        y0 = yOrg;
                        break;
                    }
                    y0 = (int)(miny / (maxy - miny) * ly) + yOrg;
                    break;
                }
                default: {
                    y0 = yOrg;
                }
            }
            Graphics2D g2 = (Graphics2D)g;
            BasicStroke bs = GraphicsUtils.createStrokeForLine(v.getLineWidth(), v.getStyle());
            Paint fPattern = GraphicsUtils.createPatternForFilling(v.getFillStyle(), v.getFillColor(), v.getColor());
            int barWidth = this.computeBarWidth(v, xAxis);
            while (l.isValid()) {
                l.initFirstPoint();
                while (valid && l.isValid()) {
                    double vty = A0y + A1y * l.d1.y + A2y * l.d1.y * l.d1.y;
                    double vtx = A0x + A1x * l.d2.y + A2x * l.d2.y * l.d2.y;
                    boolean bl = valid = !Double.isNaN(vtx) && !Double.isNaN(vty) && (sx != 1 || vtx > 1.0E-100) && (this.scale != 1 || vty > 1.0E-100);
                    if (!valid) continue;
                    double xratio = sx == 1 ? (Math.log(vtx) / this.ln10 - minx) / (maxx - minx) * lx : (vtx - minx) / (maxx - minx) * lx;
                    double yratio = this.scale == 1 ? -(Math.log(vty) / this.ln10 - miny) / (maxy - miny) * ly : -(vty - miny) / (maxy - miny) * ly;
                    if (xratio < -32000.0) {
                        xratio = -32000.0;
                    }
                    if (xratio > 32000.0) {
                        xratio = 32000.0;
                    }
                    if (yratio < -32000.0) {
                        yratio = -32000.0;
                    }
                    if (yratio > 32000.0) {
                        yratio = 32000.0;
                    }
                    if (j < nbPoint) {
                        pointX[j] = (int)xratio + xOrg;
                        pointY[j] = (int)yratio + yOrg;
                        if (v.getMarker() > 0) {
                            g.setColor(v.getMarkerColor());
                            JLAxis.paintMarker(g, v.getMarker(), v.getMarkerSize(), pointX[j], pointY[j]);
                        }
                        this.paintDataViewBar(g2, v, barWidth, bs, fPattern, y0, pointX[j], pointY[j]);
                        ++j;
                    }
                    l.toNextXYPoint();
                }
                this.paintDataViewPolyline(g2, v, bs, fPattern, j, y0, pointX, pointY);
                j = 0;
                if (valid) continue;
                l.toNextXYPoint();
                valid = true;
            }
        }
    }

    private void paintYOutTicks(Graphics g, int x0, double ys, int y0, int la, BasicStroke bs, int tr, int off, boolean grid) {
        block8: {
            Stroke old;
            Graphics2D g2;
            block9: {
                g2 = (Graphics2D)g;
                old = g2.getStroke();
                if (!this.subtickVisible) break block8;
                if (this.subTickStep != -1) break block9;
                int j = 0;
                while (j < logStep.length) {
                    int h = (int)Math.rint(ys + this.tickStep * logStep[j]);
                    if (h >= y0 && h <= y0 + this.csize.height) {
                        g.drawLine(x0 + tr + off, h, x0 + tr + off + this.subtickLength, h);
                        if (this.gridVisible && this.subGridVisible && grid) {
                            if (bs != null) {
                                g2.setStroke(bs);
                            }
                            g.drawLine(x0, h, x0 + la, h);
                            g2.setStroke(old);
                        }
                    }
                    ++j;
                }
                break block8;
            }
            if (this.subTickStep <= 0) break block8;
            double r = 1.0 / (double)this.subTickStep;
            int j = 0;
            while (j < this.subTickStep) {
                int h = (int)Math.rint(ys + this.tickStep * r * (double)j);
                if (h >= y0 && h <= y0 + this.csize.height) {
                    g.drawLine(x0 + tr + off, h, x0 + tr + off + this.subtickLength, h);
                    if (j > 0 && this.gridVisible && this.subGridVisible && grid) {
                        if (bs != null) {
                            g2.setStroke(bs);
                        }
                        g.drawLine(x0, h, x0 + la, h);
                        g2.setStroke(old);
                    }
                }
                ++j;
            }
        }
    }

    private void paintXOutTicks(Graphics g, int y0, double xs, int x0, int la, BasicStroke bs, int tr, int off, boolean grid) {
        block8: {
            Stroke old;
            Graphics2D g2;
            block9: {
                g2 = (Graphics2D)g;
                old = g2.getStroke();
                if (!this.subtickVisible) break block8;
                if (this.subTickStep != -1) break block9;
                int j = 0;
                while (j < logStep.length) {
                    int w = (int)Math.rint(xs + this.tickStep * logStep[j]);
                    if (w >= x0 && w <= x0 + this.csize.width) {
                        g.drawLine(w, y0 + tr + off, w, y0 + tr + off + this.subtickLength);
                        if (this.gridVisible && this.subGridVisible && grid) {
                            if (bs != null) {
                                g2.setStroke(bs);
                            }
                            g.drawLine(w, y0, w, y0 + la);
                            g2.setStroke(old);
                        }
                    }
                    ++j;
                }
                break block8;
            }
            if (this.subTickStep <= 0) break block8;
            double r = 1.0 / (double)this.subTickStep;
            int j = 0;
            while (j < this.subTickStep) {
                int w = (int)Math.rint(xs + this.tickStep * r * (double)j);
                if (w >= x0 && w <= x0 + this.csize.width) {
                    g.drawLine(w, y0 + tr + off, w, y0 + tr + off + this.subtickLength);
                    if (j > 0 && this.gridVisible && this.subGridVisible && grid) {
                        if (bs != null) {
                            g2.setStroke(bs);
                        }
                        g.drawLine(w, y0, w, y0 + la);
                        g2.setStroke(old);
                    }
                }
                ++j;
            }
        }
    }

    private int getTickShift(int width) {
        int off = 0;
        switch (this.dOrientation) {
            case 6: {
                if (this.orientation != 7) break;
                off = -width / 2;
                break;
            }
            case 5: {
                if (this.orientation == 7) {
                    off = -width / 2;
                    break;
                }
                off = -width;
                break;
            }
            case 1: 
            case 2: {
                off = this.orientation == 3 || this.orientation == 4 ? -width / 2 : (this.orientation == 2 ? 0 : -width);
            }
        }
        return off;
    }

    private int getTickShiftOpposite(int width) {
        int off = 0;
        switch (this.dOrientation) {
            case 5: {
                if (this.orientation != 7) break;
                off = -width / 2;
                break;
            }
            case 6: {
                if (this.orientation == 7) {
                    off = -width / 2;
                    break;
                }
                off = -width;
                break;
            }
            case 1: 
            case 2: {
                off = this.orientation == 3 || this.orientation == 4 ? -width / 2 : (this.orientation == 2 ? -width : 0);
            }
        }
        return off;
    }

    private void paintYTicks(Graphics g, int i, int x0, double y, int la, BasicStroke bs, int tr, int off, boolean grid) {
        block6: {
            Stroke old;
            Graphics2D g2;
            block7: {
                g2 = (Graphics2D)g;
                old = g2.getStroke();
                if (!this.subtickVisible || i >= this.labels.size() - 1) break block6;
                if (this.subTickStep != -1) break block7;
                int j = 0;
                while (j < logStep.length) {
                    int h = (int)Math.rint(y + this.tickStep * logStep[j]);
                    g.drawLine(x0 + tr + off, h, x0 + tr + off + this.subtickLength, h);
                    if (this.gridVisible && this.subGridVisible && grid) {
                        if (bs != null) {
                            g2.setStroke(bs);
                        }
                        g.drawLine(x0, h, x0 + la, h);
                        g2.setStroke(old);
                    }
                    ++j;
                }
                break block6;
            }
            if (this.subTickStep <= 0) break block6;
            double r = 1.0 / (double)this.subTickStep;
            int j = 0;
            while (j < this.subTickStep) {
                int h = (int)Math.rint(y + this.tickStep * r * (double)j);
                g.drawLine(x0 + tr + off, h, x0 + tr + off + this.subtickLength, h);
                if (j > 0 && this.gridVisible && this.subGridVisible && grid) {
                    if (bs != null) {
                        g2.setStroke(bs);
                    }
                    g.drawLine(x0, h, x0 + la, h);
                    g2.setStroke(old);
                }
                ++j;
            }
        }
    }

    private void paintXTicks(Graphics g, int i, int y0, double x, int la, BasicStroke bs, int tr, int off, boolean grid) {
        block6: {
            Stroke old;
            Graphics2D g2;
            block7: {
                g2 = (Graphics2D)g;
                old = g2.getStroke();
                if (!this.subtickVisible || i >= this.labels.size() - 1) break block6;
                if (this.subTickStep != -1) break block7;
                int j = 0;
                while (j < logStep.length) {
                    int w = (int)Math.rint(x + this.tickStep * logStep[j]);
                    g.drawLine(w, y0 + tr + off, w, y0 + tr + off + this.subtickLength);
                    if (this.gridVisible && this.subGridVisible && grid) {
                        if (bs != null) {
                            g2.setStroke(bs);
                        }
                        g.drawLine(w, y0, w, y0 + la);
                        g2.setStroke(old);
                    }
                    ++j;
                }
                break block6;
            }
            if (this.subTickStep <= 0) break block6;
            double r = 1.0 / (double)this.subTickStep;
            int j = 0;
            while (j < this.subTickStep) {
                int w = (int)Math.rint(x + this.tickStep * r * (double)j);
                g.drawLine(w, y0 + tr + off, w, y0 + tr + off + this.subtickLength);
                if (j > 0 && this.gridVisible && this.subGridVisible && grid) {
                    if (bs != null) {
                        g2.setStroke(bs);
                    }
                    g.drawLine(w, y0, w, y0 + la);
                    g2.setStroke(old);
                }
                ++j;
            }
        }
    }

    public Color computeMediumColor(Color c1, Color c2) {
        return new Color((c1.getRed() + 3 * c2.getRed()) / 4, (c1.getGreen() + 3 * c2.getGreen()) / 4, (c1.getBlue() + 3 * c2.getBlue()) / 4);
    }

    void paintAxis(Graphics g, FontRenderContext frc, int x0, int y0, JLAxis xAxis, int xOrg, int yOrg, Color back, boolean oppositeVisible) {
        int la = 0;
        int tr = 0;
        Point p0 = null;
        if (!this.isHorizontal() && this.dataViews.size() == 0) {
            return;
        }
        if (this.getLength() <= 1) {
            this.boundRect.setRect(0.0, 0.0, 0.0, 0.0);
            return;
        }
        la = xAxis.getLength();
        if (la <= 0) {
            this.boundRect.setRect(0.0, 0.0, 0.0, 0.0);
            return;
        }
        switch (this.dOrientation) {
            case 6: {
                this.boundRect.setRect(x0 + this.getThickness(), y0, la, this.csize.height);
                if (this.orientation != 7) break;
                p0 = this.transform(0.0, 1.0, xAxis);
                if (p0.x >= x0 + this.csize.width && p0.x <= x0 + this.csize.width + la) {
                    tr = p0.x - (x0 + this.csize.width);
                    break;
                }
                return;
            }
            case 5: {
                this.boundRect.setRect(x0 - la - 1, y0, la, this.csize.height);
                if (this.orientation != 7) break;
                p0 = this.transform(0.0, 1.0, xAxis);
                if (p0.x >= x0 - la - 1 && p0.x <= x0) {
                    tr = p0.x - x0;
                    break;
                }
                return;
            }
            case 1: 
            case 2: {
                this.boundRect.setRect(x0, y0 - la, this.csize.width, la);
                if (this.orientation != 3 && this.orientation != 4) break;
                p0 = xAxis.transform(1.0, 0.0, this);
                if (p0.y >= y0 - la && p0.y <= y0) {
                    tr = p0.y - y0;
                    break;
                }
                return;
            }
            default: {
                System.out.println("JLChart warning: Wrong axis position");
            }
        }
        if (!this.visible) {
            return;
        }
        this.paintAxisDirect(g, frc, x0, y0, back, tr, xAxis.getLength());
        if (this.drawOpposite && oppositeVisible) {
            if (this.orientation == 7 || this.orientation == 3 || this.orientation == 4) {
                this.paintAxisOppositeDouble(g, frc, x0, y0, back, tr, xAxis.getLength());
            } else {
                this.paintAxisOpposite(g, frc, x0, y0, back, tr, xAxis.getLength());
            }
        }
    }

    public void paintAxisDirect(Graphics g, FontRenderContext frc, int x0, int y0, Color back, int tr, int la) {
        BasicStroke bs = null;
        Graphics2D g2 = (Graphics2D)g;
        Color subgridColor = this.computeMediumColor(this.labelColor, back);
        if (this.gridVisible) {
            bs = GraphicsUtils.createStrokeForLine(1, this.gridStyle);
        }
        g.setFont(this.labelFont);
        int tickOff = this.getTickShift(this.tickLength);
        int subTickOff = this.getTickShift(this.subtickLength);
        switch (this.dOrientation) {
            case 6: {
                if (this.labels.size() > 0 && this.autoLabeling) {
                    LabelInfo lis = this.labels.get(0);
                    LabelInfo lie = this.labels.get(this.labels.size() - 1);
                    g.setColor(subgridColor);
                    this.paintYOutTicks(g, x0 + this.csize.width, (double)y0 + lis.pos - this.tickStep, y0, la, bs, tr, subTickOff, true);
                    this.paintYOutTicks(g, x0 + this.csize.width, (double)y0 + lie.pos, y0, la, bs, tr, subTickOff, true);
                }
                int i = 0;
                while (i < this.labels.size()) {
                    g.setColor(this.labelColor);
                    LabelInfo li = this.labels.get(i);
                    int x = x0 + (this.csize.width - 4) - li.size.width;
                    int y = (int)Math.rint(li.pos) + y0;
                    g.drawString(li.value, x + tr + li.offset.x, y + li.offset.y + li.size.height / 3);
                    if (this.gridVisible) {
                        Stroke old = g2.getStroke();
                        if (bs != null) {
                            g2.setStroke(bs);
                        }
                        g.drawLine(x0 + (this.csize.width + 1), y, x0 + (this.csize.width + 1) + la, y);
                        g2.setStroke(old);
                    }
                    if (this.autoLabeling) {
                        g.setColor(subgridColor);
                        this.paintYTicks(g, i, x0 + this.csize.width, li.pos + (double)y0, la, bs, tr, subTickOff, true);
                    }
                    g.setColor(this.labelColor);
                    g.drawLine(x0 + tr + this.csize.width + tickOff, y, x0 + tr + this.csize.width + tickOff + this.tickLength, y);
                    ++i;
                }
                g.setColor(this.labelColor);
                g.drawLine(x0 + tr + this.csize.width, y0, x0 + tr + this.csize.width, y0 + this.csize.height);
                if (this.name == null) break;
                g2.rotate(-1.5707963267948966);
                Rectangle2D bounds = this.labelFont.getStringBounds(this.name, frc);
                int fontAscent = (int)(this.labelFont.getLineMetrics("0", frc).getAscent() + 0.5f);
                g.drawString(this.name, -y0 - (this.csize.height + (int)bounds.getWidth()) / 2, x0 + fontAscent - 2);
                g2.rotate(1.5707963267948966);
                break;
            }
            case 5: {
                if (this.labels.size() > 0 && this.autoLabeling) {
                    LabelInfo lis = this.labels.get(0);
                    LabelInfo lie = this.labels.get(this.labels.size() - 1);
                    g.setColor(subgridColor);
                    this.paintYOutTicks(g, x0, (double)y0 + lis.pos - this.tickStep, y0, -la, bs, tr, subTickOff, true);
                    this.paintYOutTicks(g, x0, (double)y0 + lie.pos, y0, -la, bs, tr, subTickOff, true);
                }
                int i = 0;
                while (i < this.labels.size()) {
                    g.setColor(this.labelColor);
                    LabelInfo li = this.labels.get(i);
                    int y = (int)Math.rint(li.pos) + y0;
                    g.drawString(li.value, x0 + tr + li.offset.x + 6, y + li.offset.y + li.size.height / 3);
                    if (this.gridVisible) {
                        Stroke old = g2.getStroke();
                        if (bs != null) {
                            g2.setStroke(bs);
                        }
                        g.drawLine(x0, y, x0 - la, y);
                        g2.setStroke(old);
                    }
                    if (this.autoLabeling) {
                        g.setColor(subgridColor);
                        this.paintYTicks(g, i, x0, li.pos + (double)y0, -la, bs, tr, subTickOff, true);
                    }
                    g.setColor(this.labelColor);
                    g.drawLine(x0 + tr + tickOff, y, x0 + tr + tickOff + this.tickLength, y);
                    ++i;
                }
                g.setColor(this.labelColor);
                g.drawLine(x0 + tr, y0, x0 + tr, y0 + this.csize.height);
                if (this.name == null) break;
                g2.rotate(-1.5707963267948966);
                Rectangle2D bounds = this.labelFont.getStringBounds(this.name, frc);
                g.drawString(this.name, -y0 - (this.csize.height + (int)bounds.getWidth()) / 2, x0 + tr + this.csize.width - 2);
                g2.rotate(1.5707963267948966);
                break;
            }
            case 1: 
            case 2: {
                int labelShift;
                if (this.orientation == 2) {
                    tr = -la;
                    labelShift = 1;
                } else {
                    labelShift = this.orientation == 3 || this.orientation == 4 ? 1 : 2;
                }
                if (this.labels.size() > 0 && this.autoLabeling) {
                    LabelInfo lis = this.labels.get(0);
                    LabelInfo lie = this.labels.get(this.labels.size() - 1);
                    g.setColor(subgridColor);
                    this.paintXOutTicks(g, y0, (double)x0 + lis.pos - this.tickStep, x0, -la, bs, tr, subTickOff, true);
                    this.paintXOutTicks(g, y0, (double)x0 + lie.pos, x0, -la, bs, tr, subTickOff, true);
                }
                int i = 0;
                while (i < this.labels.size()) {
                    g.setColor(this.labelColor);
                    LabelInfo li = this.labels.get(i);
                    int x = (int)Math.rint(li.pos) + x0;
                    int y = y0;
                    if (this.orientation == 2) {
                        g.drawString(li.value, x + li.offset.x - li.size.width / 2, y + tr - 2);
                    } else {
                        g.drawString(li.value, x + li.offset.x - li.size.width / 2, y + tr + li.offset.y + li.size.height + 2);
                    }
                    if (this.autoLabeling) {
                        g.setColor(subgridColor);
                        this.paintXTicks(g, i, y, li.pos + (double)x0, -la, bs, tr, subTickOff, true);
                    }
                    g.setColor(this.labelColor);
                    if (this.gridVisible) {
                        Stroke old = g2.getStroke();
                        if (bs != null) {
                            g2.setStroke(bs);
                        }
                        g.drawLine(x, y0, x, y0 - la);
                        g2.setStroke(old);
                    }
                    g.setColor(this.labelColor);
                    g.drawLine(x, y0 + tr + tickOff, x, y0 + tr + tickOff + this.tickLength);
                    ++i;
                }
                g.setColor(this.labelColor);
                g.drawLine(x0, y0 + tr, x0 + this.csize.width, y0 + tr);
                if (this.name == null) break;
                Rectangle2D bounds = this.labelFont.getStringBounds(this.name, frc);
                g.drawString(this.name, x0 + (this.csize.width - (int)bounds.getWidth()) / 2, y0 + labelShift * (int)bounds.getHeight());
            }
        }
    }

    public void paintAxisOpposite(Graphics g, FontRenderContext frc, int x0, int y0, Color back, int tr, int la) {
        BasicStroke bs = null;
        Color subgridColor = this.computeMediumColor(this.labelColor, back);
        int tickOff = this.getTickShiftOpposite(this.tickLength);
        int subTickOff = this.getTickShiftOpposite(this.subtickLength);
        switch (this.dOrientation) {
            case 5: {
                int nX0 = x0 - la - this.csize.width;
                if (this.labels.size() > 0 && this.autoLabeling) {
                    LabelInfo lis = this.labels.get(0);
                    LabelInfo lie = this.labels.get(this.labels.size() - 1);
                    g.setColor(subgridColor);
                    this.paintYOutTicks(g, nX0 + this.csize.width, (double)y0 + lis.pos - this.tickStep, y0, la, bs, tr, subTickOff, false);
                    this.paintYOutTicks(g, nX0 + this.csize.width, (double)y0 + lie.pos, y0, la, bs, tr, subTickOff, false);
                }
                int i = 0;
                while (i < this.labels.size()) {
                    LabelInfo li = this.labels.get(i);
                    int x = nX0 + (this.csize.width - 4) - li.size.width;
                    int y = (int)Math.rint(li.pos) + y0;
                    if (this.autoLabeling) {
                        g.setColor(subgridColor);
                        this.paintYTicks(g, i, nX0 + this.csize.width, li.pos + (double)y0, la, bs, tr, subTickOff, false);
                    }
                    g.setColor(this.labelColor);
                    g.drawLine(nX0 + tr + this.csize.width + tickOff, y, nX0 + tr + this.csize.width + tickOff + this.tickLength, y);
                    ++i;
                }
                g.setColor(this.labelColor);
                g.drawLine(nX0 + tr + this.csize.width, y0, nX0 + tr + this.csize.width, y0 + this.csize.height);
                break;
            }
            case 6: {
                int x = x0 + la + this.csize.width;
                if (this.labels.size() > 0 && this.autoLabeling) {
                    LabelInfo lis = this.labels.get(0);
                    LabelInfo lie = this.labels.get(this.labels.size() - 1);
                    g.setColor(subgridColor);
                    this.paintYOutTicks(g, x, (double)y0 + lis.pos - this.tickStep, y0, -la, bs, tr, subTickOff, false);
                    this.paintYOutTicks(g, x, (double)y0 + lie.pos, y0, -la, bs, tr, subTickOff, false);
                }
                int i = 0;
                while (i < this.labels.size()) {
                    LabelInfo li = this.labels.get(i);
                    int y = (int)Math.rint(li.pos) + y0;
                    if (this.autoLabeling) {
                        g.setColor(subgridColor);
                        this.paintYTicks(g, i, x, li.pos + (double)y0, -la, bs, tr, subTickOff, false);
                    }
                    g.setColor(this.labelColor);
                    g.drawLine(x + tr + tickOff, y, x + tr + tickOff + this.tickLength, y);
                    ++i;
                }
                g.setColor(this.labelColor);
                g.drawLine(x + tr, y0, x + tr, y0 + this.csize.height);
                break;
            }
            case 1: 
            case 2: {
                if (this.orientation == 1) {
                    tr = -la;
                }
                if (this.labels.size() > 0 && this.autoLabeling) {
                    LabelInfo lis = this.labels.get(0);
                    LabelInfo lie = this.labels.get(this.labels.size() - 1);
                    g.setColor(subgridColor);
                    this.paintXOutTicks(g, y0, (double)x0 + lis.pos - this.tickStep, x0, -la, bs, tr, subTickOff, false);
                    this.paintXOutTicks(g, y0, (double)x0 + lie.pos, x0, -la, bs, tr, subTickOff, false);
                }
                int i = 0;
                while (i < this.labels.size()) {
                    LabelInfo li = this.labels.get(i);
                    int x = (int)Math.rint(li.pos) + x0;
                    int y = y0;
                    if (this.autoLabeling) {
                        g.setColor(subgridColor);
                        this.paintXTicks(g, i, y, li.pos + (double)x0, -la, bs, tr, subTickOff, false);
                    }
                    g.setColor(this.labelColor);
                    g.drawLine(x, y0 + tr + tickOff, x, y0 + tr + tickOff + this.tickLength);
                    ++i;
                }
                g.setColor(this.labelColor);
                g.drawLine(x0, y0 + tr, x0 + this.csize.width, y0 + tr);
            }
        }
    }

    public void paintAxisOppositeDouble(Graphics g, FontRenderContext frc, int x0, int y0, Color back, int tr, int la) {
        switch (this.dOrientation) {
            case 5: {
                int nX0 = x0 - la;
                g.setColor(this.labelColor);
                g.drawLine(nX0, y0, nX0, y0 + this.csize.height);
                g.drawLine(nX0 + la, y0, nX0 + la, y0 + this.csize.height);
                break;
            }
            case 6: {
                int nX0 = x0 + this.csize.width;
                g.setColor(this.labelColor);
                g.drawLine(nX0, y0, nX0, y0 + this.csize.height);
                g.drawLine(nX0 + la, y0, nX0 + la, y0 + this.csize.height);
                break;
            }
            case 1: 
            case 2: {
                g.setColor(this.labelColor);
                g.drawLine(x0, y0 - la, x0 + this.csize.width, y0 - la);
                g.drawLine(x0, y0, x0 + this.csize.width, y0);
            }
        }
    }

    public void applyConfiguration(String prefix, CfFileReader f) {
        Vector p = f.getParam(String.valueOf(prefix) + "visible");
        if (p != null) {
            this.setVisible(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam(String.valueOf(prefix) + "grid")) != null) {
            this.setGridVisible(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam(String.valueOf(prefix) + "subgrid")) != null) {
            this.setSubGridVisible(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam(String.valueOf(prefix) + "grid_style")) != null) {
            this.setGridStyle(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam(String.valueOf(prefix) + "min")) != null) {
            this.setMinimum(OFormat.getDouble(p.get(0).toString()));
        }
        if ((p = f.getParam(String.valueOf(prefix) + "max")) != null) {
            this.setMaximum(OFormat.getDouble(p.get(0).toString()));
        }
        if ((p = f.getParam(String.valueOf(prefix) + "autoscale")) != null) {
            this.setAutoScale(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam(String.valueOf(prefix) + "scale")) != null) {
            this.setScale(OFormat.getInt(p.get(0).toString()));
        } else {
            p = f.getParam(String.valueOf(prefix) + "cale");
            if (p != null) {
                this.setScale(OFormat.getInt(p.get(0).toString()));
            }
        }
        p = f.getParam(String.valueOf(prefix) + "format");
        if (p != null) {
            this.setLabelFormat(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam(String.valueOf(prefix) + "title")) != null) {
            this.setName(OFormat.getName(p.get(0).toString()));
        }
        if ((p = f.getParam(String.valueOf(prefix) + "color")) != null) {
            this.setAxisColor(OFormat.getColor(p));
        }
        if ((p = f.getParam(String.valueOf(prefix) + "label_font")) != null) {
            this.setFont(OFormat.getFont(p));
        }
        if ((p = f.getParam(String.valueOf(prefix) + "fit_display_duration")) != null) {
            this.setFitXAxisToDisplayDuration(OFormat.getBoolean(p.get(0).toString()));
        }
    }

    public String getConfiguration(String prefix) {
        String to_write = "";
        to_write = String.valueOf(to_write) + prefix + "visible:" + this.isVisible() + "\n";
        to_write = String.valueOf(to_write) + prefix + "grid:" + this.isGridVisible() + "\n";
        to_write = String.valueOf(to_write) + prefix + "subgrid:" + this.isSubGridVisible() + "\n";
        to_write = String.valueOf(to_write) + prefix + "grid_style:" + this.getGridStyle() + "\n";
        to_write = String.valueOf(to_write) + prefix + "min:" + this.getMinimum() + "\n";
        to_write = String.valueOf(to_write) + prefix + "max:" + this.getMaximum() + "\n";
        to_write = String.valueOf(to_write) + prefix + "autoscale:" + this.isAutoScale() + "\n";
        to_write = String.valueOf(to_write) + prefix + "scale:" + this.getScale() + "\n";
        to_write = String.valueOf(to_write) + prefix + "format:" + this.getLabelFormat() + "\n";
        to_write = String.valueOf(to_write) + prefix + "title:'" + this.getName() + "'\n";
        to_write = String.valueOf(to_write) + prefix + "color:" + OFormat.color(this.getAxisColor()) + "\n";
        to_write = String.valueOf(to_write) + prefix + "label_font:" + OFormat.font(this.getFont()) + "\n";
        to_write = String.valueOf(to_write) + prefix + "fit_display_duration:" + this.isFitXAxisToDisplayDuration() + "\n";
        return to_write;
    }

    public boolean isZeroAlwaysVisible() {
        return this.zeroAlwaysVisible;
    }

    public void setZeroAlwaysVisible(boolean zeroAlwaysVisible) {
        this.zeroAlwaysVisible = zeroAlwaysVisible;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }
}

