/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcClientCallMessage;
import org.acplt.oncrpc.OncRpcClientReplyMessage;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcTcpSocketHelper;
import org.acplt.oncrpc.OncRpcTimeoutException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrTcpDecodingStream;
import org.acplt.oncrpc.XdrTcpEncodingStream;

public class OncRpcTcpClient
extends OncRpcClient {
    private Socket socket;
    private OncRpcTcpSocketHelper socketHelper;
    protected XdrTcpEncodingStream sendingXdr;
    protected XdrTcpDecodingStream receivingXdr;
    protected int transmissionTimeout = 30000;

    public OncRpcTcpClient(InetAddress inetAddress, int n, int n2) throws OncRpcException, IOException {
        this(inetAddress, n, n2, 0, 0);
    }

    public OncRpcTcpClient(InetAddress inetAddress, int n, int n2, int n3) throws OncRpcException, IOException {
        this(inetAddress, n, n2, n3, 0);
    }

    public OncRpcTcpClient(InetAddress inetAddress, int n, int n2, int n3, int n4) throws OncRpcException, IOException {
        this(inetAddress, n, n2, n3, n4, -1);
    }

    public OncRpcTcpClient(InetAddress inetAddress, int n, int n2, int n3, int n4, int n5) throws OncRpcException, IOException {
        super(inetAddress, n, n2, n3, 6);
        if (n4 == 0) {
            n4 = 8192;
        }
        if (n4 < 1024) {
            n4 = 1024;
        }
        this.socketHelper = new OncRpcTcpSocketHelper();
        this.socket = this.socketHelper.connect(inetAddress, this.port, n5);
        this.socket.setTcpNoDelay(true);
        if (this.socketHelper.getSendBufferSize() < n4) {
            this.socketHelper.setSendBufferSize(n4);
        }
        if (this.socketHelper.getReceiveBufferSize() < n4) {
            this.socketHelper.setReceiveBufferSize(n4);
        }
        this.sendingXdr = new XdrTcpEncodingStream(this.socket, n4);
        this.receivingXdr = new XdrTcpDecodingStream(this.socket, n4);
    }

    public void close() throws OncRpcException {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        if (this.sendingXdr != null) {
            try {
                this.sendingXdr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sendingXdr = null;
        }
        if (this.receivingXdr != null) {
            try {
                this.receivingXdr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.receivingXdr = null;
        }
    }

    public synchronized void call(int n, int n2, XdrAble xdrAble, XdrAble xdrAble2) throws OncRpcException {
        for (int i = 1; i >= 0; --i) {
            this.nextXid();
            OncRpcClientCallMessage oncRpcClientCallMessage = new OncRpcClientCallMessage(this.xid, this.program, n2, n, this.auth);
            OncRpcClientReplyMessage oncRpcClientReplyMessage = new OncRpcClientReplyMessage(this.auth);
            try {
                this.socket.setSoTimeout(this.transmissionTimeout);
                this.sendingXdr.beginEncoding(null, 0);
                oncRpcClientCallMessage.xdrEncode(this.sendingXdr);
                xdrAble.xdrEncode(this.sendingXdr);
                if (this.timeout != 0) {
                    this.sendingXdr.endEncoding();
                } else {
                    this.sendingXdr.endEncoding(false);
                }
            }
            catch (IOException iOException) {
                throw new OncRpcException(3, iOException.getLocalizedMessage());
            }
            if (this.timeout == 0) {
                return;
            }
            try {
                while (true) {
                    this.socket.setSoTimeout(this.timeout);
                    this.receivingXdr.beginDecoding();
                    this.socket.setSoTimeout(this.transmissionTimeout);
                    oncRpcClientReplyMessage.xdrDecode(this.receivingXdr);
                    if (oncRpcClientReplyMessage.messageId == oncRpcClientCallMessage.messageId) break;
                    this.receivingXdr.endDecoding();
                }
                if (!oncRpcClientReplyMessage.successfullyAccepted()) {
                    this.receivingXdr.endDecoding();
                    if (i > 0 && oncRpcClientReplyMessage.replyStatus == 1 && oncRpcClientReplyMessage.rejectStatus == 1 && this.auth != null && this.auth.canRefreshCred()) continue;
                    throw oncRpcClientReplyMessage.newException();
                }
                xdrAble2.xdrDecode(this.receivingXdr);
                this.receivingXdr.endDecoding();
                return;
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new OncRpcTimeoutException();
            }
            catch (IOException iOException) {
                throw new OncRpcException(4, iOException.getLocalizedMessage());
            }
        }
    }

    public synchronized void batchCall(int n, XdrAble xdrAble, boolean bl) throws OncRpcException {
        this.nextXid();
        OncRpcClientCallMessage oncRpcClientCallMessage = new OncRpcClientCallMessage(this.xid, this.program, this.version, n, this.auth);
        try {
            this.socket.setSoTimeout(this.transmissionTimeout);
            this.sendingXdr.beginEncoding(null, 0);
            oncRpcClientCallMessage.xdrEncode(this.sendingXdr);
            xdrAble.xdrEncode(this.sendingXdr);
            this.sendingXdr.endEncoding(bl);
        }
        catch (IOException iOException) {
            throw new OncRpcException(3, iOException.getLocalizedMessage());
        }
    }

    public void setTimeout(int n) {
        super.setTimeout(n);
    }

    public void setTransmissionTimeout(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("transmission timeout must be > 0");
        }
        this.transmissionTimeout = n;
    }

    public int getTransmissionTimeout() {
        return this.transmissionTimeout;
    }

    public void setCharacterEncoding(String string) {
        this.receivingXdr.setCharacterEncoding(string);
        this.sendingXdr.setCharacterEncoding(string);
    }

    public String getCharacterEncoding() {
        return this.receivingXdr.getCharacterEncoding();
    }
}

