/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcDumpResult;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcGetPortResult;
import org.acplt.oncrpc.OncRpcProgramNotRegisteredException;
import org.acplt.oncrpc.OncRpcServerIdent;
import org.acplt.oncrpc.OncRpcTcpClient;
import org.acplt.oncrpc.OncRpcUdpClient;
import org.acplt.oncrpc.XdrBoolean;
import org.acplt.oncrpc.XdrVoid;

public class OncRpcPortmapClient {
    public static final int PMAP_PORT = 111;
    public static final int PMAP_PROGRAM = 100000;
    public static final int PMAP_VERSION = 2;
    protected OncRpcClient portmapClient;

    public OncRpcPortmapClient(InetAddress inetAddress) throws OncRpcException, IOException {
        this(inetAddress, 17, 0);
    }

    public OncRpcPortmapClient(InetAddress inetAddress, int n) throws OncRpcException, IOException {
        this(inetAddress, n, -1);
    }

    public OncRpcPortmapClient(InetAddress inetAddress, int n, int n2) throws OncRpcException, IOException {
        switch (n) {
            case 17: {
                this.portmapClient = new OncRpcUdpClient(inetAddress, 100000, 2, 111);
                break;
            }
            case 6: {
                this.portmapClient = new OncRpcTcpClient(inetAddress, 100000, 2, 111, 0, n2);
                break;
            }
            default: {
                throw new OncRpcException(17);
            }
        }
    }

    public void close() throws OncRpcException {
        this.portmapClient.close();
    }

    public OncRpcClient getOncRpcClient() {
        return this.portmapClient;
    }

    public int getPort(int n, int n2, int n3) throws OncRpcException {
        OncRpcServerIdent oncRpcServerIdent = new OncRpcServerIdent(n, n2, n3, 0);
        OncRpcGetPortResult oncRpcGetPortResult = new OncRpcGetPortResult();
        try {
            this.portmapClient.call(3, oncRpcServerIdent, oncRpcGetPortResult);
        }
        catch (OncRpcException oncRpcException) {
            throw new OncRpcException(14);
        }
        if (oncRpcGetPortResult.port == 0) {
            throw new OncRpcProgramNotRegisteredException();
        }
        return oncRpcGetPortResult.port;
    }

    public boolean setPort(int n, int n2, int n3, int n4) throws OncRpcException {
        OncRpcServerIdent oncRpcServerIdent = new OncRpcServerIdent(n, n2, n3, n4);
        XdrBoolean xdrBoolean = new XdrBoolean(false);
        try {
            this.portmapClient.call(1, oncRpcServerIdent, xdrBoolean);
        }
        catch (OncRpcException oncRpcException) {
            throw new OncRpcException(14);
        }
        return xdrBoolean.booleanValue();
    }

    public boolean unsetPort(int n, int n2) throws OncRpcException {
        OncRpcServerIdent oncRpcServerIdent = new OncRpcServerIdent(n, n2, 0, 0);
        XdrBoolean xdrBoolean = new XdrBoolean(false);
        try {
            this.portmapClient.call(2, oncRpcServerIdent, xdrBoolean);
        }
        catch (OncRpcException oncRpcException) {
            throw new OncRpcException(14);
        }
        return xdrBoolean.booleanValue();
    }

    public OncRpcServerIdent[] listServers() throws OncRpcException {
        OncRpcDumpResult oncRpcDumpResult = new OncRpcDumpResult();
        try {
            this.portmapClient.call(4, XdrVoid.XDR_VOID, oncRpcDumpResult);
        }
        catch (OncRpcException oncRpcException) {
            throw new OncRpcException(14);
        }
        Object[] objectArray = new OncRpcServerIdent[oncRpcDumpResult.servers.size()];
        oncRpcDumpResult.servers.copyInto(objectArray);
        return objectArray;
    }

    public void ping() throws OncRpcException {
        try {
            this.portmapClient.call(0, XdrVoid.XDR_VOID, XdrVoid.XDR_VOID);
        }
        catch (OncRpcException oncRpcException) {
            throw new OncRpcException(14);
        }
    }
}

