/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TacoApi;

import fr.esrf.TacoApi.TacoConst;
import fr.esrf.TacoApi.TacoException;
import fr.esrf.TacoApi.xdr.XdrDoubleReadPoint;
import fr.esrf.TacoApi.xdr.XdrFloatReadPoint;
import fr.esrf.TacoApi.xdr.XdrLongReadPoint;
import fr.esrf.TacoApi.xdr.XdrStateFloatReadPoint;
import fr.esrf.TacoApi.xdr.XdrTacoType;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrDouble;
import org.acplt.oncrpc.XdrDoubles;
import org.acplt.oncrpc.XdrFloat;
import org.acplt.oncrpc.XdrFloats;
import org.acplt.oncrpc.XdrInt;
import org.acplt.oncrpc.XdrLongs;
import org.acplt.oncrpc.XdrShort;
import org.acplt.oncrpc.XdrShorts;
import org.acplt.oncrpc.XdrString;
import org.acplt.oncrpc.XdrStrings;
import org.acplt.oncrpc.XdrVoid;

public class TacoData
implements TacoConst {
    private int type;
    private XdrAble value = null;

    public TacoData() {
        this.type = 0;
        this.value = new XdrVoid();
    }

    public TacoData(int n) {
        this.type = n;
    }

    public void insert(short s) {
        this.type = 2;
        this.value = new XdrShort(s);
    }

    public void insert(short[] sArray) {
        this.type = 10;
        this.value = new XdrShorts(sArray);
    }

    public void insertUShort(int n) {
        this.type = 70;
        this.value = new XdrShort((short)n);
    }

    public void insertUShortArray(int[] nArray) {
        this.type = 72;
        short[] sArray = new short[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            sArray[i] = (short)nArray[i];
        }
        this.value = new XdrShorts(sArray);
    }

    public void insert(int n) {
        this.type = 3;
        this.value = new XdrInt(n);
    }

    public void insert(int[] nArray) {
        this.type = 11;
        this.value = new XdrLongs(nArray);
    }

    public void insertULong(long l) {
        this.type = 71;
        this.value = new XdrInt((int)l);
    }

    public void insertULongArray(long[] lArray) {
        this.type = 69;
        int[] nArray = new int[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            nArray[i] = (int)lArray[i];
        }
        this.value = new XdrLongs(nArray);
    }

    public void insert(float f) {
        this.type = 4;
        this.value = new XdrFloat(f);
    }

    public void insert(float[] fArray) {
        this.type = 12;
        this.value = new XdrFloats(fArray);
    }

    public void insert(double d) {
        this.type = 5;
        this.value = new XdrDouble(d);
    }

    public void insert(double[] dArray) {
        this.type = 68;
        this.value = new XdrDoubles(dArray);
    }

    public void insert(String string) {
        this.type = 6;
        this.value = new XdrString(string);
    }

    public void insert(String[] stringArray) {
        this.type = 24;
        this.value = new XdrStrings(stringArray);
    }

    public void insert(short s, float f, float f2) {
        this.type = 8;
        XdrStateFloatReadPoint xdrStateFloatReadPoint = new XdrStateFloatReadPoint();
        xdrStateFloatReadPoint.state = s;
        xdrStateFloatReadPoint.read = f;
        xdrStateFloatReadPoint.set = f2;
        this.value = xdrStateFloatReadPoint;
    }

    public short extractShort() throws TacoException {
        this.checkType(2);
        return ((XdrShort)this.value).shortValue();
    }

    public short[] extractShortArray() throws TacoException {
        this.checkType(10);
        return ((XdrShorts)this.value).shortsValue();
    }

    public int extractUShort() throws TacoException {
        this.checkType(70);
        short s = ((XdrShort)this.value).shortValue();
        return s & 0xFFFF;
    }

    public int[] extractUShortArray() throws TacoException {
        this.checkType(72);
        short[] sArray = ((XdrShorts)this.value).shortsValue();
        int[] nArray = new int[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            short s = sArray[i];
            nArray[i] = s & 0xFFFF;
        }
        return nArray;
    }

    public int extractLong() throws TacoException {
        this.checkType(3);
        return ((XdrInt)this.value).intValue();
    }

    public int[] extractLongArray() throws TacoException {
        this.checkType(11);
        return ((XdrLongs)this.value).longsValue();
    }

    public long extractULong() throws TacoException {
        this.checkType(71);
        long l = ((XdrInt)this.value).intValue();
        return l & 0xFFFFFFFFFFFFFFFFL;
    }

    public long[] extractULongArray() throws TacoException {
        this.checkType(69);
        int[] nArray = ((XdrLongs)this.value).longsValue();
        long[] lArray = new long[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            long l = nArray[i];
            lArray[i] = l & 0xFFFFFFFFFFFFFFFFL;
        }
        return lArray;
    }

    public float extractFloat() throws TacoException {
        this.checkType(4);
        return ((XdrFloat)this.value).floatValue();
    }

    public float[] extractFloatArray() throws TacoException {
        this.checkType(12);
        return ((XdrFloats)this.value).floatsValue();
    }

    public double extractDouble() throws TacoException {
        this.checkType(5);
        return ((XdrDouble)this.value).doubleValue();
    }

    public double[] extractDoubleArray() throws TacoException {
        this.checkType(68);
        return ((XdrDoubles)this.value).doublesValue();
    }

    public String extractString() throws TacoException {
        this.checkType(6);
        return ((XdrString)this.value).stringValue();
    }

    public String[] extractStringArray() throws TacoException {
        this.checkType(24);
        return ((XdrStrings)this.value).stringsValue();
    }

    public short extractStateofSFR() throws TacoException {
        return ((XdrStateFloatReadPoint)this.value).state;
    }

    public float[] extractStateFloatReadPoint() throws TacoException {
        this.checkType(8);
        return new float[]{((XdrStateFloatReadPoint)this.value).set, ((XdrStateFloatReadPoint)this.value).read};
    }

    public int[] extractLongReadPoint() throws TacoException {
        this.checkType(22);
        return new int[]{((XdrLongReadPoint)this.value).set, ((XdrLongReadPoint)this.value).read};
    }

    public float[] extractFloatReadPoint() throws TacoException {
        this.checkType(7);
        return new float[]{((XdrFloatReadPoint)this.value).set, ((XdrFloatReadPoint)this.value).read};
    }

    public double[] extractDoubleReadPoint() throws TacoException {
        this.checkType(23);
        return new double[]{((XdrDoubleReadPoint)this.value).set, ((XdrDoubleReadPoint)this.value).read};
    }

    public int getType() {
        return this.type;
    }

    public XdrAble getXdrValue() {
        return this.value;
    }

    public void setXdrValue(XdrAble xdrAble) {
        this.value = xdrAble;
    }

    private void checkType(int n) throws TacoException {
        if (this.value == null) {
            throw new TacoException("Trying to extract an empty argument");
        }
        if (this.type != n) {
            throw new TacoException("Trying to extract " + XdrTacoType.getTypeName(n) + " but argument is " + XdrTacoType.getTypeName(this.type));
        }
    }
}

