/*
 * Decompiled with CFR 0.152.
 */
package fable.fabric.view;

import fable.fabric.internal.FabricException;
import fable.fabric.view.Integrate;
import fable.fabric.view.Plothst;
import fable.framework.toolbox.FileText;
import fable.framework.toolbox.FloatText;
import fable.framework.toolbox.IntegerText;
import fable.framework.toolbox.LookAndFeel;
import fable.framework.toolbox.SWTUtils;
import fable.framework.toolbox.StringText;
import fable.framework.views.FableMessageConsole;
import fable.imageviewer.model.ImageModel;
import fable.imageviewer.views.ImageView;
import fable.imageviewer.views.ImageViewImage;
import java.io.File;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class PlothstView
extends ViewPart {
    private static final String ID = "fable.fabric.view.plothst";
    private static Shell shell;
    private FileText dirPathLabelText;
    private StringText fileStemLabelText;
    private IntegerText grainNumText;
    private IntegerText reflNumText;
    private DropTargetListener dropTargetPathListener = new DropTargetListener(){

        public void dragEnter(DropTargetEvent event) {
            if (event.detail == 16) {
                event.detail = (event.operations & 1) != 0 ? 1 : 0;
            }
        }

        public void dragLeave(DropTargetEvent event) {
        }

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
            event.feedback = 9;
        }

        public void drop(DropTargetEvent event) {
            if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                File file;
                DropTarget target = (DropTarget)event.widget;
                Text txt = (Text)target.getControl();
                String[] data = (String[])event.data;
                if (data.length > 0 && (file = new File(data[0])) != null && file.exists()) {
                    String path = file.getParent();
                    txt.setText(path);
                }
            }
        }

        public void dropAccept(DropTargetEvent event) {
        }
    };
    private DropTargetListener dropTargetStemListener = new DropTargetListener(){

        public void dragEnter(DropTargetEvent event) {
            if (event.detail == 16) {
                event.detail = (event.operations & 1) != 0 ? 1 : 0;
            }
        }

        public void dragLeave(DropTargetEvent event) {
        }

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
            event.feedback = 9;
        }

        public void drop(DropTargetEvent event) {
            if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                File file;
                DropTarget target = (DropTarget)event.widget;
                Text txt = (Text)target.getControl();
                String[] data = (String[])event.data;
                if (data.length > 0 && (file = new File(data[0])) != null && file.exists()) {
                    String draggedText = PlothstView.this.getFileStem(file.getName());
                    txt.setText(draggedText);
                }
            }
        }

        public void dropAccept(DropTargetEvent event) {
        }
    };
    private Plothst plot;
    private String information = "";
    Text infoText;
    private Integrate integrate;
    private FloatText lp_lim;

    public void createPartControl(Composite parent) {
        shell = parent.getShell();
        parent.setLayout((Layout)new GridLayout());
        parent.setLayout((Layout)new GridLayout(2, true));
        parent.setLayoutData((Object)new GridData(4, 16, true, false));
        Group fnControls = LookAndFeel.getGroup((Composite)parent, (String)"Input-file directory path and filename stem", (int)5, (int)1);
        fnControls.setLayoutData((Object)new GridData(4, 4, true, false));
        fnControls.setBackgroundMode(2);
        Label dirPathLabel = new Label((Composite)fnControls, 16384);
        dirPathLabel.setText("Path");
        this.dirPathLabelText = new FileText((Composite)fnControls, 0);
        this.dirPathLabelText.set_errorMessage("Directory not found");
        GridData dirPathGridData = new GridData(4, 16, true, false, 3, 1);
        this.dirPathLabelText.setLayoutData((Object)dirPathGridData);
        this.dirPathLabelText.setToolTipText("Enter the input-file directory path,\nor browse for it, or drag and drop from the navigator.");
        DropTarget target = new DropTarget((Control)this.dirPathLabelText.getTextField(), 17);
        target.setTransfer((Transfer[])new FileTransfer[]{FileTransfer.getInstance()});
        target.addDropListener(this.dropTargetPathListener);
        this.dirPathLabelText.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PlothstView.this.plot != null) {
                    PlothstView.this.plot.setDirec(PlothstView.this.dirPathLabelText.getText());
                }
            }
        });
        Button dirPathBrowseButton = new Button((Composite)fnControls, 8);
        dirPathBrowseButton.setText("Browse");
        dirPathBrowseButton.setToolTipText("Enter the input-file directory path,\nor browse for it, or drag and drop from the navigator.");
        dirPathBrowseButton.setLayoutData((Object)new GridData(16, 16, false, true));
        dirPathBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog directoryDialog = new DirectoryDialog(shell, 4096);
                directoryDialog.setText("Select an existing directory or enter a new directory name");
                String dir = directoryDialog.open();
                if (dir != null) {
                    PlothstView.this.dirPathLabelText.set_Text(dir);
                }
            }
        });
        Label fnStemLabel = new Label((Composite)fnControls, 16384);
        fnStemLabel.setText("Stem");
        this.fileStemLabelText = new StringText((Composite)fnControls, 0);
        GridData fileStemGridData = new GridData(4, 16, true, false, 3, 1);
        this.fileStemLabelText.setLayoutData((Object)fileStemGridData);
        this.fileStemLabelText.setToolTipText("Enter the filename stem,\nor browse for a sample file\nwith standardized name, or drag and drop from the navigator.");
        target = new DropTarget((Control)this.fileStemLabelText.getTextField(), 17);
        target.setTransfer((Transfer[])new FileTransfer[]{FileTransfer.getInstance()});
        target.addDropListener(this.dropTargetStemListener);
        this.fileStemLabelText.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PlothstView.this.plot != null) {
                    PlothstView.this.plot.setStem(PlothstView.this.fileStemLabelText.getText());
                }
            }
        });
        Button fileStemBrowseButton = new Button((Composite)fnControls, 8);
        fileStemBrowseButton.setText("Browse");
        fileStemBrowseButton.setToolTipText("Enter the filename stem,\nor browse for a sample file\nwith standardized name, or drag and drop from the navigator.");
        fileStemBrowseButton.setLayoutData((Object)new GridData(16, 16, false, true));
        fileStemBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(shell, 4096);
                fileDialog.setText("Select an existing file or enter a new filename");
                String file = fileDialog.open();
                PlothstView.this.fileStemLabelText.set_Text(PlothstView.this.getFileStem(file));
            }
        });
        Group seqControls = LookAndFeel.getGroup((Composite)parent, (String)"Sequence numbers", (int)4, (int)1);
        seqControls.setLayoutData((Object)new GridData(16, 16, false, false));
        GridLayout seqCtrlGrLy = (GridLayout)seqControls.getLayout();
        seqCtrlGrLy.makeColumnsEqualWidth = true;
        seqControls.setLayout((Layout)seqCtrlGrLy);
        seqControls.setBackgroundMode(2);
        Label grainNumLabel = new Label((Composite)seqControls, 16384);
        grainNumLabel.setText("Grain");
        this.grainNumText = new IntegerText((Composite)seqControls, 131072);
        GridData grainNumGridData = new GridData(4, 16, false, false);
        this.grainNumText.setLayoutData((Object)grainNumGridData);
        this.grainNumText.set_Text("0");
        this.grainNumText.setMinValue(0, true);
        this.grainNumText.getTextField().setTextLimit(4);
        this.grainNumText.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    PlothstView.this.information = PlothstView.this.runPlothst();
                    PlothstView.this.infoText.setText(PlothstView.this.information);
                }
            }
        });
        Button grainNumPrevButton = new Button((Composite)seqControls, 8);
        grainNumPrevButton.setText("< Previous");
        grainNumPrevButton.setToolTipText("Go to the previous grain");
        grainNumPrevButton.setLayoutData((Object)new GridData(4, 16, false, false));
        grainNumPrevButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int i = Integer.parseInt(PlothstView.this.grainNumText.getText());
                PlothstView.this.grainNumText.set_Text("" + --i);
                PlothstView.this.information = PlothstView.this.runPlothst();
                PlothstView.this.infoText.setText(PlothstView.this.information);
            }
        });
        Button grainNumNextButton = new Button((Composite)seqControls, 8);
        grainNumNextButton.setText("Next >");
        grainNumNextButton.setToolTipText("Go to the next grain");
        grainNumNextButton.setLayoutData((Object)new GridData(4, 16, false, false));
        grainNumNextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int i = Integer.parseInt(PlothstView.this.grainNumText.getText());
                PlothstView.this.grainNumText.set_Text("" + ++i);
                PlothstView.this.information = PlothstView.this.runPlothst();
                PlothstView.this.infoText.setText(PlothstView.this.information);
            }
        });
        Label reflNumLabel = new Label((Composite)seqControls, 16384);
        reflNumLabel.setText("Reflection");
        this.reflNumText = new IntegerText((Composite)seqControls, 0);
        GridData reflNumGridData = new GridData(4, 16, false, false);
        this.reflNumText.setLayoutData((Object)reflNumGridData);
        this.reflNumText.set_Text("0");
        this.reflNumText.setMinValue(0, true);
        this.reflNumText.getTextField().setTextLimit(4);
        this.reflNumText.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    PlothstView.this.information = PlothstView.this.runPlothst();
                    PlothstView.this.infoText.setText(PlothstView.this.information);
                }
            }
        });
        Button reflNumPrevButton = new Button((Composite)seqControls, 8);
        reflNumPrevButton.setText("< Previous");
        reflNumPrevButton.setToolTipText("Go to the previous reflection");
        reflNumPrevButton.setLayoutData((Object)new GridData(4, 16, false, false));
        reflNumPrevButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int i = Integer.parseInt(PlothstView.this.reflNumText.getText());
                PlothstView.this.reflNumText.set_Text("" + --i);
                PlothstView.this.information = PlothstView.this.runPlothst();
                PlothstView.this.infoText.setText(PlothstView.this.information);
            }
        });
        Button reflNumNextButton = new Button((Composite)seqControls, 8);
        reflNumNextButton.setText("  Next >  ");
        reflNumNextButton.setToolTipText("Go to the next reflection");
        reflNumNextButton.setLayoutData((Object)new GridData(4, 16, false, false));
        reflNumNextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int i = Integer.parseInt(PlothstView.this.reflNumText.getText());
                PlothstView.this.reflNumText.set_Text("" + ++i);
                PlothstView.this.information = PlothstView.this.runPlothst();
                PlothstView.this.infoText.setText(PlothstView.this.information);
            }
        });
        Group groupIntegration = new Group(parent, 0);
        groupIntegration.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        groupIntegration.setLayoutData((Object)gd);
        groupIntegration.setText("Integration: LP factor");
        Label label = new Label((Composite)groupIntegration, 16384);
        label.setText("LP limit");
        this.lp_lim = new FloatText((Composite)groupIntegration, 0);
        this.lp_lim.setToolTipText("Filter out reflections with a higher LP factor");
        Group group = LookAndFeel.getGroup((Composite)parent, (String)"Information and statistics", (int)1, (int)2);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)group.getLayoutData()).horizontalSpan = 2;
        this.infoText = new Text((Composite)group, 2818);
        GridData gdOther = new GridData(1808);
        this.infoText.setLayoutData((Object)gdOther);
        this.infoText.setToolTipText("Plothst information");
        this.infoText.setEditable(false);
        this.infoText.setBackground(Display.getDefault().getSystemColor(22));
        this.infoText.setText(this.information);
        this.setContentDescription("Set options for plothst or integrate actions here. LP factor is used for integration action only.");
    }

    public void setFocus() {
    }

    public static String getId() {
        return ID;
    }

    public String runPlothst() {
        String info = "";
        this.checkRequirement();
        if (!this.fileStemLabelText.is_isRequiredField() && !this.dirPathLabelText.is_isRequiredField()) {
            if (this.plot == null) {
                try {
                    this.plot = new Plothst(this.dirPathLabelText.getText(), this.fileStemLabelText.getText());
                }
                catch (FabricException e) {
                    SWTUtils.errMsg((String)("Plothst can not be created. An error occured during creation : " + e.getMessage()));
                }
            } else {
                this.plot.setDirec(this.dirPathLabelText.getText());
                this.plot.setStem(this.fileStemLabelText.getText());
                if (this.reflNumText.is_bValide()) {
                    this.plot.setReflno(Integer.valueOf(this.reflNumText.getText()));
                }
                if (this.grainNumText.is_bValide()) {
                    this.plot.setReflno(Integer.valueOf(this.grainNumText.getText()));
                }
            }
            if (this.plot != null) {
                try {
                    this.plot.readData(0, Integer.valueOf(this.grainNumText.getText()), Integer.valueOf(this.reflNumText.getText()));
                    info = this.plot.getInfoStr();
                    int sbw = this.plot.getShoeboxAllWidth();
                    int sby = this.plot.getSbox_y();
                    float[] data = new float[sbw * sby];
                    int k = 0;
                    int i = 0;
                    while (i < sby) {
                        int j = 0;
                        while (j < sbw) {
                            data[k] = this.plot.getShb()[i][j];
                            ++k;
                            ++j;
                        }
                        ++i;
                    }
                    this.displayImageViewer(sbw, sby, data);
                    if (info != null) {
                        this.infoText.setText(info);
                    }
                }
                catch (FabricException e) {
                    SWTUtils.errMsg((String)e.getMessage());
                }
            }
        } else {
            if (this.fileStemLabelText.is_isRequiredField()) {
                FableMessageConsole.console.displayError(this.fileStemLabelText.getErrorMessage());
            }
            if (this.dirPathLabelText.is_isRequiredField()) {
                FableMessageConsole.console.displayError(this.dirPathLabelText.getErrorMessage());
            }
        }
        return info;
    }

    private void checkRequirement() {
        this.fileStemLabelText.set_isRequiredField(this.fileStemLabelText.getText().length() == 0);
        this.dirPathLabelText.set_isRequiredField(this.dirPathLabelText.getText().length() == 0);
        this.dirPathLabelText.showDecoration();
        this.fileStemLabelText.showDecoration();
    }

    private void displayImageViewer(int sbw, int sby, float[] data) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", "300", 1);
        }
        catch (PartInitException e) {
            SWTUtils.errMsg((String)e.getMessage());
        }
        IViewReference viewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ImageView", "300");
        if (viewReference != null) {
            ImageView myView = (ImageView)viewReference.getView(true);
            String fileNameSb = "";
            String fileNameSbFull = "";
            String grainNumFn = "";
            if (this.plot != null) {
                grainNumFn = "0000" + this.plot.getGrainno();
                while (grainNumFn.length() > 4) {
                    grainNumFn = grainNumFn.substring(1);
                }
                fileNameSb = String.valueOf(this.plot.getStem()) + "_gr" + grainNumFn + "_set0000.hst";
                fileNameSbFull = String.valueOf(this.plot.getDirec()) + "/" + fileNameSb;
            }
            ImageModel imageModel = new ImageModel(fileNameSb, sbw, sby, data);
            myView.setPartName(fileNameSb);
            myView.setImageModel(imageModel);
            ImageViewImage image = myView.getImage();
            image.setImageChanged(true);
            if (image.getImageRect().width != imageModel.getWidth() || image.getImageRect().height != imageModel.getHeight()) {
                image.clearCanvas();
            }
            image.setImageRect(new Rectangle(image.getImageRect().x, image.getImageRect().y, imageModel.getWidth(), imageModel.getHeight()));
            image.calculateMainRectangles();
            myView.resetCoordinates();
            myView.updateStatusLabel("Loading file: " + fileNameSbFull);
            myView.setStatistics(imageModel.getStatistics(image.getImageRect()));
            myView.setKeepAspect(true);
            myView.getImage().displayImage();
        }
    }

    private String getFileStem(String file) {
        String fileName;
        String[] fileNameChunks;
        String value = "";
        if (file != null && (fileNameChunks = (fileName = new File(file).getName()).split("_gr[0-9]{4}_set[0-9]{4}")) != null && fileNameChunks.length > 0) {
            value = fileNameChunks[0];
        }
        return value;
    }

    public void integrate() {
        this.checkRequirement();
        if (!this.fileStemLabelText.is_isRequiredField() && !this.dirPathLabelText.is_isRequiredField()) {
            if (this.integrate == null) {
                this.integrate = new Integrate();
            }
            if (this.integrate != null) {
                this.integrate.run(this.dirPathLabelText.getText(), this.fileStemLabelText.getText(), Integer.valueOf(this.grainNumText.getText()), Integer.valueOf(this.reflNumText.getText()), Float.valueOf(this.lp_lim.getText()));
            }
        } else {
            if (this.fileStemLabelText.is_isRequiredField()) {
                FableMessageConsole.console.displayError(this.fileStemLabelText.getErrorMessage());
            }
            if (this.dirPathLabelText.is_isRequiredField()) {
                FableMessageConsole.console.displayError(this.dirPathLabelText.getErrorMessage());
            }
        }
    }
}

