/*
 * Decompiled with CFR 0.152.
 */
package fable.fabric.view;

import fable.fabric.internal.FabricException;
import fable.python.jep.FableJep;
import jep.JepException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class Plothst {
    private String direc;
    private String stem;
    private int setno;
    private int grainno = 0;
    private int reflno = 0;
    private String[] paramName = new String[]{"grain_id", "ref_id", "spot_id", "h", "k", "l", "tth", "omega", "eta", "dety", "detz", "detyd", "detzd", "gv1", "gv2", "gv3", "L", "P", "frame_start", "frame_end", "border", "overlaps"};
    private float[] param = new float[22];
    private int sbox_omega;
    private int sbox_y;
    private int sbox_z;
    private float[][][] shoebox;
    private int padding = 1;
    private int shoeboxAllWidth;
    private float[][] shoeboxAll;
    private float[] minSb;
    private float[] maxSb;
    private float[] meanSb;
    FableJep jep;
    private float min;
    private float max;
    private float mean;
    private float LP;
    private float integ;
    private float median;
    private boolean medianSubtraction = true;
    private String infoStr;

    public Plothst() {
    }

    public Plothst(String direcOpt, String stemOpt) throws FabricException {
        this.setDirec(direcOpt);
        this.setStem(stemOpt);
        try {
            this.jep = new FableJep();
            this.jep.eval("from optparse import OptionParser");
            this.jep.eval("from Fabric import plothstclass");
            this.jep.eval("import numpy as n");
            this.jep.eval("options = OptionParser()");
            this.jep.eval("options.stem=\"" + this.stem + "\"");
            this.jep.eval("options.direc=\"" + this.direc + "\"");
            this.jep.eval("options.reflno=0");
            this.jep.eval("options.grainno=0");
            this.jep.eval("options.setno=0");
            this.jep.eval("plot = plothstclass.plothst(direc=options.direc,stem=options.stem,grainno=options.grainno,reflno=options.reflno)");
        }
        catch (JepException e) {
            throw new FabricException(this.getClass().getName(), "Plothst()", "JepException occurs : " + e.getMessage());
        }
    }

    public void readData(int setnoOpt, int grainnoOpt, int reflnoOpt) throws FabricException {
        this.setGrainno(grainnoOpt);
        this.setReflno(reflnoOpt);
        this.setSetno(setnoOpt);
        try {
            this.jep.eval("plot.reflno=" + this.reflno);
            this.jep.eval("plot.grainno=" + this.grainno);
            this.jep.eval("plot.setno=" + this.setno);
            this.jep.eval("plot.read_data()");
            int i = 0;
            while (i < 22) {
                this.param[i] = Float.parseFloat(this.jep.getValue("plot.ref.refinfo[" + this.reflno + "," + i + "]").toString());
                ++i;
            }
            this.sbox_omega = Integer.parseInt(this.jep.getValue("plot.hst.par['sbox_omega']").toString());
            this.sbox_y = Integer.parseInt(this.jep.getValue("plot.hst.par['sbox_y']").toString());
            this.sbox_z = Integer.parseInt(this.jep.getValue("plot.hst.par['sbox_z']").toString());
            this.shoebox = new float[this.sbox_omega][this.sbox_y][this.sbox_z];
            this.shoeboxAllWidth = this.sbox_omega * this.sbox_z + (this.sbox_omega - 1) * this.padding;
            this.shoeboxAll = new float[this.sbox_y][this.shoeboxAllWidth];
            this.minSb = new float[this.sbox_omega];
            this.maxSb = new float[this.sbox_omega];
            this.meanSb = new float[this.sbox_omega];
            float minTmp = 0.0f;
            this.mean = 0.0f;
            this.max = 0.0f;
            int i2 = 0;
            while (i2 < this.sbox_omega) {
                float meanTmp = 0.0f;
                float maxTmp = 0.0f;
                int j = 0;
                while (j < this.sbox_y) {
                    int k = 0;
                    while (k < this.sbox_z) {
                        if (this.jep.getValue("plot.shoebox[" + i2 + "," + j + "," + k + "]") != null) {
                            float shbxTmp;
                            this.shoebox[i2][j][k] = shbxTmp = Float.parseFloat(this.jep.getValue("plot.shoebox[" + i2 + "," + j + "," + k + "]").toString());
                            meanTmp += shbxTmp;
                            if (shbxTmp > maxTmp) {
                                maxTmp = shbxTmp;
                            }
                            if (k == 0 & j == 0) {
                                minTmp = shbxTmp;
                            } else if (shbxTmp < minTmp) {
                                minTmp = shbxTmp;
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                this.meanSb[i2] = meanTmp / (float)(this.sbox_y * this.sbox_z);
                this.mean += this.meanSb[i2];
                this.maxSb[i2] = maxTmp;
                if (maxTmp > this.max) {
                    this.max = maxTmp;
                }
                this.minSb[i2] = minTmp;
                if (i2 == 0) {
                    this.min = minTmp;
                } else if (this.min > minTmp) {
                    this.min = minTmp;
                }
                ++i2;
            }
            if (this.sbox_omega != 0) {
                this.mean /= (float)this.sbox_omega;
            }
            this.jep.eval("median = n.median(plot.shoebox.ravel())");
            this.jep.eval("elements = n.prod(plot.shoebox.shape)");
            this.jep.eval("int = plot.shoebox.sum() - elements * median");
            this.LP = this.param[16] * this.param[17];
            this.median = Float.parseFloat(this.jep.getValue("median").toString());
            this.integ = Float.parseFloat(this.jep.getValue("int").toString());
            this.integ /= this.LP;
            this.infoStr = "hkl : ";
            i2 = 3;
            while (i2 < 6) {
                this.infoStr = String.valueOf(this.infoStr) + "  " + (int)this.param[i2];
                ++i2;
            }
            i2 = 6;
            while (i2 < 11) {
                this.infoStr = String.valueOf(this.infoStr) + "\n" + this.paramName[i2] + " : " + this.param[i2];
                ++i2;
            }
            this.infoStr = String.valueOf(this.infoStr) + "\nLP : " + this.LP;
            this.infoStr = String.valueOf(this.infoStr) + "\nInt : " + this.integ;
            this.infoStr = String.valueOf(this.infoStr) + "\nMedi : " + this.median;
            this.infoStr = String.valueOf(this.infoStr) + "\n" + this.paramName[2] + " : " + (int)this.param[2];
            this.infoStr = String.valueOf(this.infoStr) + "\n" + this.paramName[21] + " : " + (int)this.param[21];
            this.infoStr = String.valueOf(this.infoStr) + "\nIntensity min : " + this.min;
            this.infoStr = String.valueOf(this.infoStr) + "\nIntensity max : " + this.max;
            this.infoStr = String.valueOf(this.infoStr) + "\nIntensity mean : " + this.mean;
            float contrastSep = this.max;
            if (this.mean > 0.5f * this.max & !this.medianSubtraction) {
                contrastSep = 0.0f;
            }
            if (this.max == 0.0f) {
                contrastSep = 1.0f;
            }
            int i3 = 0;
            while (i3 < this.sbox_omega && this.shoebox != null) {
                int padi = this.padding;
                if (i3 == 0) {
                    padi = 0;
                }
                int l = i3 * (this.sbox_z + padi) - padi;
                int k = 0;
                while (k < this.sbox_z + padi) {
                    int j = 0;
                    while (j < this.sbox_y) {
                        this.shoeboxAll[j][l] = k < padi ? contrastSep : (this.medianSubtraction ? this.shoebox[i3][j][k - padi] - this.median : this.shoebox[i3][j][k - padi]);
                        ++j;
                    }
                    ++l;
                    ++k;
                }
                ++i3;
            }
        }
        catch (JepException e) {
            throw new FabricException(this.getClass().getName(), "readData()", "JepException occurs : " + e.getMessage());
        }
    }

    public void saveWork() throws FabricException {
        try {
            FableJep jep = new FableJep();
            jep.eval("from optparse import OptionParser");
            jep.eval("from Fabric import goplothst");
            jep.eval("options = OptionParser()");
            jep.eval("options.stem=\"" + this.stem + "\"");
            jep.eval("options.direc=\"" + this.direc + "\"");
            jep.eval("options.reflno=" + this.reflno);
            jep.eval("options.grainno=" + this.grainno);
            jep.eval("options.setno=" + this.setno);
            jep.eval("goplothst.run(options)");
            int i = 0;
            while (i < 22) {
                this.param[i] = Float.parseFloat(jep.getValue("ref.refinfo[" + this.reflno + "," + i + "]").toString());
                ++i;
            }
            this.sbox_omega = Integer.parseInt(jep.getValue("hst.par['sbox_omega']").toString());
            this.sbox_y = Integer.parseInt(jep.getValue("hst.par['sbox_y']").toString());
            this.sbox_z = Integer.parseInt(jep.getValue("hst.par['sbox_z']").toString());
            this.shoebox = new float[this.sbox_omega][this.sbox_y][this.sbox_z];
            this.shoeboxAllWidth = this.sbox_omega * this.sbox_z + (this.sbox_omega - 1) * this.padding;
            this.shoeboxAll = new float[this.sbox_y][this.shoeboxAllWidth];
            this.minSb = new float[this.sbox_omega];
            this.maxSb = new float[this.sbox_omega];
            this.meanSb = new float[this.sbox_omega];
            float minTmp = 0.0f;
            this.mean = 0.0f;
            this.max = 0.0f;
            int i2 = 0;
            while (i2 < this.sbox_omega) {
                float meanTmp = 0.0f;
                float maxTmp = 0.0f;
                int j = 0;
                while (j < this.sbox_y) {
                    int k = 0;
                    while (k < this.sbox_z) {
                        float shbxTmp;
                        this.shoebox[i2][j][k] = shbxTmp = Float.parseFloat(jep.getValue("shoebox[" + i2 + "," + j + "," + k + "]").toString());
                        meanTmp += shbxTmp;
                        if (shbxTmp > maxTmp) {
                            maxTmp = shbxTmp;
                        }
                        if (k == 0 & j == 0) {
                            minTmp = shbxTmp;
                        } else if (shbxTmp < minTmp) {
                            minTmp = shbxTmp;
                        }
                        ++k;
                    }
                    ++j;
                }
                this.meanSb[i2] = meanTmp / (float)(this.sbox_y * this.sbox_z);
                this.mean += this.meanSb[i2];
                this.maxSb[i2] = maxTmp;
                if (maxTmp > this.max) {
                    this.max = maxTmp;
                }
                this.minSb[i2] = minTmp;
                if (i2 == 0) {
                    this.min = minTmp;
                } else if (this.min > minTmp) {
                    this.min = minTmp;
                }
                ++i2;
            }
            this.mean /= (float)this.sbox_omega;
            jep.eval("median = n.median(shoebox.ravel())");
            jep.eval("elements = n.prod(shoebox.shape)");
            jep.eval("int = shoebox.sum() - elements * median");
            this.LP = this.param[16] * this.param[17];
            this.median = Float.parseFloat(jep.getValue("median").toString());
            this.integ = Float.parseFloat(jep.getValue("int").toString());
            this.integ /= this.LP;
            this.infoStr = "hkl : ";
            i2 = 3;
            while (i2 < 6) {
                this.infoStr = String.valueOf(this.infoStr) + "  " + (int)this.param[i2];
                ++i2;
            }
            i2 = 6;
            while (i2 < 11) {
                this.infoStr = String.valueOf(this.infoStr) + "\n" + this.paramName[i2] + " : " + this.param[i2];
                ++i2;
            }
            this.infoStr = String.valueOf(this.infoStr) + "\nLP : " + this.LP;
            this.infoStr = String.valueOf(this.infoStr) + "\nInt : " + this.integ;
            this.infoStr = String.valueOf(this.infoStr) + "\nMedi : " + this.median;
            this.infoStr = String.valueOf(this.infoStr) + "\n" + this.paramName[2] + " : " + (int)this.param[2];
            this.infoStr = String.valueOf(this.infoStr) + "\n" + this.paramName[21] + " : " + (int)this.param[21];
            this.infoStr = String.valueOf(this.infoStr) + "\nIntensity min : " + this.min;
            this.infoStr = String.valueOf(this.infoStr) + "\nIntensity max : " + this.max;
            this.infoStr = String.valueOf(this.infoStr) + "\nIntensity mean : " + this.mean;
            float contrastSep = this.max;
            if (this.mean > 0.5f * this.max & !this.medianSubtraction) {
                contrastSep = 0.0f;
            }
            if (this.max == 0.0f) {
                contrastSep = 1.0f;
            }
            int i3 = 0;
            while (i3 < this.sbox_omega) {
                int padi = this.padding;
                if (i3 == 0) {
                    padi = 0;
                }
                int l = i3 * (this.sbox_z + padi) - padi;
                int k = 0;
                while (k < this.sbox_z + padi) {
                    int j = 0;
                    while (j < this.sbox_y) {
                        this.shoeboxAll[j][l] = k < padi ? contrastSep : (this.medianSubtraction ? this.shoebox[i3][j][k - padi] - this.median : this.shoebox[i3][j][k - padi]);
                        ++j;
                    }
                    ++l;
                    ++k;
                }
                ++i3;
            }
            jep.close();
        }
        catch (JepException e) {
            throw new FabricException(this.getClass().getName(), "readData()", "JepException occurs : " + e.getMessage());
        }
    }

    private FableJep doScript() throws JepException {
        FableJep jep = new FableJep();
        jep.eval("from Fabric import file_io");
        jep.eval("import numpy as n");
        jep.eval("direc=\"" + this.direc + "\"");
        jep.eval("stem=\"" + this.stem + "\"");
        jep.eval("grainno=" + this.grainno);
        jep.eval("setno=" + this.setno);
        jep.eval("reflno=" + this.reflno);
        jep.eval("ref = file_io.readref(direc, stem)");
        jep.eval("ref._open(grainno, setno)");
        jep.eval("ref.read(grainno, setno)");
        jep.eval("hst = file_io.readhst(direc, stem)");
        jep.eval("hst._open(grainno, setno)");
        jep.eval("hst.get_file_pos()");
        jep.eval("hst.read(grainno, setno, hst.spotpos[ref.refinfo[reflno, ref.colinfo['spot_id']]])");
        jep.eval("shoebox = n.clip(hst.shoebox, 0, 2 ** 16 - 1)");
        jep.eval("shoebox = shoebox.astype(n.uint16)");
        return jep;
    }

    public String getDirec() {
        return this.direc;
    }

    public void setDirec(String direc) {
        this.direc = direc;
    }

    public String getStem() {
        return this.stem;
    }

    public void setStem(String stem) {
        this.stem = stem;
    }

    public int getSetno() {
        return this.setno;
    }

    public void setSetno(int setno) {
        this.setno = setno;
    }

    public int getGrainno() {
        return this.grainno;
    }

    public void setGrainno(int grainno) {
        this.grainno = grainno;
    }

    public int getReflno() {
        return this.reflno;
    }

    public void setReflno(int reflno) {
        this.reflno = reflno;
    }

    public float[][][] getSb() {
        return this.shoebox;
    }

    public void setSb(float[][][] sb) {
        this.shoebox = sb;
    }

    public float[][] getShb() {
        return this.shoeboxAll;
    }

    public void setShb(float[][] shb) {
        this.shoeboxAll = shb;
    }

    public int getSbox_y() {
        return this.sbox_y;
    }

    public int getShoeboxAllWidth() {
        return this.shoeboxAllWidth;
    }

    public String getInfoStr() {
        return this.infoStr;
    }

    public boolean isMedianSubtraction() {
        return this.medianSubtraction;
    }

    public void setMedianSubtraction(boolean medianSubtraction) {
        this.medianSubtraction = medianSubtraction;
    }

    public void runIntegrate() {
        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"essai", (String)"work in progress");
    }
}

