/*
 * Decompiled with CFR 0.152.
 */
package fable.fabric.internal;

import fable.fabric.internal.FabricException;
import fable.framework.toolbox.FableUtils;
import fable.framework.views.FableMessageConsole;
import fable.python.jep.FableJep;
import fable.python.jep.StdoutRead;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import jep.JepException;

public class Fabric {
    private StdoutRead stdoutThread;
    private String currentDirectory;
    private String currentInputFile = null;
    private HashMap<String, String> optionalItems;
    private String killFile = "";
    private boolean endOfProgram = false;

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private void runFabric(String inputFile) throws FabricException {
        this.endOfProgram = false;
        try {
            File tempFile = File.createTempFile("fabric", ".stdout");
            File tempErrFile = File.createTempFile("fabric", ".stderr");
            this.stdoutThread = new StdoutRead(tempFile.getAbsolutePath());
            StdoutRead stderrThread = new StdoutRead(tempErrFile.getAbsolutePath());
            tempFile.deleteOnExit();
            tempErrFile.deleteOnExit();
            FableJep jep = new FableJep();
            this.chdir(this.getCurrentDirectory(), jep);
            jep.outputConsole(FableMessageConsole.console);
            jep.redirectStdout(tempFile.getAbsolutePath());
            jep.redirectStderr(tempErrFile.getAbsolutePath());
            this.stdoutThread.start();
            this.stdoutThread.setOutputToFableConsole(true);
            stderrThread.start();
            stderrThread.setOutputToFableConsole(true);
            jep.eval("from Fabric import gofabric");
            jep.eval("from optparse import OptionParser");
            jep.eval("import sys");
            jep.eval("sys.stderr = sys.stdout");
            jep.eval("parser = OptionParser()");
            jep.eval("options = gofabric.get_options(parser)");
            jep.eval("options.filename=\"" + inputFile + "\"");
            jep.eval("gofabric.run_fabric(options)");
            jep.eval("sys.stdout.flush()");
            this.endOfProgram = true;
            if (this.stdoutThread != null) {
                this.stdoutThread.stopped = true;
                try {
                    this.stdoutThread.join();
                }
                catch (InterruptedException e) {
                    this.endOfProgram = true;
                    FableUtils.excMsg((Object)this, (String)e.getMessage(), (Throwable)e);
                }
            }
            if (stderrThread != null) {
                this.endOfProgram = true;
                try {
                    stderrThread.join();
                }
                catch (InterruptedException e) {
                    this.endOfProgram = true;
                    FableUtils.excMsg((Object)this, (String)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            this.endOfProgram = true;
            throw new FabricException(this.getClass().getName(), "runFabric()", "IOException on output-message temp-file creation attempt:" + e.getMessage());
        }
        catch (JepException e) {
            this.endOfProgram = true;
            throw new FabricException(this.getClass().getName(), "runFabric()", "JepException occurs : " + e.getMessage());
        }
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(String path) {
        this.currentDirectory = path.replaceAll("\\\\", "/");
    }

    private void chdir(String currentDirectory, FableJep jep) throws JepException {
        jep.eval("import os");
        currentDirectory = currentDirectory.replaceAll("\\\\", "/");
        jep.eval("os.chdir(\"" + currentDirectory + "\")");
    }

    public void runFabric() throws FabricException {
        String inputFile = this.getInputFile();
        if (inputFile != null) {
            this.runFabric(inputFile);
        } else {
            new FabricException(this.getClass().getName(), "runFabric()", "No input file option has been set");
        }
    }

    public String getInputFile() {
        return this.currentInputFile;
    }

    public void setInputFile(String input) {
        this.currentInputFile = input;
    }

    public void dispose() {
    }

    public static String[] getRequiredKeys() {
        String[] requireKeys = null;
        try {
            FableJep jep = new FableJep();
            Fabric.checkImport(jep);
            jep.eval("checkObject = check_input.parse_input()");
            jep.eval("required_items = checkObject.needed_items");
            if (jep.eval("required_items is not None")) {
                int len = jep.getIntegerValue("len(required_items)");
                requireKeys = new String[len];
                int i = 0;
                while (i < len) {
                    jep.set("i", i);
                    requireKeys[i] = jep.getStringValue("required_items.keys()[i]");
                    ++i;
                }
            }
            jep.close();
        }
        catch (JepException e) {
            FableUtils.excMsg(Fabric.class, (String)"An error occured with jep", (Throwable)e);
        }
        return requireKeys;
    }

    public String[] getOptionalKeys() {
        String[] optionalKeys = null;
        try {
            FableJep jep = new FableJep();
            Fabric.checkImport(jep);
            jep.eval("checkObject = check_input.parse_input()");
            jep.eval("optional_items = checkObject.optional_items");
            if (jep.eval("optional_items is not None")) {
                int len = jep.getIntegerValue("len(optional_items)");
                optionalKeys = new String[len];
                int i = 0;
                while (i < len) {
                    jep.set("i", i);
                    optionalKeys[i] = jep.getStringValue("optional_items.keys()[i]");
                    ++i;
                }
            }
            jep.close();
        }
        catch (JepException e) {
            FableUtils.excMsg(Fabric.class, (String)"An error occured with jep", (Throwable)e);
        }
        return optionalKeys;
    }

    public static String[] getAllKeyWords() {
        String[] allKeys = null;
        try {
            FableJep jep = new FableJep();
            Fabric.checkImport(jep);
            jep.eval("checkObject = check_input.parse_input()");
            jep.eval("required_items = checkObject.needed_items");
            jep.eval("optional_items = checkObject.optional_items");
            if (jep.eval("optional_items is not None") && jep.eval("required_items is not None")) {
                int len_optional_items = jep.getIntegerValue("len(optional_items)");
                int len_required_items = jep.getIntegerValue("len(required_items)");
                int len = len_required_items + len_optional_items;
                allKeys = new String[len];
                int i = 0;
                i = 0;
                while (i < len_optional_items) {
                    jep.set("i", i);
                    allKeys[i] = jep.getStringValue("optional_items.keys()[i]");
                    ++i;
                }
                int j = 0;
                while (j < len_required_items) {
                    jep.set("j", j);
                    allKeys[i] = jep.getStringValue("required_items.keys()[j]");
                    ++i;
                    ++j;
                }
            }
            jep.close();
        }
        catch (JepException e) {
            FableUtils.excMsg(Fabric.class, (String)"An error occured with jep", (Throwable)e);
        }
        return allKeys;
    }

    public String getDefaultValue(String key) {
        return this.getOptionalItems().get(key);
    }

    public HashMap<String, String> getOptionalItems() {
        if (this.optionalItems == null) {
            this.optionalItems = new HashMap();
            try {
                FableJep jep = new FableJep();
                Fabric.checkImport(jep);
                jep.eval("checkObject = check_input.parse_input()");
                jep.eval("optional_items = checkObject.optional_items");
                if (jep.eval("optional_items is not None")) {
                    int len = jep.getIntegerValue("len(optional_items)");
                    int i = 0;
                    while (i < len) {
                        jep.set("i", i);
                        String key = jep.getStringValue("optional_items.keys()[i]");
                        if (key != null) {
                            jep.set("key_java", key);
                            Object value = jep.getValue("optional_items[key_java]");
                            if (value != null) {
                                this.optionalItems.put(key, value.toString());
                            }
                        }
                        ++i;
                    }
                }
                jep.close();
            }
            catch (JepException e) {
                FableUtils.excMsg(Fabric.class, (String)"An error occured with jep", (Throwable)e);
            }
        }
        return this.optionalItems;
    }

    public static void checkImport(FableJep myjep) throws JepException {
        myjep.eval("from Fabric import check_input");
    }

    public void setKillFile(String file) {
        this.killFile = file;
    }

    public String getKillFile() {
        return this.killFile;
    }

    public boolean hasFinished() {
        return this.endOfProgram;
    }

    public void setEndOfProgram(boolean b) {
        this.endOfProgram = b;
    }

    public void integrate(String directory, String stem, String grainno) throws FabricException {
        try {
            File tempFile = File.createTempFile("fabric", ".stdout");
            File tempErrFile = File.createTempFile("fabric", ".stderr");
            this.stdoutThread = new StdoutRead(tempFile.getAbsolutePath());
            StdoutRead stderrThread = new StdoutRead(tempErrFile.getAbsolutePath());
            tempFile.deleteOnExit();
            tempErrFile.deleteOnExit();
            FableJep jep = new FableJep();
            jep.eval("from Fabric import gofabric");
            jep.eval("from optparse import OptionParser");
            jep.eval("import sys");
            this.chdir(this.getCurrentDirectory(), jep);
            jep.outputConsole(FableMessageConsole.console);
            jep.redirectStdout(tempFile.getAbsolutePath());
            jep.redirectStderr(tempErrFile.getAbsolutePath());
            this.stdoutThread.start();
            this.stdoutThread.setOutputToFableConsole(true);
            stderrThread.start();
            stderrThread.setOutputToFableConsole(true);
            jep.eval("from Fabric import run_integrate");
            jep.eval("from optparse import OptionParser");
            jep.eval("import sys");
            jep.eval("sys.stderr = sys.stdout");
            jep.eval("parser = OptionParser()");
            jep.eval("options = run_integrate.get_options(parser)");
            jep.eval("options.stem=\"" + stem + "\"");
            jep.eval("options.direc=\"" + directory + "\"");
            jep.eval("options.grainno=" + grainno);
            jep.eval("run_integrate.run(options)");
            jep.eval("sys.stdout.flush()");
            if (this.stdoutThread != null) {
                this.stdoutThread.stopped = true;
                try {
                    this.stdoutThread.join();
                }
                catch (InterruptedException e) {
                    FableUtils.excMsg((Object)this, (String)e.getMessage(), (Throwable)e);
                }
            }
            if (stderrThread != null) {
                try {
                    stderrThread.join();
                }
                catch (InterruptedException e) {
                    FableUtils.excMsg((Object)this, (String)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (JepException e) {
            throw new FabricException(Fabric.class.getName(), "integrate (" + directory + ", " + stem + ", " + grainno + ")", e.getMessage());
        }
        catch (IOException e) {
            throw new FabricException(Fabric.class.getName(), "integrate (" + directory + ", " + stem + ", " + grainno + ")", e.getMessage());
        }
    }
}

