/*
 * Decompiled with CFR 0.152.
 */
package fable.fabric.editors;

import fable.fabric.editors.FabricEditorConfiguration;
import fable.framework.toolbox.SWTUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class FabricEditor
extends TextEditor
implements IResourceChangeListener {
    private static final String ID = "fable.fabric.fabricEditor";
    public static final String EDITOR_CONTEXT = "fable.fabric.fabricEditor.context";
    public static final String RULER_CONTEXT = "fable.fabric.fabricEditor.context.ruler";

    public FabricEditor() {
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new FabricEditorConfiguration());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public static String getID() {
        return ID;
    }

    public String getCurrentDirectory() {
        String directory = "";
        IEditorInput input = this.getEditorInput();
        if (input != null && input instanceof FileEditorInput) {
            int index;
            String fileName;
            IPath path = ((FileEditorInput)input).getPath();
            if (path != null) {
                directory = path.toOSString();
            }
            if (!(fileName = ((FileEditorInput)input).getName()).equals("") && !directory.equals("") && (index = directory.lastIndexOf(fileName)) < directory.length() && index >= 0) {
                directory = directory.substring(0, index);
            }
        }
        return directory;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
    }

    public void doSaveAs() {
        super.doSaveAs();
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId(EDITOR_CONTEXT);
        this.setRulerContextMenuId(RULER_CONTEXT);
    }

    public String getFileName() {
        String fileName = "";
        IEditorInput input = this.getEditorInput();
        if (input != null && input instanceof FileEditorInput) {
            fileName = ((FileEditorInput)input).getName();
        } else if (input != null && input instanceof FileStoreEditorInput) {
            fileName = ((FileStoreEditorInput)input).getName();
        }
        return fileName;
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage[] pages = FabricEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)FabricEditor.this.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(FabricEditor.this.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
        if (event.getType() == 1) {
            IFileEditorInput fileInput = null;
            IPath path = null;
            IResourceDelta delta = null;
            IResource res = null;
            if (this.getEditorInput() != null && this.getEditorInput() instanceof IFileEditorInput) {
                fileInput = (IFileEditorInput)this.getEditorInput();
                path = fileInput.getFile().getFullPath();
            }
            if (path != null) {
                delta = event.getDelta().findMember(path);
            }
            if (delta != null) {
                res = delta.getResource();
            }
            if (res != null) {
                int kind = delta.getKind();
                if (kind == 2) {
                    final IFileEditorInput input = fileInput;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchPage[] pages = FabricEditor.this.getSite().getWorkbenchWindow().getPages();
                            int i = 0;
                            while (i < pages.length) {
                                IEditorPart editorPart = pages[i].findEditor((IEditorInput)input);
                                pages[i].closeEditor(editorPart, true);
                                ++i;
                            }
                        }
                    });
                } else {
                    SWTUtils.infoMsgAsync((String)("Got POST_CHANGE [" + delta.getKind() + "] for " + path.toOSString()));
                }
            }
        }
    }
}

