/*
 * Decompiled with CFR 0.152.
 */
package fable.fabric.actions;

import fable.fabric.editors.FabricEditor;
import fable.fabric.internal.IVarKeys;
import fable.framework.toolbox.SWTUtils;
import fable.framework.views.FableMessageConsole;
import java.io.File;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class OpenInputFile
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private IEditorInput input;

    public void dispose() {
    }

    public void init(IWorkbenchWindow arg0) {
        this.window = arg0;
    }

    public void run(IAction arg1) {
        if (this.window != null) {
            FileDialog fileDlg = new FileDialog(new Shell(), 4096);
            try {
                IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWindow != null) {
                    activeWindow.getWorkbench().showPerspective("fable.fabric.perspective", activeWindow);
                }
            }
            catch (PartInitException partInitException) {
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayError("Fabric perspective can not be displayed.");
                }
            }
            catch (WorkbenchException e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening Fabric perspective: " + e.getMessage()));
            }
            fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_INI);
            fileDlg.setFilterNames(IVarKeys.FILTER_NAMES_INI);
            fileDlg.setText("Select an input file.");
            String file = fileDlg.open();
            if (file != null) {
                File theInputFile = new File(file);
                if (theInputFile.exists()) {
                    this.input = SWTUtils.createEditorInput((File)theInputFile);
                    String editorId = FabricEditor.getID();
                    try {
                        this.window.getActivePage().openEditor(this.input, editorId);
                    }
                    catch (PartInitException e) {
                        MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening input file: " + e.getMessage()));
                    }
                } else {
                    MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening input file: " + theInputFile.getName()));
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

