/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.help.ui.RootScopePage;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.help.ui.internal.IHelpUIConstants;
import org.eclipse.help.ui.internal.views.EngineDescriptor;
import org.eclipse.help.ui.internal.views.EngineDescriptorManager;
import org.eclipse.help.ui.internal.views.ScopeSet;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;

public class ScopePreferenceManager
extends PreferenceManager
implements IHelpUIConstants {
    private ScopeSet set;

    public ScopePreferenceManager(EngineDescriptorManager descManager, ScopeSet set) {
        this.set = set;
        this.load(descManager.getDescriptors());
    }

    private void load(EngineDescriptor[] descriptors) {
        int i = 0;
        while (i < descriptors.length) {
            EngineDescriptor desc = descriptors[i];
            this.addNode(desc);
            IConfigurationElement[] pages = desc.getPages();
            int j = 0;
            while (j < pages.length) {
                String category = pages[i].getAttribute("category");
                this.addNode(category, pages[i].getAttribute("id"), pages[i].getAttribute("label"), pages[i]);
                ++j;
            }
            ++i;
        }
    }

    public IPreferenceNode addNode(EngineDescriptor desc) {
        EnginePreferenceNode node = new EnginePreferenceNode(desc);
        this.addToRoot((IPreferenceNode)node);
        return node;
    }

    private IPreferenceNode addNode(String category, String id, String name, IConfigurationElement config) {
        IPreferenceNode parent = this.find(category);
        SubpagePreferenceNode node = new SubpagePreferenceNode(id, name, config);
        if (parent != null) {
            parent.add((IPreferenceNode)node);
        }
        return node;
    }

    class EnginePreferenceNode
    extends PreferenceNode {
        private EngineDescriptor desc;

        public EnginePreferenceNode(EngineDescriptor desc) {
            super(desc.getId(), desc.getLabel(), desc.getImageDescriptor(), null);
            this.desc = desc;
        }

        public EngineDescriptor getDescriptor() {
            return this.desc;
        }

        public void createPage() {
            RootScopePage page = this.desc.createRootPage(ScopePreferenceManager.this.set.getName());
            this.setPage(page);
            page.setTitle(this.desc.getLabel());
            page.setImageDescriptor(this.desc.getImageDescriptor());
            page.setDescription(this.desc.getDescription());
        }
    }

    class SubpagePreferenceNode
    extends PreferenceNode {
        private IConfigurationElement config;

        public SubpagePreferenceNode(String id, String label, IConfigurationElement config) {
            super(id, label, null, null);
            this.config = config;
        }

        public void createPage() {
            try {
                Object obj = this.config.createExecutableExtension("class");
                IPreferencePage page = (IPreferencePage)obj;
                this.setPage(page);
                page.setTitle(this.getLabelText());
            }
            catch (CoreException e) {
                HelpUIPlugin.logError("Unable to create executable extension", e);
            }
        }
    }
}

