/*
 * Decompiled with CFR 0.152.
 */
package fable.python.views;

import fable.framework.logging.FableLogger;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class PythonPlotView
extends ViewPart {
    public static final String ID = "fable.python.views.PythonPlotView";
    private Vector<JLDataView> dataViewSeries = new Vector();
    private JLChart chart;
    Button y1Button;
    Button y2Button;
    int[] dataMarkers = new int[]{2, 9, 8, 4, 1, 5};
    static int iDataMarker = 0;
    Color[] dataColors = new Color[]{Color.RED, Color.BLUE, Color.CYAN, Color.GREEN, Color.MAGENTA, Color.ORANGE, Color.YELLOW};
    static int iDataColor = 0;
    public static PythonPlotView view;
    private String title = "Python Plot";
    private Composite swtAwtComponent;
    Frame chartFrame;
    Logger logger = FableLogger.getLogger(PythonPlotView.class);
    private JApplet chartContainer;
    private JLDataView dataView = null;

    public void createPartControl(Composite parent) {
        view = this;
        parent.setLayout((Layout)new GridLayout());
        this.createChartFrame(parent);
        this.createChart();
        Composite controlComposite = new Composite(parent, 0);
        GridLayout controlGridLayout = new GridLayout();
        controlGridLayout.numColumns = 3;
        controlComposite.setLayout((Layout)controlGridLayout);
        this.y1Button = new Button(controlComposite, 16);
        this.y1Button.setText("add to Y1");
        this.y1Button.setToolTipText("add next plot to Y1 axis");
        this.y1Button.setSelection(true);
        this.y2Button = new Button(controlComposite, 16);
        this.y2Button.setText("add to Y2");
        this.y2Button.setToolTipText("add next plot to Y2 axis");
        this.y2Button.setSelection(false);
        Button clearButton = new Button(controlComposite, 8);
        clearButton.setText("clear plot");
        clearButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PythonPlotView.this.clearAllPlots();
            }

            public void widgetSelected(SelectionEvent e) {
                PythonPlotView.this.clearAllPlots();
            }
        });
        this.setPartName("Python Plot");
    }

    public void setFocus() {
    }

    private void createChartFrame(Composite parent) {
        this.swtAwtComponent = new Composite(parent, 0x1040000);
        this.swtAwtComponent.setLayout((Layout)new GridLayout());
        this.swtAwtComponent.setLayoutData((Object)new GridData(1808));
        this.chartFrame = SWT_AWT.new_Frame((Composite)this.swtAwtComponent);
        this.chartContainer = new JApplet();
        this.chartFrame.add(this.chartContainer);
    }

    public void createChart() {
        this.chart = new JLChart();
        this.chart.setHeader(this.title);
        this.chart.setHeaderFont(new Font("Dialog", 1, 18));
        this.chart.getY1Axis().setName("value");
        this.chart.getY1Axis().setAutoScale(true);
        this.chart.getY2Axis().setAutoScale(true);
        this.chart.getXAxis().setAutoScale(true);
        this.chart.getXAxis().setName("index");
        this.chart.getXAxis().setGridVisible(true);
        this.chart.getXAxis().setSubGridVisible(true);
        this.chart.getXAxis().setAnnotation(2);
        this.chart.getY1Axis().setGridVisible(true);
        this.chart.getY1Axis().setSubGridVisible(true);
        this.chartContainer.add((Component)this.chart);
    }

    public void plotArray(String _arrayName, float[] _arrayData) {
        if (this.dataView == null) {
            this.dataView = new JLDataView();
            this.dataView.setName(_arrayName);
            this.dataView.setMarker(this.dataMarkers[iDataMarker]);
            this.dataView.setMarkerColor(this.dataColors[iDataColor]);
            this.dataView.setColor(this.dataColors[iDataColor]);
            if (this.y1Button.getSelection()) {
                this.chart.getY1Axis().addDataView(this.dataView);
            } else {
                this.chart.getY2Axis().addDataView(this.dataView);
            }
        }
        double[] x = new double[_arrayData.length];
        double[] y = new double[_arrayData.length];
        int i = 0;
        while (i < _arrayData.length) {
            x[i] = i + 1;
            y[i] = _arrayData[i];
            ++i;
        }
        this.dataView.setData(x, y);
        this.chart.repaint();
        if (++iDataMarker >= this.dataMarkers.length) {
            iDataMarker = 0;
        }
        if (++iDataColor >= this.dataColors.length) {
            iDataColor = 0;
        }
        this.dataViewSeries.add(this.dataView);
        this.dataView = null;
    }

    public void clearAllPlots() {
        int i = 0;
        while (i < this.dataViewSeries.size()) {
            this.chart.removeDataView(this.dataViewSeries.get(i));
            ++i;
        }
        Dimension chartSize = this.chartContainer.getSize();
        this.chart.setSize(chartSize);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PythonPlotView.this.chartContainer.repaint();
            }
        });
        this.dataViewSeries.clear();
    }
}

