/*
 * Decompiled with CFR 0.152.
 */
package fable.python.jep.test;

import fable.python.jep.FableJep;
import fable.python.jep.StdoutRead;
import jep.Jep;
import jep.JepException;
import org.junit.Assert;
import org.junit.Test;

public class FableJepTest {
    @Test
    public final void testGetJep() {
        Jep jep = null;
        try {
            jep = new FableJep().getJep();
        }
        catch (JepException e) {
            e.printStackTrace();
        }
        if (jep == null) {
            Assert.fail((String)"could not get Jep object");
        }
    }

    @Test
    public final void testJepEval() {
        Jep jep = null;
        try {
            jep = new FableJep().getJep();
        }
        catch (JepException e1) {
            e1.printStackTrace();
        }
        if (jep == null) {
            Assert.fail((String)"could not get Jep object");
        }
        try {
            jep.eval("print 'hello world'");
        }
        catch (JepException e) {
            e.printStackTrace();
        }
    }

    @Test
    public final void testRedirectStdout() {
        System.out.println("testRedirectStdout(): test redirection of stdout ...");
        FableJep jep = null;
        try {
            jep = new FableJep();
        }
        catch (JepException e1) {
            e1.printStackTrace();
        }
        if (jep == null) {
            Assert.fail((String)"could not get Jep object");
        }
        try {
            jep.redirectStdout("/tmp/stdout.test");
            long printtime = System.currentTimeMillis();
            jep.eval("print 'hello world 1';print 'hello world 2'");
            StdoutRead stdoutThread = new StdoutRead("/tmp/stdout.test");
            stdoutThread.setOutputToSystemOut(true);
            stdoutThread.setOutputToFableConsole(false);
            stdoutThread.start();
            jep.eval("sys.stdout.flush()");
            jep.eval("import sys");
            jep.eval("import time");
            jep.eval("time.sleep(10)");
            System.out.println("print was received " + (stdoutThread.lasttime - printtime) + " millisecond(s) later");
            if (Math.abs(stdoutThread.lasttime - printtime) > 1000L) {
                Assert.fail((String)("print was received at least " + (printtime - stdoutThread.lasttime) / 1000L + " seconds late !"));
            }
            stdoutThread.lasttime = 0L;
            jep.eval("print 'goodbye world 1';print 'goodbye world 2'");
            printtime = System.currentTimeMillis();
            jep.eval("sys.stdout.flush()");
            jep.eval("time.sleep(10)");
            System.out.println("print was received " + (printtime - stdoutThread.lasttime) / 1000L + " seconds later");
            if (Math.abs(stdoutThread.lasttime - printtime) > 1000L) {
                Assert.fail((String)("print was received at least " + (stdoutThread.lasttime - printtime) + " millisecond(s) late !"));
            }
            stdoutThread.stopped = true;
            stdoutThread.join();
        }
        catch (JepException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Test
    public final void testSysArgv() {
        System.out.println("testSysArgv(): test sys.argv is set to jep ...");
        FableJep jep = null;
        try {
            jep = new FableJep();
        }
        catch (JepException e1) {
            e1.printStackTrace();
        }
        if (jep == null) {
            Assert.fail((String)"could not get Jep object");
        }
        try {
            jep.eval("print sys.argv");
            String sysargv = jep.getStringValue("sys.argv[0]");
            System.out.println("sys.argv[0] = " + sysargv);
            if (!sysargv.equalsIgnoreCase("jep")) {
                Assert.fail((String)"sys.argv[0] != jep");
            }
        }
        catch (JepException e) {
            e.printStackTrace();
        }
    }
}

