/*
 * Decompiled with CFR 0.152.
 */
package fable.python;

import fable.python.jep.FableJep;
import jep.JepException;

public class ChiFile {
    private FableJep fableJep;
    private float mintth;
    private float maxtth;
    private float meantth;
    private float minIntensity;
    private float maxIntensity;
    private float meanIntensity;
    private float[] dots = null;
    private int numDots = 0;

    public ChiFile() {
        try {
            this.fableJep = new FableJep();
            FableJep.jepImportModules(this.fableJep.getJep(), "numpy");
            FableJep.jepImportSpecificDefinition(this.fableJep.getJep(), "FableFacility", "chi_file");
            this.fableJep.eval("reader =chi_file.chi_file()");
        }
        catch (JepException e) {
            e.printStackTrace();
        }
    }

    public void loadfile(String chifile) throws JepException {
        this.fableJep.set("filename", chifile);
        this.fableJep.eval("reader.loadfile(filename)");
    }

    public float[] getlist() throws JepException {
        this.numDots = this.fableJep.getIntegerValue("len(reader.dots)");
        if (this.numDots > 0) {
            this.numDots /= 2;
            this.dots = new float[this.numDots];
            this.dots = this.fableJep.getValue_floatarray("reader.dots.astype(numpy.float32).tostring()");
            this.setMinIntensity(this.fableJep.getFloatValue("reader.getminIntensity()").floatValue());
            this.setMaxIntensity(this.fableJep.getFloatValue("reader.getmaxIntensity()").floatValue());
            this.setMeanIntensity(this.fableJep.getFloatValue("reader.getmeanIntensity()").floatValue());
            this.setMaxtth(this.fableJep.getFloatValue("reader.getmaxAngle()").floatValue());
            this.setMintth(this.fableJep.getFloatValue("reader.getminAngle()").floatValue());
            this.setMeantth(this.fableJep.getFloatValue("reader.getmeanAngle()").floatValue());
        }
        return this.dots;
    }

    public float getMinIntensity() {
        return this.minIntensity;
    }

    private void setMinIntensity(float min) {
        this.minIntensity = min;
    }

    public float getMaxIntensity() {
        return this.maxIntensity;
    }

    private void setMaxIntensity(float max) {
        this.maxIntensity = max;
    }

    public float getMeanIntensity() {
        return this.meanIntensity;
    }

    private void setMeanIntensity(float mean) {
        this.meanIntensity = mean;
    }

    public int getNumDots() {
        return this.numDots;
    }

    public float getMintth() {
        return this.mintth;
    }

    public void setMintth(float mintth) {
        this.mintth = mintth;
    }

    public float getMaxtth() {
        return this.maxtth;
    }

    public void setMaxtth(float maxtth) {
        this.maxtth = maxtth;
    }

    public float getMeantth() {
        return this.meantth;
    }

    public void setMeantth(float meantth) {
        this.meantth = meantth;
    }
}

