/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.logging.FableLogger;
import fable.framework.navigator.controller.SampleController;
import fable.framework.toolbox.FableUtils;
import fable.python.FabioFile;
import fable.python.FabioFileException;
import fable.python.Sample;
import fable.python.jep.FableJep;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import jep.JepException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.part.ViewPart;

public class RockingCurveView
extends ViewPart {
    public static final String ID = "fable.imageviewer.views.RockingCurveView";
    private JLDataView dataView;
    private JLChart chart;
    String title;
    private int rockStart = -1;
    private int rockCenter = -1;
    private int rockEnd = -1;
    private int rockRange;
    private int xAxis = 0;
    private int[] rockArea = new int[4];
    private float[] rockX;
    private float[] rockIntensity;
    private Spinner rockStartSpinner;
    private Spinner rockEndSpinner;
    private Label rockStartLabel;
    private Label rockEndLabel;
    private Button updateButton;
    private Button averageButton;
    private Combo xAxisCombo;
    public static RockingCurveView view;
    private Composite swtAwtComponent;
    public SampleController controller = SampleController.getController();
    public Sample sample = null;
    private Frame chartFrame;
    private JApplet chartContainer;
    Logger logger;
    private IProgressMonitor jobMonitor;
    private final String[] imageNumber = new String[]{"image number"};
    private String[] xAxisItems = this.imageNumber;
    private boolean jobRunning = false;
    private boolean average = true;

    public void createPartControl(Composite parent) {
        view = this;
        this.logger = FableLogger.getLogger(RockingCurveView.class);
        parent.setLayout((Layout)new GridLayout());
        this.createChartFrame(parent);
        this.createChart();
        Composite controlPanelComposite = new Composite(parent, 0);
        GridLayout controlGridLayout = new GridLayout();
        controlGridLayout.numColumns = 8;
        controlPanelComposite.setLayout((Layout)controlGridLayout);
        controlPanelComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        Label xAxisLabel = new Label(controlPanelComposite, 0);
        xAxisLabel.setText("X Axis");
        this.xAxisCombo = new Combo(controlPanelComposite, 0);
        this.xAxisCombo.setItems(this.xAxisItems);
        this.xAxisCombo.select(0);
        this.xAxis = 0;
        this.xAxisCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RockingCurveView.this.xAxis = RockingCurveView.this.xAxisCombo.getSelectionIndex();
            }
        });
        this.rockStartLabel = new Label(controlPanelComposite, 0);
        this.rockStartLabel.setText("Start");
        this.rockStartSpinner = new Spinner(controlPanelComposite, 0);
        this.rockEndLabel = new Label(controlPanelComposite, 0);
        this.rockEndLabel.setText("End");
        this.rockEndSpinner = new Spinner(controlPanelComposite, 0);
        this.averageButton = new Button(controlPanelComposite, 32);
        this.averageButton.setText("Average");
        this.averageButton.setSelection(true);
        this.average = true;
        this.averageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RockingCurveView.this.averageButton.getSelection()) {
                    RockingCurveView.this.average = true;
                } else {
                    RockingCurveView.this.average = false;
                }
            }
        });
        this.updateButton = new Button(controlPanelComposite, 0);
        this.updateButton.setText("Update");
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RockingCurveView.this.rockStart = RockingCurveView.this.rockStartSpinner.getSelection();
                RockingCurveView.this.rockEnd = RockingCurveView.this.rockEndSpinner.getSelection();
                RockingCurveView.this.runIntegratePlotJob();
            }
        });
    }

    public void setFocus() {
    }

    private void createChartFrame(Composite parent) {
        this.swtAwtComponent = new Composite(parent, 0x1040000);
        this.swtAwtComponent.setLayout((Layout)new GridLayout());
        this.swtAwtComponent.setLayoutData((Object)new GridData(1808));
        this.chartFrame = SWT_AWT.new_Frame((Composite)this.swtAwtComponent);
        this.chartContainer = new JApplet();
        this.chartFrame.add(this.chartContainer);
    }

    public void createChart() {
        this.chart = new JLChart();
        this.chart.setHeader("Rocking Curve Plot");
        this.chart.setHeaderFont(new Font("Dialog", 1, 18));
        this.chart.getY1Axis().setName("integrated intensity");
        this.chart.getY1Axis().setAutoScale(true);
        this.chart.getXAxis().setAutoScale(true);
        this.chart.getXAxis().setName("image number");
        this.chart.getXAxis().setGridVisible(true);
        this.chart.getXAxis().setSubGridVisible(true);
        this.chart.getXAxis().setAnnotation(2);
        this.chart.getY1Axis().setGridVisible(true);
        this.chart.getY1Axis().setSubGridVisible(true);
        this.dataView = new JLDataView();
        this.dataView.setName("integrated intensity [" + this.rockArea[0] + "," + this.rockArea[1] + "] - [" + this.rockArea[2] + "," + this.rockArea[3] + "]");
        this.chart.getY1Axis().addDataView(this.dataView);
        this.chartContainer.add((Component)this.chart);
    }

    public void setCenterArea(String _title, int center, int y1, int z1, int y2, int z2) {
        if (!this.jobRunning) {
            this.jobRunning = true;
            if (this.sample != this.controller.getCurrentsample()) {
                this.sample = this.controller.getCurrentsample();
                try {
                    String[] headerItems = ((FabioFile)this.sample.getFilteredfiles().get(0)).getKeys();
                    this.xAxisItems = new String[1 + headerItems.length];
                    this.xAxisItems[0] = "image number";
                    int i = 0;
                    while (i < headerItems.length) {
                        this.xAxisItems[i + 1] = headerItems[i];
                        ++i;
                    }
                }
                catch (FabioFileException ex) {
                    FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error setting center area", (Throwable)ex);
                }
                catch (JepException ex) {
                    FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error setting center area", (Throwable)ex);
                }
                this.xAxisCombo.setItems(this.xAxisItems);
                this.xAxisCombo.select(0);
                this.xAxis = 0;
            }
            this.title = _title;
            this.rockStartSpinner.setMaximum(this.sample.getFilteredfiles().size() - 1);
            this.rockEndSpinner.setMaximum(this.sample.getFilteredfiles().size() - 1);
            this.rockArea[0] = y1;
            this.rockArea[1] = z1;
            this.rockArea[2] = y2;
            this.rockArea[3] = z2;
            this.rockCenter = center;
            this.rockRange = this.rockEnd - this.rockStart;
            this.rockStart = this.rockRange <= 3 ? center - 3 : center - this.rockRange / 2;
            this.rockEnd = this.rockRange <= 3 ? center + 3 : center + (this.rockRange + 1) / 2;
            this.checkRockRange();
            this.runIntegratePlotJob();
        }
    }

    public void checkRockRange() {
        if (this.rockStart < 0) {
            this.rockStart = 0;
        }
        if (this.rockEnd > this.sample.getFilteredfiles().size() - 1) {
            this.rockEnd = this.sample.getFilteredfiles().size() - 1;
        }
        if (this.rockStart > this.rockEnd) {
            int temp = this.rockStart;
            this.rockStart = this.rockEnd;
            this.rockEnd = temp;
        }
        this.rockStartSpinner.setSelection(this.rockStart);
        this.rockEndSpinner.setSelection(this.rockEnd);
    }

    public void runIntegratePlotJob() {
        Job job = new Job("Integrate rocking curve for sample " + this.sample.getDirectoryName() + " ... "){

            protected IStatus run(IProgressMonitor monitor) {
                RockingCurveView.this.jobMonitor = monitor;
                monitor.beginTask("Integrate rocking curve for sample " + RockingCurveView.this.sample.getDirectoryName() + " ... ", RockingCurveView.this.rockEnd - RockingCurveView.this.rockStart + 1);
                if (RockingCurveView.this.Integrate() != 0) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RockingCurveView.this.Plot();
                    }
                });
                monitor.done();
                RockingCurveView.this.jobRunning = false;
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
    }

    public int Integrate() {
        FableJep fableJep = null;
        try {
            fableJep = new FableJep();
        }
        catch (JepException ex) {
            FableUtils.excMsg((Object)((Object)this), (String)"Error in Integrate creating FableJep", (Throwable)ex);
        }
        Vector fabioFiles = this.sample.getFilteredfiles();
        FabioFile fabioFile = (FabioFile)fabioFiles.get(this.rockCenter);
        try {
            int width = fabioFile.getWidth();
            int height = fabioFile.getHeight();
            int npoints = (this.rockArea[2] - this.rockArea[0]) * (this.rockArea[3] - this.rockArea[1]);
            this.rockX = new float[this.rockEnd - this.rockStart + 1];
            this.rockIntensity = new float[this.rockEnd - this.rockStart + 1];
            int rockingCurveErrors = 0;
            int i = this.rockStart;
            while (i <= this.rockEnd) {
                this.jobMonitor.worked(1);
                fabioFile = (FabioFile)fabioFiles.get(i);
                float[] imageFloat = fabioFile.getImageAsFloat(fableJep);
                if (fabioFile.getWidth() == width && fabioFile.getHeight() == height) {
                    float sum = 0.0f;
                    int z = this.rockArea[1];
                    while (z < this.rockArea[3]) {
                        int zOffset = width * z;
                        int y = this.rockArea[0];
                        while (y < this.rockArea[2]) {
                            sum += imageFloat[zOffset + y];
                            ++y;
                        }
                        ++z;
                    }
                    this.rockIntensity[i - this.rockStart] = this.average ? sum / (float)npoints : sum;
                } else {
                    this.rockIntensity[i - this.rockStart] = Float.NaN;
                    ++rockingCurveErrors;
                }
                if (this.xAxis != 0) {
                    this.rockX[i - this.rockStart] = Float.NaN;
                    String keyValue = "";
                    try {
                        if (!fabioFile.headerRead) {
                            fabioFile.loadHeader(fableJep);
                        }
                        keyValue = fabioFile.getValue(this.xAxisItems[this.xAxis]);
                    }
                    catch (FabioFileException ex) {
                        FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error in Integrate loading header", (Throwable)ex);
                    }
                    try {
                        this.rockX[i - this.rockStart] = Float.parseFloat(keyValue);
                    }
                    catch (NumberFormatException ex) {
                        FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error in Integrate loading header", (Throwable)ex);
                        ++rockingCurveErrors;
                    }
                } else {
                    this.rockX[i - this.rockStart] = i;
                }
                ++i;
            }
            if (rockingCurveErrors != 0) {
                final String message = String.valueOf(rockingCurveErrors) + " files will not be plotted on the rocking curve " + "because their size differs or the key chosen for " + "the x axis does not exist";
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Confirm", (String)message);
                    }
                });
                return 1;
            }
        }
        catch (JepException ex) {
            FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error in Integrate", (Throwable)ex);
        }
        return 0;
    }

    public void Plot() {
        if (this.average) {
            this.chart.getY1Axis().setName("average intensity");
        } else {
            this.chart.getY1Axis().setName("integrated intensity");
        }
        this.chart.getXAxis().setName(this.xAxisItems[this.xAxis]);
        this.chart.setHeader(this.title);
        double[] x = new double[this.rockEnd - this.rockStart + 1];
        double[] y = new double[this.rockEnd - this.rockStart + 1];
        int i = 0;
        while (i < this.rockEnd - this.rockStart + 1) {
            x[i] = this.rockX[i];
            y[i] = this.rockIntensity[i];
            ++i;
        }
        this.dataView.setData(x, y);
        this.dataView.setName("integrated intensity [" + this.rockArea[0] + "," + this.rockArea[1] + "] - [" + this.rockArea[2] + "," + this.rockArea[3] + "]");
        Dimension chartSize = this.chartContainer.getSize();
        this.chart.setSize(chartSize);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RockingCurveView.this.chartContainer.repaint();
            }
        });
    }
}

