/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.logging.FableLogger;
import fable.framework.navigator.controller.SampleController;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class ProfileView
extends ViewPart {
    public static final String ID = "fable.imageviewer.views.ProfileView";
    private JLDataView dataViewX;
    private JLDataView dataViewY;
    private JLChart chartX;
    private JLChart chartY;
    public static ProfileView view;
    private Composite swtAwtComponentX;
    private Composite swtAwtComponentY;
    public SampleController controller = SampleController.getController();
    private Frame chartFrameX;
    private Frame chartFrameY;
    Logger logger;
    private JApplet chartContainerX;
    private JApplet chartContainerY;

    public void createPartControl(Composite parent) {
        view = this;
        parent.setLayout((Layout)new GridLayout());
        this.createChartFrame(parent);
        this.createChart();
        this.logger = FableLogger.getLogger(ProfileView.class);
    }

    public void setFocus() {
    }

    private void createChartFrame(Composite parent) {
        this.swtAwtComponentX = new Composite(parent, 0x1040000);
        this.swtAwtComponentX.setLayout((Layout)new GridLayout());
        this.swtAwtComponentX.setLayoutData((Object)new GridData(1808));
        this.chartFrameX = SWT_AWT.new_Frame((Composite)this.swtAwtComponentX);
        this.chartContainerX = new JApplet();
        this.chartFrameX.add(this.chartContainerX);
        this.swtAwtComponentY = new Composite(parent, 0x1040000);
        this.swtAwtComponentY.setLayout((Layout)new GridLayout());
        this.swtAwtComponentY.setLayoutData((Object)new GridData(1808));
        this.chartFrameY = SWT_AWT.new_Frame((Composite)this.swtAwtComponentY);
        this.chartContainerY = new JApplet();
        this.chartFrameY.add(this.chartContainerY);
    }

    public void createChart() {
        this.chartX = new JLChart();
        this.chartX.setHeader("X Profile");
        this.chartX.setHeaderFont(new Font("Dialog", 1, 18));
        this.chartX.getY1Axis().setName("Intensity");
        this.chartX.getY1Axis().setAutoScale(true);
        this.chartX.getXAxis().setAutoScale(true);
        this.chartX.getXAxis().setName("X");
        this.chartX.getXAxis().setGridVisible(true);
        this.chartX.getXAxis().setSubGridVisible(true);
        this.chartX.getXAxis().setAnnotation(2);
        this.chartX.getY1Axis().setGridVisible(true);
        this.chartX.getY1Axis().setSubGridVisible(true);
        this.chartContainerX.add((Component)this.chartX);
        this.dataViewX = new JLDataView();
        this.dataViewX.setName("Intensity");
        this.chartX.getY1Axis().addDataView(this.dataViewX);
        this.chartY = new JLChart();
        this.chartY.setHeader("Y Profile");
        this.chartY.setHeaderFont(new Font("Dialog", 1, 18));
        this.chartY.getY1Axis().setName("Intensity");
        this.chartY.getY1Axis().setAutoScale(true);
        this.chartY.getXAxis().setAutoScale(true);
        this.chartY.getXAxis().setName("Y");
        this.chartY.getXAxis().setGridVisible(true);
        this.chartY.getXAxis().setSubGridVisible(true);
        this.chartY.getXAxis().setAnnotation(2);
        this.chartY.getY1Axis().setGridVisible(true);
        this.chartY.getY1Axis().setSubGridVisible(true);
        this.chartContainerY.add((Component)this.chartY);
        this.dataViewY = new JLDataView();
        this.dataViewY.setName("Intensity");
        this.chartY.getY1Axis().addDataView(this.dataViewY);
    }

    public void setData(String title, String xTitle, String yTitle, boolean xInverted, boolean yInverted, float[] pixel_x, float[] profile_x, float[] pixel_y, float[] profile_y) {
        double[] x_x = new double[pixel_x.length];
        double[] x_y = new double[pixel_x.length];
        int i = 0;
        while (i < pixel_x.length) {
            x_x[i] = pixel_x[i];
            x_y[i] = xInverted ? (double)profile_x[pixel_x.length - 1 - i] : (double)profile_x[i];
            ++i;
        }
        this.dataViewX.setData(x_x, x_y);
        this.chartX.setHeader("X " + title);
        Dimension chartSizeY = this.chartContainerX.getSize();
        this.chartX.setSize(chartSizeY);
        this.chartX.getXAxis().setName(xTitle);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProfileView.this.chartContainerX.repaint();
            }
        });
        double[] y_x = new double[pixel_y.length];
        double[] y_y = new double[pixel_y.length];
        int i2 = 0;
        while (i2 < pixel_y.length) {
            y_x[i2] = pixel_y[i2];
            y_y[i2] = yInverted ? (double)profile_y[pixel_y.length - 1 - i2] : (double)profile_y[i2];
            ++i2;
        }
        this.dataViewY.setData(y_x, y_y);
        this.chartY.setHeader("Y " + title);
        this.chartY.getXAxis().setName(yTitle);
        Dimension chartSizeZ = this.chartContainerY.getSize();
        this.chartY.setSize(chartSizeZ);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProfileView.this.chartContainerY.repaint();
            }
        });
    }
}

