/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.logging.FableLogger;
import fable.framework.navigator.controller.SampleController;
import fable.framework.toolbox.FableUtils;
import fable.imageviewer.internal.IImagesVarKeys;
import fable.imageviewer.internal.ImageViewType;
import fable.imageviewer.internal.ZoomSelection;
import fable.imageviewer.model.ImageModel;
import fable.imageviewer.views.ImageView;
import fable.imageviewer.views.ImageViewControls;
import fable.imageviewer.views.LineView;
import fable.imageviewer.views.ProfileView;
import fable.imageviewer.views.ReliefView;
import fable.imageviewer.views.RockingCurveView;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ImageViewImage
implements IImagesVarKeys {
    private static final boolean debug = false;
    private static final boolean debug1 = false;
    private static final float ZOOMFACTOR_LARGE = 0.5f;
    private static final boolean LINEVIEW_HISTOGRAM = true;
    ImageView iv = null;
    private ImageViewControls controls;
    private Canvas imageCanvas;
    private GC imageCanvasGC;
    private Image image = null;
    private ImageData imageData;
    private Rectangle imageRect = new Rectangle(0, 0, 0, 0);
    private Rectangle origRect = new Rectangle(0, 0, 0, 0);
    private Rectangle orientedOrigRect = new Rectangle(0, 0, 0, 0);
    private Rectangle orientedRect = new Rectangle(0, 0, 0, 0);
    double xScale;
    double yScale;
    private Boolean selectingOn = false;
    private int canvasWidth;
    private int canvasHeight;
    private Boolean selectOn = false;
    private boolean imageChanged = true;
    private Boolean newSelection = true;
    private int xSelectionStart;
    private int ySelectionStart;
    private Rectangle selectedArea = new Rectangle(0, 0, 0, 0);
    private Display display;
    private Logger logger = FableLogger.getLogger(this.getClass());
    private ImageView zoomAreaView;
    private LineView lineView;
    private ProfileView profileView;
    private ReliefView zoomReliefView;
    private RockingCurveView zoomRockingCurveView;

    public ImageViewImage(ImageView iv, ImageViewControls controls) {
        this.iv = iv;
        this.controls = controls;
        iv.setImage(this);
        controls.setImage(this);
    }

    public void initializeCanvas() {
        if (this.iv == null || this.controls == null) {
            return;
        }
        this.imageCanvas = this.controls.getImageCanvas();
        this.display = this.iv.getDisplay();
        this.imageCanvas.setBackground(this.display.getSystemColor(16));
        GridData gridData = new GridData(4, 4, true, true);
        this.imageCanvas.setLayoutData((Object)gridData);
        this.imageCanvasGC = new GC((Drawable)this.imageCanvas);
        Rectangle bounds = this.imageCanvas.getBounds();
        this.canvasWidth = bounds.width;
        this.canvasHeight = bounds.height;
        this.imageCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageViewImage.this.imageCanvasGC.dispose();
            }
        });
        this.imageCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (ImageViewImage.this.image == null) {
                    return;
                }
                Rectangle bounds = ImageViewImage.this.imageCanvas.getBounds();
                event.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                if (ImageViewImage.this.canvasWidth != bounds.width || ImageViewImage.this.canvasHeight != bounds.height) {
                    double imageXScale = ImageViewImage.this.xScale;
                    double imageYScale = ImageViewImage.this.yScale;
                    ImageViewImage.this.createScreenImage(ImageViewImage.this.imageData);
                    ((ImageViewImage)ImageViewImage.this).selectedArea.width = (int)Math.round((double)((ImageViewImage)ImageViewImage.this).selectedArea.width * (imageXScale /= ImageViewImage.this.xScale));
                    ((ImageViewImage)ImageViewImage.this).selectedArea.height = (int)Math.round((double)((ImageViewImage)ImageViewImage.this).selectedArea.height * (imageYScale /= ImageViewImage.this.yScale));
                    ((ImageViewImage)ImageViewImage.this).selectedArea.x = (int)Math.round((double)((ImageViewImage)ImageViewImage.this).selectedArea.x * imageXScale);
                    ((ImageViewImage)ImageViewImage.this).selectedArea.y = (int)Math.round((double)((ImageViewImage)ImageViewImage.this).selectedArea.y * imageYScale);
                    ImageViewImage.this.canvasWidth = bounds.width;
                    ImageViewImage.this.canvasHeight = bounds.height;
                }
                ImageViewImage.this.displayImage();
            }
        });
        this.imageCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                if (ImageViewImage.this.image != null) {
                    ImageViewImage.this.showPixelAtCursor(event.x, event.y);
                    if (ImageViewImage.this.selectingOn.booleanValue()) {
                        int width = event.x - ImageViewImage.this.xSelectionStart;
                        int height = event.y - ImageViewImage.this.ySelectionStart;
                        ImageViewImage.this.imageCanvasGC.setForeground(ImageViewImage.this.display.getSystemColor(1));
                        ImageViewImage.this.drawImage(false);
                        ZoomSelection zoomSelection = ImageViewImage.this.iv.getZoomSelection();
                        if (zoomSelection == ZoomSelection.AREA || zoomSelection == ZoomSelection.PROFILE || zoomSelection == ZoomSelection.RELIEF || zoomSelection == ZoomSelection.ROCKINGCURVE) {
                            Rectangle selectedRectangle = new Rectangle(ImageViewImage.this.xSelectionStart, ImageViewImage.this.ySelectionStart, width, height);
                            ImageViewImage.this.imageCanvasGC.setLineWidth(1);
                            ImageViewImage.this.imageCanvasGC.setXORMode(true);
                            ImageViewImage.this.imageCanvasGC.drawRectangle(selectedRectangle);
                            ImageViewImage.this.imageCanvasGC.setXORMode(false);
                        } else if (zoomSelection == ZoomSelection.LINE) {
                            ImageViewImage.this.imageCanvasGC.setXORMode(true);
                            ImageViewImage.this.imageCanvasGC.drawLine(ImageViewImage.this.xSelectionStart, ImageViewImage.this.ySelectionStart, event.x, event.y);
                            ImageViewImage.this.imageCanvasGC.setXORMode(false);
                        }
                    }
                }
            }
        });
        this.imageCanvas.addListener(7, new Listener(){

            public void handleEvent(Event event) {
                ImageViewImage.this.controls.setStatusText("");
                if (ImageViewImage.this.selectingOn.booleanValue()) {
                    ImageViewImage.this.drawImage(false);
                    ImageViewImage.this.selectingOn = false;
                }
            }
        });
        this.imageCanvas.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent ev) {
                switch (ev.keyCode) {
                    case 27: {
                        if (!ImageViewImage.this.selectingOn.booleanValue()) break;
                        ImageViewImage.this.drawImage(false);
                        ImageViewImage.this.selectingOn = false;
                    }
                }
            }
        });
        this.imageCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (ImageViewImage.this.selectingOn.booleanValue()) {
                    ImageViewImage.this.drawImage(false);
                    ImageViewImage.this.selectingOn = false;
                    ImageViewImage.this.selectOn = false;
                }
            }

            public void mouseDown(MouseEvent ev) {
                if (ImageViewImage.this.image == null) {
                    return;
                }
                if (ev.button == 1) {
                    if ((ev.stateMask & 0x40000) != 0) {
                        ImageViewImage.this.selectingOn = false;
                        ImageViewImage.this.selectOn = false;
                        ImageViewImage.this.showZoom(ev, true);
                    } else if ((ev.stateMask & 0x20000) != 0) {
                        ImageViewImage.this.selectingOn = false;
                        ImageViewImage.this.selectOn = false;
                        ImageViewImage.this.showZoom(ev, false);
                    } else if ((ev.stateMask & 0x10000) != 0) {
                        ImageViewImage.this.selectingOn = false;
                        ImageViewImage.this.selectOn = false;
                        ImageViewImage.this.resetZoom();
                    } else {
                        ImageViewImage.this.selectingOn = true;
                        ImageViewImage.this.xSelectionStart = ev.x;
                        ImageViewImage.this.ySelectionStart = ev.y;
                    }
                }
            }

            public void mouseUp(MouseEvent ev) {
                if (ImageViewImage.this.image == null) {
                    return;
                }
                if (!ImageViewImage.this.selectingOn.booleanValue()) {
                    return;
                }
                if (ImageViewImage.this.xSelectionStart != ev.x || ImageViewImage.this.ySelectionStart != ev.y) {
                    ((ImageViewImage)ImageViewImage.this).selectedArea.x = ImageViewImage.this.xSelectionStart;
                    ((ImageViewImage)ImageViewImage.this).selectedArea.y = ImageViewImage.this.ySelectionStart;
                    ((ImageViewImage)ImageViewImage.this).selectedArea.width = ev.x - ((ImageViewImage)ImageViewImage.this).selectedArea.x;
                    ((ImageViewImage)ImageViewImage.this).selectedArea.height = ev.y - ((ImageViewImage)ImageViewImage.this).selectedArea.y;
                    ImageViewImage.this.imageCanvasGC.setForeground(ImageViewImage.this.display.getSystemColor(1));
                    ImageViewImage.this.drawImage(false);
                    ImageViewImage.this.imageChanged = true;
                    ImageViewImage.this.newSelection = true;
                    ImageViewImage.this.showSelection();
                }
                ImageViewImage.this.selectingOn = false;
            }
        });
        this.createDropTarget();
    }

    public void dispose() {
        if (this.imageCanvas != null) {
            this.imageCanvas.dispose();
        }
        if (this.image != null) {
            this.image.dispose();
        }
    }

    public void calculateMainRectangles() {
        this.origRect = this.iv.getImageModel().getRect();
        this.orientedOrigRect.x = 0;
        this.orientedOrigRect.y = 0;
        switch (this.iv.getOrientation()) {
            default: {
                this.orientedRect.x = this.imageRect.x;
                this.orientedRect.y = this.imageRect.y;
                this.orientedRect.width = this.imageRect.width;
                this.orientedRect.height = this.imageRect.height;
                this.orientedOrigRect.width = this.origRect.width;
                this.orientedOrigRect.height = this.origRect.height;
                break;
            }
            case 1: {
                this.orientedRect.x = this.origRect.width - this.imageRect.width - this.imageRect.x;
                this.orientedRect.y = this.imageRect.y;
                this.orientedRect.width = this.imageRect.width;
                this.orientedRect.height = this.imageRect.height;
                this.orientedOrigRect.width = this.origRect.width;
                this.orientedOrigRect.height = this.origRect.height;
                break;
            }
            case 2: {
                this.orientedRect.x = this.imageRect.x;
                this.orientedRect.y = this.origRect.height - this.imageRect.height - this.imageRect.y;
                this.orientedRect.width = this.imageRect.width;
                this.orientedRect.height = this.imageRect.height;
                this.orientedOrigRect.width = this.origRect.width;
                this.orientedOrigRect.height = this.origRect.height;
                break;
            }
            case 3: {
                this.orientedRect.x = this.origRect.width - this.imageRect.width - this.imageRect.x;
                this.orientedRect.y = this.origRect.height - this.imageRect.height - this.imageRect.y;
                this.orientedRect.width = this.imageRect.width;
                this.orientedRect.height = this.imageRect.height;
                this.orientedOrigRect.width = this.origRect.width;
                this.orientedOrigRect.height = this.origRect.height;
                break;
            }
            case 6: {
                this.orientedRect.x = this.imageRect.y;
                this.orientedRect.y = this.imageRect.x;
                this.orientedRect.width = this.imageRect.height;
                this.orientedRect.height = this.imageRect.width;
                this.orientedOrigRect.width = this.origRect.height;
                this.orientedOrigRect.height = this.origRect.width;
                break;
            }
            case 4: {
                this.orientedRect.x = this.imageRect.y;
                this.orientedRect.y = this.origRect.width - this.imageRect.width - this.imageRect.x;
                this.orientedRect.width = this.imageRect.height;
                this.orientedRect.height = this.imageRect.width;
                this.orientedOrigRect.width = this.origRect.height;
                this.orientedOrigRect.height = this.origRect.width;
                break;
            }
            case 5: {
                this.orientedRect.x = this.origRect.height - this.imageRect.height - this.imageRect.y;
                this.orientedRect.y = this.imageRect.x;
                this.orientedRect.width = this.imageRect.height;
                this.orientedRect.height = this.imageRect.width;
                this.orientedOrigRect.width = this.origRect.height;
                this.orientedOrigRect.height = this.origRect.width;
                break;
            }
            case 7: {
                this.orientedRect.x = this.origRect.height - this.imageRect.height - this.imageRect.y;
                this.orientedRect.y = this.origRect.width - this.imageRect.width - this.imageRect.x;
                this.orientedRect.width = this.imageRect.height;
                this.orientedRect.height = this.imageRect.width;
                this.orientedOrigRect.width = this.origRect.height;
                this.orientedOrigRect.height = this.origRect.width;
            }
        }
    }

    public void showSelection() {
        if (!this.selectingOn.booleanValue() && !this.selectOn.booleanValue()) {
            return;
        }
        ZoomSelection zoomSelection = this.iv.getZoomSelection();
        if (zoomSelection == ZoomSelection.AREA || zoomSelection == ZoomSelection.RELIEF || zoomSelection == ZoomSelection.ROCKINGCURVE) {
            this.imageCanvasGC.setXORMode(true);
            this.imageCanvasGC.drawRectangle(this.selectedArea);
            this.imageCanvasGC.setXORMode(false);
            if (this.imageChanged) {
                this.showSelectedArea(this.selectedArea, true);
            }
            this.selectOn = true;
        } else if (zoomSelection == ZoomSelection.LINE) {
            this.imageCanvasGC.setXORMode(true);
            this.imageCanvasGC.drawLine(this.selectedArea.x, this.selectedArea.y, this.selectedArea.x + this.selectedArea.width, this.selectedArea.y + this.selectedArea.height);
            this.imageCanvasGC.setLineWidth(1);
            this.imageCanvasGC.setXORMode(false);
            if (this.imageChanged) {
                this.showSelectedLine();
            }
            this.selectOn = true;
        } else if (zoomSelection == ZoomSelection.PROFILE) {
            this.imageCanvasGC.drawRectangle(this.selectedArea);
            if (this.imageChanged) {
                this.showProfile();
            }
            this.selectOn = true;
        }
        this.newSelection = false;
        this.imageChanged = false;
    }

    public void showZoom(MouseEvent ev, boolean in) {
        if (this.iv == ImageView.mainImageView) {
            return;
        }
        this.setSelectOn(false);
        float scale = in ? 2.0f : 0.5f;
        Rectangle bounds = this.imageCanvas.getBounds();
        int width = (int)((float)bounds.width * scale + 0.5f);
        int height = (int)((float)bounds.height * scale + 0.5f);
        int x = ev.x - width / 2;
        int y = ev.y - height / 2;
        Rectangle rect = new Rectangle(x, y, width, height);
        Rectangle origRect = this.screenRectangleToImageRectangle(rect, true);
        float[] zoomAreaAsFloat = !this.iv.isImageDiffOn() ? this.iv.getImageModel().getData(origRect) : this.iv.getImageDiffModel().getData(origRect);
        if (!this.iv.isImageDiffOn()) {
            this.changeImageRect(origRect, zoomAreaAsFloat, this.iv.getImageModel().getFileName(), this.iv.getImageModel());
        } else {
            this.changeImageRect(origRect, zoomAreaAsFloat, this.iv.getImageModel().getFileName(), this.iv.getImageDiffModel());
        }
    }

    public void resetZoom() {
        if (this.image == null) {
            return;
        }
        this.selectingOn = false;
        this.selectOn = false;
        this.showSelectedArea(this.origRect, false);
    }

    public void showPeaks() {
        Vector<Float> peaks = this.iv.getPeaks();
        if (peaks != null) {
            Color color = this.display.getSystemColor(3);
            this.imageCanvasGC.setForeground(color);
            this.imageCanvasGC.setLineWidth(1);
            Point point = new Point(0, 0);
            int peakMarkerSize = this.iv.getPeakMarkerSize();
            int i = 0;
            while (i < peaks.size() / 2) {
                point = this.tcToScreen(peaks.elementAt(i * 2).floatValue(), peaks.elementAt(i * 2 + 1).floatValue());
                int x = point.x;
                int y = point.y;
                Rectangle rect = new Rectangle(x -= peakMarkerSize / 2, y -= peakMarkerSize / 2, peakMarkerSize, peakMarkerSize);
                this.imageCanvasGC.drawRectangle(rect);
                ++i;
            }
        }
    }

    public void showSelectedPeaks(float[] peaksToColor) {
        this.showPeaks();
        if (peaksToColor != null) {
            Color color = this.display.getSystemColor(5);
            this.imageCanvasGC.setForeground(color);
            this.imageCanvasGC.setLineWidth(1);
            Point point = new Point(0, 0);
            int peakMarkerSize = this.iv.getPeakMarkerSize();
            int i = 0;
            while (i < peaksToColor.length / 2) {
                int index = i * 2;
                point = this.tcToScreen(peaksToColor[index], peaksToColor[index + 1]);
                int x = point.x;
                int y = point.y;
                Rectangle rect = new Rectangle(x -= peakMarkerSize / 2, y -= peakMarkerSize / 2, peakMarkerSize, peakMarkerSize);
                this.imageCanvasGC.drawRectangle(rect);
                ++i;
            }
        }
    }

    void showPixelAtCursor(int mx, int my) {
        if (this.iv.getImageModel() != null) {
            int x4 = (int)((double)mx * this.xScale);
            int y4 = (int)((double)my * this.yScale);
            if (x4 < 0 || x4 >= this.orientedRect.width || y4 < 0 || y4 >= this.orientedRect.height) {
                if (this.controls != null) {
                    this.controls.setStatusText("");
                }
                return;
            }
            Point p = this.orientedToImage(new Point(x4, y4));
            int x1 = p.x;
            int y1 = p.y;
            if (x1 < 0 || x1 >= this.iv.getImageModel().getWidth() || y1 < 0 || y1 >= this.iv.getImageModel().getHeight()) {
                this.controls.setStatusText("");
                return;
            }
            float pixel = 0.0f;
            pixel = !this.iv.isImageDiffOn() ? this.iv.getImageModel().getData(y1, x1) : this.iv.getImageDiffModel().getData(y1, x1);
            if (this.controls != null) {
                this.controls.setStatusText(this.iv.getCoordinates().getCoordinateString(x4 + this.orientedRect.x, y4 + this.orientedRect.y, pixel));
            }
        }
    }

    void showSelectedArea(Rectangle rect, boolean screen) {
        Rectangle origRect = screen ? this.screenRectangleToImageRectangle(rect, true) : rect;
        try {
            float[] zoomAreaAsFloat;
            float[] statistics = null;
            if (!this.iv.isImageDiffOn()) {
                zoomAreaAsFloat = this.iv.getImageModel().getData(origRect);
                statistics = this.iv.getImageModel().getStatistics(origRect);
            } else {
                zoomAreaAsFloat = this.iv.getImageDiffModel().getData(origRect);
                statistics = this.iv.getImageDiffModel().getStatistics(origRect);
            }
            float areaMinimum = statistics[0];
            float areaMaximum = statistics[1];
            float areaMean = statistics[2];
            ZoomSelection zoomSelection = this.iv.getZoomSelection();
            if (zoomSelection == ZoomSelection.AREA) {
                IViewReference viewReference;
                if (this.newSelection.booleanValue()) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", "100", 1);
                }
                if ((viewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ImageView", "100")) != null) {
                    this.zoomAreaView = (ImageView)viewReference.getView(true);
                    if (this.zoomAreaView != null) {
                        this.zoomAreaView.getImage().setSelectOn(false);
                        if (!this.iv.isImageDiffOn()) {
                            this.zoomAreaView.getImage().changeImageRect(origRect, zoomAreaAsFloat, this.iv.getImageModel().getFileName(), this.iv.getImageModel());
                            this.zoomAreaView.setPartName("Zoom Area " + this.iv.getFileName());
                        } else {
                            this.zoomAreaView.getImage().changeImageRect(origRect, zoomAreaAsFloat, this.iv.getImageModel().getFileName(), this.iv.getImageDiffModel());
                            this.zoomAreaView.setPartName("Zoom Diff " + this.iv.getFileName());
                        }
                        this.zoomAreaView.stopListening();
                        this.zoomAreaView.setViewType(ImageViewType.IMAGE_ZOOM_VIEW);
                        this.zoomAreaView.transferSelectedSettings(this.iv);
                    }
                }
            } else if (zoomSelection == ZoomSelection.RELIEF) {
                IViewReference viewReference;
                if (this.newSelection.booleanValue()) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ReliefView", "0", 1);
                }
                if ((viewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ReliefView", "0")) != null) {
                    this.zoomReliefView = (ReliefView)viewReference.getView(true);
                    if (this.zoomReliefView != null) {
                        this.zoomReliefView.setImageAsFloat(zoomAreaAsFloat, origRect.width, origRect.height, areaMinimum, areaMaximum, areaMean, this.iv.getImageModel().getFileName());
                    }
                }
            } else if (zoomSelection == ZoomSelection.ROCKINGCURVE) {
                IViewReference viewReference;
                if (this.newSelection.booleanValue()) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.RockingCurveView", "0", 1);
                }
                if ((viewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.RockingCurveView", "0")) != null) {
                    this.zoomRockingCurveView = (RockingCurveView)viewReference.getView(true);
                    if (this.zoomRockingCurveView != null) {
                        int x2 = origRect.width == 0 ? origRect.x : origRect.x + origRect.width - 1;
                        int y2 = origRect.height == 0 ? origRect.y : origRect.y + origRect.height - 1;
                        this.zoomRockingCurveView.setCenterArea("Rocking Curve " + this.iv.getFileName(), SampleController.getController().getCurrentFileIndex(), origRect.x, origRect.y, x2, y2);
                    }
                }
            }
        }
        catch (PartInitException ex) {
            FableUtils.excMsg((Object)this, (String)"Unable to show selected area", (Throwable)ex);
        }
    }

    void showSelectedLine() {
        Rectangle lineRect = this.screenRectangleToOrientedImageRectangle(this.selectedArea, false);
        int x1 = lineRect.x;
        int y1 = lineRect.y;
        int x2 = lineRect.x + lineRect.width - 1;
        int y2 = lineRect.y + lineRect.height - 1;
        Point p = new Point(0, 0);
        double[] vals = new double[]{0.0, 0.0};
        boolean inverted = false;
        try {
            IViewReference viewReference;
            int i;
            float[] intensity;
            float[] pixels;
            int len;
            String yTitle;
            String xTitle;
            float slope = Float.NaN;
            if (Math.abs(x2 - x1) >= Math.abs(y2 - y1)) {
                xTitle = "Pixels in " + this.iv.getCoordinates().getXName();
                yTitle = "Intensity";
                float half = 0.5f * (float)this.iv.getCoordinates().getPixelWidth();
                inverted = this.iv.getCoordinates().isXInverted();
                if (x2 < x1) {
                    int temp = x1;
                    x1 = x2;
                    x2 = temp;
                    temp = y1;
                    y1 = y2;
                    y2 = temp;
                }
                len = x2 - x1 + 1;
                pixels = new float[2 * len + 2];
                intensity = new float[2 * len + 2];
                intensity[2 * len + 1] = 0.0f;
                intensity[0] = 0.0f;
                if (x2 - x1 != 0) {
                    slope = (float)(y2 - y1) / (float)(x2 - x1);
                }
                this.logger.debug((Object)("slope " + slope));
                i = 0;
                while (i < len) {
                    int idx = 2 * i + 1;
                    int x = x1 + i;
                    int y = (int)((double)((float)y1 + slope * (float)i) + 0.5);
                    if (y < 0) {
                        y = 0;
                    }
                    if (y > this.orientedOrigRect.height - 1) {
                        y = this.orientedOrigRect.height - 1;
                    }
                    p.x = x + this.orientedRect.x;
                    p.y = y + this.orientedRect.y;
                    vals = this.iv.getCoordinates().getCoordinatesFromOriented(p);
                    float val = (float)vals[0];
                    if (i == 0) {
                        pixels[0] = val - half;
                    }
                    pixels[idx] = val - half;
                    pixels[idx + 1] = val + half;
                    if (i == len - 1) {
                        pixels[idx + 2] = val + half;
                    }
                    p.x = x;
                    p.y = y;
                    p = this.orientedToImage(p);
                    val = !this.iv.isImageDiffOn() ? this.iv.getImageModel().getData(p.y, p.x) : this.iv.getImageDiffModel().getData(p.y, p.x);
                    intensity[idx] = val;
                    intensity[idx + 1] = val;
                    ++i;
                }
            } else {
                xTitle = "Pixels in " + this.iv.getCoordinates().getYName();
                yTitle = "Intensity";
                inverted = this.iv.getCoordinates().isYInverted();
                float half = 0.5f * (float)this.iv.getCoordinates().getPixelHeight();
                if (y2 < y1) {
                    int temp = x1;
                    x1 = x2;
                    x2 = temp;
                    temp = y1;
                    y1 = y2;
                    y2 = temp;
                }
                len = y2 - y1 + 1;
                pixels = new float[2 * len + 2];
                intensity = new float[2 * len + 2];
                intensity[2 * len + 1] = 0.0f;
                intensity[0] = 0.0f;
                if (x2 - x1 != 0) {
                    slope = (float)(y2 - y1) / (float)(x2 - x1);
                }
                this.logger.debug((Object)("slope " + slope));
                i = 0;
                while (i < len) {
                    int idx = 2 * i + 1;
                    int y = y1 + i;
                    int x = x2 - x1 != 0 ? (int)((double)((float)x1 + (float)i / slope) + 0.5) : x1;
                    if (x < 0) {
                        x = 0;
                    }
                    if (x > this.orientedOrigRect.width - 1) {
                        x = this.orientedOrigRect.width - 1;
                    }
                    p.x = x + this.orientedRect.x;
                    p.y = y + this.orientedRect.y;
                    vals = this.iv.getCoordinates().getCoordinatesFromOriented(p);
                    float val = (float)vals[1];
                    if (i == 0) {
                        pixels[0] = val - half;
                    }
                    pixels[idx] = val - half;
                    pixels[idx + 1] = val + half;
                    if (i == len - 1) {
                        pixels[idx + 2] = val + half;
                    }
                    p.x = x;
                    p.y = y;
                    p = this.orientedToImage(p);
                    val = !this.iv.isImageDiffOn() ? this.iv.getImageModel().getData(p.y, p.x) : this.iv.getImageDiffModel().getData(p.y, p.x);
                    intensity[idx] = val;
                    intensity[idx + 1] = val;
                    this.logger.setLevel(Level.ERROR);
                    ++i;
                }
            }
            if (this.newSelection.booleanValue()) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.LineView", "0", 1);
            }
            if ((viewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.LineView", "0")) != null) {
                this.lineView = (LineView)viewReference.getView(true);
                if (this.lineView != null) {
                    String from = "unknown";
                    String to = "unknown";
                    p.x = x1 + this.orientedRect.x;
                    p.y = y1 + this.orientedRect.y;
                    from = this.iv.getCoordinates().getCoordinateString(p.x, p.y);
                    p.x = x2 + this.orientedRect.x;
                    p.y = y2 + this.orientedRect.y;
                    to = this.iv.getCoordinates().getCoordinateString(p.x, p.y);
                    xTitle = String.valueOf(xTitle) + " from (" + from + ") to (" + to + ") for " + this.iv.getCoordinatesName();
                    this.lineView.setData(this.iv.getFileName(), xTitle, inverted, pixels, yTitle, intensity);
                }
            }
        }
        catch (PartInitException ex) {
            FableUtils.excMsg((Object)this, (String)"Unable to show selected line", (Throwable)ex);
        }
    }

    void showProfile() {
        int temp;
        Rectangle lineRect = this.screenRectangleToOrientedImageRectangle(this.selectedArea, true);
        int x1 = lineRect.x;
        int y1 = lineRect.y;
        int x2 = lineRect.x + lineRect.width - 1;
        int y2 = lineRect.y + lineRect.height - 1;
        if (x1 > x2) {
            temp = y1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 > y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        try {
            IViewReference viewReference;
            float val;
            int idx;
            String xTitle = "Pixels in " + this.iv.getCoordinates().getXName();
            String yTitle = "Pixels in " + this.iv.getCoordinates().getYName();
            boolean xInverted = this.iv.getCoordinates().isXInverted();
            boolean yInverted = this.iv.getCoordinates().isYInverted();
            double[] vals = new double[]{0.0, 0.0};
            int lenx = x2 - x1 + 1;
            float[] pixels_x = new float[2 * lenx + 2];
            float[] intensity_x = new float[2 * lenx + 2];
            float half = 0.5f * (float)this.iv.getCoordinates().getPixelWidth();
            pixels_x[0] = (float)x1 - half;
            pixels_x[2 * lenx + 1] = (float)x2 + half;
            intensity_x[2 * lenx + 1] = 0.0f;
            intensity_x[0] = 0.0f;
            Point p = new Point(0, 0);
            Point po = new Point(0, 0);
            int i = 0;
            while (i < lenx) {
                idx = 2 * i + 1;
                p.x = x1 + i + this.orientedRect.x;
                p.y = y1 + this.orientedRect.y;
                vals = this.iv.getCoordinates().getCoordinatesFromOriented(p);
                val = (float)vals[0];
                if (i == 0) {
                    pixels_x[0] = val - half;
                }
                pixels_x[idx] = val - half;
                pixels_x[idx + 1] = val + half;
                if (i == lenx - 1) {
                    pixels_x[idx + 2] = val + half;
                }
                intensity_x[idx + 1] = 0.0f;
                intensity_x[idx] = 0.0f;
                p.x = x1 + i;
                int j = y1;
                while (j <= y2) {
                    p.y = j;
                    po = this.orientedToImage(p);
                    val = !this.iv.isImageDiffOn() ? this.iv.getImageModel().getData(po.y, po.x) : this.iv.getImageDiffModel().getData(po.y, po.x);
                    int n = idx;
                    intensity_x[n] = intensity_x[n] + val;
                    int n2 = idx + 1;
                    intensity_x[n2] = intensity_x[n2] + val;
                    ++j;
                }
                ++i;
            }
            int leny = y2 - y1 + 1;
            float[] pixels_y = new float[2 * leny + 2];
            float[] intensity_y = new float[2 * leny + 2];
            half = 0.5f * (float)this.iv.getCoordinates().getPixelHeight();
            pixels_y[0] = (float)y1 - half;
            pixels_y[2 * leny + 1] = (float)y2 + half;
            intensity_y[2 * leny + 1] = 0.0f;
            intensity_y[0] = 0.0f;
            int i2 = 0;
            while (i2 < leny) {
                idx = 2 * i2 + 1;
                p.x = x1 + this.orientedRect.x;
                p.y = y1 + i2 + this.orientedRect.y;
                vals = this.iv.getCoordinates().getCoordinatesFromOriented(p);
                val = (float)vals[1];
                if (i2 == 0) {
                    pixels_y[0] = val - half;
                }
                pixels_y[idx] = val - half;
                pixels_y[idx + 1] = val + half;
                if (i2 == leny - 1) {
                    pixels_y[idx + 2] = val + half;
                }
                intensity_y[idx + 1] = 0.0f;
                intensity_y[idx] = 0.0f;
                p.y = y1 + i2;
                int j = x1;
                while (j <= x2) {
                    p.x = j;
                    po = this.orientedToImage(p);
                    val = !this.iv.isImageDiffOn() ? this.iv.getImageModel().getData(po.y, po.x) : this.iv.getImageDiffModel().getData(po.y, po.x);
                    int n = idx;
                    intensity_y[n] = intensity_y[n] + val;
                    int n3 = idx + 1;
                    intensity_y[n3] = intensity_y[n3] + val;
                    ++j;
                }
                ++i2;
            }
            if (this.newSelection.booleanValue()) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ProfileView", "0", 1);
            }
            if ((viewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ProfileView", "0")) != null) {
                this.profileView = (ProfileView)viewReference.getView(true);
                if (this.profileView != null) {
                    this.profileView.setData(this.iv.getFileName(), xTitle, yTitle, xInverted, yInverted, pixels_x, intensity_x, pixels_y, intensity_y);
                }
            }
        }
        catch (PartInitException ex) {
            FableUtils.excMsg((Object)this, (String)"Unable to show profile", (Throwable)ex);
        }
    }

    public void changeImageRect(Rectangle rect, float[] areaAsFloat, String fileName, ImageModel _imageModel) {
        if (this.imageRect.width != rect.width || this.imageRect.height != rect.height) {
            this.clearCanvas();
        } else {
            this.selectingOn = false;
            this.selectOn = false;
        }
        if (_imageModel == null) {
            this.iv.setImageModel(new ImageModel(fileName, rect.width, rect.height, areaAsFloat));
        } else if (_imageModel != this.iv.getImageModel()) {
            this.iv.setImageModel(_imageModel);
        }
        this.imageRect = rect;
        this.calculateMainRectangles();
        this.iv.resetCoordinates();
        float[] statistics = this.iv.getImageModel().getStatistics(this.imageRect);
        this.iv.setStatistics(statistics);
    }

    public void displayImage() {
        float max;
        float min;
        if (this.iv.getImageModel() == null || this.iv.getImageModel().getData() == null) {
            return;
        }
        if (this.iv.getAutoscale()) {
            min = this.iv.getMinimum();
            max = this.iv.getMaximum();
        } else {
            min = this.iv.getUserMinimum();
            max = this.iv.getUserMaximum();
        }
        this.imageData = this.createImageData(min, max, this.iv.getPalette());
        this.createScreenImage(this.imageData);
        this.drawImage(true);
        this.imageChanged = false;
    }

    public ImageData createImageData(float _minimum, float _maximum, PaletteData palette) {
        float maxPixel;
        float scale_8bit;
        float[] screenImageData = !this.iv.isImageDiffOn() ? this.iv.getImageModel().getData(this.imageRect) : this.iv.getImageDiffModel().getData(this.imageRect);
        int len = screenImageData.length;
        if (len == 0) {
            return null;
        }
        this.calculateMainRectangles();
        this.iv.resetCoordinates();
        if (_maximum > _minimum) {
            scale_8bit = 255.0f / (_maximum - _minimum);
            maxPixel = _maximum - _minimum;
        } else {
            scale_8bit = 1.0f;
            maxPixel = 255.0f;
        }
        byte[] scaledImageAsByte = new byte[len];
        Point p2 = new Point(0, 0);
        int i = 0;
        while (i < len) {
            float scaled_pixel = screenImageData[i] < _minimum ? 0.0f : (screenImageData[i] >= _maximum ? maxPixel : screenImageData[i] - _minimum);
            byte pixel = (byte)(0xFF & (int)(scaled_pixel *= scale_8bit));
            p2.x = i % this.imageRect.width;
            p2.y = i / this.imageRect.width;
            Point p1 = this.imageToOriented(p2);
            int index = p1.y * this.orientedRect.width + p1.x;
            scaledImageAsByte[index] = pixel;
            ++i;
        }
        ImageData imageData = new ImageData(this.orientedRect.width, this.orientedRect.height, 8, palette, 1, scaledImageAsByte);
        return imageData;
    }

    public Image createScreenImage(ImageData data) {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
            this.image = null;
        }
        Rectangle bounds = this.imageCanvas.getBounds();
        this.xScale = (double)this.orientedRect.width / (double)bounds.width;
        this.yScale = (double)this.orientedRect.height / (double)bounds.height;
        if (this.iv.isKeepAspect()) {
            if (this.xScale > this.yScale) {
                this.yScale = this.xScale;
            } else {
                this.xScale = this.yScale;
            }
        }
        if ((double)this.orientedRect.width / this.xScale < 1.0) {
            this.xScale = (double)this.orientedRect.width / (double)bounds.width;
        }
        if ((double)this.orientedRect.height / this.yScale < 1.0) {
            this.yScale = (double)this.orientedRect.height / (double)bounds.height;
        }
        int xscaledTo = (int)((double)this.orientedRect.width / this.xScale);
        int yscaledTo = (int)((double)this.orientedRect.height / this.yScale);
        if (data == null) {
            this.logger.debug((Object)"data is null !");
            this.image = null;
        } else {
            this.image = new Image((Device)Display.getCurrent(), data.scaledTo(xscaledTo, yscaledTo));
        }
        return this.image;
    }

    void drawImage(boolean doSelection) {
        if (this.imageCanvasGC == null || this.image == null) {
            return;
        }
        this.imageCanvasGC.drawImage(this.image, 0, 0);
        if (this.iv.isPeaksOn()) {
            this.showPeaks();
        }
        if (doSelection && this.selectOn.booleanValue()) {
            this.showSelection();
        }
    }

    private void createDropTarget() {
        DropTarget dropTarget = new DropTarget((Control)this.imageCanvas, 17);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        dropTarget.setTransfer(types);
        dropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                String text;
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType) && (text = (String)event.data).startsWith("samplefile")) {
                    ImageViewImage.this.iv.dropFile();
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
    }

    public Point orientedToImage(Point point) {
        int x3 = point.x + this.orientedRect.x;
        int y3 = point.y + this.orientedRect.y;
        int x2 = x3;
        int y2 = y3;
        switch (this.iv.getOrientation()) {
            default: {
                break;
            }
            case 1: {
                x2 = this.orientedOrigRect.width - x3 - 1;
                break;
            }
            case 2: {
                y2 = this.orientedOrigRect.height - y3 - 1;
                break;
            }
            case 3: {
                x2 = this.orientedOrigRect.width - x3 - 1;
                y2 = this.orientedOrigRect.height - y3 - 1;
                break;
            }
            case 6: {
                x2 = y3;
                y2 = x3;
                break;
            }
            case 4: {
                x2 = this.orientedOrigRect.height - y3 - 1;
                y2 = x3;
                break;
            }
            case 5: {
                x2 = y3;
                y2 = this.orientedOrigRect.width - x3 - 1;
                break;
            }
            case 7: {
                x2 = this.orientedOrigRect.height - y3 - 1;
                y2 = this.orientedOrigRect.width - x3 - 1;
            }
        }
        Point converted = new Point(x2, y2);
        return converted;
    }

    public Point imageToOriented(Point point) {
        int x2 = point.x;
        int y2 = point.y;
        int x3 = x2;
        int y3 = y2;
        switch (this.iv.getOrientation()) {
            default: {
                break;
            }
            case 1: {
                x3 = this.imageRect.width - x2 - 1;
                break;
            }
            case 2: {
                y3 = this.imageRect.height - y2 - 1;
                break;
            }
            case 3: {
                x3 = this.imageRect.width - x2 - 1;
                y3 = this.imageRect.height - y2 - 1;
                break;
            }
            case 6: {
                x3 = y2;
                y3 = x2;
                break;
            }
            case 5: {
                x3 = this.imageRect.height - y2 - 1;
                y3 = x2;
                break;
            }
            case 4: {
                x3 = y2;
                y3 = this.imageRect.width - x2 - 1;
                break;
            }
            case 7: {
                x3 = this.imageRect.height - y2 - 1;
                y3 = this.imageRect.width - x2 - 1;
            }
        }
        return new Point(x3, y3);
    }

    public float[] imageToOriented(float[] point) {
        float x2 = point[0];
        float y2 = point[1];
        float x3 = x2;
        float y3 = y2;
        switch (this.iv.getOrientation()) {
            default: {
                break;
            }
            case 1: {
                x3 = (float)this.imageRect.width - x2 - 1.0f;
                break;
            }
            case 2: {
                y3 = (float)this.imageRect.height - y2 - 1.0f;
                break;
            }
            case 3: {
                x3 = (float)this.imageRect.width - x2 - 1.0f;
                y3 = (float)this.imageRect.height - y2 - 1.0f;
                break;
            }
            case 6: {
                x3 = y2;
                y3 = x2;
                break;
            }
            case 5: {
                x3 = (float)this.imageRect.height - y2 - 1.0f;
                y3 = x2;
                break;
            }
            case 4: {
                x3 = y2;
                y3 = (float)this.imageRect.width - x2 - 1.0f;
                break;
            }
            case 7: {
                x3 = (float)this.imageRect.height - y2 - 1.0f;
                y3 = (float)this.imageRect.width - x2 - 1.0f;
            }
        }
        return new float[]{x3, y3};
    }

    public Rectangle screenRectangleToImageRectangle(Rectangle screenRect, boolean ordered) {
        int x0 = screenRect.x - this.imageData.x;
        int y0 = screenRect.y - this.imageData.y;
        int x1 = (int)((double)x0 * this.xScale);
        int y1 = (int)((double)y0 * this.yScale);
        int x2 = screenRect.width != 0 ? (int)((double)(x0 + screenRect.width - 1) * this.xScale) : x1;
        int y2 = screenRect.height != 0 ? (int)((double)(y0 + screenRect.height - 1) * this.yScale) : y1;
        Point p1 = this.orientedToImage(new Point(x1, y1));
        Point p2 = this.orientedToImage(new Point(x2, y2));
        x1 = p1.x;
        y1 = p1.y;
        x2 = p2.x;
        y2 = p2.y;
        if (ordered) {
            int temp;
            if (x1 > x2) {
                temp = x1;
                x1 = x2;
                x2 = temp;
            }
            if (y1 > y2) {
                temp = y1;
                y1 = y2;
                y2 = temp;
            }
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (x1 >= this.origRect.width) {
            x1 = this.origRect.width - 1;
        }
        if (x2 < 0) {
            x2 = 0;
        }
        if (x2 >= this.origRect.width) {
            x2 = this.origRect.width - 1;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (y1 >= this.origRect.height) {
            y1 = this.origRect.height - 1;
        }
        if (y2 < 0) {
            y2 = 0;
        }
        if (y2 >= this.origRect.height) {
            y2 = this.origRect.height - 1;
        }
        int width = x2 - x1 + 1;
        int height = y2 - y1 + 1;
        Rectangle newRect = new Rectangle(x1, y1, width, height);
        return newRect;
    }

    public Rectangle screenRectangleToOrientedImageRectangle(Rectangle screenRect, boolean ordered) {
        int x0 = screenRect.x - this.imageData.x;
        int y0 = screenRect.y - this.imageData.y;
        int x1 = (int)((double)x0 * this.xScale);
        int y1 = (int)((double)y0 * this.yScale);
        int x2 = screenRect.width != 0 ? (int)((double)(x0 + screenRect.width - 1) * this.xScale) : x1;
        int y2 = screenRect.height != 0 ? (int)((double)(y0 + screenRect.height - 1) * this.yScale) : y1;
        if (ordered) {
            int temp;
            if (x1 > x2) {
                temp = x1;
                x1 = x2;
                x2 = temp;
            }
            if (y1 > y2) {
                temp = y1;
                y1 = y2;
                y2 = temp;
            }
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (x1 >= this.orientedRect.width) {
            x1 = this.orientedRect.width - 1;
        }
        if (x2 < 0) {
            x2 = 0;
        }
        if (x2 >= this.orientedRect.width) {
            x2 = this.orientedRect.width - 1;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (y1 >= this.orientedRect.height) {
            y1 = this.orientedRect.height - 1;
        }
        if (y2 < 0) {
            y2 = 0;
        }
        if (y2 >= this.orientedRect.height) {
            y2 = this.orientedRect.height - 1;
        }
        int width = x2 - x1 + 1;
        int height = y2 - y1 + 1;
        Rectangle newRect = new Rectangle(x1, y1, width, height);
        return newRect;
    }

    public Point tcToScreen(float tcY, float tcZ) {
        float x = tcY - (float)this.imageRect.x;
        float y = tcZ - (float)this.imageRect.y;
        float[] oriented = this.imageToOriented(new float[]{x, y});
        Point point = new Point((int)((double)oriented[0] / this.xScale), (int)((double)oriented[1] / this.yScale));
        return point;
    }

    public void clearCanvas() {
        if (this.imageCanvas != null && this.imageCanvasGC != null) {
            Rectangle bounds = this.imageCanvas.getBounds();
            this.imageCanvasGC.fillRectangle(0, 0, bounds.width, bounds.height);
        }
    }

    public Rectangle getSelectedArea() {
        return this.selectedArea;
    }

    public void selectZoom(ZoomSelection zoomselect) {
        this.logger.debug((Object)("set zoom to " + zoomselect.getName()));
        this.iv.setZoomSelection(zoomselect);
        this.selectingOn = false;
        this.selectOn = false;
    }

    public boolean isImageChanged() {
        return this.imageChanged;
    }

    public void setImageChanged(boolean imageChanged) {
        this.imageChanged = imageChanged;
    }

    public Rectangle getImageRect() {
        return this.imageRect;
    }

    public void setImageRect(Rectangle imageRect) {
        this.imageRect = imageRect;
    }

    public Rectangle getOrigRect() {
        return this.origRect;
    }

    public Rectangle getOrientedOrigRect() {
        return this.orientedOrigRect;
    }

    public Rectangle getOrientedRect() {
        return this.orientedRect;
    }

    public Boolean getSelectOn() {
        return this.selectOn;
    }

    public void setSelectOn(Boolean selectOn) {
        this.selectOn = selectOn;
    }

    public Image getImage() {
        return this.image;
    }
}

