/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.model;

import fable.imageviewer.model.ImageModelEvent;
import fable.imageviewer.model.ImageModelListener;
import fable.python.FabioFile;
import java.util.EventListener;
import javax.swing.event.EventListenerList;
import jep.JepException;
import org.eclipse.swt.graphics.Rectangle;

public class ImageModel {
    private EventListenerList listenerList = new EventListenerList();
    private String fileName = null;
    private int width = 0;
    private int height = 0;
    private float[] data = null;
    private float[] statistics = null;
    public static final String DATA_CHANGED = String.valueOf(ImageModel.class.getName()) + ".DataChanged";
    public static final String RESET = String.valueOf(ImageModel.class.getName()) + ".Reset";

    public ImageModel() {
    }

    public ImageModel(FabioFile fabioFile) throws JepException {
        this();
        this.reset(fabioFile);
    }

    public ImageModel(String fileName, int width, int height, float[] data) {
        this();
        this.reset(fileName, width, height, data);
    }

    public void addImageModelListener(ImageModelListener l) {
        this.listenerList.add(ImageModelListener.class, l);
    }

    public void removeImageModelListener(ImageModelListener l) {
        this.listenerList.remove(ImageModelListener.class, l);
    }

    public void removeAllImageModelListeners(ImageModelListener l) {
        EventListener[] listeners;
        EventListener[] eventListenerArray = listeners = this.listenerList.getListeners(ImageModelListener.class);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            EventListener listener = eventListenerArray[n2];
            this.listenerList.remove(ImageModelListener.class, (ImageModelListener)listener);
            ++n2;
        }
    }

    protected void fireImageModelEvent(String name, Object oldValue, Object newValue) {
        EventListener[] listeners;
        EventListener[] eventListenerArray = listeners = this.listenerList.getListeners(ImageModelListener.class);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            EventListener listener = eventListenerArray[n2];
            ImageModelEvent imageModelEvent = new ImageModelEvent(this, name, oldValue, newValue);
            ((ImageModelListener)listener).propertyChange(imageModelEvent);
            ++n2;
        }
    }

    public void reset(FabioFile fabioFile) throws JepException {
        try {
            this.statistics = null;
            this.fileName = fabioFile.getFileName();
            this.width = fabioFile.getWidth();
            this.height = fabioFile.getHeight();
            this.data = fabioFile.getImageAsFloat();
        }
        finally {
            this.fireImageModelEvent(RESET, this, this);
        }
    }

    public void reset(String fileName, int width, int height, float[] data) {
        this.statistics = null;
        this.fileName = fileName;
        this.width = width;
        this.height = height;
        this.data = data;
        this.fireImageModelEvent(RESET, this, this);
    }

    private void calculateStatistics() {
        this.statistics = null;
        if (this.data == null) {
            return;
        }
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        float mean = 0.0f;
        float sum = 0.0f;
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width) {
                float val = this.data[i + j * this.width];
                sum += val;
                if (val < min) {
                    min = val;
                }
                if (val > max) {
                    max = val;
                }
                ++i;
            }
            ++j;
        }
        mean = sum / (float)(this.width * this.height);
        this.statistics = new float[]{min, max, mean};
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle getRect() {
        return new Rectangle(0, 0, this.width, this.height);
    }

    public float[] getStatistics() {
        if (this.statistics == null) {
            this.calculateStatistics();
        }
        return this.statistics;
    }

    public float[] getStatistics(Rectangle rect) {
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        float mean = 0.0f;
        float sum = 0.0f;
        int j = 0;
        while (j < rect.height) {
            int i = 0;
            while (i < rect.width) {
                float val = this.data[rect.x + i + (rect.y + j) * this.width];
                sum += val;
                if (val < min) {
                    min = val;
                }
                if (val > max) {
                    max = val;
                }
                ++i;
            }
            ++j;
        }
        mean = sum / (float)(rect.width * rect.height);
        return new float[]{min, max, mean};
    }

    public float[] getData() {
        return this.data;
    }

    public float getData(int row, int col) {
        if (this.data == null) {
            return Float.NaN;
        }
        return this.data[col + row * this.width];
    }

    public float getData(int row, int col, Rectangle rect) {
        if (this.data == null) {
            return Float.NaN;
        }
        int index1 = col + row * rect.width;
        int col1 = index1 % this.width;
        int row1 = index1 / this.width;
        return this.data[col1 + row1 * this.width];
    }

    public float[] getData(Rectangle rect) {
        if (this.data == null) {
            return null;
        }
        float[] array = new float[rect.width * rect.height];
        int j = 0;
        while (j < rect.height) {
            int i = 0;
            while (i < rect.width) {
                array[i + j * rect.width] = this.data[rect.x + i + (rect.y + j) * this.width];
                ++i;
            }
            ++j;
        }
        return array;
    }

    public void setData(float[] data) {
        float[] oldValue = this.data;
        if (data != oldValue) {
            this.statistics = null;
            this.data = data;
            this.fireImageModelEvent(DATA_CHANGED, oldValue, data);
        }
    }
}

