/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.internal;

import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class PaletteUtils {
    public static PaletteData makeGrayScalePalette() {
        RGB[] grayscale = new RGB[256];
        int i = 0;
        while (i < 256) {
            grayscale[i] = new RGB(i, i, i);
            ++i;
        }
        return new PaletteData(grayscale);
    }

    public static PaletteData makeColorPalette() {
        RGB[] color = new RGB[256];
        color[0] = new RGB(0, 0, 0);
        int i = 1;
        int j = 0;
        while (j < 3) {
            int k = 1;
            while (k <= 85) {
                color[i] = j == 0 ? new RGB(0, 0, k * 3) : (j == 1 ? new RGB(0, k * 3, 3) : new RGB(k * 3, 0, 0));
                ++i;
                ++k;
            }
            ++j;
        }
        return new PaletteData(color);
    }

    public static PaletteData makeRainbow1Palette() {
        RGB[] rainbow = new RGB[256];
        RGB[] colorVal = new RGB[]{new RGB(200, 0, 250), new RGB(40, 40, 255), new RGB(40, 255, 40), new RGB(250, 250, 0), new RGB(255, 0, 0)};
        double[] colorPos = new double[]{0.0, 0.25, 0.5, 0.75, 1.0};
        int nb = 256;
        int colId = 0;
        int i = 0;
        while (i < nb) {
            double r = (double)i / (double)nb;
            if (colId < colorPos.length - 2 && r >= colorPos[colId + 1]) {
                ++colId;
            }
            double r1 = colorVal[colId].red;
            double g1 = colorVal[colId].green;
            double b1 = colorVal[colId].blue;
            double r2 = colorVal[colId + 1].red;
            double g2 = colorVal[colId + 1].green;
            double b2 = colorVal[colId + 1].blue;
            double rr = (r - colorPos[colId]) / (colorPos[colId + 1] - colorPos[colId]);
            if (rr < 0.0) {
                rr = 0.0;
            }
            if (rr > 1.0) {
                rr = 1.0;
            }
            rainbow[i] = new RGB((int)(r1 + (r2 - r1) * rr), (int)(g1 + (g2 - g1) * rr), (int)(b1 + (b2 - b1) * rr));
            ++i;
        }
        return new PaletteData(rainbow);
    }

    public static PaletteData makeRainbow2Palette() {
        RGB[] rainbow = new RGB[256];
        double nGroups = 5.0;
        double nMembers = 45.0;
        double nTotal = nGroups * nMembers;
        double high = 1.0;
        double medium = 0.375;
        int nColors = 256;
        int index = 0;
        while (index < 256) {
            int blue;
            int green;
            double b;
            double g;
            double r;
            double h = (double)index / (double)nColors;
            double hx = h * nTotal;
            double deltax = (high - medium) / nMembers;
            int gh = (int)Math.floor(hx / nMembers);
            int ih = (int)Math.floor(hx);
            switch (gh) {
                case 0: {
                    r = medium;
                    g = medium + ((double)ih - (double)gh * nMembers) * deltax;
                    b = high;
                    break;
                }
                case 1: {
                    r = medium;
                    g = high;
                    b = high - ((double)ih - (double)gh * nMembers) * deltax;
                    break;
                }
                case 2: {
                    r = medium + ((double)ih - (double)gh * nMembers) * deltax;
                    g = high;
                    b = medium;
                    break;
                }
                case 3: {
                    r = high;
                    g = high - ((double)ih - (double)gh * nMembers) * deltax;
                    b = medium;
                    break;
                }
                case 4: {
                    r = high;
                    g = medium;
                    b = medium + ((double)ih - (double)gh * nMembers) * deltax;
                    break;
                }
                default: {
                    r = high;
                    g = medium;
                    b = high;
                }
            }
            int red = (int)(r * 255.0 + 0.5);
            if (red > 255) {
                red = 255;
            }
            if ((green = (int)(g * 255.0 + 0.5)) > 255) {
                green = 255;
            }
            if ((blue = (int)(b * 255.0 + 0.5)) > 255) {
                blue = 255;
            }
            rainbow[index] = new RGB(red, green, blue);
            ++index;
        }
        return new PaletteData(rainbow);
    }

    public static PaletteData makeBluesPalette() {
        RGB[] blues = new RGB[]{new RGB(247, 251, 255), new RGB(246, 250, 254), new RGB(245, 249, 254), new RGB(244, 249, 254), new RGB(243, 248, 253), new RGB(243, 248, 253), new RGB(242, 247, 253), new RGB(241, 247, 253), new RGB(240, 246, 252), new RGB(239, 246, 252), new RGB(239, 245, 252), new RGB(238, 245, 252), new RGB(237, 244, 251), new RGB(236, 244, 251), new RGB(236, 243, 251), new RGB(235, 243, 251), new RGB(234, 242, 250), new RGB(233, 242, 250), new RGB(232, 241, 250), new RGB(232, 241, 250), new RGB(231, 240, 249), new RGB(230, 240, 249), new RGB(229, 239, 249), new RGB(228, 239, 249), new RGB(228, 238, 248), new RGB(227, 238, 248), new RGB(226, 237, 248), new RGB(225, 237, 248), new RGB(225, 236, 247), new RGB(224, 236, 247), new RGB(223, 235, 247), new RGB(222, 235, 247), new RGB(221, 234, 246), new RGB(221, 234, 246), new RGB(220, 233, 246), new RGB(219, 233, 246), new RGB(218, 232, 245), new RGB(218, 232, 245), new RGB(217, 231, 245), new RGB(216, 231, 245), new RGB(215, 230, 244), new RGB(215, 230, 244), new RGB(214, 229, 244), new RGB(213, 229, 244), new RGB(212, 228, 243), new RGB(212, 228, 243), new RGB(211, 227, 243), new RGB(210, 227, 243), new RGB(209, 226, 242), new RGB(209, 226, 242), new RGB(208, 225, 242), new RGB(207, 225, 242), new RGB(206, 224, 241), new RGB(206, 224, 241), new RGB(205, 223, 241), new RGB(204, 223, 241), new RGB(203, 222, 240), new RGB(203, 222, 240), new RGB(202, 221, 240), new RGB(201, 221, 240), new RGB(200, 220, 239), new RGB(200, 220, 239), new RGB(199, 219, 239), new RGB(198, 219, 239), new RGB(197, 218, 238), new RGB(196, 218, 238), new RGB(195, 217, 238), new RGB(193, 217, 237), new RGB(192, 216, 237), new RGB(191, 216, 236), new RGB(190, 215, 236), new RGB(188, 215, 235), new RGB(187, 214, 235), new RGB(186, 214, 234), new RGB(185, 213, 234), new RGB(183, 213, 234), new RGB(182, 212, 233), new RGB(181, 211, 233), new RGB(180, 211, 232), new RGB(178, 210, 232), new RGB(177, 210, 231), new RGB(176, 209, 231), new RGB(175, 209, 230), new RGB(173, 208, 230), new RGB(172, 208, 230), new RGB(171, 207, 229), new RGB(170, 207, 229), new RGB(168, 206, 228), new RGB(167, 206, 228), new RGB(166, 205, 227), new RGB(165, 205, 227), new RGB(163, 204, 227), new RGB(162, 203, 226), new RGB(161, 203, 226), new RGB(160, 202, 225), new RGB(158, 202, 225), new RGB(157, 201, 224), new RGB(155, 200, 224), new RGB(154, 199, 224), new RGB(152, 199, 223), new RGB(151, 198, 223), new RGB(149, 197, 223), new RGB(147, 196, 222), new RGB(146, 195, 222), new RGB(144, 194, 222), new RGB(143, 193, 221), new RGB(141, 192, 221), new RGB(139, 192, 221), new RGB(138, 191, 220), new RGB(136, 190, 220), new RGB(135, 189, 220), new RGB(133, 188, 219), new RGB(131, 187, 219), new RGB(130, 186, 219), new RGB(128, 185, 218), new RGB(127, 184, 218), new RGB(125, 184, 217), new RGB(123, 183, 217), new RGB(122, 182, 217), new RGB(120, 181, 216), new RGB(119, 180, 216), new RGB(117, 179, 216), new RGB(115, 178, 215), new RGB(114, 177, 215), new RGB(112, 177, 215), new RGB(111, 176, 214), new RGB(109, 175, 214), new RGB(107, 174, 214), new RGB(106, 173, 213), new RGB(105, 172, 213), new RGB(103, 171, 212), new RGB(102, 170, 212), new RGB(101, 170, 211), new RGB(99, 169, 211), new RGB(98, 168, 210), new RGB(97, 167, 210), new RGB(96, 166, 209), new RGB(94, 165, 209), new RGB(93, 164, 208), new RGB(92, 163, 208), new RGB(90, 163, 207), new RGB(89, 162, 207), new RGB(88, 161, 206), new RGB(87, 160, 206), new RGB(85, 159, 205), new RGB(84, 158, 205), new RGB(83, 157, 204), new RGB(81, 156, 204), new RGB(80, 155, 203), new RGB(79, 155, 203), new RGB(78, 154, 202), new RGB(76, 153, 202), new RGB(75, 152, 201), new RGB(74, 151, 201), new RGB(72, 150, 200), new RGB(71, 149, 200), new RGB(70, 148, 199), new RGB(69, 148, 199), new RGB(67, 147, 198), new RGB(66, 146, 198), new RGB(65, 145, 197), new RGB(64, 144, 197), new RGB(63, 143, 196), new RGB(62, 142, 196), new RGB(61, 141, 195), new RGB(60, 140, 195), new RGB(59, 139, 194), new RGB(58, 138, 193), new RGB(57, 137, 193), new RGB(56, 136, 192), new RGB(55, 135, 192), new RGB(53, 133, 191), new RGB(52, 132, 191), new RGB(51, 131, 190), new RGB(50, 130, 190), new RGB(49, 129, 189), new RGB(48, 128, 189), new RGB(47, 127, 188), new RGB(46, 126, 188), new RGB(45, 125, 187), new RGB(44, 124, 187), new RGB(43, 123, 186), new RGB(42, 122, 185), new RGB(41, 121, 185), new RGB(40, 120, 184), new RGB(39, 119, 184), new RGB(38, 118, 183), new RGB(37, 117, 183), new RGB(36, 116, 182), new RGB(35, 115, 182), new RGB(34, 114, 181), new RGB(33, 113, 181), new RGB(32, 112, 180), new RGB(31, 111, 179), new RGB(30, 110, 178), new RGB(30, 109, 178), new RGB(29, 108, 177), new RGB(28, 107, 176), new RGB(27, 106, 175), new RGB(26, 105, 174), new RGB(26, 104, 174), new RGB(25, 103, 173), new RGB(24, 102, 172), new RGB(23, 101, 171), new RGB(23, 100, 171), new RGB(22, 99, 170), new RGB(21, 98, 169), new RGB(20, 97, 168), new RGB(19, 96, 167), new RGB(19, 95, 167), new RGB(18, 94, 166), new RGB(17, 93, 165), new RGB(16, 92, 164), new RGB(15, 91, 163), new RGB(15, 90, 163), new RGB(14, 89, 162), new RGB(13, 88, 161), new RGB(12, 87, 160), new RGB(12, 86, 160), new RGB(11, 85, 159), new RGB(10, 84, 158), new RGB(9, 83, 157), new RGB(8, 82, 156), new RGB(8, 81, 156), new RGB(8, 80, 154), new RGB(8, 79, 153), new RGB(8, 78, 151), new RGB(8, 76, 150), new RGB(8, 75, 148), new RGB(8, 74, 146), new RGB(8, 73, 145), new RGB(8, 72, 143), new RGB(8, 71, 142), new RGB(8, 70, 140), new RGB(8, 69, 139), new RGB(8, 68, 137), new RGB(8, 67, 136), new RGB(8, 66, 134), new RGB(8, 65, 133), new RGB(8, 64, 131), new RGB(8, 63, 130), new RGB(8, 62, 128), new RGB(8, 61, 126), new RGB(8, 60, 125), new RGB(8, 59, 123), new RGB(8, 58, 122), new RGB(8, 57, 120), new RGB(8, 56, 119), new RGB(8, 55, 117), new RGB(8, 54, 116), new RGB(8, 53, 114), new RGB(8, 52, 113), new RGB(8, 51, 111), new RGB(8, 50, 110), new RGB(8, 49, 108), new RGB(8, 48, 107)};
        return new PaletteData(blues);
    }

    public static PaletteData makeGreensPalette() {
        RGB[] greens = new RGB[]{new RGB(247, 252, 245), new RGB(246, 251, 244), new RGB(245, 251, 243), new RGB(245, 251, 243), new RGB(244, 251, 242), new RGB(244, 250, 241), new RGB(243, 250, 241), new RGB(243, 250, 240), new RGB(242, 250, 239), new RGB(241, 250, 239), new RGB(241, 249, 238), new RGB(240, 249, 237), new RGB(240, 249, 237), new RGB(239, 249, 236), new RGB(239, 248, 235), new RGB(238, 248, 235), new RGB(237, 248, 234), new RGB(237, 248, 233), new RGB(236, 248, 233), new RGB(236, 247, 232), new RGB(235, 247, 231), new RGB(235, 247, 231), new RGB(234, 247, 230), new RGB(234, 246, 229), new RGB(233, 246, 229), new RGB(232, 246, 228), new RGB(232, 246, 227), new RGB(231, 246, 227), new RGB(231, 245, 226), new RGB(230, 245, 225), new RGB(230, 245, 225), new RGB(229, 245, 224), new RGB(228, 244, 223), new RGB(227, 244, 222), new RGB(227, 244, 221), new RGB(226, 243, 220), new RGB(225, 243, 219), new RGB(224, 243, 218), new RGB(223, 242, 217), new RGB(222, 242, 216), new RGB(221, 241, 215), new RGB(220, 241, 214), new RGB(219, 241, 213), new RGB(218, 240, 212), new RGB(217, 240, 211), new RGB(216, 240, 210), new RGB(215, 239, 209), new RGB(214, 239, 208), new RGB(213, 238, 207), new RGB(212, 238, 206), new RGB(211, 238, 205), new RGB(211, 237, 204), new RGB(210, 237, 203), new RGB(209, 237, 202), new RGB(208, 236, 201), new RGB(207, 236, 200), new RGB(206, 235, 199), new RGB(205, 235, 198), new RGB(204, 235, 197), new RGB(203, 234, 196), new RGB(202, 234, 195), new RGB(201, 234, 194), new RGB(200, 233, 193), new RGB(199, 233, 192), new RGB(198, 232, 191), new RGB(197, 232, 190), new RGB(196, 231, 189), new RGB(195, 231, 188), new RGB(193, 230, 187), new RGB(192, 230, 185), new RGB(191, 229, 184), new RGB(190, 229, 183), new RGB(189, 228, 182), new RGB(187, 228, 181), new RGB(186, 227, 180), new RGB(185, 227, 178), new RGB(184, 226, 177), new RGB(183, 226, 176), new RGB(182, 225, 175), new RGB(180, 225, 174), new RGB(179, 224, 173), new RGB(178, 224, 171), new RGB(177, 223, 170), new RGB(176, 223, 169), new RGB(174, 222, 168), new RGB(173, 222, 167), new RGB(172, 221, 166), new RGB(171, 221, 165), new RGB(170, 220, 163), new RGB(168, 220, 162), new RGB(167, 219, 161), new RGB(166, 219, 160), new RGB(165, 218, 159), new RGB(164, 218, 158), new RGB(162, 217, 156), new RGB(161, 217, 155), new RGB(160, 216, 154), new RGB(159, 216, 153), new RGB(157, 215, 152), new RGB(156, 214, 151), new RGB(154, 214, 149), new RGB(153, 213, 148), new RGB(152, 212, 147), new RGB(150, 212, 146), new RGB(149, 211, 145), new RGB(147, 210, 144), new RGB(146, 210, 142), new RGB(144, 209, 141), new RGB(143, 208, 140), new RGB(142, 208, 139), new RGB(140, 207, 138), new RGB(139, 206, 137), new RGB(137, 206, 135), new RGB(136, 205, 134), new RGB(135, 204, 133), new RGB(133, 204, 132), new RGB(132, 203, 131), new RGB(130, 202, 130), new RGB(129, 202, 129), new RGB(128, 201, 127), new RGB(126, 200, 126), new RGB(125, 200, 125), new RGB(123, 199, 124), new RGB(122, 198, 123), new RGB(120, 198, 122), new RGB(119, 197, 120), new RGB(118, 196, 119), new RGB(116, 196, 118), new RGB(115, 195, 117), new RGB(113, 194, 116), new RGB(112, 194, 116), new RGB(110, 193, 115), new RGB(108, 192, 114), new RGB(107, 191, 113), new RGB(105, 190, 112), new RGB(104, 190, 112), new RGB(102, 189, 111), new RGB(100, 188, 110), new RGB(99, 187, 109), new RGB(97, 186, 108), new RGB(96, 186, 108), new RGB(94, 185, 107), new RGB(92, 184, 106), new RGB(91, 183, 105), new RGB(89, 183, 105), new RGB(88, 182, 104), new RGB(86, 181, 103), new RGB(84, 180, 102), new RGB(83, 179, 101), new RGB(81, 179, 101), new RGB(80, 178, 100), new RGB(78, 177, 99), new RGB(76, 176, 98), new RGB(75, 176, 98), new RGB(73, 175, 97), new RGB(72, 174, 96), new RGB(70, 173, 95), new RGB(68, 172, 94), new RGB(67, 172, 94), new RGB(65, 171, 93), new RGB(64, 170, 92), new RGB(63, 169, 91), new RGB(62, 168, 91), new RGB(61, 167, 90), new RGB(60, 166, 89), new RGB(59, 165, 88), new RGB(58, 164, 88), new RGB(57, 163, 87), new RGB(56, 162, 86), new RGB(55, 161, 85), new RGB(55, 160, 85), new RGB(54, 159, 84), new RGB(53, 158, 83), new RGB(52, 157, 82), new RGB(51, 156, 81), new RGB(50, 155, 81), new RGB(49, 154, 80), new RGB(48, 153, 79), new RGB(47, 152, 78), new RGB(46, 151, 78), new RGB(45, 150, 77), new RGB(44, 149, 76), new RGB(43, 148, 75), new RGB(42, 147, 75), new RGB(41, 146, 74), new RGB(40, 145, 73), new RGB(39, 144, 72), new RGB(39, 143, 72), new RGB(38, 142, 71), new RGB(37, 141, 70), new RGB(36, 140, 69), new RGB(35, 139, 69), new RGB(34, 138, 68), new RGB(33, 137, 67), new RGB(31, 136, 66), new RGB(30, 135, 66), new RGB(29, 134, 65), new RGB(28, 133, 64), new RGB(27, 132, 63), new RGB(26, 131, 62), new RGB(25, 130, 62), new RGB(24, 129, 61), new RGB(23, 128, 60), new RGB(22, 127, 59), new RGB(21, 127, 59), new RGB(19, 126, 58), new RGB(18, 125, 57), new RGB(17, 124, 56), new RGB(16, 123, 55), new RGB(15, 122, 55), new RGB(14, 121, 54), new RGB(13, 120, 53), new RGB(12, 119, 52), new RGB(11, 118, 51), new RGB(10, 117, 51), new RGB(8, 116, 50), new RGB(7, 115, 49), new RGB(6, 114, 48), new RGB(5, 113, 48), new RGB(4, 112, 47), new RGB(3, 111, 46), new RGB(2, 111, 45), new RGB(1, 110, 44), new RGB(0, 109, 44), new RGB(0, 107, 43), new RGB(0, 106, 43), new RGB(0, 105, 42), new RGB(0, 104, 41), new RGB(0, 102, 41), new RGB(0, 101, 40), new RGB(0, 100, 40), new RGB(0, 98, 39), new RGB(0, 97, 39), new RGB(0, 96, 38), new RGB(0, 95, 38), new RGB(0, 93, 37), new RGB(0, 92, 37), new RGB(0, 91, 36), new RGB(0, 89, 36), new RGB(0, 88, 35), new RGB(0, 87, 35), new RGB(0, 86, 34), new RGB(0, 84, 33), new RGB(0, 83, 33), new RGB(0, 82, 32), new RGB(0, 80, 32), new RGB(0, 79, 31), new RGB(0, 78, 31), new RGB(0, 77, 30), new RGB(0, 75, 30), new RGB(0, 74, 29), new RGB(0, 73, 29), new RGB(0, 71, 28), new RGB(0, 70, 28), new RGB(0, 69, 27), new RGB(0, 68, 27)};
        return new PaletteData(greens);
    }

    public static PaletteData makeRedsPalette() {
        RGB[] reds = new RGB[]{new RGB(255, 245, 240), new RGB(254, 244, 239), new RGB(254, 243, 238), new RGB(254, 243, 237), new RGB(254, 242, 236), new RGB(254, 241, 235), new RGB(254, 241, 234), new RGB(254, 240, 233), new RGB(254, 239, 232), new RGB(254, 239, 231), new RGB(254, 238, 230), new RGB(254, 237, 229), new RGB(254, 237, 228), new RGB(254, 236, 227), new RGB(254, 235, 226), new RGB(254, 235, 225), new RGB(254, 234, 224), new RGB(254, 233, 224), new RGB(254, 233, 223), new RGB(254, 232, 222), new RGB(254, 231, 221), new RGB(254, 231, 220), new RGB(254, 230, 219), new RGB(254, 229, 218), new RGB(254, 229, 217), new RGB(254, 228, 216), new RGB(254, 227, 215), new RGB(254, 227, 214), new RGB(254, 226, 213), new RGB(254, 225, 212), new RGB(254, 225, 211), new RGB(254, 224, 210), new RGB(253, 223, 209), new RGB(253, 222, 208), new RGB(253, 221, 206), new RGB(253, 220, 205), new RGB(253, 219, 203), new RGB(253, 218, 202), new RGB(253, 216, 200), new RGB(253, 215, 199), new RGB(253, 214, 197), new RGB(253, 213, 195), new RGB(253, 212, 194), new RGB(253, 211, 192), new RGB(253, 209, 191), new RGB(253, 208, 189), new RGB(253, 207, 188), new RGB(253, 206, 186), new RGB(252, 205, 185), new RGB(252, 204, 183), new RGB(252, 202, 182), new RGB(252, 201, 180), new RGB(252, 200, 179), new RGB(252, 199, 177), new RGB(252, 198, 175), new RGB(252, 197, 174), new RGB(252, 195, 172), new RGB(252, 194, 171), new RGB(252, 193, 169), new RGB(252, 192, 168), new RGB(252, 191, 166), new RGB(252, 190, 165), new RGB(252, 189, 163), new RGB(252, 187, 162), new RGB(252, 186, 160), new RGB(252, 185, 159), new RGB(252, 184, 157), new RGB(252, 182, 156), new RGB(252, 181, 154), new RGB(252, 180, 153), new RGB(252, 178, 151), new RGB(252, 177, 150), new RGB(252, 176, 148), new RGB(252, 175, 147), new RGB(252, 173, 145), new RGB(252, 172, 144), new RGB(252, 171, 142), new RGB(252, 169, 141), new RGB(252, 168, 139), new RGB(252, 167, 138), new RGB(252, 166, 137), new RGB(252, 164, 135), new RGB(252, 163, 134), new RGB(252, 162, 132), new RGB(252, 160, 131), new RGB(252, 159, 129), new RGB(252, 158, 128), new RGB(252, 157, 126), new RGB(252, 155, 125), new RGB(252, 154, 123), new RGB(252, 153, 122), new RGB(252, 151, 120), new RGB(252, 150, 119), new RGB(252, 149, 117), new RGB(252, 148, 116), new RGB(252, 146, 114), new RGB(251, 145, 113), new RGB(251, 144, 112), new RGB(251, 143, 111), new RGB(251, 141, 109), new RGB(251, 140, 108), new RGB(251, 139, 107), new RGB(251, 138, 106), new RGB(251, 136, 104), new RGB(251, 135, 103), new RGB(251, 134, 102), new RGB(251, 132, 100), new RGB(251, 131, 99), new RGB(251, 130, 98), new RGB(251, 129, 97), new RGB(251, 127, 95), new RGB(251, 126, 94), new RGB(251, 125, 93), new RGB(251, 124, 92), new RGB(251, 122, 90), new RGB(251, 121, 89), new RGB(251, 120, 88), new RGB(251, 119, 87), new RGB(251, 117, 85), new RGB(251, 116, 84), new RGB(251, 115, 83), new RGB(251, 114, 82), new RGB(251, 112, 80), new RGB(251, 111, 79), new RGB(251, 110, 78), new RGB(251, 109, 77), new RGB(251, 107, 75), new RGB(251, 106, 74), new RGB(250, 105, 73), new RGB(250, 103, 72), new RGB(250, 102, 71), new RGB(249, 100, 70), new RGB(249, 99, 69), new RGB(248, 97, 68), new RGB(248, 96, 67), new RGB(248, 94, 66), new RGB(247, 93, 66), new RGB(247, 91, 65), new RGB(247, 90, 64), new RGB(246, 89, 63), new RGB(246, 87, 62), new RGB(245, 86, 61), new RGB(245, 84, 60), new RGB(245, 83, 59), new RGB(244, 81, 58), new RGB(244, 80, 57), new RGB(244, 78, 56), new RGB(243, 77, 55), new RGB(243, 75, 54), new RGB(242, 74, 53), new RGB(242, 72, 52), new RGB(242, 71, 51), new RGB(241, 69, 50), new RGB(241, 68, 50), new RGB(241, 66, 49), new RGB(240, 65, 48), new RGB(240, 63, 47), new RGB(239, 62, 46), new RGB(239, 61, 45), new RGB(239, 59, 44), new RGB(238, 58, 43), new RGB(237, 57, 43), new RGB(236, 56, 42), new RGB(234, 55, 42), new RGB(233, 53, 41), new RGB(232, 52, 41), new RGB(231, 51, 40), new RGB(230, 50, 40), new RGB(229, 49, 39), new RGB(228, 48, 39), new RGB(227, 47, 39), new RGB(225, 46, 38), new RGB(224, 45, 38), new RGB(223, 44, 37), new RGB(222, 42, 37), new RGB(221, 41, 36), new RGB(220, 40, 36), new RGB(219, 39, 35), new RGB(217, 38, 35), new RGB(216, 37, 34), new RGB(215, 36, 34), new RGB(214, 35, 33), new RGB(213, 34, 33), new RGB(212, 33, 32), new RGB(211, 31, 32), new RGB(210, 30, 31), new RGB(208, 29, 31), new RGB(207, 28, 31), new RGB(206, 27, 30), new RGB(205, 26, 30), new RGB(204, 25, 29), new RGB(203, 24, 29), new RGB(202, 23, 28), new RGB(200, 23, 28), new RGB(199, 23, 28), new RGB(198, 22, 28), new RGB(197, 22, 27), new RGB(196, 22, 27), new RGB(194, 22, 27), new RGB(193, 21, 27), new RGB(192, 21, 26), new RGB(191, 21, 26), new RGB(190, 20, 26), new RGB(188, 20, 26), new RGB(187, 20, 25), new RGB(186, 20, 25), new RGB(185, 19, 25), new RGB(184, 19, 25), new RGB(183, 19, 24), new RGB(181, 18, 24), new RGB(180, 18, 24), new RGB(179, 18, 24), new RGB(178, 18, 23), new RGB(177, 17, 23), new RGB(175, 17, 23), new RGB(174, 17, 23), new RGB(173, 17, 22), new RGB(172, 16, 22), new RGB(171, 16, 22), new RGB(169, 16, 22), new RGB(168, 15, 21), new RGB(167, 15, 21), new RGB(166, 15, 21), new RGB(165, 15, 21), new RGB(163, 14, 20), new RGB(161, 14, 20), new RGB(159, 13, 20), new RGB(157, 13, 20), new RGB(155, 12, 19), new RGB(153, 12, 19), new RGB(151, 11, 19), new RGB(149, 11, 19), new RGB(147, 10, 18), new RGB(145, 10, 18), new RGB(143, 9, 18), new RGB(141, 9, 18), new RGB(139, 8, 17), new RGB(138, 8, 17), new RGB(136, 8, 17), new RGB(134, 7, 17), new RGB(132, 7, 16), new RGB(130, 6, 16), new RGB(128, 6, 16), new RGB(126, 5, 16), new RGB(124, 5, 15), new RGB(122, 4, 15), new RGB(120, 4, 15), new RGB(118, 3, 15), new RGB(116, 3, 14), new RGB(114, 2, 14), new RGB(112, 2, 14), new RGB(110, 1, 14), new RGB(108, 1, 13), new RGB(106, 0, 13), new RGB(104, 0, 13), new RGB(103, 0, 13)};
        return new PaletteData(reds);
    }

    public static PaletteData makePastel1Palette() {
        RGB[] pastel1 = new RGB[]{new RGB(251, 180, 174), new RGB(248, 180, 175), new RGB(246, 181, 177), new RGB(244, 182, 178), new RGB(241, 183, 180), new RGB(239, 183, 182), new RGB(237, 184, 183), new RGB(235, 185, 185), new RGB(232, 186, 187), new RGB(230, 187, 188), new RGB(228, 187, 190), new RGB(226, 188, 192), new RGB(223, 189, 193), new RGB(221, 190, 195), new RGB(219, 190, 197), new RGB(217, 191, 198), new RGB(214, 192, 200), new RGB(212, 193, 202), new RGB(210, 194, 203), new RGB(208, 194, 205), new RGB(205, 195, 207), new RGB(203, 196, 208), new RGB(201, 197, 210), new RGB(199, 198, 212), new RGB(196, 198, 213), new RGB(194, 199, 215), new RGB(192, 200, 217), new RGB(190, 201, 218), new RGB(187, 201, 220), new RGB(185, 202, 222), new RGB(183, 203, 223), new RGB(180, 204, 225), new RGB(179, 205, 226), new RGB(179, 206, 225), new RGB(180, 207, 225), new RGB(181, 207, 224), new RGB(182, 208, 223), new RGB(183, 209, 222), new RGB(183, 210, 221), new RGB(184, 211, 220), new RGB(185, 212, 219), new RGB(186, 213, 218), new RGB(186, 214, 217), new RGB(187, 215, 216), new RGB(188, 216, 215), new RGB(189, 217, 214), new RGB(190, 218, 213), new RGB(190, 219, 212), new RGB(191, 220, 211), new RGB(192, 221, 210), new RGB(193, 222, 209), new RGB(194, 223, 209), new RGB(194, 223, 208), new RGB(195, 224, 207), new RGB(196, 225, 206), new RGB(197, 226, 205), new RGB(197, 227, 204), new RGB(198, 228, 203), new RGB(199, 229, 202), new RGB(200, 230, 201), new RGB(201, 231, 200), new RGB(201, 232, 199), new RGB(202, 233, 198), new RGB(203, 234, 197), new RGB(204, 234, 197), new RGB(204, 233, 198), new RGB(205, 232, 199), new RGB(205, 231, 200), new RGB(206, 230, 201), new RGB(206, 229, 202), new RGB(207, 228, 203), new RGB(208, 227, 204), new RGB(208, 226, 205), new RGB(209, 225, 205), new RGB(209, 224, 206), new RGB(210, 223, 207), new RGB(210, 222, 208), new RGB(211, 221, 209), new RGB(212, 220, 210), new RGB(212, 219, 211), new RGB(213, 218, 212), new RGB(213, 217, 213), new RGB(214, 216, 214), new RGB(214, 215, 215), new RGB(215, 214, 216), new RGB(216, 213, 217), new RGB(216, 212, 218), new RGB(217, 211, 219), new RGB(217, 210, 220), new RGB(218, 209, 221), new RGB(218, 208, 222), new RGB(219, 207, 223), new RGB(219, 206, 224), new RGB(220, 205, 225), new RGB(221, 204, 226), new RGB(221, 203, 227), new RGB(222, 203, 227), new RGB(223, 203, 225), new RGB(224, 204, 223), new RGB(225, 204, 221), new RGB(226, 204, 219), new RGB(227, 205, 217), new RGB(228, 205, 215), new RGB(229, 206, 213), new RGB(230, 206, 211), new RGB(231, 207, 209), new RGB(232, 207, 207), new RGB(233, 207, 205), new RGB(234, 208, 203), new RGB(235, 208, 201), new RGB(236, 209, 200), new RGB(237, 209, 198), new RGB(238, 210, 196), new RGB(239, 210, 194), new RGB(240, 211, 192), new RGB(241, 211, 190), new RGB(242, 211, 188), new RGB(243, 212, 186), new RGB(244, 212, 184), new RGB(245, 213, 182), new RGB(246, 213, 180), new RGB(247, 214, 178), new RGB(248, 214, 176), new RGB(249, 215, 174), new RGB(250, 215, 172), new RGB(251, 215, 170), new RGB(252, 216, 168), new RGB(253, 216, 166), new RGB(254, 217, 166), new RGB(254, 218, 167), new RGB(254, 219, 168), new RGB(254, 221, 170), new RGB(254, 222, 171), new RGB(254, 223, 172), new RGB(254, 224, 173), new RGB(254, 225, 174), new RGB(254, 227, 176), new RGB(254, 228, 177), new RGB(254, 229, 178), new RGB(254, 230, 179), new RGB(254, 231, 180), new RGB(254, 233, 182), new RGB(254, 234, 183), new RGB(254, 235, 184), new RGB(254, 236, 185), new RGB(254, 237, 186), new RGB(254, 239, 188), new RGB(254, 240, 189), new RGB(254, 241, 190), new RGB(254, 242, 191), new RGB(254, 243, 192), new RGB(254, 245, 194), new RGB(254, 246, 195), new RGB(254, 247, 196), new RGB(254, 248, 197), new RGB(254, 249, 198), new RGB(254, 250, 199), new RGB(254, 252, 201), new RGB(254, 253, 202), new RGB(254, 254, 203), new RGB(254, 254, 203), new RGB(253, 253, 203), new RGB(252, 251, 202), new RGB(252, 250, 202), new RGB(251, 249, 201), new RGB(250, 248, 201), new RGB(249, 246, 200), new RGB(248, 245, 200), new RGB(247, 244, 199), new RGB(247, 243, 199), new RGB(246, 242, 199), new RGB(245, 240, 198), new RGB(244, 239, 198), new RGB(243, 238, 197), new RGB(243, 237, 197), new RGB(242, 235, 196), new RGB(241, 234, 196), new RGB(240, 233, 195), new RGB(239, 232, 195), new RGB(238, 230, 194), new RGB(238, 229, 194), new RGB(237, 228, 193), new RGB(236, 227, 193), new RGB(235, 226, 192), new RGB(234, 224, 192), new RGB(234, 223, 191), new RGB(233, 222, 191), new RGB(232, 221, 191), new RGB(231, 219, 190), new RGB(230, 218, 190), new RGB(230, 217, 189), new RGB(229, 216, 189), new RGB(229, 216, 190), new RGB(230, 216, 191), new RGB(231, 216, 193), new RGB(231, 216, 194), new RGB(232, 216, 196), new RGB(233, 216, 197), new RGB(234, 216, 198), new RGB(234, 216, 200), new RGB(235, 216, 201), new RGB(236, 216, 203), new RGB(237, 216, 204), new RGB(237, 216, 206), new RGB(238, 216, 207), new RGB(239, 216, 209), new RGB(240, 216, 210), new RGB(240, 216, 212), new RGB(241, 217, 213), new RGB(242, 217, 215), new RGB(243, 217, 216), new RGB(243, 217, 218), new RGB(244, 217, 219), new RGB(245, 217, 221), new RGB(246, 217, 222), new RGB(246, 217, 224), new RGB(247, 217, 225), new RGB(248, 217, 226), new RGB(249, 217, 228), new RGB(249, 217, 229), new RGB(250, 217, 231), new RGB(251, 217, 232), new RGB(252, 217, 234), new RGB(252, 217, 235), new RGB(252, 218, 236), new RGB(252, 219, 236), new RGB(252, 220, 236), new RGB(251, 220, 236), new RGB(251, 221, 236), new RGB(250, 222, 237), new RGB(250, 223, 237), new RGB(250, 223, 237), new RGB(249, 224, 237), new RGB(249, 225, 237), new RGB(249, 226, 238), new RGB(248, 226, 238), new RGB(248, 227, 238), new RGB(248, 228, 238), new RGB(247, 229, 238), new RGB(247, 229, 238), new RGB(247, 230, 239), new RGB(246, 231, 239), new RGB(246, 232, 239), new RGB(246, 232, 239), new RGB(245, 233, 239), new RGB(245, 234, 240), new RGB(245, 235, 240), new RGB(244, 235, 240), new RGB(244, 236, 240), new RGB(244, 237, 240), new RGB(243, 238, 241), new RGB(243, 238, 241), new RGB(243, 239, 241), new RGB(242, 240, 241), new RGB(242, 241, 241), new RGB(242, 242, 242)};
        return new PaletteData(pastel1);
    }

    public static PaletteData makeSpringPalette() {
        RGB[] spring = new RGB[]{new RGB(255, 0, 255), new RGB(255, 1, 254), new RGB(255, 2, 253), new RGB(255, 3, 252), new RGB(255, 4, 251), new RGB(255, 5, 250), new RGB(255, 6, 249), new RGB(255, 7, 248), new RGB(255, 8, 247), new RGB(255, 9, 246), new RGB(255, 10, 245), new RGB(255, 11, 244), new RGB(255, 12, 243), new RGB(255, 13, 242), new RGB(255, 14, 241), new RGB(255, 15, 240), new RGB(255, 16, 239), new RGB(255, 17, 238), new RGB(255, 18, 237), new RGB(255, 19, 236), new RGB(255, 20, 235), new RGB(255, 21, 234), new RGB(255, 22, 233), new RGB(255, 23, 232), new RGB(255, 24, 231), new RGB(255, 25, 230), new RGB(255, 26, 229), new RGB(255, 27, 228), new RGB(255, 28, 227), new RGB(255, 29, 226), new RGB(255, 30, 225), new RGB(255, 31, 224), new RGB(255, 32, 223), new RGB(255, 33, 222), new RGB(255, 34, 221), new RGB(255, 35, 220), new RGB(255, 36, 219), new RGB(255, 37, 218), new RGB(255, 38, 217), new RGB(255, 39, 216), new RGB(255, 40, 215), new RGB(255, 41, 214), new RGB(255, 42, 213), new RGB(255, 43, 211), new RGB(255, 44, 211), new RGB(255, 45, 210), new RGB(255, 46, 209), new RGB(255, 47, 208), new RGB(255, 48, 207), new RGB(255, 49, 206), new RGB(255, 50, 205), new RGB(255, 51, 204), new RGB(255, 52, 203), new RGB(255, 53, 202), new RGB(255, 54, 201), new RGB(255, 55, 200), new RGB(255, 56, 199), new RGB(255, 57, 198), new RGB(255, 58, 197), new RGB(255, 59, 195), new RGB(255, 60, 195), new RGB(255, 61, 194), new RGB(255, 62, 193), new RGB(255, 63, 192), new RGB(255, 64, 191), new RGB(255, 65, 190), new RGB(255, 66, 189), new RGB(255, 67, 188), new RGB(255, 68, 187), new RGB(255, 69, 186), new RGB(255, 70, 185), new RGB(255, 71, 184), new RGB(255, 72, 183), new RGB(255, 73, 182), new RGB(255, 74, 180), new RGB(255, 75, 179), new RGB(255, 76, 179), new RGB(255, 77, 178), new RGB(255, 78, 177), new RGB(255, 79, 176), new RGB(255, 80, 175), new RGB(255, 81, 174), new RGB(255, 82, 173), new RGB(255, 83, 172), new RGB(255, 84, 171), new RGB(255, 85, 170), new RGB(255, 86, 169), new RGB(255, 87, 168), new RGB(255, 88, 167), new RGB(255, 89, 166), new RGB(255, 90, 164), new RGB(255, 91, 163), new RGB(255, 92, 163), new RGB(255, 93, 162), new RGB(255, 94, 161), new RGB(255, 95, 160), new RGB(255, 96, 159), new RGB(255, 97, 158), new RGB(255, 98, 157), new RGB(255, 99, 156), new RGB(255, 100, 155), new RGB(255, 101, 154), new RGB(255, 102, 153), new RGB(255, 103, 152), new RGB(255, 104, 151), new RGB(255, 105, 150), new RGB(255, 106, 148), new RGB(255, 107, 147), new RGB(255, 108, 147), new RGB(255, 109, 146), new RGB(255, 110, 145), new RGB(255, 111, 144), new RGB(255, 112, 143), new RGB(255, 113, 142), new RGB(255, 114, 141), new RGB(255, 115, 140), new RGB(255, 116, 139), new RGB(255, 117, 138), new RGB(255, 118, 137), new RGB(255, 119, 136), new RGB(255, 120, 135), new RGB(255, 121, 134), new RGB(255, 122, 132), new RGB(255, 123, 131), new RGB(255, 124, 131), new RGB(255, 125, 130), new RGB(255, 126, 129), new RGB(255, 127, 128), new RGB(255, 128, 127), new RGB(255, 129, 126), new RGB(255, 130, 125), new RGB(255, 131, 124), new RGB(255, 132, 122), new RGB(255, 133, 121), new RGB(255, 134, 121), new RGB(255, 135, 120), new RGB(255, 136, 119), new RGB(255, 137, 118), new RGB(255, 138, 117), new RGB(255, 139, 116), new RGB(255, 140, 114), new RGB(255, 141, 113), new RGB(255, 142, 113), new RGB(255, 143, 112), new RGB(255, 144, 111), new RGB(255, 145, 110), new RGB(255, 146, 109), new RGB(255, 147, 108), new RGB(255, 148, 106), new RGB(255, 149, 105), new RGB(255, 150, 105), new RGB(255, 151, 104), new RGB(255, 152, 103), new RGB(255, 153, 102), new RGB(255, 154, 101), new RGB(255, 155, 100), new RGB(255, 156, 98), new RGB(255, 157, 97), new RGB(255, 158, 97), new RGB(255, 159, 96), new RGB(255, 160, 95), new RGB(255, 161, 94), new RGB(255, 162, 93), new RGB(255, 163, 92), new RGB(255, 164, 90), new RGB(255, 165, 89), new RGB(255, 166, 89), new RGB(255, 167, 88), new RGB(255, 168, 87), new RGB(255, 169, 86), new RGB(255, 170, 85), new RGB(255, 171, 84), new RGB(255, 172, 82), new RGB(255, 173, 81), new RGB(255, 174, 81), new RGB(255, 175, 80), new RGB(255, 176, 79), new RGB(255, 177, 78), new RGB(255, 178, 77), new RGB(255, 179, 76), new RGB(255, 180, 74), new RGB(255, 181, 73), new RGB(255, 182, 73), new RGB(255, 183, 72), new RGB(255, 184, 71), new RGB(255, 185, 70), new RGB(255, 186, 69), new RGB(255, 187, 68), new RGB(255, 188, 66), new RGB(255, 189, 65), new RGB(255, 190, 65), new RGB(255, 191, 64), new RGB(255, 192, 63), new RGB(255, 193, 62), new RGB(255, 194, 61), new RGB(255, 195, 60), new RGB(255, 196, 58), new RGB(255, 197, 57), new RGB(255, 198, 56), new RGB(255, 199, 56), new RGB(255, 200, 55), new RGB(255, 201, 54), new RGB(255, 202, 53), new RGB(255, 203, 52), new RGB(255, 204, 50), new RGB(255, 205, 49), new RGB(255, 206, 48), new RGB(255, 207, 48), new RGB(255, 208, 47), new RGB(255, 209, 46), new RGB(255, 210, 45), new RGB(255, 211, 44), new RGB(255, 212, 42), new RGB(255, 213, 41), new RGB(255, 214, 40), new RGB(255, 215, 40), new RGB(255, 216, 39), new RGB(255, 217, 38), new RGB(255, 218, 37), new RGB(255, 219, 36), new RGB(255, 220, 34), new RGB(255, 221, 33), new RGB(255, 222, 32), new RGB(255, 223, 32), new RGB(255, 224, 31), new RGB(255, 225, 30), new RGB(255, 226, 29), new RGB(255, 227, 28), new RGB(255, 228, 26), new RGB(255, 229, 25), new RGB(255, 230, 24), new RGB(255, 231, 24), new RGB(255, 232, 23), new RGB(255, 233, 22), new RGB(255, 234, 21), new RGB(255, 235, 20), new RGB(255, 236, 18), new RGB(255, 237, 17), new RGB(255, 238, 16), new RGB(255, 239, 16), new RGB(255, 240, 15), new RGB(255, 241, 14), new RGB(255, 242, 13), new RGB(255, 243, 12), new RGB(255, 244, 10), new RGB(255, 245, 9), new RGB(255, 246, 8), new RGB(255, 247, 8), new RGB(255, 248, 7), new RGB(255, 249, 6), new RGB(255, 250, 5), new RGB(255, 251, 4), new RGB(255, 252, 2), new RGB(255, 253, 1), new RGB(255, 254, 0), new RGB(255, 255, 0)};
        return new PaletteData(spring);
    }

    public static PaletteData makeSummerPalette() {
        RGB[] summer = new RGB[]{new RGB(0, 127, 102), new RGB(1, 128, 102), new RGB(2, 128, 102), new RGB(3, 129, 102), new RGB(4, 129, 102), new RGB(5, 130, 102), new RGB(6, 130, 102), new RGB(7, 131, 102), new RGB(8, 131, 102), new RGB(9, 132, 102), new RGB(10, 132, 102), new RGB(11, 133, 102), new RGB(12, 133, 102), new RGB(13, 134, 102), new RGB(14, 134, 102), new RGB(15, 135, 102), new RGB(16, 135, 102), new RGB(17, 136, 102), new RGB(18, 136, 102), new RGB(19, 137, 102), new RGB(20, 137, 102), new RGB(21, 138, 102), new RGB(22, 138, 102), new RGB(23, 139, 102), new RGB(24, 139, 102), new RGB(25, 140, 102), new RGB(26, 140, 102), new RGB(27, 141, 102), new RGB(28, 141, 102), new RGB(29, 142, 102), new RGB(30, 142, 102), new RGB(31, 143, 102), new RGB(32, 143, 102), new RGB(33, 144, 102), new RGB(34, 144, 102), new RGB(35, 145, 102), new RGB(36, 145, 102), new RGB(37, 146, 102), new RGB(38, 146, 102), new RGB(39, 147, 102), new RGB(40, 147, 102), new RGB(41, 148, 102), new RGB(42, 148, 102), new RGB(43, 149, 102), new RGB(44, 149, 102), new RGB(45, 150, 102), new RGB(46, 150, 102), new RGB(47, 151, 102), new RGB(48, 151, 102), new RGB(49, 152, 102), new RGB(50, 152, 102), new RGB(51, 153, 102), new RGB(52, 153, 102), new RGB(53, 154, 102), new RGB(54, 154, 102), new RGB(55, 155, 102), new RGB(56, 155, 102), new RGB(57, 156, 102), new RGB(58, 156, 102), new RGB(59, 157, 102), new RGB(60, 157, 102), new RGB(61, 158, 102), new RGB(62, 158, 102), new RGB(63, 159, 102), new RGB(64, 159, 102), new RGB(65, 160, 102), new RGB(66, 160, 102), new RGB(67, 161, 102), new RGB(68, 161, 102), new RGB(69, 162, 102), new RGB(70, 162, 102), new RGB(71, 163, 102), new RGB(72, 163, 102), new RGB(73, 163, 102), new RGB(74, 164, 102), new RGB(75, 165, 102), new RGB(76, 165, 102), new RGB(77, 166, 102), new RGB(78, 166, 102), new RGB(79, 167, 102), new RGB(80, 167, 102), new RGB(81, 168, 102), new RGB(82, 168, 102), new RGB(83, 169, 102), new RGB(84, 169, 102), new RGB(85, 170, 102), new RGB(86, 170, 102), new RGB(87, 171, 102), new RGB(88, 171, 102), new RGB(89, 172, 102), new RGB(90, 172, 102), new RGB(91, 173, 102), new RGB(92, 173, 102), new RGB(93, 174, 102), new RGB(94, 174, 102), new RGB(95, 175, 102), new RGB(96, 175, 102), new RGB(97, 176, 102), new RGB(98, 176, 102), new RGB(99, 177, 102), new RGB(100, 177, 102), new RGB(101, 178, 102), new RGB(102, 178, 102), new RGB(103, 179, 102), new RGB(104, 179, 102), new RGB(105, 179, 102), new RGB(106, 180, 102), new RGB(107, 181, 102), new RGB(108, 181, 102), new RGB(109, 182, 102), new RGB(110, 182, 102), new RGB(111, 183, 102), new RGB(112, 183, 102), new RGB(113, 184, 102), new RGB(114, 184, 102), new RGB(115, 185, 102), new RGB(116, 185, 102), new RGB(117, 186, 102), new RGB(118, 186, 102), new RGB(119, 187, 102), new RGB(120, 187, 102), new RGB(121, 188, 102), new RGB(122, 188, 102), new RGB(123, 189, 102), new RGB(124, 189, 102), new RGB(125, 190, 102), new RGB(126, 190, 102), new RGB(127, 191, 102), new RGB(128, 191, 102), new RGB(129, 192, 102), new RGB(130, 192, 102), new RGB(131, 193, 102), new RGB(132, 193, 102), new RGB(133, 194, 102), new RGB(134, 194, 102), new RGB(135, 195, 102), new RGB(136, 195, 102), new RGB(137, 195, 102), new RGB(138, 196, 102), new RGB(139, 196, 102), new RGB(140, 197, 102), new RGB(141, 198, 102), new RGB(142, 198, 102), new RGB(143, 199, 102), new RGB(144, 199, 102), new RGB(145, 200, 102), new RGB(146, 200, 102), new RGB(147, 201, 102), new RGB(148, 201, 102), new RGB(149, 202, 102), new RGB(150, 202, 102), new RGB(151, 203, 102), new RGB(152, 203, 102), new RGB(153, 204, 102), new RGB(154, 204, 102), new RGB(155, 205, 102), new RGB(156, 205, 102), new RGB(157, 206, 102), new RGB(158, 206, 102), new RGB(159, 207, 102), new RGB(160, 207, 102), new RGB(161, 208, 102), new RGB(162, 208, 102), new RGB(163, 209, 102), new RGB(164, 209, 102), new RGB(165, 210, 102), new RGB(166, 210, 102), new RGB(167, 211, 102), new RGB(168, 211, 102), new RGB(169, 211, 102), new RGB(170, 212, 102), new RGB(171, 212, 102), new RGB(172, 213, 102), new RGB(173, 214, 102), new RGB(174, 214, 102), new RGB(175, 215, 102), new RGB(176, 215, 102), new RGB(177, 216, 102), new RGB(178, 216, 102), new RGB(179, 217, 102), new RGB(180, 217, 102), new RGB(181, 218, 102), new RGB(182, 218, 102), new RGB(183, 219, 102), new RGB(184, 219, 102), new RGB(185, 220, 102), new RGB(186, 220, 102), new RGB(187, 221, 102), new RGB(188, 221, 102), new RGB(189, 222, 102), new RGB(190, 222, 102), new RGB(191, 223, 102), new RGB(192, 223, 102), new RGB(193, 224, 102), new RGB(194, 224, 102), new RGB(195, 225, 102), new RGB(196, 225, 102), new RGB(197, 226, 102), new RGB(198, 226, 102), new RGB(199, 227, 102), new RGB(200, 227, 102), new RGB(201, 227, 102), new RGB(202, 228, 102), new RGB(203, 228, 102), new RGB(204, 229, 102), new RGB(205, 230, 102), new RGB(206, 230, 102), new RGB(207, 231, 102), new RGB(208, 231, 102), new RGB(209, 232, 102), new RGB(210, 232, 102), new RGB(211, 233, 102), new RGB(212, 233, 102), new RGB(213, 234, 102), new RGB(214, 234, 102), new RGB(215, 235, 102), new RGB(216, 235, 102), new RGB(217, 236, 102), new RGB(218, 236, 102), new RGB(219, 237, 102), new RGB(220, 237, 102), new RGB(221, 238, 102), new RGB(222, 238, 102), new RGB(223, 239, 102), new RGB(224, 239, 102), new RGB(225, 240, 102), new RGB(226, 240, 102), new RGB(227, 241, 102), new RGB(228, 241, 102), new RGB(229, 242, 102), new RGB(230, 242, 102), new RGB(231, 243, 102), new RGB(232, 243, 102), new RGB(233, 243, 102), new RGB(234, 244, 102), new RGB(235, 244, 102), new RGB(236, 245, 102), new RGB(237, 246, 102), new RGB(238, 246, 102), new RGB(239, 247, 102), new RGB(240, 247, 102), new RGB(241, 248, 102), new RGB(242, 248, 102), new RGB(243, 249, 102), new RGB(244, 249, 102), new RGB(245, 250, 102), new RGB(246, 250, 102), new RGB(247, 251, 102), new RGB(248, 251, 102), new RGB(249, 252, 102), new RGB(250, 252, 102), new RGB(251, 253, 102), new RGB(252, 253, 102), new RGB(253, 254, 102), new RGB(254, 254, 102), new RGB(255, 255, 102)};
        return new PaletteData(summer);
    }

    public static PaletteData makeAutumnPalette() {
        RGB[] autumn = new RGB[]{new RGB(255, 0, 0), new RGB(255, 1, 0), new RGB(255, 2, 0), new RGB(255, 3, 0), new RGB(255, 4, 0), new RGB(255, 5, 0), new RGB(255, 6, 0), new RGB(255, 7, 0), new RGB(255, 8, 0), new RGB(255, 9, 0), new RGB(255, 10, 0), new RGB(255, 11, 0), new RGB(255, 12, 0), new RGB(255, 13, 0), new RGB(255, 14, 0), new RGB(255, 15, 0), new RGB(255, 16, 0), new RGB(255, 17, 0), new RGB(255, 18, 0), new RGB(255, 19, 0), new RGB(255, 20, 0), new RGB(255, 21, 0), new RGB(255, 22, 0), new RGB(255, 23, 0), new RGB(255, 24, 0), new RGB(255, 25, 0), new RGB(255, 26, 0), new RGB(255, 27, 0), new RGB(255, 28, 0), new RGB(255, 29, 0), new RGB(255, 30, 0), new RGB(255, 31, 0), new RGB(255, 32, 0), new RGB(255, 33, 0), new RGB(255, 34, 0), new RGB(255, 35, 0), new RGB(255, 36, 0), new RGB(255, 37, 0), new RGB(255, 38, 0), new RGB(255, 39, 0), new RGB(255, 40, 0), new RGB(255, 41, 0), new RGB(255, 42, 0), new RGB(255, 43, 0), new RGB(255, 44, 0), new RGB(255, 45, 0), new RGB(255, 46, 0), new RGB(255, 47, 0), new RGB(255, 48, 0), new RGB(255, 49, 0), new RGB(255, 50, 0), new RGB(255, 51, 0), new RGB(255, 52, 0), new RGB(255, 53, 0), new RGB(255, 54, 0), new RGB(255, 55, 0), new RGB(255, 56, 0), new RGB(255, 57, 0), new RGB(255, 58, 0), new RGB(255, 59, 0), new RGB(255, 60, 0), new RGB(255, 61, 0), new RGB(255, 62, 0), new RGB(255, 63, 0), new RGB(255, 64, 0), new RGB(255, 65, 0), new RGB(255, 66, 0), new RGB(255, 67, 0), new RGB(255, 68, 0), new RGB(255, 69, 0), new RGB(255, 70, 0), new RGB(255, 71, 0), new RGB(255, 72, 0), new RGB(255, 73, 0), new RGB(255, 74, 0), new RGB(255, 75, 0), new RGB(255, 76, 0), new RGB(255, 77, 0), new RGB(255, 78, 0), new RGB(255, 79, 0), new RGB(255, 80, 0), new RGB(255, 81, 0), new RGB(255, 82, 0), new RGB(255, 83, 0), new RGB(255, 84, 0), new RGB(255, 85, 0), new RGB(255, 86, 0), new RGB(255, 87, 0), new RGB(255, 88, 0), new RGB(255, 89, 0), new RGB(255, 90, 0), new RGB(255, 91, 0), new RGB(255, 92, 0), new RGB(255, 93, 0), new RGB(255, 94, 0), new RGB(255, 95, 0), new RGB(255, 96, 0), new RGB(255, 97, 0), new RGB(255, 98, 0), new RGB(255, 99, 0), new RGB(255, 100, 0), new RGB(255, 101, 0), new RGB(255, 102, 0), new RGB(255, 103, 0), new RGB(255, 104, 0), new RGB(255, 105, 0), new RGB(255, 106, 0), new RGB(255, 107, 0), new RGB(255, 108, 0), new RGB(255, 109, 0), new RGB(255, 110, 0), new RGB(255, 111, 0), new RGB(255, 112, 0), new RGB(255, 113, 0), new RGB(255, 114, 0), new RGB(255, 115, 0), new RGB(255, 116, 0), new RGB(255, 117, 0), new RGB(255, 118, 0), new RGB(255, 119, 0), new RGB(255, 120, 0), new RGB(255, 121, 0), new RGB(255, 122, 0), new RGB(255, 123, 0), new RGB(255, 124, 0), new RGB(255, 125, 0), new RGB(255, 126, 0), new RGB(255, 127, 0), new RGB(255, 128, 0), new RGB(255, 129, 0), new RGB(255, 130, 0), new RGB(255, 131, 0), new RGB(255, 132, 0), new RGB(255, 133, 0), new RGB(255, 134, 0), new RGB(255, 135, 0), new RGB(255, 136, 0), new RGB(255, 137, 0), new RGB(255, 138, 0), new RGB(255, 139, 0), new RGB(255, 140, 0), new RGB(255, 141, 0), new RGB(255, 142, 0), new RGB(255, 143, 0), new RGB(255, 144, 0), new RGB(255, 145, 0), new RGB(255, 146, 0), new RGB(255, 147, 0), new RGB(255, 148, 0), new RGB(255, 149, 0), new RGB(255, 150, 0), new RGB(255, 151, 0), new RGB(255, 152, 0), new RGB(255, 153, 0), new RGB(255, 154, 0), new RGB(255, 155, 0), new RGB(255, 156, 0), new RGB(255, 157, 0), new RGB(255, 158, 0), new RGB(255, 159, 0), new RGB(255, 160, 0), new RGB(255, 161, 0), new RGB(255, 162, 0), new RGB(255, 163, 0), new RGB(255, 164, 0), new RGB(255, 165, 0), new RGB(255, 166, 0), new RGB(255, 167, 0), new RGB(255, 168, 0), new RGB(255, 169, 0), new RGB(255, 170, 0), new RGB(255, 171, 0), new RGB(255, 172, 0), new RGB(255, 173, 0), new RGB(255, 174, 0), new RGB(255, 175, 0), new RGB(255, 176, 0), new RGB(255, 177, 0), new RGB(255, 178, 0), new RGB(255, 179, 0), new RGB(255, 180, 0), new RGB(255, 181, 0), new RGB(255, 182, 0), new RGB(255, 183, 0), new RGB(255, 184, 0), new RGB(255, 185, 0), new RGB(255, 186, 0), new RGB(255, 187, 0), new RGB(255, 188, 0), new RGB(255, 189, 0), new RGB(255, 190, 0), new RGB(255, 191, 0), new RGB(255, 192, 0), new RGB(255, 193, 0), new RGB(255, 194, 0), new RGB(255, 195, 0), new RGB(255, 196, 0), new RGB(255, 197, 0), new RGB(255, 198, 0), new RGB(255, 199, 0), new RGB(255, 200, 0), new RGB(255, 201, 0), new RGB(255, 202, 0), new RGB(255, 203, 0), new RGB(255, 204, 0), new RGB(255, 205, 0), new RGB(255, 206, 0), new RGB(255, 207, 0), new RGB(255, 208, 0), new RGB(255, 209, 0), new RGB(255, 210, 0), new RGB(255, 211, 0), new RGB(255, 212, 0), new RGB(255, 213, 0), new RGB(255, 214, 0), new RGB(255, 215, 0), new RGB(255, 216, 0), new RGB(255, 217, 0), new RGB(255, 218, 0), new RGB(255, 219, 0), new RGB(255, 220, 0), new RGB(255, 221, 0), new RGB(255, 222, 0), new RGB(255, 223, 0), new RGB(255, 224, 0), new RGB(255, 225, 0), new RGB(255, 226, 0), new RGB(255, 227, 0), new RGB(255, 228, 0), new RGB(255, 229, 0), new RGB(255, 230, 0), new RGB(255, 231, 0), new RGB(255, 232, 0), new RGB(255, 233, 0), new RGB(255, 234, 0), new RGB(255, 235, 0), new RGB(255, 236, 0), new RGB(255, 237, 0), new RGB(255, 238, 0), new RGB(255, 239, 0), new RGB(255, 240, 0), new RGB(255, 241, 0), new RGB(255, 242, 0), new RGB(255, 243, 0), new RGB(255, 244, 0), new RGB(255, 245, 0), new RGB(255, 246, 0), new RGB(255, 247, 0), new RGB(255, 248, 0), new RGB(255, 249, 0), new RGB(255, 250, 0), new RGB(255, 251, 0), new RGB(255, 252, 0), new RGB(255, 253, 0), new RGB(255, 254, 0), new RGB(255, 255, 0)};
        return new PaletteData(autumn);
    }

    public static PaletteData makeWinterPalette() {
        RGB[] winter = new RGB[]{new RGB(0, 0, 255), new RGB(0, 1, 254), new RGB(0, 2, 254), new RGB(0, 3, 253), new RGB(0, 4, 253), new RGB(0, 5, 252), new RGB(0, 6, 252), new RGB(0, 7, 251), new RGB(0, 8, 251), new RGB(0, 9, 250), new RGB(0, 10, 250), new RGB(0, 11, 249), new RGB(0, 12, 249), new RGB(0, 13, 248), new RGB(0, 14, 248), new RGB(0, 15, 247), new RGB(0, 16, 247), new RGB(0, 17, 246), new RGB(0, 18, 246), new RGB(0, 19, 245), new RGB(0, 20, 245), new RGB(0, 21, 244), new RGB(0, 22, 244), new RGB(0, 23, 243), new RGB(0, 24, 243), new RGB(0, 25, 242), new RGB(0, 26, 242), new RGB(0, 27, 241), new RGB(0, 28, 241), new RGB(0, 29, 240), new RGB(0, 30, 240), new RGB(0, 31, 239), new RGB(0, 32, 239), new RGB(0, 33, 238), new RGB(0, 34, 238), new RGB(0, 35, 237), new RGB(0, 36, 237), new RGB(0, 37, 236), new RGB(0, 38, 236), new RGB(0, 39, 235), new RGB(0, 40, 235), new RGB(0, 41, 234), new RGB(0, 42, 234), new RGB(0, 43, 233), new RGB(0, 44, 233), new RGB(0, 45, 232), new RGB(0, 46, 232), new RGB(0, 47, 231), new RGB(0, 48, 231), new RGB(0, 49, 230), new RGB(0, 50, 230), new RGB(0, 51, 229), new RGB(0, 52, 229), new RGB(0, 53, 228), new RGB(0, 54, 228), new RGB(0, 55, 227), new RGB(0, 56, 227), new RGB(0, 57, 226), new RGB(0, 58, 226), new RGB(0, 59, 225), new RGB(0, 60, 225), new RGB(0, 61, 224), new RGB(0, 62, 224), new RGB(0, 63, 223), new RGB(0, 64, 223), new RGB(0, 65, 222), new RGB(0, 66, 222), new RGB(0, 67, 221), new RGB(0, 68, 221), new RGB(0, 69, 220), new RGB(0, 70, 220), new RGB(0, 71, 219), new RGB(0, 72, 219), new RGB(0, 73, 218), new RGB(0, 74, 218), new RGB(0, 75, 217), new RGB(0, 76, 217), new RGB(0, 77, 216), new RGB(0, 78, 216), new RGB(0, 79, 215), new RGB(0, 80, 215), new RGB(0, 81, 214), new RGB(0, 82, 214), new RGB(0, 83, 213), new RGB(0, 84, 213), new RGB(0, 85, 212), new RGB(0, 86, 211), new RGB(0, 87, 211), new RGB(0, 88, 211), new RGB(0, 89, 210), new RGB(0, 90, 210), new RGB(0, 91, 209), new RGB(0, 92, 209), new RGB(0, 93, 208), new RGB(0, 94, 208), new RGB(0, 95, 207), new RGB(0, 96, 207), new RGB(0, 97, 206), new RGB(0, 98, 206), new RGB(0, 99, 205), new RGB(0, 100, 205), new RGB(0, 101, 204), new RGB(0, 102, 204), new RGB(0, 103, 203), new RGB(0, 104, 203), new RGB(0, 105, 202), new RGB(0, 106, 202), new RGB(0, 107, 201), new RGB(0, 108, 201), new RGB(0, 109, 200), new RGB(0, 110, 200), new RGB(0, 111, 199), new RGB(0, 112, 199), new RGB(0, 113, 198), new RGB(0, 114, 198), new RGB(0, 115, 197), new RGB(0, 116, 197), new RGB(0, 117, 196), new RGB(0, 118, 195), new RGB(0, 119, 195), new RGB(0, 120, 195), new RGB(0, 121, 194), new RGB(0, 122, 194), new RGB(0, 123, 193), new RGB(0, 124, 193), new RGB(0, 125, 192), new RGB(0, 126, 192), new RGB(0, 127, 191), new RGB(0, 128, 191), new RGB(0, 129, 190), new RGB(0, 130, 190), new RGB(0, 131, 189), new RGB(0, 132, 189), new RGB(0, 133, 188), new RGB(0, 134, 188), new RGB(0, 135, 187), new RGB(0, 136, 187), new RGB(0, 137, 186), new RGB(0, 138, 186), new RGB(0, 139, 185), new RGB(0, 140, 185), new RGB(0, 141, 184), new RGB(0, 142, 184), new RGB(0, 143, 183), new RGB(0, 144, 183), new RGB(0, 145, 182), new RGB(0, 146, 182), new RGB(0, 147, 181), new RGB(0, 148, 180), new RGB(0, 149, 180), new RGB(0, 150, 179), new RGB(0, 151, 179), new RGB(0, 152, 179), new RGB(0, 153, 178), new RGB(0, 154, 178), new RGB(0, 155, 177), new RGB(0, 156, 177), new RGB(0, 157, 176), new RGB(0, 158, 176), new RGB(0, 159, 175), new RGB(0, 160, 175), new RGB(0, 161, 174), new RGB(0, 162, 174), new RGB(0, 163, 173), new RGB(0, 164, 173), new RGB(0, 165, 172), new RGB(0, 166, 172), new RGB(0, 167, 171), new RGB(0, 168, 171), new RGB(0, 169, 170), new RGB(0, 170, 170), new RGB(0, 171, 169), new RGB(0, 172, 169), new RGB(0, 173, 168), new RGB(0, 174, 168), new RGB(0, 175, 167), new RGB(0, 176, 167), new RGB(0, 177, 166), new RGB(0, 178, 166), new RGB(0, 179, 165), new RGB(0, 180, 164), new RGB(0, 181, 164), new RGB(0, 182, 163), new RGB(0, 183, 163), new RGB(0, 184, 163), new RGB(0, 185, 162), new RGB(0, 186, 162), new RGB(0, 187, 161), new RGB(0, 188, 161), new RGB(0, 189, 160), new RGB(0, 190, 160), new RGB(0, 191, 159), new RGB(0, 192, 159), new RGB(0, 193, 158), new RGB(0, 194, 158), new RGB(0, 195, 157), new RGB(0, 196, 157), new RGB(0, 197, 156), new RGB(0, 198, 156), new RGB(0, 199, 155), new RGB(0, 200, 155), new RGB(0, 201, 154), new RGB(0, 202, 154), new RGB(0, 203, 153), new RGB(0, 204, 153), new RGB(0, 205, 152), new RGB(0, 206, 152), new RGB(0, 207, 151), new RGB(0, 208, 151), new RGB(0, 209, 150), new RGB(0, 210, 150), new RGB(0, 211, 149), new RGB(0, 212, 148), new RGB(0, 213, 148), new RGB(0, 214, 147), new RGB(0, 215, 147), new RGB(0, 216, 147), new RGB(0, 217, 146), new RGB(0, 218, 146), new RGB(0, 219, 145), new RGB(0, 220, 145), new RGB(0, 221, 144), new RGB(0, 222, 144), new RGB(0, 223, 143), new RGB(0, 224, 143), new RGB(0, 225, 142), new RGB(0, 226, 142), new RGB(0, 227, 141), new RGB(0, 228, 141), new RGB(0, 229, 140), new RGB(0, 230, 140), new RGB(0, 231, 139), new RGB(0, 232, 139), new RGB(0, 233, 138), new RGB(0, 234, 138), new RGB(0, 235, 137), new RGB(0, 236, 137), new RGB(0, 237, 136), new RGB(0, 238, 136), new RGB(0, 239, 135), new RGB(0, 240, 135), new RGB(0, 241, 134), new RGB(0, 242, 134), new RGB(0, 243, 133), new RGB(0, 244, 132), new RGB(0, 245, 132), new RGB(0, 246, 131), new RGB(0, 247, 131), new RGB(0, 248, 131), new RGB(0, 249, 130), new RGB(0, 250, 130), new RGB(0, 251, 129), new RGB(0, 252, 129), new RGB(0, 253, 128), new RGB(0, 254, 128), new RGB(0, 255, 127)};
        return new PaletteData(winter);
    }
}

