/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.internal;

import fable.imageviewer.internal.IImagesVarKeys;
import org.eclipse.swt.graphics.Point;

public class Coordinates
implements IImagesVarKeys {
    private double x0;
    private double y0;
    private double pixelWidth;
    private double pixelHeight;
    private String xName;
    private String yName;
    private int type;

    public Coordinates() {
        this.resetToDefault();
    }

    public Coordinates(int type, double width, double height) {
        this.reset(type, width, height);
    }

    public Coordinates(int type, double x0, double y0, double pixelWidth, double pixelHeight, String xName, String yName) {
        this.reset(type, x0, y0, pixelWidth, pixelHeight, xName, yName);
    }

    public void resetToDefault() {
        this.x0 = 0.0;
        this.y0 = 0.0;
        this.pixelWidth = 1.0;
        this.pixelHeight = 1.0;
        this.xName = "x";
        this.yName = "y";
        this.type = 0;
    }

    public void reset(int type, double width, double height) {
        this.type = type;
        if (type == 4) {
            return;
        }
        this.xName = "x";
        this.yName = "y";
        switch (type) {
            case 0: {
                this.y0 = 0.0;
                this.x0 = 0.0;
                this.pixelWidth = 1.0;
                this.pixelHeight = 1.0;
                break;
            }
            case 1: {
                this.x0 = width == 0.0 ? 0.0 : width - 1.0;
                this.y0 = 0.0;
                this.pixelWidth = -1.0;
                this.pixelHeight = 1.0;
                break;
            }
            case 2: {
                this.x0 = width == 0.0 ? 0.0 : width - 1.0;
                this.y0 = height == 0.0 ? 0.0 : height - 1.0;
                this.pixelWidth = -1.0;
                this.pixelHeight = -1.0;
                break;
            }
            case 3: {
                this.x0 = 0.0;
                this.y0 = height == 0.0 ? 0.0 : height - 1.0;
                this.pixelWidth = 1.0;
                this.pixelHeight = -1.0;
            }
        }
    }

    public void reset(int type, double x0, double y0, double pixelWidth, double pixelHeight, String xName, String yName) {
        if (type != 4) {
            this.reset(type, pixelWidth, pixelHeight);
            return;
        }
        this.type = type;
        this.x0 = x0;
        this.y0 = y0;
        this.pixelWidth = pixelWidth;
        this.pixelHeight = pixelHeight;
        this.xName = xName;
        this.yName = yName;
    }

    public double[] getCoordinatesFromOriented(Point point) {
        double x1 = this.pixelWidth * ((double)point.x - this.x0);
        double y1 = this.pixelHeight * ((double)point.y - this.y0);
        return new double[]{x1, y1};
    }

    public String getCoordinateString(int x, int y) {
        double x1 = this.pixelWidth * ((double)x - this.x0);
        double y1 = this.pixelHeight * ((double)y - this.y0);
        if (this.type == 4) {
            return String.format("%s=%g, %s=%g", this.xName, x1, this.yName, y1);
        }
        return String.format("%s=%d, %s=%d", this.xName, (int)(x1 + 0.5), this.yName, (int)(y1 + 0.5));
    }

    public String getCoordinateString(int x, int y, float pixelValue) {
        double x1 = this.pixelWidth * ((double)x - this.x0);
        double y1 = this.pixelHeight * ((double)y - this.y0);
        if (this.type == 4) {
            return String.format("%s=%g %s=%g value=%.0f", this.xName, x1, this.yName, y1, Float.valueOf(pixelValue));
        }
        return String.format("%s=%d %s=%d value=%.0f", this.xName, (int)(x1 + 0.5), this.yName, (int)(y1 + 0.5), Float.valueOf(pixelValue));
    }

    public boolean isXInverted() {
        return this.pixelWidth < 0.0;
    }

    public boolean isYInverted() {
        return this.pixelHeight < 0.0;
    }

    public double getX0() {
        return this.x0;
    }

    public double getY0() {
        return this.y0;
    }

    public double getPixelWidth() {
        return this.pixelWidth;
    }

    public double getPixelHeight() {
        return this.pixelHeight;
    }

    public String getXName() {
        return this.xName;
    }

    public String getYName() {
        return this.yName;
    }

    public int getType() {
        return this.type;
    }
}

