/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.actions;

import fable.framework.navigator.views.SampleNavigatorView;
import fable.framework.toolbox.FableUtils;
import fable.imageviewer.internal.ImageUtils;
import fable.imageviewer.internal.ZoomSelection;
import fable.imageviewer.views.ImageView;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class Slice1DAction
extends Action
implements IViewActionDelegate {
    ImageView iv = null;

    public Slice1DAction() {
    }

    public Slice1DAction(String string) {
        super(string, 1);
        this.setEnabled(true);
    }

    public void init(IViewPart view) {
        this.iv = (ImageView)view;
    }

    public void run(IAction action) {
        this.slice1D();
    }

    public void run() {
        this.slice1D();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void slice1D() {
        try {
            Vector selectedFiles = SampleNavigatorView.view.getSelectedFilesIndex();
            if (selectedFiles.size() <= 1) {
                this.iv.updateStatusLabel("select at least 2 files to make a slice");
            } else {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", Integer.toString(200), 1);
                ImageView imageSlice1DView = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ImageView", Integer.toString(200)).getView(true);
                imageSlice1DView.stopListening();
                Rectangle selectionArea = this.iv.getImage().getSelectedArea();
                Rectangle imageArea = this.iv.getImage().screenRectangleToImageRectangle(selectionArea, true);
                if (this.iv.getZoomSelection() == ZoomSelection.LINE) {
                    ImageUtils.Slice2DLine(imageArea.x, imageArea.y, imageArea.x + imageArea.width, imageArea.y + imageArea.height, 1);
                } else {
                    this.iv.updateStatusLabel("zoom on a 1D line to make a slice");
                }
                imageSlice1DView.transferSelectedSettings(this.iv);
                imageSlice1DView.setName("1D Slice " + this.iv.getFileName());
            }
        }
        catch (PartInitException ex) {
            FableUtils.excMsg((Object)((Object)this), (String)"Error opening view", (Throwable)ex);
        }
    }
}

