/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.actions;

import fable.framework.navigator.views.SampleNavigatorView;
import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.ToolBox;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class OpenImageViewerResourceAction
implements IObjectActionDelegate {
    private ISelection selection = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IFile iFile = null;
        IFolder iFolder = null;
        ArrayList<String> list = new ArrayList<String>();
        if (this.selection instanceof IStructuredSelection) {
            Iterator it = ((IStructuredSelection)this.selection).iterator();
            while (it.hasNext()) {
                iFile = null;
                iFolder = null;
                Object element = it.next();
                if (element instanceof IFile) {
                    iFile = (IFile)element;
                } else if (element instanceof IFolder) {
                    iFolder = (IFolder)element;
                } else if (element instanceof IAdaptable) {
                    iFile = (IFile)((IAdaptable)element).getAdapter(IFile.class);
                    iFolder = (IFolder)((IAdaptable)element).getAdapter(IFolder.class);
                }
                if (iFile != null) {
                    list.add(iFile.getLocation().toString());
                    continue;
                }
                if (iFolder == null) continue;
                this.loadFolder(iFolder);
            }
        }
        this.processFiles(list);
    }

    void processFiles(ArrayList<String> list) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            try {
                if (ToolBox.isSmallPerspectiveSet()) {
                    PlatformUI.getWorkbench().showPerspective("fable.imageviewer.perspectiveSmall", window);
                } else {
                    PlatformUI.getWorkbench().showPerspective("fable.imageviewer.perspective", window);
                }
            }
            catch (WorkbenchException ex) {
                FableUtils.excMsg((Object)this, (String)"Error opening ImageViewer perspective", (Throwable)ex);
                return;
            }
            try {
                String[] files;
                SampleNavigatorView sampleView = (SampleNavigatorView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("fable.framework.navigator.views.SampleNavigatorViewid");
                Collections.sort(list);
                ListIterator<String> iter = list.listIterator();
                String curDir = null;
                String prevDir = null;
                ArrayList<String> fileList = new ArrayList<String>();
                while (iter.hasNext()) {
                    String filePath = iter.next();
                    File file = new File(filePath);
                    curDir = file.getParent();
                    String fileName = file.getName();
                    if (curDir.equals(prevDir)) {
                        fileList.add(fileName);
                    } else {
                        if (prevDir != null && !fileList.isEmpty()) {
                            files = new String[fileList.size()];
                            fileList.toArray(files);
                            sampleView.addFiles(files, prevDir);
                        }
                        prevDir = curDir;
                        fileList.clear();
                        fileList.add(fileName);
                    }
                    files = new String[fileList.size()];
                }
                if (prevDir != null && !fileList.isEmpty()) {
                    files = new String[fileList.size()];
                    fileList.toArray(files);
                    sampleView.addFiles(files, prevDir);
                }
            }
            catch (Exception ex) {
                FableUtils.excMsg((Object)this, (String)"Error loading Image File", (Throwable)ex);
            }
        }
    }

    private void loadFolder(IFolder iFolder) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            try {
                if (ToolBox.isSmallPerspectiveSet()) {
                    PlatformUI.getWorkbench().showPerspective("fable.imageviewer.perspectiveSmall", window);
                } else {
                    PlatformUI.getWorkbench().showPerspective("fable.imageviewer.perspective", window);
                }
            }
            catch (WorkbenchException ex) {
                FableUtils.excMsg((Object)this, (String)"Error opening ImageViewer perspective", (Throwable)ex);
                return;
            }
            try {
                SampleNavigatorView sampleView = (SampleNavigatorView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("fable.framework.navigator.views.SampleNavigatorViewid");
                sampleView.addDirectory(iFolder.getLocation().toString());
            }
            catch (Exception ex) {
                FableUtils.excMsg((Object)this, (String)"Error loading Image Folder", (Throwable)ex);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

