/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.object;

import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.ToolBox;
import fable.framework.views.FableMessageConsole;
import fable.framework.xmlparser.object.FableXmlContentHandler;
import fable.framework.xmlparser.object.Xmloption;
import fable.peaksearch.Activator;
import fable.peaksearch.object.PeaksearchException;
import fable.python.Sample;
import fable.python.jep.FableJep;
import fable.python.jep.StdoutRead;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import jep.Jep;
import jep.JepException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class Peaksearch {
    private Vector<Xmloption> options;
    private Vector<Sample> samples;
    private Sample sample;
    private static Logger logger;
    private FableXmlContentHandler xmlContentHandler;
    private XMLReader saxReader;
    private static Peaksearch peaksearch;
    private ArrayList<IPropertyChangeListener> listeners = new ArrayList();
    private ArrayList<String> listKillFile = new ArrayList();
    private static String iniFile;
    private Job job;
    private ArrayList<PeaksearchThread> peaksearchersRunning;
    private boolean forceQuit = false;
    private IProgressMonitor peaksearchProgressMonitor;

    static {
        peaksearch = null;
        iniFile = "";
    }

    public static Peaksearch getPeaksearch() throws PeaksearchException, JepException {
        if (peaksearch == null) {
            peaksearch = new Peaksearch();
        }
        return peaksearch;
    }

    public static Peaksearch getPeaksearch(String ini) throws PeaksearchException, JepException {
        iniFile = ini;
        if (peaksearch == null) {
            peaksearch = new Peaksearch();
        }
        return peaksearch;
    }

    private Peaksearch() throws PeaksearchException {
        logger = Logger.getLogger(Peaksearch.class);
        logger.info((Object)"Create Peaksearch");
        this.xmlContentHandler = new FableXmlContentHandler();
        iniFile = Activator.getDefault().getPreferenceStore().getString("pref_ini_peaksearch");
        if (ToolBox.checkIfFileExists((String)iniFile)) {
            this.parse();
        }
        this.peaksearchersRunning = new ArrayList();
    }

    private void parse() throws PeaksearchException {
        if (this.saxReader == null) {
            try {
                this.saxReader = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException ex) {
                FableUtils.excNoTraceMsg((Object)this, (String)"Error reading XML file", (Throwable)ex);
                throw new PeaksearchException(3, this.getClass().getName(), "Peaksearch()", ex.getMessage());
            }
        }
        try {
            this.saxReader.setContentHandler((ContentHandler)this.xmlContentHandler);
            this.saxReader.parse(new InputSource("file:" + iniFile));
            this.setOptions(this.xmlContentHandler.getOptions());
            this.fireIniFile();
        }
        catch (IOException ex) {
            FableUtils.excNoTraceMsg((Object)this, (String)(String.valueOf(iniFile) + " used to create view not found"), (Throwable)ex);
            throw new PeaksearchException(3, this.getClass().getName(), "Peaksearch()", ex.getMessage());
        }
        catch (SAXException ex) {
            FableUtils.excNoTraceMsg((Object)this, (String)"Error reading XML file", (Throwable)ex);
            throw new PeaksearchException(3, this.getClass().getName(), "Peaksearch()", ex.getMessage());
        }
    }

    public void loadIniFile(String ini) throws PeaksearchException {
        if (ToolBox.checkIfFileExists((String)ini)) {
            iniFile = ini;
            logger.info((Object)("loadIniFile" + ini));
            this.parse();
        } else {
            logger.debug((Object)(String.valueOf(ini) + " file used to load peaksearch doesn't exist. " + "User must set a valid xml file name in peaksearch preferences"));
            if (FableMessageConsole.console != null) {
                FableMessageConsole.console.displayIn(" is unable to load  option view with xml file set in peaksearch preferences.");
            }
        }
    }

    public Vector<Xmloption> getOptions() {
        return this.options;
    }

    public Sample getSample(int index) {
        Sample s = null;
        if (this.samples != null) {
            this.samples.elementAt(index);
        }
        return s;
    }

    public Vector<Sample> getSamples() {
        return this.samples;
    }

    public void setIniFile(String fileName) {
        iniFile = fileName;
        this.fireGetOptions();
    }

    public static String getIniFile() {
        return iniFile;
    }

    public void setOptions(Vector<Xmloption> opt) {
        this.options = opt;
    }

    public void setSamples(Vector<Sample> s) {
        this.samples = s;
    }

    public void run() {
        this.forceQuit = false;
        this.job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                int size = 0;
                if (Peaksearch.this.samples != null) {
                    size = Peaksearch.this.samples.size();
                }
                if (size > 0 && !Peaksearch.this.forceQuit) {
                    Peaksearch.this.firePeakSearchRuns();
                    int i = 0;
                    i = 0;
                    while (i < size && !Peaksearch.this.forceQuit) {
                        Peaksearch.this.sample = Peaksearch.this.getSamples().elementAt(i);
                        Peaksearch.this.peaksearchProgressMonitor = monitor;
                        Peaksearch.this.peaksearchProgressMonitor.beginTask("Search for peaks in sample " + Peaksearch.this.sample.getDirectoryName(), -1);
                        Peaksearch.this.peaksearchersRunning.add(new PeaksearchThread(Peaksearch.this.sample));
                        ((PeaksearchThread)Peaksearch.this.peaksearchersRunning.get(i)).run();
                        if (Peaksearch.this.peaksearchProgressMonitor.isCanceled()) {
                            Peaksearch.this.forceQuit = true;
                            Peaksearch.this.firePeakSearchStops();
                            Peaksearch.this.peaksearchProgressMonitor.setCanceled(true);
                            return Status.CANCEL_STATUS;
                        }
                        ++i;
                    }
                } else {
                    Peaksearch.this.firePeakSearchRuns();
                    new PeaksearchThread().run();
                }
                Peaksearch.this.firePeakSearchStops();
                return Status.OK_STATUS;
            }
        };
        this.job.setUser(false);
        if (this.samples == null) {
            logger.error((Object)" can not be launched : There are no samples");
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)" can not be launched : There are no samples");
                }
            });
            this.firePeakSearchStops();
            return;
        }
        this.peaksearchersRunning.removeAll(this.peaksearchersRunning);
        this.listKillFile.removeAll(this.listKillFile);
        this.job.schedule();
    }

    public void forceQuit() {
        this.forceQuit = true;
        for (String file : this.listKillFile) {
            File f = new File(file);
            try {
                if (f.createNewFile()) {
                    logger.debug((Object)("Force peaksearch to exit with killFile = " + file));
                } else {
                    logger.debug((Object)("file " + file + " already exists "));
                }
                this.peaksearchProgressMonitor.setCanceled(true);
                this.job.done(Status.CANCEL_STATUS);
            }
            catch (IOException ex) {
                FableUtils.excNoTraceMsg((Object)this, (String)"Error creating a file to kill PeakSearch", (Throwable)ex);
            }
        }
        this.peaksearchProgressMonitor.setCanceled(true);
    }

    public boolean isRunning() {
        if (this.job == null) {
            return false;
        }
        return this.job.getState() == 4;
    }

    public boolean hasBeenCanceled() {
        return this.forceQuit;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyrChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void fireGetOptions() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "save_ini", null, (Object)iniFile));
        }
    }

    public void firePeakSearchRuns() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "run", (Object)false, (Object)true));
        }
    }

    public void fireIniFile() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "load_ini", (Object)false, (Object)true));
        }
    }

    public void fireLaunchPeaksearch() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "start", (Object)false, (Object)false));
        }
    }

    public void firePeakSearchStops() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "stop", (Object)false, (Object)false));
        }
    }

    public void firePeakSearchforceQuit() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "quit", (Object)false, (Object)false));
        }
    }

    public void createTempOptionFile() {
        try {
            FableJep jep = new FableJep();
            FableJep.jepImportSpecificDefinition((Jep)jep.getJep(), (String)"ImageD11", (String)"xml_pks");
            jep.eval("");
        }
        catch (JepException ex) {
            FableUtils.excNoTraceMsg((Object)this, (String)"Error creating temporary option file for PeakSearch", (Throwable)ex);
        }
    }

    public ArrayList<IPropertyChangeListener> getPropertyChangeListeners() {
        return this.listeners;
    }

    class PeaksearchThread
    implements Runnable {
        private Sample sample = null;
        private FableJep peaksearchJep = null;
        private StdoutRead stdout;
        private boolean stop = false;
        private String killFile;
        protected String currentStem;

        public PeaksearchThread(Sample s) {
            this.sample = s;
        }

        public PeaksearchThread() {
        }

        private boolean init() {
            boolean breturn = true;
            try {
                this.peaksearchJep = new FableJep();
                try {
                    File stdoutFilename = File.createTempFile("peaksearcher", ".stdout");
                    stdoutFilename.deleteOnExit();
                    logger.debug((Object)("tempFile = " + stdoutFilename.getAbsolutePath()));
                    this.peaksearchJep.redirectStdout(stdoutFilename.getAbsolutePath());
                    this.stdout = new StdoutRead(stdoutFilename.getAbsolutePath());
                    this.stdout.start();
                    String dir = stdoutFilename.getPath();
                    int index = dir.lastIndexOf(stdoutFilename.getName());
                    if (index > 0 && index < dir.length()) {
                        dir = dir.substring(0, index);
                    }
                    this.killFile = String.valueOf(dir) + "killPeakSearch." + new Date().getTime();
                    Peaksearch.this.listKillFile.add(this.killFile);
                }
                catch (IOException ex) {
                    FableUtils.excNoTraceMsg((Object)this, (String)("Error getting getting PeakSearch output for sample " + this.sample.getDirectoryName()), (Throwable)ex);
                    FableMessageConsole.console.displayIn("Error getting getting PeakSearch output for sample " + this.sample.getDirectoryName());
                    breturn = false;
                }
            }
            catch (JepException ex) {
                FableUtils.excNoTraceMsg((Object)this, (String)("Error running PeakSearch for sample " + this.sample.getDirectoryName()), (Throwable)ex);
                FableMessageConsole.console.displayIn("Error running PeakSearch for sample " + this.sample.getDirectoryName());
            }
            return breturn;
        }

        public void _run() {
            if (this.stop) {
                this.stdout.stopped = true;
                return;
            }
            if (!this.init()) {
                this.stop = true;
                this.stdout.stopped = true;
                return;
            }
            try {
                this.getDefaultPythonOptions();
            }
            catch (JepException ex) {
                this.catchJepException(ex);
            }
            try {
                String currentDirectory = null;
                if (this.sample != null) {
                    currentDirectory = this.sample.getDirectoryPath().replaceAll("\\\\", "/");
                } else {
                    boolean cannotMakeItWork = true;
                    if (cannotMakeItWork) {
                        this.stop = true;
                        this.stdout.stopped = true;
                        FableUtils.errMsg((Object)this, (String)"No sample files loaded.  Open a directory containing the images.");
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                FableMessageConsole.console.displayError("No sample files loaded.  Open a directory containing the images.");
                            }
                        });
                        return;
                    }
                    if (Peaksearch.this.options != null) {
                        for (Xmloption opt : Peaksearch.this.options) {
                            if (!opt.getOption().equals("outfile")) continue;
                            currentDirectory = opt.getValue().replaceAll("\\\\", "/");
                            break;
                        }
                        if (currentDirectory == null) {
                            this.stop = true;
                            this.stdout.stopped = true;
                            FableUtils.errMsg((Object)this, (String)"Cannot determine directory for images");
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    FableMessageConsole.console.displayError("Cannot determine directory for images");
                                }
                            });
                            return;
                        }
                    }
                }
                final String usedDirectory = currentDirectory;
                if (this.peaksearchJep != null) {
                    FableJep.jepImportModules((Jep)this.peaksearchJep.getJep(), (String)"os");
                    this.peaksearchJep.eval("os.chdir(\"" + currentDirectory + "\")");
                    try {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                FableMessageConsole.console.displayOut("Peak searching on " + usedDirectory);
                            }
                        });
                        this.transferOptionsJavaToPython(this.sample);
                        this.stdout.stopped = true;
                        this.stop = true;
                    }
                    catch (PeaksearchException ex) {
                        this.stdout.stopped = true;
                        this.stop = true;
                        FableUtils.excNoTraceMsg((Object)this, (String)"Error launching Peaksearcher.py", (Throwable)ex);
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                FableMessageConsole.console.displayError("Error launching Peaksearcher.py");
                            }
                        });
                    }
                }
            }
            catch (JepException ex) {
                this.catchJepException(ex);
            }
            this.stop = true;
        }

        @Override
        public void run() {
            if (this.stop) {
                this.stdout.stopped = true;
                return;
            }
            if (!this.init()) {
                this.stop = true;
                this.stdout.stopped = true;
                return;
            }
            try {
                this.getDefaultPythonOptions();
            }
            catch (JepException ex) {
                this.catchJepException(ex);
            }
            try {
                String currentDirectory = null;
                if (this.sample != null) {
                    final String usedDirectory = currentDirectory = this.sample.getDirectoryPath().replaceAll("\\\\", "/");
                    if (this.peaksearchJep != null) {
                        FableJep.jepImportModules((Jep)this.peaksearchJep.getJep(), (String)"os");
                        this.peaksearchJep.eval("os.chdir(\"" + currentDirectory + "\")");
                        try {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    FableMessageConsole.console.displayOut("Peak searching on " + usedDirectory);
                                }
                            });
                            this.transferOptionsJavaToPython(this.sample);
                            this.stdout.stopped = true;
                            this.stop = true;
                        }
                        catch (PeaksearchException ex) {
                            this.stdout.stopped = true;
                            this.stop = true;
                            FableUtils.excNoTraceMsg((Object)this, (String)"Error launching Peaksearcher.py", (Throwable)ex);
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    FableMessageConsole.console.displayError("Error launching Peaksearcher.py");
                                }
                            });
                        }
                    }
                } else {
                    try {
                        this.transferOptionsJavaToPython();
                    }
                    catch (PeaksearchException e) {
                        this.stdout.stopped = true;
                        this.stop = true;
                        final String msg = "Program failed " + e.getMessage();
                        FableUtils.errMsg((Object)this, (String)msg);
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                FableMessageConsole.console.displayError(msg);
                            }
                        });
                    }
                }
            }
            catch (JepException ex) {
                this.catchJepException(ex);
            }
            this.stop = true;
        }

        private void catchJepException(JepException ex) {
            this.stdout.stopped = true;
            this.stop = true;
            Peaksearch.this.firePeakSearchStops();
            FableUtils.excNoTraceMsg((Object)this, (String)"Jep Exception in PeakSearch", (Throwable)ex);
            if (Peaksearch.this.peaksearchProgressMonitor != null) {
                Peaksearch.this.peaksearchProgressMonitor.setCanceled(true);
            }
        }

        private void getDefaultPythonOptions() throws JepException {
            try {
                FableJep.jepImportSpecificDefinition((Jep)this.peaksearchJep.getJep(), (String)"ImageD11", (String)"peaksearcher");
                this.peaksearchJep.eval("class o:\n    def add_option(self, *a, **k):\n        setattr(self, k[\"dest\"], k[\"default\"])\n");
                this.peaksearchJep.eval("option_holder = o()");
                this.peaksearchJep.eval("peaksearcher.get_options( option_holder )");
                this.peaksearchJep.flushStdout();
            }
            catch (JepException ex) {
                FableUtils.excNoTraceMsg((Object)this, (String)"Error getting Python options", (Throwable)ex);
            }
        }

        public void notifyEndToPeaksearch() {
            logger.debug((Object)("killFile = " + this.killFile));
            new File(this.killFile);
            this.stop = true;
        }

        private void transferOptionsJavaToPython(final Sample mySample) throws PeaksearchException {
            String shortOutputName = null;
            int i = 0;
            while (i < Peaksearch.this.options.size() && !this.stop) {
                Xmloption opt = (Xmloption)Peaksearch.this.options.elementAt(i);
                if (opt.getOption().equals("stem")) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            logger.info((Object)("we are peaksearching for these files stem = " + mySample.getStem()));
                            PeaksearchThread.this.currentStem = mySample.getStem();
                        }
                    });
                    opt.setValue(this.currentStem);
                } else if (opt.getOption().equals("first")) {
                    opt.setValue(String.valueOf(mySample.getFirst()));
                } else if (opt.getOption().equals("format")) {
                    opt.setValue(String.valueOf(mySample.getFileFormat()));
                } else if (opt.getOption().equals("last")) {
                    opt.setValue(String.valueOf(mySample.getLast()));
                } else if (opt.getOption().equals("outfile")) {
                    shortOutputName = mySample.getPeaksearchoutStem();
                    if (shortOutputName != null) {
                        opt.setValue(String.valueOf(shortOutputName) + ".spt");
                    }
                    shortOutputName = opt.getValue();
                } else if (opt.getOption().equals("ndigits")) {
                    opt.setValue(String.valueOf(mySample.getNDigits()));
                }
                this.optionHolder(opt);
                ++i;
            }
            this.setKillFile();
            if (!Peaksearch.this.forceQuit) {
                try {
                    this.optionDriver();
                }
                catch (JepException ex) {
                    FableUtils.excNoTraceMsg((Object)this, (String)("Error setting kill file for PeakSearch for stem " + mySample.getDirectoryName()), (Throwable)ex);
                    if (FableMessageConsole.console != null) {
                        FableMessageConsole.console.displayError("Error setting kill file for PeakSearch for stem " + mySample.getDirectoryName() + ".");
                    }
                    throw new PeaksearchException(1, this.getClass().getName(), "transferOptionsJavaToPython in peaksearch_driver( option_holder , () )", ex.getMessage());
                }
            } else if (FableMessageConsole.console != null) {
                FableMessageConsole.console.displayOut("Search stopped by user.");
            }
        }

        private void transferOptionsJavaToPython() throws PeaksearchException {
            int i = 0;
            while (i < Peaksearch.this.options.size() && !this.stop) {
                Xmloption opt = (Xmloption)Peaksearch.this.options.elementAt(i);
                this.optionHolder(opt);
                ++i;
            }
            this.setKillFile();
            if (!Peaksearch.this.forceQuit) {
                try {
                    this.optionDriver();
                }
                catch (JepException ex) {
                    throw new PeaksearchException(1, this.getClass().getName(), "transferOptionsJavaToPython in peaksearch_driver( option_holder , () )", ex.getMessage());
                }
            } else if (FableMessageConsole.console != null) {
                FableMessageConsole.console.displayOut("Search stopped by user.");
            }
        }

        private void setKillFile() {
            if (this.killFile != null && !Peaksearch.this.forceQuit) {
                try {
                    this.peaksearchJep.set("killfile", this.killFile);
                    this.peaksearchJep.eval("option_holder.killfile=killfile");
                }
                catch (JepException ex) {
                    FableUtils.excNoTraceMsg((Object)this, (String)"Error setting kill file name for PeakSearch", (Throwable)ex);
                }
            }
        }

        private void optionDriver() throws JepException {
            this.peaksearchJep.eval("peaksearcher.peaksearch_driver( option_holder , () )");
            this.peaksearchJep.flushStdout();
        }

        private void optionHolder(Xmloption opt) throws PeaksearchException {
            logger.info((Object)(String.valueOf(opt.getDest()) + " " + opt.getOption() + " get value: " + opt.getValue() + " and type " + opt.getType()));
            if (opt.getValue() != null && !opt.getValue().equals("")) {
                try {
                    this.peaksearchJep.eval("option_holder." + opt.toString());
                    logger.info((Object)("option_holder." + opt.toString()));
                }
                catch (JepException ex) {
                    FableUtils.excNoTraceMsg((Object)this, (String)"Error running kill file for PeakSearch", (Throwable)ex);
                    throw new PeaksearchException(1, this.getClass().getName(), "transferOptionsJavaToPython", ex.getMessage());
                }
            }
            try {
                this.peaksearchJep.flushStdout();
            }
            catch (JepException ex) {
                FableUtils.excNoTraceMsg((Object)this, (String)"Error flushing stdout for PeakSearch", (Throwable)ex);
            }
            FableMessageConsole.console.displayOut("opt:" + opt.getOption() + "=" + opt.getValue());
        }
    }
}

