/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.object;

import fable.framework.writer.Xmlwriter;
import fable.framework.writer.XmlwriterException;
import fable.framework.xmlparser.object.XmlParserException;
import fable.framework.xmlparser.object.Xmloption;
import fable.framework.xmlparser.views.Options;
import fable.peaksearch.object.Peaksearch;
import fable.peaksearch.object.PeaksearchException;
import jep.JepException;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class OptionsImpl
implements IPropertyChangeListener {
    private Peaksearch peaksearch;
    private Options optionPeaksearch;
    Logger logger = Logger.getLogger(OptionsImpl.class);

    public OptionsImpl() {
        try {
            this.peaksearch = Peaksearch.getPeaksearch();
            this.peaksearch.addPropertyChangeListener(this);
        }
        catch (PeaksearchException e) {
            this.logger.error((Object)e.getMessage());
        }
        catch (JepException e) {
            this.logger.error((Object)e.getMessage());
        }
    }

    public void create(Composite parent) throws XmlParserException {
        if (this.peaksearch != null) {
            this.optionPeaksearch = new Options(parent, this.peaksearch.getOptions());
        }
    }

    public boolean launch() {
        boolean bok = false;
        if (this.validateView()) {
            this.logger.info((Object)"Options for peaksearch are valid");
            this.setOptions();
            bok = true;
        } else {
            this.optionPeaksearch.fireOptionsAreNotValides();
            this.peaksearch.firePeakSearchStops();
            this.optionPeaksearch.stop();
            this.logger.warn((Object)"Options for peaksearch are not valid");
        }
        return bok;
    }

    public void setOptions() {
        this.optionPeaksearch.setOptions();
    }

    public boolean validateView() {
        return this.optionPeaksearch.validateView();
    }

    public void addListener(IPropertyChangeListener i) {
        this.optionPeaksearch.addListener(i);
    }

    public void removeListener(IPropertyChangeListener i) {
        this.optionPeaksearch.removeListener(i);
    }

    public boolean updateFields(String KeyOption, String value) {
        return this.optionPeaksearch.updateFields(KeyOption, value);
    }

    public void setCurrentPath(String currentSamplePath) {
        this.optionPeaksearch.setCurrentPath(currentSamplePath);
    }

    public boolean updateFields(Control[] c, String KeyOption, String value) {
        return this.optionPeaksearch.updateFields(c, KeyOption, value);
    }

    public boolean loadOptions(Control[] c, Xmloption options) {
        return this.optionPeaksearch.loadOptions(c, options);
    }

    public boolean loadOptions(Xmloption options) {
        return this.optionPeaksearch.loadOptions(options);
    }

    public String getdefaultValue(String option) {
        return this.optionPeaksearch.getdefaultValue(option);
    }

    public void resetFields() {
        this.optionPeaksearch.resetFields();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("save_ini")) {
            try {
                this.optionPeaksearch.storeDefaultOptions();
                new Xmlwriter("root", "option", (String)event.getNewValue(), this.peaksearch.getOptions());
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Peaksearch ini file", (String)"Load fields value in default tag");
            }
            catch (XmlwriterException e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)e.getMessage());
            }
        } else if (event.getProperty().equals("stop")) {
            this.optionPeaksearch.stop();
        } else if (event.getProperty().equals("run")) {
            this.optionPeaksearch.run();
        }
    }

    public void stop() {
        this.optionPeaksearch.stop();
    }
}

