/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.actions;

import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.ToolBox;
import fable.peaksearch.object.Peaksearch;
import fable.peaksearch.object.PeaksearchException;
import java.util.Iterator;
import jep.JepException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class OpenXmlOptionResource
implements IObjectActionDelegate {
    private ISelection selection = null;
    private int nview = 0;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IFile iFile = null;
        if (this.selection instanceof IStructuredSelection) {
            Iterator it = ((IStructuredSelection)this.selection).iterator();
            while (it.hasNext()) {
                iFile = null;
                Object element = it.next();
                if (element instanceof IFile) {
                    iFile = (IFile)element;
                } else if (element instanceof IAdaptable) {
                    iFile = (IFile)((IAdaptable)element).getAdapter(IFile.class);
                }
                if (iFile == null) continue;
                this.loadFile(iFile);
            }
        }
    }

    private void loadFile(IFile iFile) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            try {
                if (ToolBox.isSmallPerspectiveSet()) {
                    PlatformUI.getWorkbench().showPerspective("fable.peaksearch.perspective.smallScreen", window);
                } else {
                    PlatformUI.getWorkbench().showPerspective("fable.peaksearch.perspective", window);
                }
            }
            catch (WorkbenchException ex) {
                FableUtils.excMsg((Object)this, (String)"Error opening PeakSearch perspective", (Throwable)ex);
                return;
            }
            try {
                String xml = iFile.getLocation().toString();
                if (xml != null) {
                    Peaksearch.getPeaksearch(xml).loadIniFile(xml);
                }
            }
            catch (PeaksearchException ex) {
                FableUtils.excNoTraceMsg((Object)this, (String)"Error loading PeakSearch options", (Throwable)ex);
            }
            catch (JepException ex) {
                FableUtils.excNoTraceMsg((Object)this, (String)"Error loading PeakSearch options", (Throwable)ex);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

