/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.run;

import fable.framework.toolbox.FableUtils;
import fable.framework.views.FableMessageConsole;
import fable.grainspotter.internal.GrainSpotterEvent;
import fable.grainspotter.internal.GrainSpotterListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ReadGveThread
implements Runnable {
    private boolean writeToConsole;
    private boolean open3DView;
    private int nGvectors = 0;
    private boolean gveFileRead;
    String gvectorFile = null;
    public CopyOnWriteArrayList<double[]> gveXYZ = new CopyOnWriteArrayList();
    private ListenerList listenerList = null;
    public String GVE_FILE_PARSED = "Gve File Parsed";

    public ReadGveThread() {
        this(true, true);
    }

    public ReadGveThread(boolean writeToConsole, boolean open3DView) {
        this.writeToConsole = writeToConsole;
        this.open3DView = open3DView;
        this.gveFileRead = false;
        this.listenerList = new ListenerList();
    }

    public void addGrainSpotterListener(GrainSpotterListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removeGrainSpotterListener(GrainSpotterListener listener) {
        this.listenerList.remove((Object)listener);
    }

    public void removeAllGrainSpotterListeners() {
        Object[] listeners;
        Object[] objectArray = listeners = this.listenerList.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            this.listenerList.remove(listener);
            ++n2;
        }
    }

    protected void fireGveFileParsedEvent() {
        Object[] listeners;
        Object[] objectArray = listeners = this.listenerList.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (listener instanceof GrainSpotterListener) {
                GrainSpotterEvent ev = new GrainSpotterEvent(this, this.GVE_FILE_PARSED, null, this.gvectorFile);
                ((GrainSpotterListener)listener).propertyChange(ev);
            }
            ++n2;
        }
    }

    public void finish() {
        if (this.listenerList != null) {
            this.removeAllGrainSpotterListeners();
        }
        this.listenerList = null;
    }

    @Override
    public void run() {
        if (this.gvectorFile != null) {
            this.gveFileRead = false;
            this.gveXYZ.clear();
            assert (this.gvectorFile != null);
            this.nGvectors = 0;
            boolean regexmatched = false;
            this.consoleIn("Started reading gve file " + this.gvectorFile);
            Pattern pattern = Pattern.compile("(.*?xr\\s+yr\\s+zr.*?$)||(.*?gx\\s+gy\\s+gz.*?$)");
            try {
                String line;
                File f = new File(this.gvectorFile);
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                while ((line = reader.readLine()) != null) {
                    if (line.length() <= 0) continue;
                    Matcher matcher = pattern.matcher(line);
                    if (matcher.matches()) {
                        regexmatched = true;
                    }
                    if (!regexmatched || matcher.matches()) continue;
                    double[] xyz = new double[3];
                    ++this.nGvectors;
                    try {
                        String[] outTokens = line.split("\\s+");
                        xyz[0] = Double.valueOf(outTokens[0]);
                        xyz[1] = Double.valueOf(outTokens[1]);
                        xyz[2] = Double.valueOf(outTokens[2]);
                        this.gveXYZ.add(xyz);
                    }
                    catch (NumberFormatException ex) {
                        FableUtils.excNoTraceMsg((Object)this, (String)("An error occured while parsing file " + this.gvectorFile + " at line " + line), (Throwable)ex);
                        this.consoleError("An error occured while parsing file " + f.getName() + " at line " + line);
                    }
                }
                reader.close();
                this.gveFileRead = true;
                this.consoleIn("Finished reading .gve file " + this.gvectorFile + " found " + this.nGvectors + " vectors");
                if (this.open3DView) {
                    this.open3Dview();
                }
                this.fireGveFileParsedEvent();
            }
            catch (IOException ex) {
                FableUtils.excNoTraceMsg((Object)this, (String)("Error while opening or reading gve file = " + this.gvectorFile), (Throwable)ex);
                this.consoleError("Error while opening or reading gve file = " + this.gvectorFile);
                this.consoleError("Make sure the path and file name are correct and verify the contents");
            }
        }
    }

    public void open3Dview() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage activePage;
                    IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null) {
                        activePage.showView("fable.grainspotter.grains3dview");
                    }
                }
                catch (PartInitException ex) {
                    FableUtils.excNoTraceMsg((Object)this, (String)"Exception occurred trying to show Grains3DView", (Throwable)ex);
                    ReadGveThread.this.consoleError("Exception occurred trying to show Grains3DView: " + (Object)((Object)ex) + "\n" + ex.getMessage());
                    ex.printStackTrace();
                }
            }
        });
    }

    private void consoleIn(String msg) {
        if (!this.writeToConsole || FableMessageConsole.console == null) {
            return;
        }
        FableMessageConsole.console.displayIn(msg);
    }

    private void consoleError(String msg) {
        if (!this.writeToConsole || FableMessageConsole.console == null) {
            return;
        }
        FableMessageConsole.console.displayError(msg);
    }

    public int getNGvectors() {
        return this.nGvectors;
    }

    public void setNGvectors(int gvectors) {
        this.nGvectors = gvectors;
    }

    public String getGvectorFile() {
        return this.gvectorFile;
    }

    public void setGvectorFile(String gvectorFile) {
        this.gvectorFile = gvectorFile;
    }

    public CopyOnWriteArrayList<double[]> getGveXYZ() {
        return this.gveXYZ;
    }

    public void setGveXYZ(CopyOnWriteArrayList<double[]> array) {
        this.gveXYZ = array;
    }

    public boolean getGveFileRead() {
        return this.gveFileRead;
    }

    public void setGveFileRead(boolean gveFileRead) {
        this.gveFileRead = gveFileRead;
    }
}

