/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.run;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.SWTUtils;
import fable.framework.toolbox.ToolBox;
import fable.framework.views.FableMessageConsole;
import fable.grainspotter.editors.GrainSpotterLogFileEditor;
import fable.grainspotter.editors.GveFileEditor;
import fable.grainspotter.internal.IVarKeys;
import fable.grainspotter.rcp.Activator;
import fable.grainspotter.run.InputFile;
import fable.grainspotter.run.LogFile;
import fable.grainspotter.view.Grains3DView;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class GrainSpotter
implements IVarKeys {
    private static final String pathSeparator = System.getProperty("file.separator");
    private InputFile inputFile;
    private LogFile logFile;
    private static final long WAIT_INTERVAL = 1000L;
    private boolean logEditorOnFinish = false;
    private boolean gveEditorOnFinish = false;
    private boolean grains3DViewOnFinish = false;
    private String grainSpotterCommand = "GrainSpotter";
    private String grainSpotterPath = ".";
    private Process grainSpotterProcess;
    public ArrayList<double[]> gveXYZ = new ArrayList();
    public ArrayList<int[]> grainGvectors = new ArrayList();
    private Runtime runtime;
    ArrayList<IPropertyChangeListener> myListeners = new ArrayList();
    protected IProgressMonitor grainSpotterMonitor;
    private String gveFileName;
    IPropertyChangeListener preferencesListener;

    public GrainSpotter() {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        this.logEditorOnFinish = prefs.getBoolean("logEditorOnFinish");
        this.gveEditorOnFinish = prefs.getBoolean("gveEditorOnFinish");
        this.grains3DViewOnFinish = prefs.getBoolean("3DViewOnFinish");
        this.preferencesListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property.equals("grainSpotterExecutable")) {
                    GrainSpotter.this.setGrainSpotterCommand(Activator.getDefault().getPreferenceStore().getString("grainSpotterExecutable"));
                } else if (property.equals("logEditorOnFinish")) {
                    String value = (String)event.getNewValue();
                    GrainSpotter.this.logEditorOnFinish = Boolean.getBoolean(value);
                } else if (property.equals("gveEditorOnFinish")) {
                    String value = (String)event.getNewValue();
                    GrainSpotter.this.gveEditorOnFinish = Boolean.getBoolean(value);
                } else if (property.equals("3DViewOnFinish")) {
                    String value = (String)event.getNewValue();
                    GrainSpotter.this.grains3DViewOnFinish = Boolean.getBoolean(value);
                }
            }
        };
        prefs.addPropertyChangeListener(this.preferencesListener);
        this.setGrainSpotterCommand(prefs.getString("grainSpotterExecutable"));
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.myListeners.remove(listener);
    }

    public void dispose() {
        this.myListeners.removeAll(this.myListeners);
        if (Activator.getDefault() != null && Activator.getDefault().getPreferenceStore() != null) {
            Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferencesListener);
        }
    }

    public void run() {
        Job job = new Job("Running GrainSpotter " + this.inputFile.iniFileName){

            protected synchronized IStatus run(IProgressMonitor monitor) {
                block16: {
                    Thread.currentThread().setName("GrainSpotter");
                    GrainSpotter.this.grainSpotterMonitor = monitor;
                    GrainSpotter.this.grainSpotterMonitor.beginTask("Running GrainSpotter " + ((GrainSpotter)GrainSpotter.this).inputFile.iniFileName + " ... ", 100);
                    GrainSpotter.this.grainSpotterMonitor.subTask("Setting up");
                    StreamReaderThread outThread = null;
                    StreamReaderThread errThread = null;
                    try {
                        GrainSpotter.this.runtime = Runtime.getRuntime();
                        String[] gsRunCommand = GrainSpotter.this.makeGSRunCommand();
                        if (gsRunCommand == null) {
                            String msg = "Failed to successfully make the GrainSpotter run command";
                            FableLogger.error((Object)msg);
                            monitor.done();
                            return new Status(4, "fable.grainspotter", msg);
                        }
                        File file = new File(((GrainSpotter)GrainSpotter.this).inputFile.iniFilePath);
                        if (!file.exists()) {
                            String msg = ".ini file path does not exist: " + ((GrainSpotter)GrainSpotter.this).inputFile.iniFilePath;
                            FableLogger.error((Object)msg);
                            monitor.done();
                            return new Status(4, "fable.grainspotter", msg);
                        }
                        GrainSpotter.this.fireStateChange("running");
                        GrainSpotter.this.grainSpotterProcess = GrainSpotter.this.runtime.exec(gsRunCommand, null, file);
                        outThread = new StreamReaderThread(GrainSpotter.this.grainSpotterProcess.getInputStream());
                        errThread = new StreamReaderThread(GrainSpotter.this.grainSpotterProcess.getErrorStream());
                        outThread.start();
                        errThread.start();
                        boolean finished = false;
                        long waitInterval = 1000L;
                        while (!finished) {
                            try {
                                ((Object)((Object)this)).wait(waitInterval);
                                try {
                                    if (GrainSpotter.this.grainSpotterMonitor.isCanceled()) {
                                        GrainSpotter.this.stop();
                                    }
                                    GrainSpotter.this.grainSpotterProcess.exitValue();
                                    finished = true;
                                }
                                catch (IllegalThreadStateException illegalThreadStateException) {}
                            }
                            catch (InterruptedException ex) {
                                if (FableMessageConsole.console == null) continue;
                                FableMessageConsole.console.displayError(ex.getMessage());
                            }
                        }
                        outThread.join();
                        errThread.join();
                        if (outThread != null) {
                            outThread.setStopped(true);
                        }
                        if (errThread != null) {
                            errThread.setStopped(true);
                        }
                        GrainSpotter.this.fireStateChange("stopped");
                    }
                    catch (IOException e) {
                        if (FableMessageConsole.console != null) {
                            FableMessageConsole.console.displayError(e.getMessage());
                        }
                    }
                    catch (InterruptedException e) {
                        if (FableMessageConsole.console == null) break block16;
                        FableMessageConsole.console.displayError(e.getMessage());
                    }
                }
                if (!GrainSpotter.this.grainSpotterMonitor.isCanceled()) {
                    GrainSpotter.this.doPostRun();
                }
                monitor.done();
                if (monitor.isCanceled()) {
                    FableMessageConsole.console.displayOut("GrainSpotter run canceled by user");
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private void doPostRun() {
        if (!Display.getDefault().isDisposed()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    String logFileToLoad = GrainSpotter.this.extendFileName(GrainSpotter.this.inputFile.getLogFileName());
                    String gveFileToLoad = GrainSpotter.this.extendFileName(GrainSpotter.this.gveFileName);
                    if (GrainSpotter.this.gveEditorOnFinish) {
                        IEditorPart part = GrainSpotter.this.openEditor(gveFileToLoad, GveFileEditor.getID());
                        if (part != null && part instanceof GveFileEditor) {
                            GveFileEditor editor = (GveFileEditor)part;
                            editor.setLogFile(logFileToLoad);
                        } else {
                            String msg = "Failed to open GveFileEditor for " + GrainSpotter.this.gveFileName;
                            if (part != null) {
                                msg = String.valueOf(msg) + "\nGot " + part.getClass() + " instead";
                            }
                            FableLogger.error((Object)msg);
                        }
                    }
                    if (GrainSpotter.this.grains3DViewOnFinish) {
                        Grains3DView view = null;
                        try {
                            IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            IWorkbenchPage activePage = activeWindow.getActivePage();
                            view = (Grains3DView)activePage.showView("fable.grainspotter.grains3dview");
                        }
                        catch (PartInitException ex) {
                            FableUtils.excNoTraceMsg((Object)this, (String)"Error opening Grains3DView", (Throwable)ex);
                        }
                        if (view == null) {
                            FableUtils.errMsg((Object)this, (String)"Error opening Grains3DView");
                        } else {
                            view.loadGVectors(gveFileToLoad);
                            view.setLogFile(logFileToLoad);
                        }
                    }
                    if (GrainSpotter.this.logEditorOnFinish) {
                        GrainSpotter.this.openEditor(logFileToLoad, GrainSpotterLogFileEditor.getID());
                    }
                }
            });
        }
    }

    public void stop() {
        this.grainSpotterProcess.destroy();
        this.fireStateChange("stopped");
    }

    public void fireStateChange(String _change) {
        for (IPropertyChangeListener element : this.myListeners) {
            element.propertyChange(new PropertyChangeEvent((Object)this, "grainspotter", null, (Object)_change));
        }
    }

    private IEditorPart openEditor(String fileName, String editorID) {
        IEditorPart part = null;
        if (ToolBox.checkIfFileExists((String)fileName)) {
            try {
                File file = new File(fileName);
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IEditorInput editorInput = SWTUtils.createEditorInput((File)file);
                IWorkbenchPage page = window.getActivePage();
                part = page.openEditor(editorInput, editorID);
            }
            catch (Exception ex) {
                FableUtils.excNoTraceMsg((Object)this, (String)("Error opening: " + fileName), (Throwable)ex);
            }
        } else {
            String msg = "Not found: " + fileName;
            FableUtils.errMsg((Object)this, (String)msg);
            if (FableMessageConsole.console != null) {
                FableMessageConsole.console.displayError(msg);
            }
        }
        return part;
    }

    private String extendFileName(String fileName) {
        File file = new File(fileName);
        if (file.isAbsolute()) {
            return fileName;
        }
        String extendedName = String.valueOf(this.inputFile.getIniFilePath()) + pathSeparator + fileName;
        file = new File(extendedName);
        return file.getAbsolutePath();
    }

    public String[] makeGSRunCommand() {
        String msg;
        File gsCommandFile = new File(this.grainSpotterCommand);
        boolean abort = false;
        if (!gsCommandFile.exists()) {
            msg = "The GrainSpotter executable: " + this.grainSpotterCommand + ", does not exist";
            FableUtils.errMsg((Object)this, (String)msg);
            FableMessageConsole.console.displayError(msg);
            FableMessageConsole.console.displayError("Check the path is correct and the command exists");
            abort = true;
        }
        if (!abort && !gsCommandFile.canExecute()) {
            msg = "The GrainSpotter executable: " + this.grainSpotterCommand + ", is not executable by this application";
            FableUtils.errMsg((Object)this, (String)msg);
            FableMessageConsole.console.displayError(msg);
            FableMessageConsole.console.displayError("Check the command and permissions");
            abort = true;
        }
        if (!abort && !this.testGrainSpotterExecutable()) {
            msg = "The GrainSpotter executable: " + this.grainSpotterCommand + " exists but cannot be run successfully";
            FableUtils.errMsg((Object)this, (String)msg);
            FableMessageConsole.console.displayError(msg);
            FableMessageConsole.console.displayError("Check the command");
            abort = true;
        }
        if (abort) {
            FableMessageConsole.console.displayError("Hint: use Edit -> Preferences to specify the GrainSpotter command");
            return null;
        }
        String[] cmd = new String[]{this.grainSpotterCommand, this.inputFile.iniFileName};
        return cmd;
    }

    public boolean testGrainSpotterExecutable() {
        Runtime runtime = Runtime.getRuntime();
        try {
            runtime.exec(this.grainSpotterCommand);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public String getGrainSpotterCommand() {
        return this.grainSpotterCommand;
    }

    public void setGrainSpotterCommand(String grainSpotterCommand) {
        this.grainSpotterCommand = grainSpotterCommand;
    }

    public void setGveFileName(String fileName) {
        this.gveFileName = fileName;
        this.fireNewGveFileToParse();
    }

    private void fireNewGveFileToParse() {
        for (IPropertyChangeListener element : this.myListeners) {
            element.propertyChange(new PropertyChangeEvent((Object)this, "new gve file", (Object)this.inputFile.iniFilePath, (Object)this.gveFileName));
        }
    }

    public String getGrainSpotterPath() {
        return this.grainSpotterPath;
    }

    public void setGrainSpotterPath(String grainSpotterPath) {
        this.grainSpotterPath = grainSpotterPath;
    }

    public String getIniFilePath() {
        return this.inputFile.iniFilePath;
    }

    public void setIniFilePath(String iniFilePath) {
        this.inputFile.iniFilePath = iniFilePath;
        if (this.inputFile.gveFilePath.equals("")) {
            this.setGveFilePath(iniFilePath);
        }
        if (this.inputFile.logFilePath.equals("")) {
            this.setLogFilePath(iniFilePath);
        }
    }

    public String getGveFilePath() {
        return this.inputFile.gveFilePath;
    }

    public void setGveFilePath(String gveFilePath) {
        this.inputFile.gveFilePath = gveFilePath;
    }

    public String getLogFilePath() {
        return this.inputFile.logFilePath;
    }

    public void setLogFilePath(String logFilePath) {
        this.inputFile.logFilePath = logFilePath;
        this.setLogFile(new LogFile(logFilePath));
    }

    private void fireLogFileHasBeenSet() {
        for (IPropertyChangeListener element : this.myListeners) {
            element.propertyChange(new PropertyChangeEvent((Object)this, "new log file", (Object)this.inputFile.iniFilePath, (Object)this.getLogFile()));
        }
    }

    public String getIniFileName() {
        return String.valueOf(this.inputFile.iniFilePath) + pathSeparator + this.inputFile.iniFileName;
    }

    public void setIniFileName(String _iniFileName) {
        if (_iniFileName.indexOf(pathSeparator) >= 0) {
            this.inputFile.iniFilePath = _iniFileName.substring(_iniFileName.lastIndexOf(pathSeparator) + 1);
            this.inputFile.iniFilePath = _iniFileName.substring(0, _iniFileName.lastIndexOf(pathSeparator) + 1);
        } else {
            this.inputFile.iniFileName = _iniFileName;
        }
    }

    public void setLogFileName(String _logFileName) {
        if (_logFileName.indexOf(pathSeparator) >= 0) {
            this.inputFile.logFileName = _logFileName.substring(_logFileName.lastIndexOf(pathSeparator) + 1);
            this.inputFile.logFilePath = _logFileName.substring(0, _logFileName.lastIndexOf(pathSeparator));
        } else {
            this.inputFile.logFilePath = this.inputFile.iniFilePath;
            this.inputFile.logFileName = _logFileName;
        }
    }

    public String getLogFileName() {
        if (this.inputFile.logFilePath.equals("")) {
            this.setLogFilePath(this.inputFile.iniFilePath);
        }
        return String.valueOf(this.inputFile.logFilePath) + pathSeparator + this.inputFile.logFileName;
    }

    public void setLogFile(LogFile f) {
        this.logFile = f;
        this.fireLogFileHasBeenSet();
    }

    public LogFile getLogFile() {
        return this.logFile;
    }

    public ArrayList<double[]> getGveXYZ() {
        return this.gveXYZ;
    }

    public void setGveXYZ(ArrayList<double[]> gveXYZ) {
        this.gveXYZ = gveXYZ;
    }

    public InputFile getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(InputFile inputFile) {
        this.inputFile = inputFile;
    }

    public class StreamReaderThread
    extends Thread {
        String outputMessage;
        InputStream inStream;
        private boolean stopped = false;

        public StreamReaderThread(InputStream in) {
            this.inStream = in;
        }

        @Override
        public void run() {
            BufferedReader outputread = new BufferedReader(new InputStreamReader(this.inStream));
            try {
                int percentage = 0;
                int workdone = 0;
                int ngrains_found = 0;
                String percentageLine = null;
                while ((this.outputMessage = outputread.readLine()) != null) {
                    if (this.outputMessage.indexOf("ngrain") != -1) {
                        ++ngrains_found;
                    }
                    if (this.outputMessage.indexOf("completed") != -1 && GrainSpotter.this.grainSpotterMonitor != null) {
                        percentageLine = this.outputMessage;
                        String percentageString = "";
                        int percentageIndex = this.outputMessage.indexOf("%");
                        percentageString = this.outputMessage.charAt(percentageIndex - 2) == ' ' ? this.outputMessage.substring(percentageIndex - 1, percentageIndex) : this.outputMessage.substring(percentageIndex - 2, percentageIndex);
                        percentage = Integer.parseInt(percentageString);
                        GrainSpotter.this.grainSpotterMonitor.worked(percentage - workdone);
                        workdone = percentage;
                    }
                    GrainSpotter.this.grainSpotterMonitor.subTask("Looking for grains - " + ngrains_found + " grains found so far" + (percentageLine == null ? "" : "\n" + percentageLine.trim()));
                    if (Display.getDefault().isDisposed()) continue;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            FableMessageConsole.console.displayOut(StreamReaderThread.this.outputMessage);
                        }
                    });
                }
            }
            catch (IOException ex) {
                FableUtils.excNoTraceMsg((Object)this, (String)"Error reading GrainSpotter run output", (Throwable)ex);
            }
        }

        public boolean isStopped() {
            return this.stopped;
        }

        public void setStopped(boolean stopped) {
            this.stopped = stopped;
        }
    }
}

