/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.providers;

import fable.grainspotter.modelviewer.GrainInfoModel;
import fable.grainspotter.modelviewer.GrainSyntaxModel;
import fable.grainspotter.modelviewer.GrainUBIMatrixModel;
import fable.grainspotter.modelviewer.GrainUMatrixModel;
import fable.grainspotter.rcp.Activator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class GrainSpotterLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private ImageDescriptor descriptor = Activator.imageDescriptorFromPlugin((String)"fable.grainspotter", (String)"icons/greendot.gif");
    private ImageDescriptor matrixDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.grainspotter", (String)"icons/umatrix3.gif");
    private ImageDescriptor infoDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.grainspotter", (String)"icons/greendotinfo.gif");
    private ImageDescriptor ubiDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.grainspotter", (String)"icons/ubi3.gif");
    private Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>(11);
    final Color light_green = new Color((Device)Display.getCurrent(), 228, 250, 240);

    public void dispose() {
        Iterator<Image> i = this.imageCache.values().iterator();
        while (i.hasNext()) {
            i.next().dispose();
        }
        this.imageCache.clear();
        if (this.light_green != null) {
            this.light_green.dispose();
        }
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = this.imageCache.get(this.descriptor);
        Image imagematrix = this.imageCache.get(this.matrixDescriptor);
        Image imageInfo = this.imageCache.get(this.infoDescriptor);
        Image imageUbi = this.imageCache.get(this.ubiDescriptor);
        if (imagematrix == null) {
            imagematrix = this.matrixDescriptor.createImage();
            this.imageCache.put(this.matrixDescriptor, imagematrix);
        }
        if (imageUbi == null) {
            imageUbi = this.ubiDescriptor.createImage();
            this.imageCache.put(this.ubiDescriptor, imageUbi);
        }
        if (imageInfo == null) {
            imageInfo = this.infoDescriptor.createImage();
            this.imageCache.put(this.infoDescriptor, imageInfo);
        }
        if (image == null) {
            image = this.descriptor.createImage();
            this.imageCache.put(this.descriptor, image);
        }
        if (columnIndex == 0) {
            if (element instanceof GrainSyntaxModel) {
                return image;
            }
            if (element instanceof GrainUBIMatrixModel) {
                return imageUbi;
            }
            if (element instanceof GrainUMatrixModel) {
                return imagematrix;
            }
            if (element instanceof GrainInfoModel) {
                return imageInfo;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof GrainSyntaxModel) {
                return ((GrainSyntaxModel)element).toString();
            }
            if (element instanceof GrainInfoModel) {
                return ((GrainInfoModel)element).getKey();
            }
            if (element instanceof GrainUMatrixModel) {
                return ((GrainUMatrixModel)element).toString();
            }
        } else if (columnIndex == 1 && element instanceof GrainInfoModel) {
            return ((GrainInfoModel)element).getValue();
        }
        return "";
    }

    public Color getBackground(Object element) {
        if (element instanceof GrainSyntaxModel) {
            return this.light_green;
        }
        return Display.getCurrent().getSystemColor(1);
    }

    public Color getForeground(Object element) {
        return null;
    }
}

