/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.preferences;

import fable.grainspotter.preferences.FloatFieldEditor;
import fable.grainspotter.rcp.Activator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DefaultValuesPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String SPACEGROUP = "pref_SpaceGroup";
    public static final String ETASPEC_MIN = "pref_etaspec_min";
    public static final String ETASPEC_MAX = "pref_etaspec_max";
    public static final String OMEGASPEC_MIN = "pref_omegaspec_min";
    public static final String OMEGASPEC_MAX = "pref_omegaspec_max";
    public static final String OMEGASPEC_DELTA = "pref_omegaspec_delta";
    public static final String STEP_EULER = "pref_eulerStep";
    public static final String CUTS_MINMEASUREMENT = "pref_cuts_minMesurement";
    public static final String CUTS_COMPLETENESS = "pref_cuts_completeness";
    public static final String UNCERTANTIE_TTH = "pref_sigma_tth";
    public static final String UNCERTANTIE_ETA = "pref_sigma_eta";
    public static final String UNCERTANTIE_OMEGA = "pref_sigma_omega";
    public static final String NSIGMA = "pref_sigmas";
    public static final String NHKL = "pref_nhkl";
    public static final String DSSPEC_MAX = "prefs_dsMax";
    public static final String DSSPEC_MIN = "prefs_dsMin";
    public static final String TTHRANGE_MIN = "prefs_tthRange_Min";
    public static final String TTHRANGE_MAX = "prefs_tthRange_Max";
    public static final String RANDOM = "prefs_Random_grainspotter";
    public static final String POSITIONFIT = "prefs_positionFit_grainspotter";
    public static final String MINFRACG = "prefs_minfracg_grainspotter";
    public static final String TTHRANGE_VS_DSPACINGRANGE = "prefs_TthrangeByDefault";
    public static final String TTHRANGEPREFFERED = "tthrangePreferred";
    public static final String DSPACINGPREFFERED = "dspacingPreffered";
    public static String CUTS_UNIQUENESS = "pref_uniqueness";
    private IntegerFieldEditor spaceGroup;
    private FloatFieldEditor etaSpecMin;
    private FloatFieldEditor etaSpecMax;
    private FloatFieldEditor omegaSpecMin;
    private FloatFieldEditor omegaSpecMax;
    private FloatFieldEditor omegaSpecDelta;
    private FloatFieldEditor stepEuler;
    private IntegerFieldEditor cutsMinMeas;
    private FloatFieldEditor cutsMinCompleteness;
    private FloatFieldEditor cutsMinUniqueness;
    private FloatFieldEditor sigmaTth;
    private FloatFieldEditor sigmaEta;
    private FloatFieldEditor sigmaOmega;
    private FloatFieldEditor nSigmas;
    private FloatFieldEditor minfracg;
    private IntegerFieldEditor nHKL;
    private List<FieldEditor> fieldsEditors;
    private IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
    private FloatFieldEditor dsSpecMin;
    private FloatFieldEditor dsSpecMax;
    private FloatFieldEditor tthRangeMin;
    private FloatFieldEditor tthRangeMax;
    private BooleanFieldEditor positionFit;
    private RadioGroupFieldEditor tthRangebyDefault;
    private IntegerFieldEditor random;

    public DefaultValuesPreferencePage() {
        super(1);
        this.setPreferenceStore(this.preferences);
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        GridLayout innerLayout = new GridLayout();
        GridData gridData0 = new GridData(1808);
        gridData0.grabExcessHorizontalSpace = true;
        innerLayout.numColumns = 2;
        parent.setLayout((Layout)innerLayout);
        parent.setLayoutData((Object)gridData0);
        this.fieldsEditors = new ArrayList<FieldEditor>();
        this.spaceGroup = new IntegerFieldEditor(SPACEGROUP, "Space group", parent);
        this.addField((FieldEditor)this.spaceGroup);
        this.fieldsEditors.add((FieldEditor)this.spaceGroup);
        this.tthRangebyDefault = new RadioGroupFieldEditor(TTHRANGE_VS_DSPACINGRANGE, "Set Tth range or D-spacing range", 2, (String[][])new String[][]{{"D-Spacing", DSPACINGPREFFERED}, {"Tth range", TTHRANGEPREFFERED}}, parent, true);
        this.addField((FieldEditor)this.tthRangebyDefault);
        this.fieldsEditors.add((FieldEditor)this.tthRangebyDefault);
        GridData gridDatads = new GridData(4, 4, true, true);
        Group grp_dspacing = new Group(parent, 16);
        grp_dspacing.setText("D-spacing range");
        grp_dspacing.setLayout((Layout)innerLayout);
        grp_dspacing.setLayoutData((Object)gridDatads);
        this.dsSpecMin = new FloatFieldEditor(DSSPEC_MIN, "Minimum", (Composite)grp_dspacing, new Float(0.0f), new Float(360.0f));
        this.addField((FieldEditor)this.dsSpecMin);
        this.fieldsEditors.add((FieldEditor)this.dsSpecMin);
        this.dsSpecMax = new FloatFieldEditor(DSSPEC_MAX, "Maximum", (Composite)grp_dspacing, new Float(0.0f), new Float(360.0f));
        this.addField((FieldEditor)this.dsSpecMax);
        this.fieldsEditors.add((FieldEditor)this.dsSpecMax);
        GridData gridDataTthRange = new GridData(4, 4, true, true);
        Group grp_Tthpacing = new Group(parent, 16);
        grp_Tthpacing.setText("Tth range");
        grp_Tthpacing.setLayout((Layout)innerLayout);
        grp_Tthpacing.setLayoutData((Object)gridDataTthRange);
        this.tthRangeMin = new FloatFieldEditor(TTHRANGE_MIN, "Minimum", (Composite)grp_Tthpacing, new Float(0.0f), new Float(360.0f));
        this.addField((FieldEditor)this.tthRangeMin);
        this.fieldsEditors.add((FieldEditor)this.tthRangeMin);
        this.tthRangeMax = new FloatFieldEditor(TTHRANGE_MAX, "Maximum", (Composite)grp_Tthpacing, new Float(0.0f), new Float(360.0f));
        this.addField((FieldEditor)this.tthRangeMax);
        this.fieldsEditors.add((FieldEditor)this.tthRangeMax);
        GridData gridDataEta = new GridData(4, 4, true, true);
        Group grp_eta = new Group(parent, 16);
        grp_eta.setText("Etat range");
        grp_eta.setLayout((Layout)innerLayout);
        grp_eta.setLayoutData((Object)gridDataEta);
        this.etaSpecMin = new FloatFieldEditor(ETASPEC_MIN, "Minimum", (Composite)grp_eta, new Float(0.0f), new Float(360.0f));
        this.addField((FieldEditor)this.etaSpecMin);
        this.fieldsEditors.add((FieldEditor)this.etaSpecMin);
        this.etaSpecMax = new FloatFieldEditor(ETASPEC_MAX, "Maximum", (Composite)grp_eta, new Float(0.0f), new Float(360.0f));
        this.addField((FieldEditor)this.etaSpecMax);
        this.fieldsEditors.add((FieldEditor)this.etaSpecMax);
        GridData gridDataomega = new GridData(4, 4, true, true);
        Group grp_omega = new Group(parent, 16);
        grp_omega.setText("Omega range");
        grp_omega.setLayout((Layout)innerLayout);
        grp_omega.setLayoutData((Object)gridDataomega);
        this.omegaSpecDelta = new FloatFieldEditor(OMEGASPEC_DELTA, "Delta", (Composite)grp_omega);
        this.addField((FieldEditor)this.omegaSpecDelta);
        this.fieldsEditors.add((FieldEditor)this.omegaSpecDelta);
        this.omegaSpecMin = new FloatFieldEditor(OMEGASPEC_MIN, "Minimum", (Composite)grp_omega, new Float(-180.0f), new Float(180.0f));
        this.addField((FieldEditor)this.omegaSpecMin);
        this.fieldsEditors.add((FieldEditor)this.omegaSpecMin);
        this.omegaSpecMax = new FloatFieldEditor(OMEGASPEC_MAX, "Maximum", (Composite)grp_omega, new Float(-180.0f), new Float(180.0f));
        this.addField((FieldEditor)this.omegaSpecMax);
        this.fieldsEditors.add((FieldEditor)this.omegaSpecMax);
        GridData gridDataCuts = new GridData(4, 4, true, true);
        Group grp_Cuts = new Group(parent, 16);
        grp_Cuts.setText("Cuts preferences");
        grp_Cuts.setLayout((Layout)innerLayout);
        grp_Cuts.setLayoutData((Object)gridDataCuts);
        this.cutsMinMeas = new IntegerFieldEditor(CUTS_MINMEASUREMENT, "Minimum measurement", (Composite)grp_Cuts);
        this.cutsMinMeas.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.cutsMinMeas);
        this.fieldsEditors.add((FieldEditor)this.cutsMinMeas);
        this.cutsMinCompleteness = new FloatFieldEditor(CUTS_COMPLETENESS, "Minimum completeness", (Composite)grp_Cuts);
        this.addField((FieldEditor)this.cutsMinCompleteness);
        this.fieldsEditors.add((FieldEditor)this.cutsMinCompleteness);
        this.cutsMinUniqueness = new FloatFieldEditor(CUTS_UNIQUENESS, "Minimum uniqueness", (Composite)grp_Cuts);
        this.addField((FieldEditor)this.cutsMinUniqueness);
        this.fieldsEditors.add((FieldEditor)this.cutsMinUniqueness);
        GridData gridDataSigma = new GridData(4, 4, true, true);
        Group grp_Sigma = new Group(parent, 16);
        grp_Sigma.setText("Uncertainties");
        grp_Sigma.setLayout((Layout)innerLayout);
        grp_Sigma.setLayoutData((Object)gridDataSigma);
        this.sigmaTth = new FloatFieldEditor(UNCERTANTIE_TTH, "Sigma 2 tetah", (Composite)grp_Sigma);
        this.addField((FieldEditor)this.sigmaTth);
        this.fieldsEditors.add((FieldEditor)this.sigmaTth);
        this.sigmaOmega = new FloatFieldEditor(UNCERTANTIE_OMEGA, "Sigma omega", (Composite)grp_Sigma);
        this.addField((FieldEditor)this.sigmaOmega);
        this.fieldsEditors.add((FieldEditor)this.sigmaOmega);
        this.sigmaEta = new FloatFieldEditor(UNCERTANTIE_ETA, "Sigma eta", (Composite)grp_Sigma);
        this.addField((FieldEditor)this.sigmaEta);
        this.fieldsEditors.add((FieldEditor)this.sigmaEta);
        this.stepEuler = new FloatFieldEditor(STEP_EULER, "Step size in Euler space in degrees", parent);
        this.addField((FieldEditor)this.stepEuler);
        this.fieldsEditors.add((FieldEditor)this.stepEuler);
        this.nSigmas = new FloatFieldEditor(NSIGMA, "NSigmas", parent);
        this.addField((FieldEditor)this.nSigmas);
        this.fieldsEditors.add((FieldEditor)this.nSigmas);
        this.minfracg = new FloatFieldEditor(MINFRACG, "Minfracg", parent);
        this.addField((FieldEditor)this.minfracg);
        this.fieldsEditors.add((FieldEditor)this.minfracg);
        this.nHKL = new IntegerFieldEditor(NHKL, "Nhkls in indexing", parent);
        this.addField((FieldEditor)this.nHKL);
        this.fieldsEditors.add((FieldEditor)this.nHKL);
        this.random = new IntegerFieldEditor(RANDOM, "Random", parent);
        this.addField((FieldEditor)this.random);
        this.fieldsEditors.add((FieldEditor)this.random);
        this.positionFit = new BooleanFieldEditor(POSITIONFIT, "Fit position of the grain", parent);
        this.addField((FieldEditor)this.positionFit);
        this.fieldsEditors.add((FieldEditor)this.positionFit);
        this.setErrorMessageForAllFields(this.fieldsEditors);
    }

    private void setErrorMessageForAllFields(List<FieldEditor> listFieldEditors) {
        for (FieldEditor currentField : listFieldEditors) {
            StringFieldEditor editor;
            if (currentField instanceof StringFieldEditor) {
                editor = (StringFieldEditor)currentField;
                editor.setErrorMessage(String.valueOf(editor.getLabelText()) + " " + editor.getErrorMessage());
                continue;
            }
            if (currentField instanceof FileFieldEditor) {
                editor = (FileFieldEditor)currentField;
                editor.setErrorMessage(String.valueOf(editor.getLabelText()) + " :" + editor.getErrorMessage().toLowerCase());
                continue;
            }
            if (!(currentField instanceof FloatFieldEditor)) continue;
            editor = (FloatFieldEditor)currentField;
            editor.setErrorMessage(String.valueOf(editor.getLabelText()) + " :" + editor.getErrorMessage().toLowerCase());
        }
    }

    protected void performDefaults() {
        this.stepEuler.loadDefault();
        this.spaceGroup.loadDefault();
        this.etaSpecMin.loadDefault();
        this.etaSpecMax.loadDefault();
        this.omegaSpecMin.loadDefault();
        this.omegaSpecMax.loadDefault();
        this.omegaSpecDelta.loadDefault();
        this.cutsMinMeas.loadDefault();
        this.cutsMinCompleteness.loadDefault();
        this.cutsMinUniqueness.loadDefault();
        this.sigmaTth.loadDefault();
        this.sigmaOmega.loadDefault();
        this.sigmaEta.loadDefault();
        this.nSigmas.loadDefault();
        this.nHKL.loadDefault();
        this.positionFit.loadDefault();
        this.random.loadDefault();
        this.tthRangeMax.loadDefault();
        this.tthRangeMin.loadDefault();
        this.minfracg.loadDefault();
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }

    public boolean isValid() {
        boolean bIsvalid = super.isValid();
        if (!bIsvalid) {
            this.getErrorMessage();
        } else {
            this.setErrorMessage(null);
        }
        return bIsvalid;
    }

    public boolean okToLeave() {
        return super.okToLeave();
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }
}

