/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.modelviewer;

import fable.grainspotter.modelviewer.GrainGvectorModel;
import fable.grainspotter.modelviewer.GrainInfoModel;
import fable.grainspotter.modelviewer.GrainMeanIAModel;
import fable.grainspotter.modelviewer.GrainModel;
import fable.grainspotter.modelviewer.GrainOrientationEulerAngleModel;
import fable.grainspotter.modelviewer.GrainOrientationQuaternionModel;
import fable.grainspotter.modelviewer.GrainOrientationRModel;
import fable.grainspotter.modelviewer.GrainUBIMatrixModel;
import fable.grainspotter.modelviewer.GrainUMatrixModel;
import fable.grainspotter.modelviewer.IModelVisitor;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class GrainSyntaxModel
extends GrainModel {
    protected List<GrainSyntaxModel> grains = new CopyOnWriteArrayList<GrainSyntaxModel>();
    protected List<GrainInfoModel> info = new CopyOnWriteArrayList<GrainInfoModel>();
    protected List<GrainMeanIAModel> meanIA = new CopyOnWriteArrayList<GrainMeanIAModel>();
    protected List<GrainUMatrixModel> Umatrix = new CopyOnWriteArrayList<GrainUMatrixModel>();
    protected List<GrainUBIMatrixModel> UBImatrix = new CopyOnWriteArrayList<GrainUBIMatrixModel>();
    protected List<GrainOrientationRModel> orientationRodrigues = new CopyOnWriteArrayList<GrainOrientationRModel>();
    protected List<GrainOrientationQuaternionModel> orientationQuaternion = new CopyOnWriteArrayList<GrainOrientationQuaternionModel>();
    protected List<GrainOrientationEulerAngleModel> orientationEuler = new CopyOnWriteArrayList<GrainOrientationEulerAngleModel>();
    protected List<GrainGvectorModel> gvectors = new CopyOnWriteArrayList<GrainGvectorModel>();
    private int gvecsMeasured = 0;
    private int gvecsExpected = 0;
    private static IModelVisitor adder = new Adder();

    public GrainSyntaxModel(String id) {
        this();
        this.id = id;
        this.setName();
    }

    public void setName() {
        this.setName("Grain #" + this.id);
    }

    public GrainSyntaxModel() {
    }

    private void addInfo(GrainInfoModel infoToAdd) {
        this.info.add(infoToAdd);
        infoToAdd.parent = this;
    }

    private void addMeanIA(GrainMeanIAModel meanIAToAdd) {
        this.meanIA.add(meanIAToAdd);
        meanIAToAdd.parent = this;
    }

    private void addUMatrix(GrainUMatrixModel i) {
        this.Umatrix.add(i);
        i.parent = this;
    }

    private void addUBIMatrix(GrainUBIMatrixModel i) {
        this.UBImatrix.add(i);
        i.parent = this;
    }

    private void addOrientationR(GrainOrientationRModel i) {
        this.orientationRodrigues.add(i);
        i.parent = this;
    }

    private void addOrientationQ(GrainOrientationQuaternionModel i) {
        this.orientationQuaternion.add(i);
        i.parent = this;
    }

    private void addOrientationEuler(GrainOrientationEulerAngleModel i) {
        this.orientationEuler.add(i);
        i.parent = this;
    }

    private void addGvector(GrainGvectorModel i) {
        this.gvectors.add(i);
        i.parent = this;
    }

    private void addGrain(GrainSyntaxModel grain) {
        this.grains.add(grain);
        grain.parent = this;
    }

    public List<GrainInfoModel> getInfo() {
        return this.info;
    }

    public List<GrainMeanIAModel> getMeanIA() {
        return this.meanIA;
    }

    public List<GrainUMatrixModel> getUMatrix() {
        return this.Umatrix;
    }

    public List<GrainUBIMatrixModel> getUBIMatrix() {
        return this.UBImatrix;
    }

    public List<GrainOrientationRModel> getOrientationRodrigues() {
        return this.orientationRodrigues;
    }

    public List<GrainOrientationQuaternionModel> getOrientationQuaternion() {
        return this.orientationQuaternion;
    }

    public List<GrainOrientationEulerAngleModel> getOrientationEuList() {
        return this.orientationEuler;
    }

    public List<GrainSyntaxModel> getGrains() {
        return this.grains;
    }

    public List<GrainGvectorModel> getGVectors() {
        return this.gvectors;
    }

    public void add(GrainModel toAdd) {
        toAdd.accept(adder, this);
    }

    public void add(GrainGvectorModel toAdd) {
        toAdd.accept(adder, this);
    }

    @Override
    public void accept(IModelVisitor visitor, Object passAlongArgument) {
        visitor.visitSyntax(this, passAlongArgument);
    }

    public String toString() {
        return this.getName();
    }

    public void add(GrainInfoModel infosModel, String string) {
    }

    public int getGvecsMeasured() {
        return this.gvecsMeasured;
    }

    public void setGvecsMeasured(int gvecsMeasured) {
        this.gvecsMeasured = gvecsMeasured;
    }

    public void addGvecsMeasured(String string) {
        try {
            int value = Integer.valueOf(string);
            this.gvecsMeasured += value;
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public int getGvecsExpected() {
        return this.gvecsExpected;
    }

    public void setGvecsExpected(int gvecsExpected) {
        this.gvecsExpected = gvecsExpected;
    }

    public void addGvecsExpected(String string) {
        try {
            int value = Integer.valueOf(string);
            this.gvecsExpected += value;
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private static class Adder
    implements IModelVisitor {
        private Adder() {
        }

        @Override
        public void visitGrainInfo(GrainInfoModel infos, Object passAlongArgument) {
            ((GrainSyntaxModel)passAlongArgument).addInfo(infos);
        }

        @Override
        public void visitGrainUMatrix(GrainUMatrixModel matrix, Object passAlongArgument) {
            ((GrainSyntaxModel)passAlongArgument).addUMatrix(matrix);
        }

        @Override
        public void visitSyntax(GrainSyntaxModel grain, Object passAlongArgument) {
            ((GrainSyntaxModel)passAlongArgument).addGrain(grain);
        }

        @Override
        public void visitGVector(GrainGvectorModel grainGvectorModel, Object passAlongArgument) {
            ((GrainSyntaxModel)passAlongArgument).addGvector(grainGvectorModel);
        }

        @Override
        public void visitGrainMeanIA(GrainMeanIAModel mean, Object passAlongArgument) {
            ((GrainSyntaxModel)passAlongArgument).addMeanIA(mean);
        }

        @Override
        public void visitGrainPhiOrientation(GrainOrientationEulerAngleModel euler, Object passAlongArgument) {
            ((GrainSyntaxModel)passAlongArgument).addOrientationEuler(euler);
        }

        @Override
        public void visitGrainQorienation(GrainOrientationQuaternionModel orienation, Object passAlongArgument) {
            ((GrainSyntaxModel)passAlongArgument).addOrientationQ(orienation);
        }

        @Override
        public void visitGrainRorientation(GrainOrientationRModel orientation, Object passAlongArgument) {
            ((GrainSyntaxModel)passAlongArgument).addOrientationR(orientation);
        }

        @Override
        public void visitGrainUBIMatrix(GrainUBIMatrixModel matrix, Object passAlongArgument) {
            ((GrainSyntaxModel)passAlongArgument).addUBIMatrix(matrix);
        }
    }
}

