/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.internal;

public interface IGrainSpotterHelp {
    public static final String filespecsDesc = "filespecs [gvector_file log_file]:\n\nGrainSpotter requires two file inputs: the name of the \ng-vector (.gve) file and the the name of the log (.log) file \nfor the output.";
    public static final String cutsDesc = "cuts [min_measuments min_completeness min_uniqueness]:\n\nMinimum sigma requirements for accepting a grain solution.";
    public static final String deltaOmegaSpecsDesc = "domega:\n\nDefines the omega step size used in the data collection.";
    public static final String minMeasurementDesc = "min_measurements:\n\nMinimum number of g-vectors assigned to the grain \n(integer value > 3).";
    public static final String minCompletenessDesc = "min_completeness:\n\nThe minimum fraction of expected reflections assigned \n(#assigned relfections / #theretical reflections) to \nthe grain (0 <= min completeness <= 1).";
    public static final String minUniquenessDesc = "min_uniqueness:\n\nMinimum fraction of reflections assigned to only\none grain (0 <= min uniqueness <= 1).  Use 0 to avoid the\ncheck.";
    public static final String uncertaintiesDesc = "uncertainties [sigma_tth, sigma_eta, sigma_omega:\n\nUntil full error estimation is available on the \ng-vectors in the input g-vector file, sigma_twotheta, \nsigma_eta and sigma_omega give your estimation of the \nuncertainties in degrees on two-theta, eta, and omega. \nSince these are estimated by the user and since they \n\"decide\" whether a theoretical gvector matches an \nobserved, it is important to vary these parameters a \nbit to obtain a set that allows GrainSpotter to able to \ndetermine the grain orientations. ";
    public static final String tthUncertaintiesDesc = "sigma_tth:\n\nYour estimate of the uncertainty (standard deviation) in \ndegrees in two-theta.";
    public static final String etaUncertaintiesDesc = "sigma_eta:\n\nYour estimate of the uncertainty (standard deviation) in \ndegrees in eta.";
    public static final String omegaUncertaintiesDesc = "sigma_omega:\n\nYour estimate of the uncertainty (standard deviation) in \ndegrees in omega.";
    public static final String nSigmasDesc = "nsigmas:\n\nGives the maximum deviation (n-Sigma) to use when \ncomparing two quantities.  For example, when nsigmas is 2, \nthen the quantities must fit within the 2-sigma range. \nIn general, |d(quantity)| < nsigmas * sigma(quantity).";
    public static final String nHKLsDesc = "Nhkls_in_indexing:\n\nUses the first though this number of hkl families to recover \nthe crystallographic orientations. Afterwards the search \nfor additional g-vectors belonging to the grain is done \non the remaining families (integer > 0).";
    public static final String minfracgDesc = "minfracg:\n\nStop search when minfracg of the gvectors have \nbeen assigned to grains. (0 < minfracg < 1)";
    public static final String positionFitDesc = "positionfit:\n\nWhen this is set, the spatial position of the grain \nis fitted simultaneously with the orientation matrix if \nthis keyword is added.";
    public static final String randomModeDesc = "The search mode can either be scan or random.  With scan, \nEuler space is scanned systematically.  With random, random \npoints in the space are used.  Random can be faster, but \nthe results may vary from run to run.  The meanning of \neulerstep is different depending on the mode.  Note that \nrandom can give different results for different runs with \nthe same input parameters";
    public static final String randomDesc = "ramdom:\n\nRandom is the number of orientations tried. It is only \nmeaningful if the mode is random.";
    public static final String eulerStepDesc = "eulerstep:\n\nWhen scanning through Euler space (orientation space),\neulerstep gives the size in degrees of each step in the scan. \nShould be between 0 and 180. \n\nWhen using random, eulerstep denotes a small volume around \nthe random orientation in which a possible match can be \nfound. By making eulerstep small the possible solutions \nfor each step are reduced, which makes it faster. However, \nyou might also need more random steps to find all grains. \nA sensible value is around 3-6 degrees.";
    public static final String crystalSystemDesc = "The crystal system is determined by the space group.";
    public static final String spaceGroupDesc = "spacegroup:\n\nThe space group ID number is needed to transform a \ndetermined orientation into the fundamental region \n(the unique part of the orientation space). This is \ndone so that the same solution will always have the same \nU matrix, not one of the other possible symmetric \norientations allowed by symmetry. Either the space group\n symbol or the number may equivalently be given, but the \nnumber is used in GrainSpotter";
    public static final String dsRangeDesc = "dsrange:\n\nOnly values of d in these ranges will be considered.  \nYou can set one or more ranges";
    public static final String tthRangeDesc = "tthrange:\n\nOnly values of tth in these ranges will be considered.  \nYou can set one or more ranges";
    public static final String omegaRangeDesc = "omegarange:\n\nOnly values of omega in these ranges will be considered.  \nYou can set one or more ranges";
    public static final String etaRangeDesc = "etarange:\n\nOnly values of eta in these ranges will be considered.  \nYou can set one or more ranges";

    public static enum GrainSpotterParameters {
        filespecs("filespecs [gvector_file log_file]", "filespecs [gvector_file log_file]:\n\nGrainSpotter requires two file inputs: the name of the \ng-vector (.gve) file and the the name of the log (.log) file \nfor the output."),
        cuts("cuts [min_measuments min_completeness min_uniqueness]", "cuts [min_measuments min_completeness min_uniqueness]:\n\nMinimum sigma requirements for accepting a grain solution."),
        minMeasurement("min_measurements", "min_measurements:\n\nMinimum number of g-vectors assigned to the grain \n(integer value > 3)."),
        minCompleteness("min_completeness", "min_completeness:\n\nThe minimum fraction of expected reflections assigned \n(#assigned relfections / #theretical reflections) to \nthe grain (0 <= min completeness <= 1)."),
        minUniqueness("min_uniqueness", "min_uniqueness:\n\nMinimum fraction of reflections assigned to only\none grain (0 <= min uniqueness <= 1).  Use 0 to avoid the\ncheck."),
        uncertainties("uncertainties [sigma_tth sigma_eta sigma_omega]", "uncertainties [sigma_tth, sigma_eta, sigma_omega:\n\nUntil full error estimation is available on the \ng-vectors in the input g-vector file, sigma_twotheta, \nsigma_eta and sigma_omega give your estimation of the \nuncertainties in degrees on two-theta, eta, and omega. \nSince these are estimated by the user and since they \n\"decide\" whether a theoretical gvector matches an \nobserved, it is important to vary these parameters a \nbit to obtain a set that allows GrainSpotter to able to \ndetermine the grain orientations. "),
        tthUncertainties("sigma_tth", "sigma_tth:\n\nYour estimate of the uncertainty (standard deviation) in \ndegrees in two-theta."),
        etaUncertainties(" sigma_eta ", "sigma_eta:\n\nYour estimate of the uncertainty (standard deviation) in \ndegrees in eta."),
        omegaUncertainties("sigma_omega", "sigma_omega:\n\nYour estimate of the uncertainty (standard deviation) in \ndegrees in omega."),
        deltaOmegaSpecs("domega [stepsize]", "domega:\n\nDefines the omega step size used in the data collection."),
        nSigmas("nsigmas", "nsigmas:\n\nGives the maximum deviation (n-Sigma) to use when \ncomparing two quantities.  For example, when nsigmas is 2, \nthen the quantities must fit within the 2-sigma range. \nIn general, |d(quantity)| < nsigmas * sigma(quantity)."),
        nHKLs("Nhkls_in_indexing", "Nhkls_in_indexing:\n\nUses the first though this number of hkl families to recover \nthe crystallographic orientations. Afterwards the search \nfor additional g-vectors belonging to the grain is done \non the remaining families (integer > 0)."),
        minfracg("minfracg", "minfracg:\n\nStop search when minfracg of the gvectors have \nbeen assigned to grains. (0 < minfracg < 1)"),
        positionFit("positionfit", "positionfit:\n\nWhen this is set, the spatial position of the grain \nis fitted simultaneously with the orientation matrix if \nthis keyword is added."),
        dsRange("dsrange [min max]", "dsrange:\n\nOnly values of d in these ranges will be considered.  \nYou can set one or more ranges"),
        tthRange("tthrange [min max]", "tthrange:\n\nOnly values of tth in these ranges will be considered.  \nYou can set one or more ranges"),
        omegaRange("omegarange [min max]", "omegarange:\n\nOnly values of omega in these ranges will be considered.  \nYou can set one or more ranges"),
        etaRange("etarange [min max]", "etarange:\n\nOnly values of eta in these ranges will be considered.  \nYou can set one or more ranges"),
        crystalSystem("-", "The crystal system is determined by the space group."),
        spaceGroup("spacegroup", "spacegroup:\n\nThe space group ID number is needed to transform a \ndetermined orientation into the fundamental region \n(the unique part of the orientation space). This is \ndone so that the same solution will always have the same \nU matrix, not one of the other possible symmetric \norientations allowed by symmetry. Either the space group\n symbol or the number may equivalently be given, but the \nnumber is used in GrainSpotter"),
        randomMode("-", "The search mode can either be scan or random.  With scan, \nEuler space is scanned systematically.  With random, random \npoints in the space are used.  Random can be faster, but \nthe results may vary from run to run.  The meanning of \neulerstep is different depending on the mode.  Note that \nrandom can give different results for different runs with \nthe same input parameters"),
        random("random", "ramdom:\n\nRandom is the number of orientations tried. It is only \nmeaningful if the mode is random."),
        eulerstep("eulerstep", "eulerstep:\n\nWhen scanning through Euler space (orientation space),\neulerstep gives the size in degrees of each step in the scan. \nShould be between 0 and 180. \n\nWhen using random, eulerstep denotes a small volume around \nthe random orientation in which a possible match can be \nfound. By making eulerstep small the possible solutions \nfor each step are reduced, which makes it faster. However, \nyou might also need more random steps to find all grains. \nA sensible value is around 3-6 degrees.");

        private final String name;
        private final String desc;

        private GrainSpotterParameters(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

