/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.internal;

import fable.grainspotter.internal.IGrainSpotterHelp;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class GrainSpotterParametersDialog
extends Dialog
implements IGrainSpotterHelp {
    private static final int TEXT_WIDTH = 400;
    private static final int TEXT_HEIGHT = 300;

    public GrainSpotterParametersDialog(Shell parent) {
        this(parent, 2144);
    }

    public GrainSpotterParametersDialog(Shell parent, int style) {
        super(parent, style);
    }

    public String open() {
        Cursor waitCursor;
        Shell shell = new Shell(this.getParent(), this.getStyle() | 0x10);
        shell.setText("GrainSpotter Parameter Information");
        Image image = null;
        try {
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
        }
        catch (Exception exception) {}
        if (image != null) {
            shell.setImage(image);
        }
        if ((waitCursor = new Cursor((Device)shell.getDisplay(), 1)) != null) {
            this.getParent().setCursor(waitCursor);
        }
        this.createContents(shell);
        this.getParent().setCursor(null);
        waitCursor.dispose();
        shell.pack();
        shell.open();
        Display display = this.getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return null;
    }

    private void createContents(final Shell shell) {
        shell.setLayout((Layout)new GridLayout());
        ScrolledComposite sc = new ScrolledComposite((Composite)shell, 768);
        sc.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 400).grab(true, true).applyTo((Control)sc);
        Composite container = new Composite((Composite)sc, 16);
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo((Control)container);
        container.setLayout((Layout)new GridLayout());
        sc.setContent((Control)container);
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        IGrainSpotterHelp.GrainSpotterParameters[] grainSpotterParametersArray = IGrainSpotterHelp.GrainSpotterParameters.values();
        int n = grainSpotterParametersArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGrainSpotterHelp.GrainSpotterParameters p = grainSpotterParametersArray[n2];
            if (!p.getName().equals("-")) {
                Group group = new Group(container, 0);
                GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)group);
                group.setText(p.getName());
                group.setLayout((Layout)new GridLayout());
                Text text = new Text((Composite)group, 2);
                GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)text);
                text.setEditable(false);
                text.setText(p.getDesc());
            }
            ++n2;
        }
        sc.setMinSize(container.computeSize(-1, -1));
        Button close = new Button((Composite)shell, 8);
        close.setText("Close");
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)close);
        close.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                shell.close();
            }
        });
        shell.setDefaultButton(close);
    }

    public static String getGrainSpotterParametersInfo() {
        String info = "";
        IGrainSpotterHelp.GrainSpotterParameters[] grainSpotterParametersArray = IGrainSpotterHelp.GrainSpotterParameters.values();
        int n = grainSpotterParametersArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGrainSpotterHelp.GrainSpotterParameters p = grainSpotterParametersArray[n2];
            if (!p.getName().equals("-")) {
                info = String.valueOf(info) + p.getName() + "\n\n";
                info = String.valueOf(info) + p.getDesc() + "\n\n";
            }
            ++n2;
        }
        return info;
    }
}

