/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.editors;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.SWTUtils;
import fable.grainspotter.editors.GrainSpotterLogFileSummary;
import fable.grainspotter.editors.GrainSpotterLogFileTable;
import fable.grainspotter.internal.GrainSpotterUtils;
import fable.grainspotter.run.LogFile;
import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.MultiPageEditorPart;

public class GrainSpotterLogFileEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
IReusableEditor {
    private static final boolean DEBUG_FLOW = false;
    private static final String ID = "fable.grainspotter.editors.GrainspotterLogFileEditor";
    private TextEditor textEditor;
    private static final int indexSummary = 0;
    private static final int indexTable = 1;
    private static final int indexText = 2;
    private boolean pagesCreated = false;
    private boolean justSaved = false;
    private GrainSpotterLogFileTable table;
    private GrainSpotterLogFileSummary summary;
    private LogFile logFile;

    public GrainSpotterLogFileEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        this.justSaved = false;
        this.updateTitle();
    }

    protected void createPages() {
        this.createLogFile();
        this.table = new GrainSpotterLogFileTable(this.getContainer(), 0, this.logFile);
        if (this.logFile != null) {
            this.logFile.parseFile();
        }
        this.createSummary();
        this.createTable();
        this.createText();
        this.pagesCreated = true;
    }

    void createSummary() {
        this.summary = new GrainSpotterLogFileSummary(this.getContainer(), 0);
        if (this.logFile == null) {
            this.summary.setInfoText("Invalid log file");
        } else {
            this.summary.setLogFile(this.logFile);
        }
        if (!this.pagesCreated) {
            this.addPage(0, (Control)this.summary);
            this.setPageText(0, "Summary");
        } else {
            this.setControl(0, (Control)this.summary);
        }
    }

    void createTable() {
        if (this.logFile == null) {
            GrainSpotterUtils.showCompositeWithError(this.table, "Invalid log file");
        }
        if (!this.pagesCreated) {
            this.addPage(1, (Control)this.table);
            this.setPageText(1, "Table");
        } else {
            this.setControl(1, (Control)this.table);
        }
    }

    void createText() {
        if (!this.pagesCreated) {
            try {
                this.textEditor = new TextEditor();
                this.addPage(2, (IEditorPart)this.textEditor, this.getEditorInput());
                this.setPageText(2, "Text");
            }
            catch (PartInitException ex) {
                FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error creating TextEditor for GrainSpotterLogFileEditor", (Throwable)ex);
            }
        } else {
            this.textEditor.setInput(this.getEditorInput());
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(0).doSave(monitor);
        this.justSaved = true;
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(2);
        if (editor == null) {
            FableUtils.errMsg((Object)((Object)this), (String)"Can't find the editor to use for \"Save As\"");
            return;
        }
        editor.doSaveAs();
        this.setInput(editor.getEditorInput());
        this.updateTitle();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            IFileEditorInput fileInput = null;
            IPath path = null;
            IResourceDelta delta = null;
            IResource res = null;
            if (this.getEditorInput() != null && this.getEditorInput() instanceof IFileEditorInput) {
                fileInput = (IFileEditorInput)this.getEditorInput();
                path = fileInput.getFile().getFullPath();
            }
            if (path != null) {
                delta = event.getDelta().findMember(path);
            }
            if (delta != null) {
                res = delta.getResource();
            }
            if (res != null) {
                int kind = delta.getKind();
                if (kind == 2) {
                    final IFileEditorInput input = fileInput;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchPage[] pages = GrainSpotterLogFileEditor.this.getSite().getWorkbenchWindow().getPages();
                            int i = 0;
                            while (i < pages.length) {
                                IEditorPart editorPart = pages[i].findEditor((IEditorInput)input);
                                pages[i].closeEditor(editorPart, true);
                                ++i;
                            }
                        }
                    });
                } else if (kind == 4) {
                    if (this.justSaved) {
                        this.justSaved = false;
                    } else {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                GrainSpotterLogFileEditor.this.handleEditorInputChanged();
                            }
                        });
                    }
                } else {
                    SWTUtils.infoMsgAsync((String)("Got POST_CHANGE [" + delta.getKind() + "] for " + path.toOSString()));
                }
            }
        }
    }

    public void handleEditorInputChanged() {
        String msg;
        String title;
        String fileName;
        Shell shell = this.getSite().getShell();
        boolean exists = false;
        try {
            IPath iPath = SWTUtils.getPath((IEditorInput)this.getEditorInput());
            File file = iPath.toFile();
            exists = file.exists();
            fileName = iPath.toOSString();
        }
        catch (Exception ex) {
            FableLogger.error((Object)"Problem getting file name for editor input change", (Throwable)ex);
            return;
        }
        if (exists) {
            title = "GrainSpotter Input File Changed";
            msg = "The file " + fileName + " has been changed on the file system. Do you want " + "to replace the editor contents with these changes?";
            boolean res = MessageDialog.openQuestion((Shell)shell, (String)title, (String)msg);
            if (res) {
                this.logFile = null;
                this.setInput(this.getEditorInput());
            }
        } else if (this.isSaveAsAllowed()) {
            title = "GrainSpotter Input File Not Accessible";
            msg = "The file " + fileName + " has been deleted or is not accessible. Do you want" + " to save your changes or close the editor without" + " saving?";
            String[] buttons = new String[]{"Save", "Close"};
            MessageDialog dialog = new MessageDialog(shell, title, null, msg, 3, buttons, 0);
            if (dialog.open() == 0) {
                this.doSaveAs();
            } else {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            }
        } else {
            title = "GrainSpotter Input File Not Accessible";
            msg = "The file " + fileName + " has been deleted or is not accessible. This editor" + " will be closed?";
            if (MessageDialog.openConfirm((Shell)shell, (String)title, (String)msg)) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            }
        }
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.pagesCreated) {
            this.createPages();
            this.firePropertyChange(258);
        }
    }

    protected void updateTitle() {
        IEditorInput input = this.getEditorInput();
        String name = FableUtils.getShortName((String)input.getName());
        name = name == null ? "GrainSpotter .log" : name;
        this.setPartName(name);
        this.setTitleToolTip(input.getToolTipText());
    }

    public void createLogFile() {
        if (this.logFile != null) {
            return;
        }
        IPath iPath = SWTUtils.getPath((IEditorInput)this.getEditorInput());
        if (iPath == null) {
            FableUtils.errMsg((Object)((Object)this), (String)"Cannot find path for .log file");
            return;
        }
        String fileName = iPath.toOSString();
        if (fileName == null) {
            FableUtils.errMsg((Object)((Object)this), (String)".log file name is null");
            return;
        }
        this.logFile = new LogFile(fileName, false);
    }

    public static String getID() {
        return ID;
    }
}

