package fable.framework.xmlparser.views;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

import fable.framework.toolbox.FileText;
import fable.framework.toolbox.FloatText;
import fable.framework.toolbox.FloatTextAppender;
import fable.framework.toolbox.IntegerText;
import fable.framework.toolbox.StringText;
import fable.framework.toolbox.ToolBox;
import fable.framework.toolbox.TypedText;
import fable.framework.xmlparser.Activator;
import fable.framework.xmlparser.internal.IOptions;
import fable.framework.xmlparser.internal.IVarKeys;
import fable.framework.xmlparser.object.XmlParserException;
import fable.framework.xmlparser.object.Xmloption;

/**
 * 
 * @author SUCHET
 * @date 20/12/2007
 * @description This class is used in a view to build fields based on Xmloptions
 *              vector. Use create to build fields in a dynamical way in your
 *              createPartContent of your view part
 */

public class Options implements IOptions, IPropertyChangeListener {
	/**
	 * This is a regular expression for String fields and file path : that means
	 * no ponctuation allowed except file separator : and / or \.
	 */
	final static String ALPHANUM_FILESPARATOR = "[\\p{Punct}&&[^_/:\\\\]]";
	/** This is the main container that will contains all fields. */
	private Composite mainComposite;
	/***/
	private Vector<Group> listGroup;
	/** a vector with options. */
	private Vector<Xmloption> options;

	/** This is <code>ImageDescriptor</code> for stop button. */
	private ImageDescriptor imagePause = Activator.imageDescriptorFromPlugin(
			Activator.PLUGIN_ID, "images/stop.gif");

	/** This is <code>ImageDescriptor</code> for launch button. */
	private ImageDescriptor imagePlay = Activator.imageDescriptorFromPlugin(
			Activator.PLUGIN_ID, "images/e_forward.gif");
	/** This is <code>ImageDescriptor</code> for revert button. */
	private ImageDescriptor imageRevert = Activator.imageDescriptorFromPlugin(
			Activator.PLUGIN_ID, "images/revert.gif");
	/** Image play when program is not running. */
	final Image imgplay = imagePlay.createImage();

	/** Image pause for button once program is running. */
	final Image imgPause = imagePause.createImage();
	/** Image revet for revert button. */
	final Image imgRevert = imageRevert.createImage();

	private ArrayList<IPropertyChangeListener> listeners = new ArrayList<IPropertyChangeListener>();
	/** This is run button */
	private Button btnRun;
	/** This is the current fields (insanceof TypedText) that have an error. */
	private TypedText currentErrorField = null;
	private String currentPath = System.getProperty("user.dir"); // current Path
	private DropTargetListener dropTargetListener;
	private boolean isRunning = false;

	/***********************************************************************
	 * Constructor
	 * 
	 * @param parent
	 * @param opt
	 * @throws XmlParserException
	 ******************************************************************/
	public Options(Composite parent, Vector<Xmloption> opt)
			throws XmlParserException {
		options = opt;

		dropTargetListener = new DropTargetListener() {

			public void dragEnter(DropTargetEvent event) {
				if (event.detail == DND.DROP_DEFAULT) {
					if ((event.operations & DND.DROP_COPY) != 0) {
						event.detail = DND.DROP_COPY;
					} else {
						event.detail = DND.DROP_NONE;
					}
				}
			}

			public void dragLeave(DropTargetEvent event) {

			}

			public void dragOperationChanged(DropTargetEvent event) {

			}

			public void dragOver(DropTargetEvent event) {
				// provides visual feedback
				event.feedback = DND.FEEDBACK_SELECT | DND.FEEDBACK_SCROLL;

			}

			public void drop(DropTargetEvent event) {
				// if any text was dropped

				if (TextTransfer.getInstance().isSupportedType(
						event.currentDataType)) {
					// get the drop data
					DropTarget target = (DropTarget) event.widget;
					// Adapt text with drag and drop of imageViewer
					TypedText txt = (TypedText) target.getControl();
					String data = (String) event.data;
					String[] split = data.split("\\s+");
					String draggedText = "";
					if (split.length > 2) {
						draggedText = split[2];
					}
					Xmloption option = (Xmloption) txt.getData();
					if (option != null) {
						String name = option.getOption();
						if (name.equals(IVarKeys.XML_STEM)) {
							draggedText = ToolBox.getStem(draggedText);
						} else if (name.equals(IVarKeys.XML_FILEFORMAT)) {
							draggedText = "."
									+ ToolBox.getFileType(draggedText);
						} else if (name.equals(IVarKeys.XML_FIRST_FILE)
								|| name.equals(IVarKeys.XML_LAST_FILE)) {
							draggedText = ToolBox.getFileNumber(draggedText);
						}
					}

					txt.set_Text(draggedText);
					fireFieldModified(
							((Xmloption) (txt.getData())).getOption(), txt
									.getText());
				}

			}

			public void dropAccept(DropTargetEvent event) {

			}
		};
		create(parent);
		// Init enable/disabled fields
		enableFields(mainComposite.getChildren());
	}

	/**************************************************************************/
	// Controls
	/**************************************************************************/
	/**
	 * @param Composite
	 *            parent, boolean bok set to trus the first call
	 * @return boolean true if all fields are validate, that means required
	 *         fields are filled and typed fields have right values
	 * 
	 * <br>
	 *         Change 01/21/2009 : If user has created a directory for exampl,
	 *         an field that was in error should not be an error. So I change
	 *         <code>((TypedText) element[i]).is_bValide()</code> for
	 * 
	 *         <code> ((TypedText) element[i]).checkValue(((TypedText) element[i]).getText()</code>
	 * 
	 */
	public boolean checkFields(Composite parent, boolean bok) {
		currentErrorField = null;
		Control[] element = parent.getChildren();

		for (int i = 0; bok && i < element.length; i++) {

			if (element[i] instanceof Composite) {

				if (element[i] instanceof TypedText
						&& !((TypedText) element[i])
								.checkValue(((TypedText) element[i]).getText())
						&& ((TypedText) element[i]).getTextField().isEnabled()) {
					bok = false;
					currentErrorField = (TypedText) element[i];

					currentErrorField.showDecoration();
					//currentErrorField.showError();
					//currentErrorField.showrequired();
				} else {
					bok = checkFields((Composite) element[i], bok);
				}

			}
		}
		return bok;
	}

	/**************************************************************************/
	// Widgets instantiation
	/**
	 *  *********************************************************************/

	/**
	 * @name create
	 * @param Composite
	 *            parent
	 * @throws XmlParserException
	 *             if the xml file is not correct
	 * @description create a view with an xml file
	 */
	public void create(Composite parent) throws XmlParserException {
		// Display display = parent.getDisplay();

		/******************************************************************/
		ScrolledComposite sc = new ScrolledComposite(parent, SWT.V_SCROLL
				| SWT.H_SCROLL);
		// sc.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 3,1));
		mainComposite = new Composite(sc, SWT.FILL | SWT.RESIZE);
		mainComposite.setLayout(new GridLayout(1, false));

		/********************************************************************/
		listGroup = new Vector<Group>();
		// HashMap<String, Group> hashGroup = new HashMap<String, Group>();
		/********************************************************/
		/*
		 * Group vary = new Group(mainComposite, SWT.FILL );
		 * 
		 * vary.setLayout(new GridLayout(3, false)); GridData gd1 = new
		 * GridData( SWT.FILL, SWT.RESIZE, true, false);
		 * 
		 * vary.setLayoutData(gd1); vary.setText("Variable options");
		 * 
		 * Group common = new Group(mainComposite, SWT.FILL); GridData gd2 = new
		 * GridData( SWT.FILL, SWT.RESIZE, true, false);
		 * 
		 * common.setLayout(new GridLayout(3, false));
		 * common.setLayoutData(gd2); common.setText("Common options");
		 */Group global = new Group(mainComposite, SWT.FILL);
		GridData gd2 = new GridData(SWT.LEFT, SWT.RESIZE, true, false);
		global.setLayout(new GridLayout(3, false));
		global.setLayoutData(gd2);
		if (options != null) {

			for (int i = 0; options != null && i < options.size(); i++) {

				Xmloption opt = options.elementAt(i);
				/*
				 * String groupName = opt.getGroup();
				 * if(!hashGroup.containsKey(groupName)){ Group group = new
				 * Group(mainComposite, SWT.FILL); GridData gdGroup = new
				 * GridData( SWT.FILL, SWT.RESIZE, true, false);
				 * group.setLayout(new GridLayout(3, false));
				 * group.setLayoutData(gdGroup); group.setText(groupName);
				 * hashGroup.put(groupName, group); }
				 */
				/*
				 * global = hashGroup.get(groupName); if(opt.vary()){
				 * global=vary; }else{ global=common; }
				 */
				String type = opt.getType();
				// String help = opt.getHelp();
				String name = opt.getOption();
				String labelName = String.valueOf(name.toLowerCase().charAt(0))
						.toUpperCase()
						+ name.toLowerCase().substring(1, name.length());

				if (type.equals(IVarKeys.XML_OPTION_FILE)
						|| type.equals(IVarKeys.XML_OPTION_STRING)
						|| type.equals(IVarKeys.XML_OPTION_INT)
						|| type.equals(IVarKeys.XML_OPTION_FLOAT)
						|| type.equals(IVarKeys.XML_OPTION_OUTFILE)
						|| type.equals(IVarKeys.XML_OPTION_OUTSTEM)) {
					Label label = new Label(global, SWT.None);
					label.setText(labelName);
					final TypedText txt;
					if (type.equals(IVarKeys.XML_OPTION_FILE)) {
						txt = new FileText(global, SWT.NONE, "");
					} else if (type.equals(IVarKeys.XML_OPTION_STRING)
							|| type.equals(IVarKeys.XML_OPTION_OUTFILE)) {
						txt = new StringText(global, SWT.NONE, "");

					} else if (type.equals(IVarKeys.XML_OPTION_OUTSTEM)) {

						txt = new StringText(global, SWT.NONE, "",
								ALPHANUM_FILESPARATOR, "No punctuation allowed");

					} else if (type.equals(IVarKeys.XML_OPTION_INT)) {
						txt = new IntegerText(global, SWT.None, "");
					} else if (type.equals(IVarKeys.XML_OPTION_FLOAT)) {

						if (opt.getAction().equals("append")) {
							txt = new FloatTextAppender(global, SWT.None, "",
									",");
						} else {
							txt = new FloatText(global, SWT.None, "");
						}

					} else {
						txt = null;
					}

					if (txt != null) {
						txt.setToolTipText(options.elementAt(i).getHelp());

						txt.setLayoutData(new GridData(SWT.FILL, SWT.CENTER,
								true, false, 2, 1));

						if (type.equals(IVarKeys.XML_OPTION_FILE)) {

							Button btn_browse = new Button(global, SWT.PUSH);
							((GridData) txt.getLayoutData()).horizontalSpan = 1;
							btn_browse.setLayoutData(new GridData(
									SWT.BEGINNING, SWT.CENTER, false, false, 1,
									1));
							btn_browse.setText("Browse...");
							btn_browse
									.addSelectionListener(new SelectionAdapter() {
										public void widgetSelected(
												SelectionEvent e) {

											FileDialog dlg = new FileDialog(
													((Button) e.widget)
															.getParent()
															.getShell(),
													SWT.SIMPLE);
											dlg.setFilterPath(currentPath);
											String sFile = dlg.open();
											if (sFile != null) {
												txt.set_Text(sFile);

											}
										}

									});
						} else if (type.equals(IVarKeys.XML_OPTION_OUTFILE)) {
							Button btn_browse = new Button(global, SWT.PUSH);
							((GridData) txt.getLayoutData()).horizontalSpan = 1;

							btn_browse.setLayoutData(new GridData(
									SWT.BEGINNING, SWT.CENTER, false, false, 1,
									1));
							btn_browse.setText("Directory...");
							btn_browse
									.addSelectionListener(new SelectionAdapter() {
										public void widgetSelected(
												SelectionEvent e) {

											FileDialog dlg = new FileDialog(
													((Button) e.widget)
															.getParent()
															.getShell(),
													SWT.SAVE);

											dlg.setFilterPath(currentPath);
											String filename = dlg.open();

											boolean done = false;
											if (filename != null) {
												File file = new File(filename);
												if (file.exists()) {

													MessageBox mb = new MessageBox(
															dlg.getParent(),
															SWT.ICON_WARNING
																	| SWT.YES
																	| SWT.NO);
													mb
															.setMessage(filename
																	+ " already exists. Do you want to overwrite it?");
													done = mb.open() == SWT.YES;
												} else {
													done = true;
												}
												if (done) {
													txt.set_Text(filename);
													fireFieldModified(
															((Xmloption) (txt
																	.getData()))
																	.getOption(),
															txt.getText());
												}

											}

										}

									});
						} else if (type.equals(IVarKeys.XML_OPTION_OUTSTEM)) {
							Button btn_browse = new Button(global, SWT.PUSH);
							((GridData) txt.getLayoutData()).horizontalSpan = 1;

							btn_browse.setLayoutData(new GridData(
									SWT.BEGINNING, SWT.CENTER, false, false, 1,
									1));
							btn_browse.setText("Directory...");
							btn_browse
									.addSelectionListener(new SelectionAdapter() {
										public void widgetSelected(
												SelectionEvent e) {

											DirectoryDialog dlg = new DirectoryDialog(
													((Button) e.widget)
															.getParent()
															.getShell(),
													SWT.SAVE);

											dlg.setFilterPath(currentPath);
											String sdir = dlg.open();

											if (sdir != null) {

												String stem = txt.getText();
												int indexOfpath = stem
														.lastIndexOf(System
																.getProperty("file.separator"));
												if (indexOfpath >= 0) {
													indexOfpath += 1;
													if (indexOfpath < stem
															.length()) {
														stem = stem
																.substring(indexOfpath);
													}
												}
												String text = sdir
														+ System
																.getProperty("file.separator")
														+ stem;
												txt.set_Text(text);
												fireFieldModified(
														((Xmloption) (txt
																.getData()))
																.getOption(),
														txt.getText());

											}

										}

									});
						}

						DropTarget target = new org.eclipse.swt.dnd.DropTarget(
								txt, DND.DROP_COPY | DND.DROP_DEFAULT);
						target.setTransfer(new TextTransfer[] { TextTransfer
								.getInstance() });
						target.addDropListener(dropTargetListener);

						try {
							txt.set_Text(opt.getDefault_value());
							txt.setData(opt);
							txt.setData("default", opt.getDefault_value());
							txt.setData("option", opt.getOption());

						} catch (NumberFormatException n) {
							System.out.println("catch " + n.getMessage());
						}

						//
						if (opt.isRequired()) {
							txt.set_isRequiredField(true);
						}
						if (!opt.isEnabled()) {
							txt.setEnabled(false);
						}

						/*
						 * txt.getTextField().addFocusListener(new
						 * FocusAdapter() {
						 * 
						 * public void focusLost(FocusEvent e) {
						 * 
						 * fireFieldModified(((Xmloption) (txt.getData()))
						 * .getOption(), txt.getText());
						 * 
						 * }; });
						 */
						txt.getTextField().addKeyListener(new KeyAdapter() {
							@Override
							public void keyPressed(KeyEvent e) {
								if (e.keyCode == SWT.CR
										|| e.keyCode == SWT.KEYPAD_CR) {
									fireFieldModified(((Xmloption) (txt
											.getData())).getOption(), txt
											.getText());
								}
							}
						});

						txt.getTextField().addModifyListener(
								new ModifyListener() {
									@Override
									public void modifyText(ModifyEvent e) {
										fireFieldModified(((Xmloption) (txt
												.getData())).getOption(), txt
												.getText());

									}
								});
					}
					/********************* CHOICE *************************/
				} else if (type.equals(IVarKeys.XML_OPTION_CHOICE)) {

					String choices = opt.getChoices().replaceAll("\\(", "");

					String[] listchoice = choices.split("\\)");
					GridData gdForCbo = new GridData(SWT.LEFT, GridData.CENTER,
							true, false, 3, 1);

					if (listchoice.length > 1) {
						if (listchoice.length < 4) {
							// build radio button
							Group radioGroup = new Group(global, SWT.NONE);
							radioGroup.setText(labelName);
							radioGroup.setToolTipText(opt.getHelp());
							radioGroup.setLayout(new GridLayout(
									listchoice.length, false));
							radioGroup.setLayoutData(gdForCbo);

							for (int nb = 0; nb < listchoice.length; nb++) {

								Button btn_rd = new Button(radioGroup,
										SWT.RADIO);
								btn_rd
										.addSelectionListener(new SelectionAdapter() {
											@Override
											public void widgetSelected(
													SelectionEvent e) {
												enableFields(null);
											}
										});
								btn_rd.setLayoutData(new GridData());
								btn_rd.setSelection(opt.getDefault_value()
										.equals(
												listchoice[nb].replaceAll(" ",
														"")));
								String[] labelAndValue = listchoice[nb]
										.split(",");
								if (labelAndValue != null
										&& labelAndValue.length == 2) {
									btn_rd.setData("option", opt.getOption());
									btn_rd.setData(opt);
									btn_rd.setData(labelAndValue[0],
											labelAndValue[1]);
									btn_rd.setData("value", labelAndValue[1]);
									btn_rd.setData("default", opt.getDefault_value());
									if (opt.getDefault_value() != null) {
										btn_rd.setSelection(opt
												.getDefault_value().equals(
														labelAndValue[1]));
									}
									btn_rd.setText(labelAndValue[0]);
								} else {
									throw new XmlParserException(0, this
											.getClass().getName(),
											"create(Composite parent)",
											"Input xml file not properly set for "
													+ labelName);
								}
							}

							radioGroup.setData(opt);
							radioGroup.setData("option", opt.getOption());
						} else {

							/*
							 * Composite cmpToAlignToTypeText= new
							 * Composite(global,SWT.NONE);
							 * cmpToAlignToTypeText.setData(opt);
							 * cmpToAlignToTypeText.setLayout( new GridLayout(3,
							 * true)); cmpToAlignToTypeText.setLayoutData( new
							 * GridData( GridData.FILL , GridData.CENTER, true,
							 * false, 4, 1));
							 */

							/*
							 * Label lbl = new Label(global, SWT.NONE);
							 * lbl.setText(labelName);
							 *//*
								 * lbl.setLayoutData(new GridData(SWT.FILL ,
								 * GridData.CENTER, true, false, 1, 1));
								 */

							Combo cbo = new Combo(global, SWT.READ_ONLY
									| SWT.DROP_DOWN);

							cbo.setLayout(new GridLayout(3, true));
							cbo.setLayoutData(new GridData(SWT.FILL, SWT.FILL,
									true, false, 2, 1));
							cbo.setToolTipText(opt.getHelp());
							cbo.setText(labelName);
							for (int nb = 0; nb < listchoice.length; nb++) {
								String[] labelAndValue = listchoice[nb]
										.split(",");
								if (labelAndValue != null
										&& labelAndValue.length == 2) {
									cbo.setData(labelAndValue[0],
											labelAndValue[1]);
									cbo.setData("value", labelAndValue[1]);
									cbo.add(labelAndValue[0]);
								} else {
									throw new XmlParserException(0, this
											.getClass().getName(),
											"create(Composite parent)",
											"Input xml file not properly set for "
													+ labelName);
								}

							}

							cbo.select(cbo.indexOf(opt.getDefault_value()));
							cbo.addSelectionListener(new SelectionAdapter() {
								public void widgetSelected(SelectionEvent e) {
									System.out.println("Test de la selection:"
											+ ((Combo) e.widget)
													.getData(((Combo) e.widget)
															.getText()));
								}
							});
							cbo.setData(opt);
							cbo.setData("option", opt.getOption());
							cbo.setData("default", opt.getDefault_value());
							// build list box
						}

					} else {
						throw new XmlParserException(0, this.getClass()
								.getName(), "create(Composite parent)",
								"Input xml file for choices " + labelName
										+ "  not properly set");

					}
					/******** NO TYPE **************************/

				} else if (type.equals(IVarKeys.XML_OPTION_CHECK)) {
					final Button bcheck = new Button(global, SWT.CHECK);

					bcheck.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER,
							true, false, 3, 1));
					bcheck.setText(labelName);
					bcheck.setToolTipText(opt.getHelp());
					bcheck.setData(opt);
					bcheck.setData("option", opt.getOption());
					bcheck.setData("default", opt.getDefault_value());
					opt.setValue(opt.getDefault_value());
					bcheck.setSelection(opt.getDefault_value().equals("True"));
					bcheck.addSelectionListener(new SelectionAdapter() {
						@Override
						public void widgetSelected(SelectionEvent e) {
							Xmloption opt = (Xmloption) ((Button) e.getSource())
									.getData();
							if (opt != null) {
								if (((Button) e.getSource()).getSelection()) {
									opt.setValue("True");
								} else {
									opt.setValue("False");
								}
							}
						}
					});
				} else {
					Label lbl = new Label(global, SWT.NONE);
					lbl.setText(labelName);

					Composite cmpToAlignToTypeText = new Composite(global,
							SWT.NONE);
					cmpToAlignToTypeText.setData(options.elementAt(i));
					cmpToAlignToTypeText.setLayout(new GridLayout(3, true));
					cmpToAlignToTypeText.setLayoutData(new GridData(SWT.LEFT,
							GridData.CENTER, true, false, 4, 1));

					/*
					 * lbl.setLayoutData(new GridData(SWT.LEFT ,
					 * GridData.CENTER, true, false, 1, 1));
					 */
					/*
					 * GridData gd = new GridData(SWT.FILL , SWT.FILL , true,
					 * true); gd.horizontalSpan=2;
					 */

					final Text txt = new Text(cmpToAlignToTypeText, SWT.BORDER);
					// txt.setBackground(display.getSystemColor(SWT.COLOR_MAGENTA));
					txt.setToolTipText(options.elementAt(i).getHelp());
					txt.setText(options.elementAt(i).getDefault_value());
					// txt.setLayoutData(new GridLayout(3, true));

					txt.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true,
							false, 1, 1));
					DropTarget target = new org.eclipse.swt.dnd.DropTarget(txt,
							DND.DROP_COPY | DND.DROP_MOVE);
					target.setTransfer(new TextTransfer[] { TextTransfer
							.getInstance() });
					target.addDropListener(dropTargetListener);
					txt.addModifyListener(new ModifyListener() {
						@Override
						public void modifyText(ModifyEvent e) {
							fireFieldModified(((Xmloption) (((Text) e.widget)
									.getData())).getOption(), ((Text) e.widget)
									.getText());

						}
					});
					/*
					 * txt.addFocusListener( new FocusAdapter(){@Override
					 * 
					 * public void focusLost(FocusEvent e) {
					 * 
					 * fireFieldModified(((Xmloption)(
					 * ((Text)e.widget).getData())).getOption(),
					 * ((Text)e.widget).getText());
					 * 
					 * }}); txt.addKeyListener(new KeyAdapter() {
					 * 
					 * @Override public void keyPressed(KeyEvent e) { if
					 * (e.keyCode == SWT.CR || e.keyCode == SWT.KEYPAD_CR) {
					 * fireFieldModified
					 * (((Xmloption)(((Text)e.widget).getData())).
					 * getOption(),((Text)e.widget).getText()); } } });
					 */

					txt.setData(options.elementAt(i));

					txt.setData("option", opt.getOption());
					txt.setData("default", options.elementAt(i)
							.getDefault_value());
					//
					/*
					 * if(!opt.isEnabled()){ txt.setEnabled(false); }
					 */

				}

				listGroup.add(global);
			}
			/*
			 * if(vary.getChildren().length ==0){ vary.setVisible(false); }
			 */
			/******************************************************************/
			// BUTTONS
			/******************************************************************/
			// new Label(global, SWT.NONE);
			Composite cmpToAlignBtn = new Composite(mainComposite, SWT.NONE);
			/*
			 * cmpToAlignBtn.setBackground(Display.getDefault().getSystemColor(
			 * SWT.COLOR_CYAN));
			 */
			cmpToAlignBtn.setLayout(new FillLayout(SWT.HORIZONTAL));
			//
			// cmpToAlignBtn.setLayoutData(new RowLayout());
			// cmpToAlignBtn.setLayoutData(new GridData( SWT.FILL ,
			// GridData.CENTER, true, false,1,2));

			Button bdefault = new Button(cmpToAlignBtn, SWT.BORDER);
			bdefault.setAlignment(SWT.RIGHT);
			/*
			 * bdefault.setLayoutData(new GridData(SWT.RIGHT_TO_LEFT, SWT.FILL,
			 * true, true, 2,2));
			 */
			bdefault.setToolTipText("Restore default values");
			bdefault.setImage(imgRevert);
			bdefault.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					// Put default values in text fields
					setDefault(mainComposite.getChildren(), null);
				}
			});

			bdefault.addDisposeListener(new DisposeListener() {

				public void widgetDisposed(DisposeEvent e) {

					imgRevert.dispose();

				}
			});
			bdefault.setText("Restore default values");

			btnRun = new Button(cmpToAlignBtn, SWT.BORDER);
			btnRun.setAlignment(SWT.RIGHT);
			/*
			 * btn.setLayoutData(new GridData(SWT.RIGHT_TO_LEFT, SWT.FILL, true,
			 * true, 2,2));
			 */
			btnRun.setToolTipText("Run");
			btnRun.setText("Run application");
			btnRun.setImage(imgplay);
			btnRun.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {

					if (isRunning) {
						isRunning = false;
						setLaunchImage(isRunning);
						fireButtonStopPushed();

					} else {
						isRunning = true;
						setLaunchImage(isRunning);
						fireButtonStartPushed();

					}
				}

			});
			btnRun.addDisposeListener(new DisposeListener() {

				public void widgetDisposed(DisposeEvent e) {

					imgplay.dispose();
					imgPause.dispose();
				}

			});
			btnRun.setVisible(false);
			bdefault.setVisible(false);
		} // end of if(peaksearch != null)

		// END OF SCROLLING CODE
		sc.setContent(mainComposite);
		// sc.setMinWidth(display.getClientArea().width);
		// sc.setMinHeight(display.getClientArea().height);
		// sc.setMinWidth(display.getPrimaryMonitor().getBounds().width);
		sc.setExpandVertical(true);
		sc.setExpandHorizontal(true);
		sc.setMinSize(mainComposite.computeSize(SWT.DEFAULT, SWT.DEFAULT));

	}

	// set value in xml object stored in Data object
	public void storeDefaultOptions() {
		storeDefaultOptions(mainComposite.getChildren(), null);
	}

	/**
	 * @Description this function is called when the user save ini file as xml.
	 *              It stores the values in fields in the default option
	 */
	private void storeDefaultOptions(Control[] element, Xmloption opt) {
		// Control[] element = global.getChildren();
		// Xmloption opt=null;
		for (int i = 0; i < element.length; i++) {

			if (element[i] instanceof Group) {
				opt = (Xmloption) ((Group) element[i]).getData();
				storeDefaultOptions(((Group) element[i]).getChildren(), opt);
			} else if (element[i] instanceof TypedText) {
				opt = (Xmloption) ((TypedText) element[i]).getData();
				opt.putTag("default", ((TypedText) element[i]).getText());

			} else if (element[i] instanceof Button) {

				Button btn = (Button) element[i];
				if (btn.getSelection()) {

					opt.putTag("default", (String) btn.getData(btn.getText()));
				}
			} else if (element[i] instanceof Combo) {

				Combo cb = (Combo) element[i];
				opt.putTag("default", (String) cb.getData(cb.getText()));

			} else if (element[i] instanceof Composite) {
				storeDefaultOptions(((Composite) element[i]).getChildren(),
						(Xmloption) ((Composite) element[i]).getData());

			} else if (element[i] instanceof Text) {

				opt = (Xmloption) ((Text) element[i]).getData();
				opt.putTag("default", ((Text) element[i]).getText());
			}

		}
	}

	/** This method get values in the text field and set it in XmlOption object. */
	public void setOptions() {
		setOptions(mainComposite.getChildren(), null);
	}

	private void setOptions(Control[] element, Xmloption opt) {
		// parcours les widgets et assigne les valeurs trouvees dans les champs
		// avec les data ?

		// Control[] element = global.getChildren();

		for (int i = 0; i < element.length; i++) {

			if (element[i] instanceof Group) {
				opt = (Xmloption) ((Group) element[i]).getData();
				setOptions(((Group) element[i]).getChildren(), opt);
			} else if (element[i] instanceof TypedText) {
				opt = (Xmloption) ((TypedText) element[i]).getData();
				opt.setValue(((TypedText) element[i]).getText());

			} else if (element[i] instanceof Button) {

				Button btn = (Button) element[i];
				opt = (Xmloption) ((Button) element[i]).getData();
				if ((btn.getStyle() & SWT.RADIO) != 0 && btn.getSelection()) {
					opt.setValue((String) btn.getData(btn.getText()));
					/*if (options.contains(opt)) {
						System.out.println("option " + opt.getOption()
								+ " found");

					} else {
						System.out.println("option " + opt.getOption()
								+ "NOt found");

					}*/
				} else if ((btn.getStyle() & SWT.CHECK) != 0) {
					if (btn.getSelection()) {
						opt.setValue("True");
					} else {
						opt.setValue("False");
					}
				}

			} else if (element[i] instanceof Combo) {

				Combo cb = (Combo) element[i];
				opt.setValue((String) cb.getData(cb.getText()));

			} else if (element[i] instanceof Composite) {
				setOptions(((Composite) element[i]).getChildren(),
						(Xmloption) ((Composite) element[i]).getData());

			} else if (element[i] instanceof Text) {

				opt = (Xmloption) ((Text) element[i]).getData();
				opt.setValue(((Text) element[i]).getText());
			}

		}

	}

	/**************************************************************************/
	// Launch
	/**************************************************************************/

	/**
	 * This method first checks if fields are ok and then set options from the
	 * textfield to XmlOption.
	 * 
	 * @return true if fields are ok.
	 */
	public boolean launch() {
		boolean bok = false;

		if (validateView()) {

			setOptions();

			bok = true;
		}
		return bok;
	}

	/**************************************************************************/
	// Control fields
	/**************************************************************************/

	public boolean validateView() {
		return checkFields(mainComposite, true);
	}

	/***************************************************************************
	 * Register or remove listeners
	 * 
	 ************************************************************************/
	public void addPropertyChangeListener(IPropertyChangeListener listener) {
		listeners.add(listener);
	}

	public void removePropertyChangeListener(IPropertyChangeListener listener) {
		listeners.remove(listener);
	}

	public void fireButtonStartPushed() {
		for (Iterator<IPropertyChangeListener> it = listeners.iterator(); it
				.hasNext();) {
			IPropertyChangeListener element = (IPropertyChangeListener) it
					.next();
			if (element != null) {

				element.propertyChange(new PropertyChangeEvent(this, "start",
						false, true));
			}
		}
	}

	public void fireButtonStopPushed() {
		for (Iterator<IPropertyChangeListener> it = listeners.iterator(); it
				.hasNext();) {
			IPropertyChangeListener element = (IPropertyChangeListener) it
					.next();
			if (element != null) {

				element.propertyChange(new PropertyChangeEvent(this, "quit",
						false, true));
			}
		}
	}

	public void fireOptionsAreNotValides() {
		for (Iterator<IPropertyChangeListener> it = listeners.iterator(); it
				.hasNext();) {
			IPropertyChangeListener element = (IPropertyChangeListener) it
					.next();
			if (element != null) {
				element.propertyChange(new PropertyChangeEvent(this,
						"unvalidate", false, currentErrorField));
			}
		}
	}

	/**
	 * If a field value has changed, fire this event to listener
	 */
	public void fireFieldModified(String name, String value) {

		for (Iterator<IPropertyChangeListener> it = listeners.iterator(); it
				.hasNext();) {
			IPropertyChangeListener element = (IPropertyChangeListener) it
					.next();
			if (element != null) {
				element.propertyChange(new PropertyChangeEvent(this,
						"fieldChanged", name, value));
			}
		}
	}

	public void addListener(IPropertyChangeListener listener) {
		listeners.add(listener);

	}

	public void removeListener(IPropertyChangeListener listener) {
		listeners.remove(listener);

	}

	/**
	 * Displays default values stored in options in the fields. Called from
	 * button default to restore default values
	 * 
	 */
	private void setDefault(Control[] element, Xmloption opt) {
		for (int i = 0; i < element.length; i++) {
			String defaultValue = null;
			if (element[i] instanceof TypedText) {
				opt = (Xmloption) ((TypedText) element[i]).getData();
				if (opt != null) {
					defaultValue = opt.getDefault_value();
					if (defaultValue != null) {
						((TypedText) element[i]).set_Text(defaultValue);
						fireFieldModified(opt.getOption(), defaultValue);
					}

				}

			} else if (element[i] instanceof Text) {
				opt = (Xmloption) ((Text) element[i]).getData();
				if (opt != null) {
					defaultValue = opt.getDefault_value();
					if (defaultValue != null) {
						((Text) element[i]).setText(defaultValue);
						fireFieldModified(opt.getOption(), defaultValue);
					}

				}

			} else if (element[i] instanceof Combo) {
				Combo cbo = ((Combo) element[i]);
				opt = (Xmloption) cbo.getData();
				if (opt != null) {
					defaultValue = opt.getDefault_value();
					if (defaultValue != null) {
						cbo.select(cbo.indexOf(defaultValue));
						fireFieldModified(opt.getOption(), defaultValue);
					}
				}

			} else if (element[i] instanceof Group) {
				// if(((Group)element[i]).getData() != null){
				setDefault(((Group) element[i]).getChildren(),
						(Xmloption) ((Group) element[i]).getData());
				// }
			} else if (element[i] instanceof Button) {
				Button btn = (Button) element[i];

				if ((btn.getStyle() & SWT.RADIO) != 0) {
					if (opt != null) {
						defaultValue = opt.getDefault_value();
						if (defaultValue != null) {
							btn.setSelection(defaultValue.equals(btn
									.getData(btn.getText())));
							fireFieldModified(opt.getOption(), defaultValue);
						}

					}

				}
			}
		}

	}

	/**
	 * @name updateFields
	 * @param String
	 *            KeyOption the fields to update, String value the value to set
	 *            in the field
	 * @description this function is called when a sample is selected, and
	 *              update the value of the fields with the value of the sample.
	 *              For example, in peaksearch, several samples can be selected.
	 *              so when a sample is selected, stem, first and last values
	 *              should be update
	 */
	public boolean updateFields(Control[] element, String KeyOption,
			String value) {

		Xmloption opt;
		if (element == null) {
			element = mainComposite.getChildren();
		}
		boolean bFound = false; // stops when widget is found
		for (int i = 0; !bFound && i < element.length; i++) {

			if (element[i] instanceof TypedText) {
				opt = (Xmloption) ((TypedText) element[i]).getData();
				if (opt.getOption().equals(KeyOption)) {
					if (value == null) {
						String defaultValue = (String) ((TypedText) element[i])
								.getData("default");
						((TypedText) element[i]).set_Text(defaultValue);
					} else {
						((TypedText) element[i]).set_Text(value);
					}
					bFound = true;
				}

			} else if (element[i] instanceof Text) {
				opt = (Xmloption) ((Text) element[i]).getData();
				if (opt.getOption().equals(KeyOption)) {
					if (value == null) {
						String defaultValue = (String) ((Text) element[i])
								.getData("default");
						((Text) element[i]).setText(defaultValue);
					} else {
						((Text) element[i]).setText(value);
					}
					bFound = true;
				}
			} else if (element[i] instanceof Composite) {
				bFound = updateFields(((Composite) element[i]).getChildren(),
						KeyOption, value);
			}

		}
		enableFields(null);
		return bFound;

	}

	private void setLaunchImage(boolean bplay) {

		if (!bplay) {
			Display.getDefault().syncExec(new Runnable() {
				public void run() {
					if (!imgplay.isDisposed()) {
						btnRun.setImage(imgplay);
						btnRun.setToolTipText("Launch program");
					}

				}
			});

		} else {

			Display.getDefault().syncExec(new Runnable() {
				public void run() {
					if (!imgPause.isDisposed()) {
						btnRun.setImage(imgPause);
					}
					btnRun.setToolTipText("Stop program");
				}
			});

		}

	}

	public void propertyChange(PropertyChangeEvent event) {

	}

	// @Override
	public void setCurrentPath(String currentSamplePath) {
		currentPath = currentSamplePath;

	}

	public boolean updateFields(String KeyOption, String value) {

		return updateFields(mainComposite.getChildren(), KeyOption, value);

	}

	/**
	 * Enable or disable fields under conditions if exist in xml file <enabled>
	 * 
	 * @param element
	 * @return
	 */
	public boolean enableFields(Control[] element) {
		boolean enable = true;
		if (element == null) {
			element = mainComposite.getChildren();
		}
		for (int i = 0; i < element.length; i++) {
			Xmloption option = null;
			if (element[i] instanceof TypedText) {
				TypedText txt = (TypedText) element[i];
				option = (Xmloption) txt.getData();
				if (option != null) {
					txt.setEnabled(true);
					String conditionforEnable = option.getEnabledCondition();
					if (!conditionforEnable.equals("")) {
						Xmloption condition = getOption(null,
								conditionforEnable, null);
						if (condition != null
								&& condition.getValue() != null
								&& !condition.getValue().equals(
										option.getEnabledValue())) {
							enable = false;
							txt.setEnabled(false);

						}
					}
				}

			} else if (element[i] instanceof Text) {
				Text txt = (Text) element[i];
				option = (Xmloption) txt.getData();
				if (option != null) {
					txt.setEnabled(true);
					String conditionforEnable = option.getEnabledCondition();
					if (!conditionforEnable.equals("")) {
						Xmloption condition = getOption(null,
								conditionforEnable, null);
						if (condition != null
								&& condition.getValue() != null
								&& !condition.getValue().equals(
										option.getEnabledValue())) {
							enable = false;
							txt.setEnabled(false);
						}
					}
				}

			} else if (element[i] instanceof Composite) {
				enable = enableFields(((Composite) element[i]).getChildren());
			}

		}

		return enable;
	}

	/**
	 * Loop over all fields until the field with the option name in the parameter is
	 * found.
	 * 
	 * @return
	 */
	public Xmloption getOption(Control[] element, String option_Name,
			Xmloption opt) {
		if (element == null) {
			element = mainComposite.getChildren();
		}
		Xmloption xmlOptionFound = opt; // stops when widget is found
		for (int i = 0; (xmlOptionFound == null) && i < element.length; i++) {

			if (element[i] instanceof TypedText) {
				TypedText txt = (TypedText) element[i];

				String keyopt = (String) (txt).getData("option");
				if (keyopt != null && keyopt.equals(option_Name)) {
					xmlOptionFound = (Xmloption) txt.getData();
					xmlOptionFound.setValue(txt.getTextField().getText());
				}

			} else if (element[i] instanceof Text) {
				Text txt = (Text) element[i];
				String keyopt = (String) (txt).getData("option");
				if (keyopt != null && keyopt.equals(option_Name)) {
					xmlOptionFound = (Xmloption) txt.getData();
					xmlOptionFound.setValue(txt.getText());
				}
			} else if (element[i] instanceof Combo) {
				Combo cbo = ((Combo) element[i]);
				String keyopt = (String) (cbo).getData("option");
				if (keyopt != null && keyopt.equals(option_Name)) {
					xmlOptionFound = (Xmloption) cbo.getData();
					xmlOptionFound.setValue(cbo.getText());
				}

			} else if (element[i] instanceof Group) {
				Group grp = ((Group) element[i]);
				String keyopt = (String) (grp).getData("option");
				if (keyopt != null && keyopt.equals(option_Name)) {
					xmlOptionFound = (Xmloption) grp.getData();
					for (int j = 0; xmlOptionFound != null
							&& j < grp.getChildren().length; j++) {

						if (grp.getChildren()[j] instanceof Button) {
							Button btn = (Button) grp.getChildren()[j];
							if ((btn.getStyle() & SWT.RADIO) != 0) {
								if (btn.getSelection()) {

									xmlOptionFound.setValue((String) btn
											.getData("value"));
								}

							}

						}

					}
				} else {
					xmlOptionFound = getOption(((Composite) element[i])
							.getChildren(), option_Name, xmlOptionFound);
				}
			} else if (element[i] instanceof Button) {
				Button btn = (Button) element[i];
				if ((btn.getStyle() & SWT.RADIO) != 0) {
					String keyopt = (String) (btn).getData("option");
					if (keyopt != null && keyopt.equals(option_Name)) {
						xmlOptionFound = (Xmloption) btn.getData();
						if (btn.getSelection()) {
							xmlOptionFound.setValue((String) btn
									.getData("value"));
						}
					}

				}
			} else if (element[i] instanceof Composite) {
				xmlOptionFound = getOption(((Composite) element[i])
						.getChildren(), option_Name, xmlOptionFound);
			}

		}
		return xmlOptionFound;
	}

	/**
	 * This function is called when user load an xml file
	 */
	public boolean loadOptions(Control[] element, Xmloption option) {

		String option_Name = option.getOption();

		if (element == null) {
			element = mainComposite.getChildren();
		}

		boolean bFound = false; // stops when widget is found
		for (int i = 0; !bFound && i < element.length; i++) {

			if (element[i] instanceof TypedText) {
				TypedText txt = (TypedText) element[i];

				String keyopt = (String) (txt).getData("option");
				if (keyopt != null && keyopt.equals(option_Name)) {
					txt.setData(option);
					txt.setData("default", option.getDefault_value());
					txt.set_Text(option.getDefault_value());

					bFound = true;
				}

			} else if (element[i] instanceof Text) {
				Text txt = (Text) element[i];
				String keyopt = (String) (txt).getData("option");
				if (keyopt != null && keyopt.equals(option_Name)) {
					txt.setData(option);
					txt.setData("default", option.getDefault_value());
					txt.setText(option.getDefault_value());
					bFound = true;
				}
			} else if (element[i] instanceof Button) {

				Button btn = (Button) element[i];
				String keyopt = (String) (btn.getData("option"));
			
				if (keyopt != null && keyopt.equals(option_Name)) {
					btn.setData(option);
					if (option.getType().equals(IVarKeys.XML_OPTION_CHOICE)) {
							
							if ((btn.getStyle() & SWT.RADIO) != 0
									|| (btn.getStyle() & SWT.CHECK) != 0) {
								//Warning : do not get the default value for buttons 
								String val = (String)btn.getData("value");
								if(val != null){
									boolean select = val.equals(option.getDefault_value());
									btn.setSelection(select);
								}
								
							

						}

					}
				}
			} else if (element[i] instanceof Combo) {

				Combo cb = (Combo) element[i];
				String keyopt = (String) cb.getData("option");
				if (option.getOption().equals(keyopt)) {
					cb.setData("default", option.getDefault_value());
					if (option.getType().equals(IVarKeys.XML_OPTION_CHOICE)) {
						 option.getChoices().replaceAll("\\(",
								"");

						cb.select(cb.indexOf(option.getDefault_value()));

					}

					bFound = true;
				}

			} else if (element[i] instanceof Composite) {
				bFound = loadOptions(((Composite) element[i]).getChildren(),
						option);
			}

		}
		return bFound;

	}

	/**
	 * This function is called when user load an xml file
	 */
	public boolean loadOptions(Xmloption option) {

		return loadOptions(mainComposite.getChildren(), option);

	}

	/**
	 * return the default value stored for this option
	 */
	public String getdefaultValue(String option) {
		Xmloption opt = getOption(null, option, null);
		String ret = "";
		if (opt != null) {
			ret = opt.getDefault_value();
		}
		return ret;
	}

	public void resetFields() {
		setDefault(mainComposite.getChildren(), null);

	}

	public void stop() {
		isRunning = false;
		setLaunchImage(isRunning);

	}

	public void run() {
		isRunning = true;
		setLaunchImage(isRunning);

	}

	/**
	 * @return a vector of all options that have been used to build ViewPart.
	 */
	public Vector<Xmloption> getOptions() {
		return options;
	}

	public TypedText getCurrentNonValidField() {
		return currentErrorField;
	}
}
