/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.database.test;

import fable.framework.database.Activator;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class DatabaseTest {
    private static final String DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String PROTOCOL = "jdbc:derby:";
    private static final String DATABASE = "grainsDB";
    private static final String CREATE_TABLE = "CREATE TABLE grains(id int, gvectors int)";
    private static final String SELECT_RECORDS_QUERY = "SELECT SUM(id) FROM grains";
    private static final String INSERT_RECORDS_QUERY = "INSERT INTO grains (id,gvectors) VALUES(1,10)";

    public DatabaseTest() throws SQLException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        Statement s;
        Connection currentConnection = null;
        System.setProperty("derby.system.home", Activator.getDefault().getStateLocation().toFile().getAbsolutePath());
        Properties props = new Properties();
        try {
            Class.forName(DRIVER).newInstance();
            currentConnection = DriverManager.getConnection("jdbc:derby:grainsDB", props);
        }
        catch (SQLException sQLException) {
            currentConnection = DriverManager.getConnection("jdbc:derby:grainsDB;create=true", props);
            try {
                s = currentConnection.createStatement();
                try {
                    s.execute(CREATE_TABLE);
                }
                finally {
                    s.close();
                }
                currentConnection.commit();
            }
            catch (SQLException ex) {
                currentConnection.close();
                throw ex;
            }
        }
        try {
            s = currentConnection.createStatement();
            try {
                s.execute(INSERT_RECORDS_QUERY);
                ResultSet rs = s.executeQuery(SELECT_RECORDS_QUERY);
                rs.next();
                ResultSet results = s.executeQuery("select * from grains");
                ResultSetMetaData rsmd = results.getMetaData();
                int numberCols = rsmd.getColumnCount();
                int i = 1;
                while (i <= numberCols) {
                    System.out.print(String.valueOf(rsmd.getColumnLabel(i)) + "\t\t");
                    ++i;
                }
                System.out.println("\n-------------------------------------------------");
                while (results.next()) {
                    int id = results.getInt(1);
                    int gvectors = results.getInt(2);
                    System.out.println(String.valueOf(id) + "\t\t" + gvectors);
                }
                results.close();
            }
            finally {
                s.close();
            }
            currentConnection.commit();
        }
        finally {
            currentConnection.close();
        }
    }
}

