/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolExportInterface;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Viewer;

public abstract class _Exporter
implements JmolExportInterface {
    protected Viewer viewer;
    protected JmolRendererInterface jmolRenderer;
    protected StringBuffer output;
    protected BufferedWriter bw;
    private FileOutputStream os;
    protected String fileName;
    protected String commandLineOptions;
    protected boolean isToFile;
    protected Graphics3D g3d;
    protected int screenWidth;
    protected int screenHeight;
    protected int slabZ;
    protected int depthZ;
    boolean use2dBondOrderCalculation = false;
    protected Point3f center = new Point3f();
    protected Point3f tempP1 = new Point3f();
    protected Point3f tempP2 = new Point3f();
    protected Point3f tempP3 = new Point3f();
    protected Vector3f tempV1 = new Vector3f();
    protected Vector3f tempV2 = new Vector3f();
    protected Vector3f tempV3 = new Vector3f();
    protected AxisAngle4f tempA = new AxisAngle4f();
    protected static final float degreesPerRadian = 57.29578f;

    public void setRenderer(JmolRendererInterface jmolRendererInterface) {
        this.jmolRenderer = jmolRendererInterface;
    }

    public boolean initializeOutput(Viewer viewer, Graphics3D graphics3D, Object object) {
        this.viewer = viewer;
        this.g3d = graphics3D;
        this.center.set(viewer.getRotationCenter());
        if (this.screenWidth <= 0 || this.screenHeight <= 0) {
            this.screenWidth = viewer.getScreenWidth();
            this.screenHeight = viewer.getScreenHeight();
        }
        this.slabZ = graphics3D.getSlab();
        this.depthZ = graphics3D.getDepth();
        this.isToFile = object instanceof String;
        if (this.isToFile) {
            this.fileName = (String)object;
            int n = this.fileName.indexOf(":::");
            if (n > 0) {
                this.commandLineOptions = this.fileName.substring(n + 3);
                this.fileName = this.fileName.substring(0, n);
            }
            viewer.createImage(this.fileName + ".spt", viewer.getSavedState("_Export"), Integer.MIN_VALUE, 0, 0);
            try {
                this.os = new FileOutputStream(this.fileName);
                this.bw = new BufferedWriter(new OutputStreamWriter(this.os));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
        } else {
            this.output = (StringBuffer)object;
        }
        return true;
    }

    public String finalizeOutput() {
        if (!this.isToFile) {
            return this.output.toString();
        }
        try {
            this.bw.flush();
            this.bw.close();
            this.os = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    protected String getExportDate() {
        return new SimpleDateFormat("EEE, MMMM dd, yyyy 'at' h:mm aaa").format(new Date());
    }

    protected Vector3f getRotation(Vector3f vector3f) {
        this.tempV3.set(vector3f);
        this.tempV3.normalize();
        float f = (float)Math.sqrt(vector3f.x * vector3f.x + vector3f.y * vector3f.y + vector3f.z * vector3f.z);
        float f2 = (float)Math.acos(vector3f.y / f) * 57.29578f;
        if (vector3f.x < 0.0f) {
            f2 += 180.0f;
        }
        float f3 = (float)Math.atan2(vector3f.x, vector3f.z) * 57.29578f;
        this.tempV3.set(f2, f3, 0.0f);
        return this.tempV3;
    }

    protected AxisAngle4f getAxisAngle(Vector3f vector3f) {
        this.tempV3.set(0.0f, 1.0f, 0.0f);
        this.tempV2.set(vector3f);
        this.tempV2.normalize();
        this.tempV3.add(this.tempV2);
        this.tempA.set(this.tempV3.x, this.tempV3.y, this.tempV3.z, 3.14159f);
        return this.tempA;
    }

    protected String rgbFromColix(short s, char c) {
        int n = this.g3d.getColixArgb(s);
        return "" + (n >> 16 & 0xFF) + c + (n >> 8 & 0xFF) + c + (n & 0xFF);
    }

    protected String rgbFractionalFromColix(short s, char c) {
        return this.rgbFractionalFromArgb(this.g3d.getColixArgb(s), c);
    }

    protected String rgbFractionalFromArgb(int n, char c) {
        return "" + (float)(n >> 16 & 0xFF) / 255.0f + c + (float)(n >> 8 & 0xFF) / 255.0f + c + (float)(n & 0xFF) / 255.0f;
    }

    protected String translucencyFractionalFromColix(short s) {
        int n = Graphics3D.getColixTranslucencyLevel(s);
        if (Graphics3D.isColixTranslucent(s)) {
            return "" + (float)n / 255.0f;
        }
        return "" + 0.0f;
    }
}

