/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.editors;

import fable.framework.toolbox.Activator;
import fable.framework.ui.actions.SaveAsColumnFileEditorAction;
import fable.framework.ui.actions.SaveColumnFileEditorAction;
import fable.framework.ui.editors.ColumnFileContentProvider;
import fable.framework.ui.editors.ColumnFileEditorInput;
import fable.framework.ui.editors.ColumnFileLabelProvider;
import fable.framework.ui.editors.IColumnFileEditor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class ColumnFileEditor
extends EditorPart
implements IPropertyChangeListener,
IColumnFileEditor {
    private static final String ID = "fable.framework.ui.ColumnFileEditor";
    private ColumnFileEditorInput columnInput;
    private boolean dirty = false;
    private TableViewer tableViewer;
    final Color light_blue = new Color((Device)Display.getCurrent(), 228, 247, 248);
    private Table table;
    private Listener sortListener;
    private Image imgMenuRemove;
    private ImageDescriptor GifDelete = Activator.imageDescriptorFromPlugin((String)"fable.framework.toolbox", (String)"images/delete.gif");
    private ImageDescriptor keep_descriptor = Activator.imageDescriptorFromPlugin((String)"fable.framework.toolbox", (String)"images/check.gif");
    private Image imageKeep;
    private SaveColumnFileEditorAction saveAction;
    private SaveAsColumnFileEditorAction saveasAction;

    public void doSave(IProgressMonitor monitor) {
        this.columnInput.save();
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
        if (this.columnInput.saveAs()) {
            this.dirty = false;
            this.firePropertyChange(257);
            this.setPartName(this.columnInput.getColumn().getFileName());
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.columnInput = (ColumnFileEditorInput)input;
        this.setPartName(this.columnInput.getColumn().getFileName());
        this.initSortListener();
        this.columnInput.getColumn().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return this.dirty;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        GridData gdExplorer = new GridData(4, 4, true, true);
        gdExplorer.horizontalAlignment = 4;
        gdExplorer.verticalAlignment = 4;
        gdExplorer.horizontalSpan = 1;
        this.tableViewer = new TableViewer(parent, 268503042);
        this.tableViewer.setContentProvider((IContentProvider)new ColumnFileContentProvider(this.tableViewer));
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ColumnFileLabelProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.tableViewer.setInput((Object)this.columnInput.getColumn());
        this.table = this.tableViewer.getTable();
        this.table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 3) {
                    Menu menu = new Menu((Decorations)Display.getCurrent().getActiveShell(), 8);
                    MenuItem mitemRemove = new MenuItem(menu, 8);
                    MenuItem mitemKeep = new MenuItem(menu, 8);
                    ColumnFileEditor.this.imgMenuRemove = ColumnFileEditor.this.GifDelete.createImage();
                    mitemRemove.setImage(ColumnFileEditor.this.imgMenuRemove);
                    mitemRemove.setText("Throw");
                    mitemRemove.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent arg0) {
                            if (ColumnFileEditor.this.imgMenuRemove != null && !ColumnFileEditor.this.imgMenuRemove.isDisposed()) {
                                ColumnFileEditor.this.imgMenuRemove.dispose();
                            }
                        }
                    });
                    mitemRemove.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            TableItem[] selection = ColumnFileEditor.this.table.getSelection();
                            if (selection.length > 0 && ColumnFileEditor.this.table.getItemCount() > 0) {
                                ColumnFileEditor.this.table.getColumnCount();
                                Object[] idlist = new Object[selection.length];
                                int i = 0;
                                while (i < selection.length) {
                                    idlist[i] = selection[i].getText(ColumnFileEditor.this.table.getColumnCount() - 1);
                                    ++i;
                                }
                                ColumnFileEditor.this.columnInput.getColumn().removeRow(idlist, ColumnFileEditor.this.columnInput.getColumn().getColumnfileId());
                                ColumnFileEditor.this.dirty = true;
                                ColumnFileEditor.this.firePropertyChange(257);
                            }
                        }
                    });
                    ColumnFileEditor.this.imageKeep = ColumnFileEditor.this.keep_descriptor.createImage();
                    mitemKeep.setImage(ColumnFileEditor.this.imageKeep);
                    mitemKeep.setText("Keep");
                    mitemKeep.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent arg0) {
                            if (ColumnFileEditor.this.imageKeep != null && !ColumnFileEditor.this.imageKeep.isDisposed()) {
                                ColumnFileEditor.this.imageKeep.dispose();
                            }
                        }
                    });
                    mitemKeep.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            TableItem[] selection = ColumnFileEditor.this.table.getSelection();
                            if (selection.length > 0 && ColumnFileEditor.this.table.getItemCount() > 0) {
                                ColumnFileEditor.this.table.getColumnCount();
                                Object[] idlist = new Object[selection.length];
                                int i = 0;
                                while (i < selection.length) {
                                    idlist[i] = selection[i].getText(ColumnFileEditor.this.table.getColumnCount() - 1);
                                    ++i;
                                }
                                ColumnFileEditor.this.columnInput.getColumn().keepRow(idlist, ColumnFileEditor.this.columnInput.getColumn().getColumnfileId());
                                ColumnFileEditor.this.dirty = true;
                                ColumnFileEditor.this.firePropertyChange(257);
                            }
                        }
                    });
                    menu.setVisible(true);
                    while (!menu.isDisposed() && menu.isVisible()) {
                        if (Display.getCurrent().readAndDispatch()) continue;
                        Display.getCurrent().sleep();
                    }
                    menu.dispose();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.table.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                int index = event.index;
                item.setBackground(index % 2 == 0 ? Display.getCurrent().getSystemColor(1) : ColumnFileEditor.this.light_blue);
            }
        });
        this.populateTable();
        this.makeActions();
    }

    private void contributetoActionBar() {
        IActionBars bars = this.getEditorSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.saveAction);
        toolBarManager.add((IAction)this.saveasAction);
    }

    private void makeActions() {
        this.saveAction = new SaveColumnFileEditorAction(){

            @Override
            public void run(IColumnFileEditor editor) {
                ((ColumnFileEditor)editor).doSave(null);
            }
        };
        this.saveAction.setProps("Save column file");
        this.saveasAction = new SaveAsColumnFileEditorAction(){

            @Override
            public void run(IColumnFileEditor editor) {
                ((ColumnFileEditor)editor).doSaveAs();
            }
        };
        this.saveasAction.setProps("Save column file as...");
    }

    public void setFocus() {
    }

    public static String getId() {
        return ID;
    }

    private void populateTable() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ColumnFileEditor.this.table.removeAll();
                ColumnFileEditor.this.table.clearAll();
                while (ColumnFileEditor.this.table.getColumnCount() > 0) {
                    ColumnFileEditor.this.table.getColumn(0).removeListener(13, ColumnFileEditor.this.sortListener);
                    ColumnFileEditor.this.table.getColumn(0).dispose();
                }
                String[] keys = ColumnFileEditor.this.columnInput.getColumn().getTitles();
                int i = 0;
                while (i < ColumnFileEditor.this.columnInput.getColumn().getNCols()) {
                    TableColumn tb = new TableColumn(ColumnFileEditor.this.table, 16384);
                    tb.setText(keys[i]);
                    tb.addListener(13, ColumnFileEditor.this.sortListener);
                    ++i;
                }
                ColumnFileEditor.this.table.setItemCount(ColumnFileEditor.this.columnInput.getColumn().getNRows());
                i = 0;
                while (i < ColumnFileEditor.this.table.getColumnCount()) {
                    ColumnFileEditor.this.table.getColumn(i).pack();
                    ++i;
                }
            }
        });
    }

    private void initSortListener() {
        this.sortListener = new Listener(){

            public void handleEvent(Event e) {
                TableColumn sortColumn = ColumnFileEditor.this.table.getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                TableColumn[] cols = ColumnFileEditor.this.table.getColumns();
                TableColumn column = (TableColumn)e.widget;
                int index = 0;
                int x = 0;
                while (index == 0 && x < cols.length) {
                    if (cols[x].getText().equals(column.getText())) {
                        index = x;
                    }
                    ++x;
                }
                int dir = ColumnFileEditor.this.table.getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    ColumnFileEditor.this.table.setSortColumn(currentColumn);
                    dir = 128;
                }
                ColumnFileEditor.this.columnInput.getColumn().setSortedIndex(index, dir);
                ColumnFileEditor.this.tableViewer.setInput((Object)ColumnFileEditor.this.columnInput.getColumn());
                ColumnFileEditor.this.table.setSortDirection(dir);
                ColumnFileEditor.this.table.setSortColumn(column);
            }
        };
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void dispose() {
        this.columnInput.getColumn().removePropertyrChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent arg0) {
        if (arg0.getProperty().equals("updateColumn")) {
            this.dirty = true;
            this.firePropertyChange(257);
            this.table.setItemCount(this.columnInput.getColumn().getNRows());
            this.tableViewer.setInput((Object)this.columnInput.getColumn());
            this.populateTable();
        } else if (arg0.getProperty().equals("propdirty")) {
            this.dirty = (Boolean)arg0.getNewValue();
            this.firePropertyChange(257);
            this.setPartName(this.columnInput.getColumn().getFileName());
        }
    }
}

