/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.AttributeConfig;
import fr.esrf.Tango.AttributeConfig_2;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DispLevel;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoDs.Attr;
import fr.esrf.TangoDs.AttrProperty;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.ImageAttr;
import fr.esrf.TangoDs.SpectrumAttr;
import fr.esrf.TangoDs.TangoAttrCheckVal;
import fr.esrf.TangoDs.TangoAttrValue;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.Util;
import java.util.Date;
import java.util.Vector;

public class Attribute
implements TangoConst {
    protected String name;
    protected AttrWriteType writable;
    protected int data_type;
    protected AttrDataFormat data_format;
    protected int max_x;
    protected int max_y;
    protected String label;
    protected String description;
    protected String unit;
    protected String standard_unit;
    protected String display_unit;
    protected String format;
    protected String writable_attr_name;
    protected String min_alarm_str;
    protected String max_alarm_str;
    protected String min_value_str;
    protected String max_value_str;
    protected TangoAttrCheckVal min_alarm;
    protected TangoAttrCheckVal max_alarm;
    protected TangoAttrCheckVal min_value;
    protected TangoAttrCheckVal max_value;
    protected boolean check_min_alarm = false;
    protected boolean check_max_alarm = false;
    protected boolean check_min_value = false;
    protected boolean check_max_value = false;
    protected boolean min_alarm_on;
    protected boolean max_alarm_on;
    protected boolean date = true;
    protected int data_size;
    protected AttrQuality quality;
    protected TimeVal when;
    protected TangoAttrValue value;
    protected boolean value_flag;
    private short[] tmp_sh = new short[2];
    private int[] tmp_lo = new int[2];
    private float[] tmp_fl = new float[2];
    private double[] tmp_db = new double[2];
    private String[] tmp_str = new String[2];
    private boolean[] tmp_bool = new boolean[2];
    int dim_x;
    int dim_y;
    private int name_size;
    private String name_upper;
    protected int assoc_ind;
    protected DispLevel disp_level = DispLevel.OPERATOR;
    protected int poll_period;

    public Attribute(Vector vector, Attr attr, String string) throws DevFailed {
        this.min_alarm = new TangoAttrCheckVal();
        this.max_alarm = new TangoAttrCheckVal();
        this.min_value = new TangoAttrCheckVal();
        this.max_value = new TangoAttrCheckVal();
        this.value = new TangoAttrValue();
        this.when = new TimeVal();
        this.quality = AttrQuality.ATTR_VALID;
        this.name = attr.get_name();
        this.name_size = this.name.length();
        this.name_upper = new String(this.name);
        this.name_upper.toUpperCase();
        this.data_type = attr.get_type();
        this.writable = attr.get_writable();
        this.data_format = attr.get_format();
        this.disp_level = attr.get_disp_level();
        this.poll_period = attr.get_polling_period();
        this.writable_attr_name = attr.get_assoc();
        switch (this.data_format.value()) {
            case 1: {
                this.max_x = ((SpectrumAttr)attr).get_max_x();
                this.max_y = 0;
                this.dim_y = 0;
                break;
            }
            case 2: {
                this.max_x = ((ImageAttr)attr).get_max_x();
                this.max_y = ((ImageAttr)attr).get_max_y();
                break;
            }
            default: {
                this.max_x = 1;
                this.max_y = 0;
                this.dim_x = 1;
                this.dim_y = 0;
            }
        }
        this.init_opt_prop(vector, string);
    }

    private int find(Vector vector, String string) throws DevFailed {
        int n;
        int n2 = vector.size();
        for (n = 0; n < n2 && !((AttrProperty)vector.elementAt(n)).get_name().equals(string); ++n) {
        }
        if (n == n2) {
            StringBuffer stringBuffer = new StringBuffer("Property ");
            stringBuffer.append(string);
            stringBuffer.append(" not found");
            Except.throw_exception("API_AttrWrongDefined", stringBuffer.toString(), "Attribute.find");
        }
        return n;
    }

    private void init_opt_prop(Vector vector, String string) throws DevFailed {
        this.label = this.get_attr_value(vector, "label");
        this.description = this.get_attr_value(vector, "description");
        this.unit = this.get_attr_value(vector, "unit");
        this.standard_unit = this.get_attr_value(vector, "standard_unit");
        this.display_unit = this.get_attr_value(vector, "display_unit");
        this.format = this.get_attr_value(vector, "format");
        this.min_alarm_str = this.get_attr_value(vector, "min_alarm");
        if (!this.min_alarm_str.equals("Not specified") && this.data_type != 8) {
            try {
                switch (this.data_type) {
                    case 2: {
                        this.min_alarm.sh = Short.parseShort(this.min_alarm_str);
                        break;
                    }
                    case 3: {
                        this.min_alarm.lg = Integer.parseInt(this.min_alarm_str);
                        break;
                    }
                    case 5: {
                        this.min_alarm.db = Double.valueOf(this.min_alarm_str);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.throw_err_format("min_alarm", string);
            }
            this.check_min_alarm = true;
        }
        this.max_alarm_str = this.get_attr_value(vector, "max_alarm");
        if (!this.max_alarm_str.equals("Not specified") && this.data_type != 8) {
            try {
                switch (this.data_type) {
                    case 2: {
                        this.max_alarm.sh = Short.parseShort(this.max_alarm_str);
                        break;
                    }
                    case 3: {
                        this.max_alarm.lg = Integer.parseInt(this.max_alarm_str);
                        break;
                    }
                    case 5: {
                        this.max_alarm.db = Double.valueOf(this.max_alarm_str);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.throw_err_format("max_alarm", string);
            }
            this.check_max_alarm = true;
        }
        this.min_value_str = this.get_attr_value(vector, "min_value");
        if (!this.min_value_str.equals("Not specified") && this.data_type != 8) {
            try {
                switch (this.data_type) {
                    case 2: {
                        this.min_value.sh = Short.parseShort(this.min_value_str);
                        break;
                    }
                    case 3: {
                        this.min_value.lg = Integer.parseInt(this.min_value_str);
                        break;
                    }
                    case 5: {
                        this.min_value.db = Double.valueOf(this.min_value_str);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.throw_err_format("min_value", string);
            }
            this.check_min_value = true;
        }
        this.max_value_str = this.get_attr_value(vector, "max_value");
        if (!this.max_value_str.equals("Not specified") && this.data_type != 8) {
            try {
                switch (this.data_type) {
                    case 2: {
                        this.max_value.sh = Short.parseShort(this.max_value_str);
                        break;
                    }
                    case 3: {
                        this.max_value.lg = Integer.parseInt(this.max_value_str);
                        break;
                    }
                    case 5: {
                        this.max_value.db = Double.valueOf(this.max_value_str);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.throw_err_format("max_value", string);
            }
            this.check_max_value = true;
        }
    }

    private String get_attr_value(Vector vector, String string) throws DevFailed {
        int n = 0;
        try {
            n = this.find(vector, string);
        }
        catch (DevFailed devFailed) {
            StringBuffer stringBuffer = new StringBuffer("Property ");
            stringBuffer.append(string);
            stringBuffer.append(" is missing for attribute ");
            stringBuffer.append(this.name);
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.get_attr_value");
        }
        return ((AttrProperty)vector.elementAt(n)).get_value();
    }

    private void throw_err_format(String string, String string2) throws DevFailed {
        StringBuffer stringBuffer = new StringBuffer("Device ");
        stringBuffer.append(string2);
        stringBuffer.append("-> Attribute");
        stringBuffer.append(this.name);
        stringBuffer.append("\nThe property ");
        stringBuffer.append(string);
        stringBuffer.append(" is defined in a unsupported format");
        Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.throw_err_format");
    }

    private void set_data_size() {
        switch (this.data_format.value()) {
            case 0: {
                this.data_size = 1;
                break;
            }
            case 1: {
                this.data_size = this.dim_x;
                break;
            }
            case 2: {
                this.data_size = this.dim_x * this.dim_y;
            }
        }
    }

    public boolean is_writ_associated() {
        return !this.writable_attr_name.equals("None");
    }

    public boolean is_alarmed() {
        return this.check_min_alarm || this.check_max_alarm;
    }

    public void get_properties(AttributeConfig attributeConfig) {
        attributeConfig.writable = this.writable;
        attributeConfig.data_format = this.data_format;
        attributeConfig.max_dim_x = this.max_x;
        attributeConfig.max_dim_y = this.max_y;
        attributeConfig.data_type = this.data_type;
        attributeConfig.name = this.name;
        attributeConfig.label = this.label;
        attributeConfig.description = this.description;
        attributeConfig.unit = this.unit;
        attributeConfig.standard_unit = this.standard_unit;
        attributeConfig.display_unit = this.display_unit;
        attributeConfig.format = this.format;
        attributeConfig.writable_attr_name = this.writable_attr_name;
        attributeConfig.min_alarm = this.min_alarm_str;
        attributeConfig.max_alarm = this.max_alarm_str;
        attributeConfig.min_value = this.min_value_str;
        attributeConfig.max_value = this.max_value_str;
        attributeConfig.extensions = new String[0];
    }

    AttributeConfig_2 get_properties_2() {
        AttributeConfig_2 attributeConfig_2 = new AttributeConfig_2();
        attributeConfig_2.writable = this.writable;
        attributeConfig_2.data_format = this.data_format;
        attributeConfig_2.max_dim_x = this.max_x;
        attributeConfig_2.max_dim_y = this.max_y;
        attributeConfig_2.data_type = this.data_type;
        attributeConfig_2.name = this.name;
        attributeConfig_2.label = this.label;
        attributeConfig_2.description = this.description;
        attributeConfig_2.unit = this.unit;
        attributeConfig_2.standard_unit = this.standard_unit;
        attributeConfig_2.display_unit = this.display_unit;
        attributeConfig_2.format = this.format;
        attributeConfig_2.writable_attr_name = this.writable_attr_name;
        attributeConfig_2.min_alarm = this.min_alarm_str;
        attributeConfig_2.max_alarm = this.max_alarm_str;
        attributeConfig_2.min_value = this.min_value_str;
        attributeConfig_2.max_value = this.max_value_str;
        attributeConfig_2.level = this.disp_level;
        attributeConfig_2.extensions = new String[0];
        return attributeConfig_2;
    }

    void set_properties(AttributeConfig attributeConfig, String string) throws DevFailed {
        this.description = attributeConfig.description;
        this.label = attributeConfig.label;
        this.unit = attributeConfig.unit;
        this.standard_unit = attributeConfig.standard_unit;
        this.display_unit = attributeConfig.display_unit;
        this.format = attributeConfig.format;
        this.min_alarm_str = attributeConfig.min_alarm;
        if (!this.min_alarm_str.equals("Not specified") && this.data_type != 8) {
            try {
                switch (this.data_type) {
                    case 2: {
                        this.min_alarm.sh = Short.parseShort(this.min_alarm_str);
                        break;
                    }
                    case 3: {
                        this.min_alarm.lg = Integer.parseInt(this.min_alarm_str);
                        break;
                    }
                    case 5: {
                        this.min_alarm.db = Double.valueOf(this.min_alarm_str);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.throw_err_format("min_alarm", string);
            }
            this.check_min_alarm = true;
        } else {
            this.check_min_value = false;
        }
        this.max_alarm_str = attributeConfig.max_alarm;
        if (!this.max_alarm_str.equals("Not specified") && this.data_type != 8) {
            try {
                switch (this.data_type) {
                    case 2: {
                        this.max_alarm.sh = Short.parseShort(this.max_alarm_str);
                        break;
                    }
                    case 3: {
                        this.max_alarm.lg = Integer.parseInt(this.max_alarm_str);
                        break;
                    }
                    case 5: {
                        this.max_alarm.db = Double.valueOf(this.max_alarm_str);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.throw_err_format("max_alarm", string);
            }
            this.check_max_alarm = true;
        } else {
            this.check_max_alarm = false;
        }
        this.min_value_str = attributeConfig.min_value;
        if (!this.min_value_str.equals("Not specified") && this.data_type != 8) {
            try {
                switch (this.data_type) {
                    case 2: {
                        this.min_value.sh = Short.parseShort(this.min_value_str);
                        break;
                    }
                    case 3: {
                        this.min_value.lg = Integer.parseInt(this.min_value_str);
                        break;
                    }
                    case 5: {
                        this.min_value.db = Double.valueOf(this.min_value_str);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.throw_err_format("min_value", string);
            }
            this.check_min_value = true;
        } else {
            this.check_min_value = false;
        }
        this.max_value_str = attributeConfig.max_value;
        if (!this.max_value_str.equals("Not specified") && this.data_type != 8) {
            try {
                switch (this.data_type) {
                    case 2: {
                        this.max_value.sh = Short.parseShort(this.max_value_str);
                        break;
                    }
                    case 3: {
                        this.max_value.lg = Integer.parseInt(this.max_value_str);
                        break;
                    }
                    case 5: {
                        this.max_value.db = Double.valueOf(this.max_value_str);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.throw_err_format("max_value", string);
            }
            this.check_max_value = true;
        } else {
            this.check_max_value = false;
        }
    }

    void upd_database(AttributeConfig attributeConfig, String string) throws DevFailed {
        Util.out4.println("Entering upd_database method for attribute " + this.name);
        Vector<String> vector = new Vector<String>();
        vector.addElement(string);
        vector.addElement("1");
        vector.addElement(this.name);
        vector.addElement("10");
        int n = 0;
        if (!attributeConfig.description.equals("No description")) {
            vector.addElement("description");
            vector.addElement(attributeConfig.description);
            ++n;
        }
        if (!attributeConfig.label.equals("No label")) {
            vector.addElement("label");
            vector.addElement(attributeConfig.label);
            ++n;
        }
        if (!attributeConfig.unit.equals("No unit")) {
            vector.addElement("unit");
            vector.addElement(attributeConfig.unit);
            ++n;
        }
        if (!attributeConfig.standard_unit.equals("No standard unit")) {
            vector.addElement("standard_unit");
            vector.addElement(attributeConfig.standard_unit);
            ++n;
        }
        if (!attributeConfig.display_unit.equals("No display unit")) {
            vector.addElement("display_unit");
            vector.addElement(attributeConfig.display_unit);
            ++n;
        }
        if (!attributeConfig.format.equals("No format")) {
            vector.addElement("format");
            vector.addElement(attributeConfig.format);
            ++n;
        }
        if (!attributeConfig.min_value.equals("Not specified")) {
            vector.addElement("min_value");
            vector.addElement(attributeConfig.min_value);
            ++n;
        }
        if (!attributeConfig.max_value.equals("Not specified")) {
            vector.addElement("max_value");
            vector.addElement(attributeConfig.max_value);
            ++n;
        }
        if (!attributeConfig.min_alarm.equals("Not specified")) {
            vector.addElement("min_alarm");
            vector.addElement(attributeConfig.min_alarm);
            ++n;
        }
        if (!attributeConfig.max_alarm.equals("Not specified")) {
            vector.addElement("max_alarm");
            vector.addElement(attributeConfig.max_alarm);
            ++n;
        }
        if (n != 0) {
            Util.out4.println(n + " properties to update in db");
            String string2 = String.valueOf(n);
            vector.set(3, string2);
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
            Util util = Util.instance();
            DeviceData deviceData = new DeviceData();
            deviceData.insert(stringArray);
            util.get_database().command_inout("DbPutDeviceAttributeProperty", deviceData);
        }
        Util.out4.println("Leaving upd_database method");
    }

    void add_write_value(short s) {
        this.tmp_sh[1] = s;
        this.value.sh_seq = this.tmp_sh;
    }

    void add_write_value(int n) {
        this.tmp_lo[1] = n;
        this.value.lg_seq = this.tmp_lo;
    }

    void add_write_value(float f) {
        this.tmp_fl[1] = f;
        this.value.fl_seq = this.tmp_fl;
    }

    void add_write_value(double d) {
        this.tmp_db[1] = d;
        this.value.db_seq = this.tmp_db;
    }

    void add_write_value(String string) {
        this.tmp_str[1] = string;
        this.value.str_seq = this.tmp_str;
    }

    void add_write_value(boolean bl) {
        this.tmp_bool[1] = bl;
        this.value.bool_seq = this.tmp_bool;
    }

    public void set_value(short[] sArray, int n, int n2) throws DevFailed {
        StringBuffer stringBuffer;
        if (this.data_type != 2) {
            stringBuffer = new StringBuffer("Invalid data type for attribute ");
            stringBuffer.append(this.name);
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.set_value");
        }
        if (n > this.max_x || n2 > this.max_y) {
            stringBuffer = new StringBuffer("Data size for attribute ");
            stringBuffer.append(this.name);
            stringBuffer.append(" exceeds given limit");
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.set_value");
        }
        this.dim_x = n;
        this.dim_y = n2;
        this.set_data_size();
        this.quality = AttrQuality.ATTR_VALID;
        if (!this.date) {
            if (sArray.length == this.data_size) {
                this.value.sh_seq = sArray;
            } else {
                this.value.sh_seq = new short[this.data_size];
                for (int i = 0; i < this.data_size; ++i) {
                    this.value.sh_seq[i] = sArray[i];
                }
            }
        } else if (this.is_writ_associated()) {
            this.tmp_sh[0] = sArray[0];
        } else if (sArray.length == this.data_size) {
            this.value.sh_seq = sArray;
        } else {
            this.value.sh_seq = new short[this.data_size];
            for (int i = 0; i < this.data_size; ++i) {
                this.value.sh_seq[i] = sArray[i];
            }
        }
        this.value_flag = true;
        this.min_alarm_on = false;
        this.max_alarm_on = false;
        this.set_time();
    }

    public void set_value(boolean[] blArray, int n, int n2) throws DevFailed {
        StringBuffer stringBuffer;
        if (this.data_type != 1) {
            stringBuffer = new StringBuffer("Invalid data type for attribute ");
            stringBuffer.append(this.name);
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.set_value");
        }
        if (n > this.max_x || n2 > this.max_y) {
            stringBuffer = new StringBuffer("Data size for attribute ");
            stringBuffer.append(this.name);
            stringBuffer.append(" exceeds given limit");
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.set_value");
        }
        this.dim_x = n;
        this.dim_y = n2;
        this.set_data_size();
        this.quality = AttrQuality.ATTR_VALID;
        if (!this.date) {
            if (blArray.length == this.data_size) {
                this.value.bool_seq = blArray;
            } else {
                this.value.bool_seq = new boolean[this.data_size];
                for (int i = 0; i < this.data_size; ++i) {
                    this.value.bool_seq[i] = blArray[i];
                }
            }
        } else if (this.is_writ_associated()) {
            this.tmp_bool[0] = blArray[0];
        } else if (blArray.length == this.data_size) {
            this.value.bool_seq = blArray;
        } else {
            this.value.bool_seq = new boolean[this.data_size];
            for (int i = 0; i < this.data_size; ++i) {
                this.value.bool_seq[i] = blArray[i];
            }
        }
        this.value_flag = true;
        this.min_alarm_on = false;
        this.max_alarm_on = false;
        this.set_time();
    }

    public void set_value(int[] nArray, int n, int n2) throws DevFailed {
        StringBuffer stringBuffer;
        if (this.data_type != 3) {
            stringBuffer = new StringBuffer("Invalid data type for attribute ");
            stringBuffer.append(this.name);
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.set_value");
        }
        if (n > this.max_x || n2 > this.max_y) {
            stringBuffer = new StringBuffer("Data size for attribute ");
            stringBuffer.append(this.name);
            stringBuffer.append(" exceeds given limit");
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.set_value");
        }
        this.dim_x = n;
        this.dim_y = n2;
        this.set_data_size();
        this.quality = AttrQuality.ATTR_VALID;
        if (!this.date) {
            if (nArray.length == this.data_size) {
                this.value.lg_seq = nArray;
            } else {
                this.value.lg_seq = new int[this.data_size];
                for (int i = 0; i < this.data_size; ++i) {
                    this.value.lg_seq[i] = nArray[i];
                }
            }
        } else if (this.is_writ_associated()) {
            this.tmp_lo[0] = nArray[0];
        } else if (nArray.length == this.data_size) {
            this.value.lg_seq = nArray;
        } else {
            this.value.lg_seq = new int[this.data_size];
            for (int i = 0; i < this.data_size; ++i) {
                this.value.lg_seq[i] = nArray[i];
            }
        }
        this.value_flag = true;
        this.min_alarm_on = false;
        this.max_alarm_on = false;
        this.set_time();
    }

    public void set_value(float[] fArray, int n, int n2) throws DevFailed {
        StringBuffer stringBuffer;
        if (this.data_type != 4) {
            stringBuffer = new StringBuffer("Invalid data type for attribute ");
            stringBuffer.append(this.name);
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.set_value");
        }
        if (n > this.max_x || n2 > this.max_y) {
            stringBuffer = new StringBuffer("Data size for attribute ");
            stringBuffer.append(this.name);
            stringBuffer.append(" exceeds given limit");
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.set_value");
        }
        this.dim_x = n;
        this.dim_y = n2;
        this.set_data_size();
        this.quality = AttrQuality.ATTR_VALID;
        if (!this.date) {
            if (fArray.length == this.data_size) {
                this.value.fl_seq = fArray;
            } else {
                this.value.fl_seq = new float[this.data_size];
                for (int i = 0; i < this.data_size; ++i) {
                    this.value.fl_seq[i] = fArray[i];
                }
            }
        } else if (this.is_writ_associated()) {
            this.tmp_fl[0] = fArray[0];
        } else if (fArray.length == this.data_size) {
            this.value.fl_seq = fArray;
        } else {
            this.value.fl_seq = new float[this.data_size];
            for (int i = 0; i < this.data_size; ++i) {
                this.value.fl_seq[i] = fArray[i];
            }
        }
        this.value_flag = true;
        this.min_alarm_on = false;
        this.max_alarm_on = false;
        this.set_time();
    }

    public void set_value(double[] dArray, int n, int n2) throws DevFailed {
        StringBuffer stringBuffer;
        if (this.data_type != 5) {
            stringBuffer = new StringBuffer("Invalid data type for attribute ");
            stringBuffer.append(this.name);
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.set_value");
        }
        if (n > this.max_x || n2 > this.max_y) {
            stringBuffer = new StringBuffer("Data size for attribute ");
            stringBuffer.append(this.name);
            stringBuffer.append(" exceeds given limit");
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.set_value");
        }
        this.dim_x = n;
        this.dim_y = n2;
        this.set_data_size();
        this.quality = AttrQuality.ATTR_VALID;
        if (!this.date) {
            if (dArray.length == this.data_size) {
                this.value.db_seq = dArray;
            } else {
                this.value.db_seq = new double[this.data_size];
                for (int i = 0; i < this.data_size; ++i) {
                    this.value.db_seq[i] = dArray[i];
                }
            }
        } else if (this.is_writ_associated()) {
            this.tmp_db[0] = dArray[0];
        } else if (dArray.length == this.data_size) {
            this.value.db_seq = dArray;
        } else {
            this.value.db_seq = new double[this.data_size];
            for (int i = 0; i < this.data_size; ++i) {
                this.value.db_seq[i] = dArray[i];
            }
        }
        this.value_flag = true;
        this.min_alarm_on = false;
        this.max_alarm_on = false;
        this.set_time();
    }

    public void set_value(String[] stringArray, int n, int n2) throws DevFailed {
        StringBuffer stringBuffer;
        if (this.data_type != 8) {
            stringBuffer = new StringBuffer("Invalid data type for attribute ");
            stringBuffer.append(this.name);
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.set_value");
        }
        if (n > this.max_x || n2 > this.max_y) {
            stringBuffer = new StringBuffer("Data size for attribute ");
            stringBuffer.append(this.name);
            stringBuffer.append(" exceeds given limit");
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.set_value");
        }
        this.dim_x = n;
        this.dim_y = n2;
        this.set_data_size();
        this.quality = AttrQuality.ATTR_VALID;
        if (!this.date) {
            if (stringArray.length == this.data_size) {
                this.value.str_seq = stringArray;
            } else {
                this.value.str_seq = new String[this.data_size];
                for (int i = 0; i < this.data_size; ++i) {
                    this.value.str_seq[i] = stringArray[i];
                }
            }
        } else if (this.is_writ_associated()) {
            this.tmp_str[0] = stringArray[0];
        } else if (stringArray.length == this.data_size) {
            this.value.str_seq = stringArray;
        } else {
            this.value.str_seq = new String[this.data_size];
            for (int i = 0; i < this.data_size; ++i) {
                this.value.str_seq[i] = stringArray[i];
            }
        }
        this.value_flag = true;
        this.quality = AttrQuality.ATTR_VALID;
        this.set_time();
    }

    public void set_value(short s) throws DevFailed {
        short[] sArray = new short[]{s};
        this.set_value(sArray, 1, 0);
    }

    public void set_value(int n) throws DevFailed {
        int[] nArray = new int[]{n};
        this.set_value(nArray, 1, 0);
    }

    public void set_value(double d) throws DevFailed {
        double[] dArray = new double[]{d};
        this.set_value(dArray, 1, 0);
    }

    public void set_value(String string) throws DevFailed {
        String[] stringArray = new String[]{string};
        this.set_value(stringArray, 1, 0);
    }

    public void set_value(short[] sArray, int n) throws DevFailed {
        this.set_value(sArray, n, 0);
    }

    public void set_value(int[] nArray, int n) throws DevFailed {
        this.set_value(nArray, n, 0);
    }

    public void set_value(double[] dArray, int n) throws DevFailed {
        this.set_value(dArray, n, 0);
    }

    public void set_value(String[] stringArray, int n) throws DevFailed {
        this.set_value(stringArray, n, 0);
    }

    private void set_time() {
        if (this.date) {
            Date date = new Date();
            long l = date.getTime();
            this.when.tv_sec = (int)(l / 1000L);
            this.when.tv_usec = (int)((l - (long)(this.when.tv_sec * 1000)) * 1000L);
            this.when.tv_nsec = 0;
        }
    }

    public boolean check_alarm() throws DevFailed {
        if (!this.is_alarmed()) {
            StringBuffer stringBuffer = new StringBuffer("No alarm defined for attribute ");
            stringBuffer.append(this.name);
            Except.throw_exception("API_AttrNoAlarm", stringBuffer.toString(), "Attribute.check_alarm");
        }
        int n = 0;
        if (this.check_min_alarm) {
            switch (this.data_type) {
                case 2: {
                    for (n = 0; n < this.data_size; ++n) {
                        if (this.value.sh_seq[n] > this.min_alarm.sh) continue;
                        this.quality = AttrQuality.ATTR_ALARM;
                        this.min_alarm_on = true;
                        return true;
                    }
                    break;
                }
                case 3: {
                    for (n = 0; n < this.data_size; ++n) {
                        if (this.value.lg_seq[n] > this.min_alarm.lg) continue;
                        this.quality = AttrQuality.ATTR_ALARM;
                        this.min_alarm_on = true;
                        return true;
                    }
                    break;
                }
                case 5: {
                    for (n = 0; n < this.data_size; ++n) {
                        if (!(this.value.db_seq[n] <= this.min_alarm.db)) continue;
                        this.quality = AttrQuality.ATTR_ALARM;
                        this.min_alarm_on = true;
                        return true;
                    }
                    break;
                }
            }
            this.min_alarm_on = false;
        }
        if (this.check_max_alarm) {
            switch (this.data_type) {
                case 2: {
                    for (n = 0; n < this.data_size; ++n) {
                        if (this.value.sh_seq[n] < this.max_alarm.sh) continue;
                        this.quality = AttrQuality.ATTR_ALARM;
                        this.max_alarm_on = true;
                        return true;
                    }
                    break;
                }
                case 3: {
                    for (n = 0; n < this.data_size; ++n) {
                        if (this.value.lg_seq[n] < this.max_alarm.lg) continue;
                        this.quality = AttrQuality.ATTR_ALARM;
                        this.max_alarm_on = true;
                        return true;
                    }
                    break;
                }
                case 5: {
                    for (n = 0; n < this.data_size; ++n) {
                        if (!(this.value.db_seq[n] >= this.max_alarm.db)) continue;
                        this.quality = AttrQuality.ATTR_ALARM;
                        this.max_alarm_on = true;
                        return true;
                    }
                    break;
                }
            }
            this.max_alarm_on = false;
        }
        return false;
    }

    public String toString() {
        AttributeConfig_2 attributeConfig_2 = this.get_properties_2();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Attribute name = ");
        stringBuffer.append(attributeConfig_2.name);
        stringBuffer.append("\nAttribute data_type = ");
        switch (attributeConfig_2.data_type) {
            case 2: {
                stringBuffer.append("Tango_DevShort");
                break;
            }
            case 3: {
                stringBuffer.append("Tango_DevLong");
                break;
            }
            case 5: {
                stringBuffer.append("Tango_DevDouble");
                break;
            }
            case 8: {
                stringBuffer.append("Tango_DevString");
            }
        }
        stringBuffer.append("\nAttribute data_format = ");
        switch (attributeConfig_2.data_format.value()) {
            case 0: {
                stringBuffer.append("scalar");
                break;
            }
            case 1: {
                stringBuffer.append("spectrum, max_x = ");
                stringBuffer.append(attributeConfig_2.max_dim_x);
                break;
            }
            case 2: {
                stringBuffer.append("image, max_dim_x = ");
                stringBuffer.append(attributeConfig_2.max_dim_x);
                stringBuffer.append(", max_dim_y = ");
                stringBuffer.append(attributeConfig_2.max_dim_y);
            }
        }
        if (attributeConfig_2.writable == AttrWriteType.READ) {
            stringBuffer.append("\nAttribute is not writable");
        } else {
            stringBuffer.append("\nAttribute is writable");
        }
        stringBuffer.append("\nAttribute label = ");
        stringBuffer.append(attributeConfig_2.label);
        stringBuffer.append("\nAttribute description = ");
        stringBuffer.append(attributeConfig_2.description);
        stringBuffer.append("\nAttribute unit = ");
        stringBuffer.append(attributeConfig_2.unit);
        stringBuffer.append(", standard unit = ");
        stringBuffer.append(attributeConfig_2.standard_unit);
        stringBuffer.append(", display unit = ");
        stringBuffer.append(attributeConfig_2.display_unit);
        stringBuffer.append("\nAttribute format = ");
        stringBuffer.append(attributeConfig_2.format);
        stringBuffer.append("\nAttribute min alarm = ");
        stringBuffer.append(attributeConfig_2.min_alarm);
        stringBuffer.append("\nAttribute max alarm = ");
        stringBuffer.append(attributeConfig_2.max_alarm);
        stringBuffer.append("\nAttribute min value = ");
        stringBuffer.append(attributeConfig_2.min_value);
        stringBuffer.append("\nAttribute max value = ");
        stringBuffer.append(attributeConfig_2.max_value);
        stringBuffer.append("\nAttribute poll_period = ");
        stringBuffer.append(this.poll_period);
        stringBuffer.append("\nAttribute writable_attr_name = ");
        stringBuffer.append(attributeConfig_2.writable_attr_name);
        if (attributeConfig_2.level == DispLevel.OPERATOR) {
            stringBuffer.append("\nDisplay Level = OPERATOR");
        } else {
            stringBuffer.append("\nDisplay Level = EXPERT");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    void set_value() throws DevFailed {
    }

    public AttrWriteType get_writable() {
        return this.writable;
    }

    public String get_name() {
        return this.name;
    }

    public String get_assoc_name() {
        return this.writable_attr_name;
    }

    public int get_data_type() {
        return this.data_type;
    }

    public boolean is_min_alarm() {
        return this.min_alarm_on;
    }

    public boolean is_max_alarm() {
        return this.max_alarm_on;
    }

    public AttrDataFormat get_data_format() {
        return this.data_format;
    }

    public int get_assoc_ind() {
        return this.assoc_ind;
    }

    public void set_assoc_ind(int n) {
        this.assoc_ind = n;
    }

    public int get_data_size() {
        return this.data_size;
    }

    int get_x() {
        return this.dim_x;
    }

    int get_y() {
        return this.dim_y;
    }

    public AttrQuality get_quality() {
        return this.quality;
    }

    public void set_quality(AttrQuality attrQuality) {
        this.quality = attrQuality;
    }

    public TimeVal get_when() {
        return this.when;
    }

    public TimeVal get_date() {
        return this.when;
    }

    public void set_date(TimeVal timeVal) {
        this.when = timeVal;
    }

    void wanted_date(boolean bl) {
        this.date = bl;
    }

    String get_upper_name() {
        return this.name_upper;
    }

    int get_name_size() {
        return this.name_size;
    }

    void set_value_flag(boolean bl) {
        this.value_flag = bl;
    }

    boolean get_value_flag() {
        return this.value_flag;
    }

    short[] get_short_value() {
        return this.value.sh_seq;
    }

    int[] get_long_value() {
        return this.value.lg_seq;
    }

    float[] get_float_value() {
        return this.value.fl_seq;
    }

    double[] get_double_value() {
        return this.value.db_seq;
    }

    String[] get_string_value() {
        return this.value.str_seq;
    }

    boolean[] get_boolean_value() {
        return this.value.bool_seq;
    }

    int get_polling_period() {
        return this.poll_period;
    }

    void set_polling_period(int n) {
        this.poll_period = n;
    }
}

